/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.security.MinCrypto;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageProducerImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SessionDispatcher;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class SessionImpl
implements Session,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SessionImpl.java, disthub, j600, j600-201-061220 1.36.1.1 05/05/25 15:44:20";
    private static final DebugObject debug = new DebugObject("SessionImpl");
    private boolean active = true;
    private boolean stopped = true;
    private boolean transacted;
    private int acknowledgeMode;
    private ConnectionImpl parentConnection;
    private MessageListener listener;
    private MessageQueue dispatchQueue;
    private static MessageQueue s_dispatchQueue;
    private SessionDispatcher dispatcher;
    private static SessionDispatcher s_dispatcher;
    private static boolean threadPoolChecked;
    protected Vector consumers;
    protected Vector producers;
    boolean mapNameStyle = true;
    private static final MinCrypto cryptorand;
    private String unlikely;
    private int topicCounter;

    private static synchronized void checkForThreadPooling(SessionConfig sessionConfig) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"StreamMessageImpl.checkForThreadPooling");
        }
        if (!threadPoolChecked) {
            threadPoolChecked = true;
            if (SessionConfig.getSessionConfig().MAX_CLIENT_READ_THREADS > 0) {
                s_dispatchQueue = new MessageQueue(sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
                s_dispatcher = new SessionDispatcher(s_dispatchQueue);
                ConnectionImpl.threadProvider.schedule((Runnable)s_dispatcher);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"CheckForThreadPooling");
        }
    }

    SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"SessionImpl", (Object)connectionImpl, (Object)new Boolean(bl), (Object)new Integer(n));
        }
        if (bl) {
            String string = "MQJMS6311";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotSupportedException(string2);
        }
        this.transacted = bl;
        this.setAcknowledgeMode(n);
        this.parentConnection = connectionImpl;
        this.mapNameStyle = connectionImpl.mapNameStyle;
        SessionImpl.checkForThreadPooling(connectionImpl.sessionConfig);
        if (s_dispatchQueue != null) {
            this.dispatchQueue = s_dispatchQueue;
            this.dispatcher = s_dispatcher;
        } else {
            this.dispatchQueue = new MessageQueue(connectionImpl.sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
            this.parentConnection.addFreeSpaceHeapNode(connectionImpl.sessionConfig.MAX_MESSAGE_QUEUE_SIZE, this.dispatchQueue);
            this.dispatcher = new SessionDispatcher(this.dispatchQueue);
            ConnectionImpl.threadProvider.schedule((Runnable)this.dispatcher);
        }
        this.consumers = new Vector();
        this.producers = new Vector();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"SessionImpl");
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createBytesMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        BytesMessageImpl bytesMessageImpl = new BytesMessageImpl();
        bytesMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createBytesMessage", (Object)bytesMessageImpl);
        }
        return bytesMessageImpl;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createMapMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        MapMessageImpl mapMessageImpl = new MapMessageImpl();
        mapMessageImpl.setSession(this);
        mapMessageImpl.mapNameStyle = this.mapNameStyle;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createMapMessage", (Object)mapMessageImpl);
        }
        return mapMessageImpl;
    }

    public Message createMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        MessageImpl messageImpl = new MessageImpl();
        messageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createMessage", (Object)messageImpl);
        }
        return messageImpl;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createObjectMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createObjectMessage", (Object)objectMessageImpl);
        }
        return objectMessageImpl;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createObjectMessage", (Object)serializable);
        }
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setSession(this);
        objectMessageImpl.setObject(serializable);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createObjectMessage", (Object)objectMessageImpl);
        }
        return objectMessageImpl;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createStreamMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        StreamMessageImpl streamMessageImpl = new StreamMessageImpl();
        streamMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createStreamMessage", (Object)streamMessageImpl);
        }
        return streamMessageImpl;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)textMessageImpl);
        }
        return textMessageImpl;
    }

    public TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage", (Object)stringBuffer);
        }
        TextMessage textMessage = this.createTextMessage(stringBuffer.toString());
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)textMessage);
        }
        return textMessage;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage", (Object)string);
        }
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setSession(this);
        textMessageImpl.setText(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)textMessageImpl);
        }
        return textMessageImpl;
    }

    public boolean getTransacted() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTransacted");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTransacted", (Object)new Boolean(this.transacted));
        }
        return this.transacted;
    }

    public void commit() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"commit");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        String string = "MQJMS6311";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string2, string);
    }

    public void rollback() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"rollback");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        String string = "MQJMS6311";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string2, string);
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)exception, (Object)new Boolean(bl));
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"close");
            }
            return;
        }
        this.active = false;
        this.parentConnection.closed(this);
        this.stop();
        if (s_dispatcher == null && this.dispatcher != null) {
            this.dispatcher.close(exception, bl);
        }
        this.dispatcher = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    public void recover() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"recover");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        String string = "MQJMS6311";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string2, string);
    }

    public MessageListener getMessageListener() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageListener");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageListener", (Object)this.listener);
        }
        return this.listener;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setMessageListener", (Object)messageListener);
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            MessageListener messageListener2 = this.listener;
            this.listener = messageListener;
            if (messageListener2 == messageListener) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"setMessageListener");
                }
                return;
            }
            boolean bl = this.stopped;
            if (!bl) {
                this.stop();
            }
            Vector vector = (Vector)this.consumers.clone();
            for (int i = 0; i < vector.size(); ++i) {
                MessageConsumerImpl messageConsumerImpl = (MessageConsumerImpl)vector.elementAt(i);
                messageConsumerImpl.setSessionMessageListener(messageListener);
            }
            if (!bl) {
                this.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setMessageListener");
        }
    }

    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"run");
        }
        throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-148245959, null));
    }

    ConnectionImpl getConnection() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getConnection");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getConnection", (Object)this.parentConnection);
        }
        return this.parentConnection;
    }

    MessageQueue getDispatchQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDispatchQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDispatchQueue", (Object)this.dispatchQueue);
        }
        return this.dispatchQueue;
    }

    private void setAcknowledgeMode(int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setAcknowledgeMode", (Object)new Integer(n));
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.acknowledgeMode = n;
                break;
            }
            default: {
                String string = "MQJMS1001";
                String string2 = ConfigEnvironment.getErrorMessage(string, String.valueOf(n));
                throw new JMSInvalidParameterException(string2);
            }
        }
        if (this.acknowledgeMode == 2) {
            String string = "MQJMS6404";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotSupportedException(string3);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setAcknowledgeMode");
        }
    }

    public int getAcknowledgeMode() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getAcknowledgeMode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getAcknowledgeMode", (Object)new Integer(this.acknowledgeMode));
        }
        return this.acknowledgeMode;
    }

    boolean acknowledgeModeIsAuto() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsAuto");
        }
        boolean bl2 = bl = 1 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsAuto", (Object)new Boolean(bl));
        }
        return bl;
    }

    boolean acknowledgeModeIsClient() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsClient");
        }
        boolean bl2 = bl = 2 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsClient", (Object)new Boolean(bl));
        }
        return bl;
    }

    boolean acknowledgeModeIsDupsOK() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsDupsOK");
        }
        boolean bl2 = bl = 3 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsDupsOK", (Object)new Boolean(bl));
        }
        return bl;
    }

    void enqueue(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"enqueue", (Object)messageImpl);
        }
        this.dispatchQueue.enqueue(messageImpl);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"enqueue");
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        return !this.active;
    }

    protected boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStopped", (Object)new Boolean(this.stopped));
        }
        return this.stopped;
    }

    synchronized void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.stopped = true;
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        Vector vector = (Vector)this.consumers.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((MessageConsumerImpl)vector.elementAt(i)).stop();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
    }

    synchronized void start() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.stopped = false;
        this.dispatcher.start();
        Vector vector = (Vector)this.consumers.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((MessageConsumerImpl)vector.elementAt(i)).start();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTemporaryQueue");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createTemporaryQueue");
        }
        String string = "MQJMS1110";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string2, string);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createBrowser");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createBrowser");
        }
        String string = "MQJMS1110";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string2, string);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createBrowser");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createBrowser");
        }
        String string2 = "MQJMS1110";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createProducer");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed - IllegalStateException");
                Trace.exit(this, "createProducer");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (destination instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)destination).incUse();
        }
        MessageProducerImpl messageProducerImpl = new MessageProducerImpl(destination, this);
        this.producers.addElement(messageProducerImpl);
        if (Trace.isOn) {
            Trace.exit(this, "createProducer");
        }
        return messageProducerImpl;
    }

    public Queue createQueue(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createQueue");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createQueue");
        }
        String string2 = "MQJMS1110";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (destination instanceof MQTopic) {
            return this.createConsumer((Destination)((Topic)destination), string, false);
        }
        if (Trace.isOn) {
            Trace.entry(this, "createConsumer");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createConsumer");
        }
        String string2 = "MQJMS1110";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer messageConsumer = this.createConsumer(destination, null, false);
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        MQTopic mQTopic = null;
        Object var5_5 = null;
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "createConsumer");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "createConsumer");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (destination == null || destination.toString().length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Topic is Null - InvalidDestinationException");
                Trace.exit(this, "createConsumer");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "Topic");
            throw new InvalidDestinationException(string3, string2);
        }
        if (!(destination instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                Trace.exit(this, "createConsumer");
            }
            String string4 = "MQJMS0003";
            String string5 = ConfigEnvironment.getErrorMessage(string4);
            throw new InvalidDestinationException(string5, string4);
        }
        mQTopic = (MQTopic)destination;
        if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                Trace.exit(this, "createConsumer");
            }
            String string6 = "MQJMS0003";
            String string7 = ConfigEnvironment.getErrorMessage(string6);
            throw new InvalidDestinationException(string7, string6);
        }
        if (destination instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)destination).isCreatedOnThisConnection(this)) {
            if (Trace.isOn) {
                Trace.trace(this, "Temporary Topic not created on this connection - JMSException");
                Trace.exit(this, "createConsumer");
            }
            throw new JMSException(ExceptionBuilder.buildReasonString((int)793507705, null));
        }
        if (destination instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)destination).incUse();
        }
        MessageConsumerImpl messageConsumerImpl = new MessageConsumerImpl(mQTopic, string, null, bl, this.getConnection().isPre1_2() ? 1 : 2, this);
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.consumers.addElement(messageConsumerImpl);
            if (!this.isStopped()) {
                messageConsumerImpl.start();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createConsumer");
        }
        return messageConsumerImpl;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2) throws JMSParameterIsNullException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public void unsubscribe(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "unsubscribe");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "unsubscribe");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public Topic createTopic(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopic");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (string == null || string.length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "No topic Name - JMSParameterIsNullException");
                Trace.exit(this, "createTopic");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "TopicName");
            throw new JMSParameterIsNullException(string3);
        }
        MQTopic mQTopic = new MQTopic(string);
        if (Trace.isOn) {
            Trace.exit(this, "createTopic");
        }
        return mQTopic;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTemporaryTopic");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.unlikely == null) {
            this.makeUnlikely();
        }
        String string = this.unlikely + '/' + this.topicCounter++;
        TemporaryTopicImpl temporaryTopicImpl = new TemporaryTopicImpl(this, this.getConnection().getTemporaryTopicString(string));
        if (Trace.isOn) {
            Trace.exit(this, "createTemporaryTopic");
        }
        return temporaryTopicImpl;
    }

    private void makeUnlikely() {
        byte[] byArray = cryptorand.random(20);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c == '/' || c == '#' || c == '+' || c == '?' || c < '0' || c > 'z') continue;
            stringBuffer.append(c);
        }
        this.unlikely = stringBuffer.toString();
    }

    void closed(MessageConsumerImpl messageConsumerImpl) throws JMSException {
        Assert.condition((boolean)this.consumers.removeElement(messageConsumerImpl));
    }

    void closed(MessageProducerImpl messageProducerImpl) throws JMSException {
        Assert.condition((boolean)this.producers.removeElement(messageProducerImpl));
    }

    static {
        cryptorand = new MinCrypto();
    }
}

