/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import java.util.Vector;

public class RFH2Folder {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/RFH2Folder.java, jms, j600, j600-201-061220 1.6.1.1 05/05/25 16:02:34";
    public static final int DT_STRING = 0;
    public static final int DT_BOOLEAN = 1;
    public static final int DT_BINHEX = 2;
    public static final int DT_I1 = 3;
    public static final int DT_I2 = 4;
    public static final int DT_I4 = 5;
    public static final int DT_I8 = 6;
    public static final int DT_INT = 7;
    public static final int DT_R4 = 8;
    public static final int DT_R8 = 9;
    private static final String[] DT_LOOKUP_TABLE = new String[]{"string", "boolean", "bin.hex", "i1", "i2", "i4", "i8", "int", "r4", "r8"};
    private static final int DT_NONE = -1;
    private String name = null;
    private int type = -1;
    private Vector children = null;
    private String content = null;
    private boolean ownRolled = false;

    public RFH2Folder() {
        this.ownRolled = true;
    }

    public RFH2Folder(String string) {
        this.name = string;
    }

    public void setContent(String string, int n) throws Exception {
        if (this.children != null) {
            throw new Exception("Cannot set content for a parental folder");
        }
        if (this.ownRolled && n != -1) {
            throw new Exception("Cannot set typed content for ownRolled folder");
        }
        if (this.content != null) {
            throw new Exception("Content already set to '" + string + "'");
        }
        this.content = string;
        this.type = n;
    }

    public void setContent(String string) throws Exception {
        this.setContent(string, -1);
    }

    public void addFolder(RFH2Folder rFH2Folder) throws Exception {
        if (this.ownRolled) {
            throw new Exception("Cannot add a folder to an ownRolled folder");
        }
        if (this.content != null) {
            throw new Exception("Cannot add a child folder to an infertile folder");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(rFH2Folder);
    }

    public String render() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ownRolled) {
            stringBuffer.append(this.content);
        } else {
            stringBuffer.append("<" + this.name);
            if (this.type != -1) {
                stringBuffer.append(" dt=\"" + DT_LOOKUP_TABLE[this.type] + "\"");
            }
            stringBuffer.append(">");
            if (this.children != null) {
                n2 = this.children.size();
                for (n = 0; n < n2; ++n) {
                    RFH2Folder rFH2Folder = (RFH2Folder)this.children.elementAt(n);
                    stringBuffer.append(rFH2Folder.renderNoPad());
                }
            } else {
                stringBuffer.append(this.content == null ? "" : this.content);
            }
            stringBuffer.append("</" + this.name + ">");
        }
        n2 = stringBuffer.length() % 4;
        if (n2 != 0) {
            for (n = n2; n < 4; ++n) {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private String renderNoPad() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + this.name);
        if (this.type != -1) {
            stringBuffer.append(" dt=\"" + DT_LOOKUP_TABLE[this.type] + "\"");
        }
        stringBuffer.append(">");
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                RFH2Folder rFH2Folder = (RFH2Folder)this.children.elementAt(i);
                stringBuffer.append(rFH2Folder.renderNoPad());
            }
        } else {
            stringBuffer.append(this.content == null ? "" : this.content);
        }
        stringBuffer.append("</" + this.name + ">");
        return stringBuffer.toString();
    }
}

