/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("ObjectMessageImpl");
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/ObjectMessageImpl.java, disthub, j600, j600-201-061220 1.18.1.1 05/05/25 15:42:35";

    public ObjectMessageImpl(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        super(messageHandle, connectionImpl);
        this.messageClass = "jms_object";
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ObjectMessageImpl", (Object)messageHandle, (Object)connectionImpl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ObjectMessageImpl");
        }
    }

    public ObjectMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ObjectMessageImpl");
        }
        this.messageClass = "jms_object";
        try {
            this.setObjectBody(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ObjectMessageImpl");
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObject", (Object)serializable);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.setObjectBody(serializable);
        }
        catch (InvalidClassException invalidClassException) {
            String string = "MQJMS1060";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        catch (NotSerializableException notSerializableException) {
            String string = "MQJMS1060";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string3, string);
        }
        catch (IOException iOException) {
            String string = "MQJMS1060";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string4, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObject");
        }
    }

    public Serializable getObject() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getObject");
        }
        Serializable serializable = null;
        try {
            serializable = this.getObjectBody();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "MQJMS1061";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        catch (InvalidClassException invalidClassException) {
            String string = "MQJMS1061";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string3, string);
        }
        catch (Exception exception) {
            String string = "MQJMS1061";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSWrappedException(string4, exception);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObject", (Object)serializable);
        }
        return serializable;
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        try {
            this.setObjectBody(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
    }
}

