/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.Trace;

public class MQQueueSubscription
extends MQSubscription {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueSubscription.java, jms, j600, j600-201-061220 1.18.1.1 05/05/25 16:04:02";
    static final String SUBENTRY_SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    static final String SUBENTRY_v1SIGNATURE = "MQJMS_PS_ADMIN_ENTRY";
    static final String SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    private char subscriberState;
    private byte[] statusMgrId;
    private boolean validity = false;

    public MQQueueSubscription(MQSubscriptionEngine mQSubscriptionEngine, MQSession mQSession, boolean bl, boolean bl2, String string, String string2, String string3, MQTopic mQTopic, String string4, boolean bl3, String string5, MQQueue mQQueue, byte[] byArray) {
        super(mQSubscriptionEngine, mQSession, bl, bl2, string, string2, string3, mQTopic, string4, bl3, string5, mQQueue, byArray);
        if (Trace.isOn) {
            Trace.entry(this, "constructor(MQSubscriptionEngine)");
            Trace.trace(this, sccsid);
        }
        this.subscriberState = (char)117;
        this.validity = true;
        Trace.exit(this, "constructor(MQSubscriptionEngine)");
    }

    public MQQueueSubscription(MQSubscriptionEngine mQSubscriptionEngine, MQSession mQSession, MQMessage mQMessage) {
        super(mQSubscriptionEngine, mQSession, false, false, mQSession.qm.name, null, null, null, null, false, null, null, null);
        if (Trace.isOn) {
            Trace.entry(this, "constructor, from message");
        }
        boolean bl = false;
        int n = 2;
        Object var7_6 = null;
        try {
            this.setQmgrName(mQSession.qm.name);
            String string = mQMessage.readStringOfByteLength("MQJMS_PS_SUBENTRY_v2".length());
            if (string.equals("MQJMS_PS_SUBENTRY_v2")) {
                bl = true;
            } else if (!string.equals("MQJMS_PS_SUBENTRY_v2")) {
                bl = true;
                n = 2;
                if (string.equals(SUBENTRY_v1SIGNATURE)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "v1 style subscriber entry found on DurSubAdmin queue.");
                    }
                    n = 1;
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Non-DurSubEntry message on DurSubAdmin queue!");
                    }
                    return;
                }
            }
            String string2 = null;
            int n2 = mQMessage.readInt();
            if (n2 > 0) {
                string2 = mQMessage.readStringOfByteLength(n2);
                int n3 = string2.indexOf(":");
                if (n3 == -1) {
                    throw new Exception();
                }
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                this.setClientId(string3);
                this.setSubName(string4);
            } else {
                this.setClientId("");
                this.setSubName("");
            }
            n2 = mQMessage.readInt();
            this.setTopic(mQMessage.readStringOfByteLength(n2));
            n2 = mQMessage.readInt();
            this.setQueueName(mQMessage.readStringOfByteLength(n2));
            n2 = mQMessage.readInt();
            if (n2 > 0) {
                this.setSelector(mQMessage.readStringOfByteLength(n2));
            } else {
                this.setSelector("");
            }
            this.setNoLocal(mQMessage.readChar() == 'y');
            if (n != 1) {
                this.setSharedQueue(mQMessage.readChar() == 'y');
                this.subscriberState = mQMessage.readChar();
                this.statusMgrId = mQMessage.correlationId;
                this.setCorrelationId(mQMessage.messageId);
            }
            this.validity = true;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "Could not create MQQueueSubscription" + exception);
            }
            this.validity = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor, from message");
        }
    }

    void setSubscriberState(char c) {
        this.subscriberState = c;
        if (Trace.isOn) {
            Trace.trace(this, "Set SubscriberState = " + c);
        }
    }

    char getSubscriberState() {
        if (Trace.isOn) {
            Trace.trace(this, "SubscriberState = " + this.subscriberState);
        }
        return this.subscriberState;
    }

    void setStatusMgrId(byte[] byArray) {
        if (Trace.isOn) {
            Trace.trace(this, "Set StatusMgrId = " + Utils.bytesToHex(byArray));
        }
        this.statusMgrId = byArray;
    }

    byte[] getStatusMgrId() {
        if (Trace.isOn) {
            Trace.trace(this, "StatusMgrId = " + Utils.bytesToHex(this.statusMgrId));
        }
        return this.statusMgrId;
    }

    boolean isValid() {
        if (Trace.isOn) {
            Trace.trace(this, "Validity = " + this.validity);
        }
        return this.validity;
    }

    MQMessage toMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "toMessage");
        }
        String string = this.getSubName();
        String string2 = this.getClientId();
        String string3 = this.getTopic();
        String string4 = this.getQueueName();
        String string5 = this.getSelector();
        byte[] byArray = this.getCorrelationId();
        if (Trace.isOn) {
            Trace.trace(this, "subName: " + string);
            Trace.trace(this, "clientId: " + string2);
            Trace.trace(this, "topic: " + string3);
            Trace.trace(this, "queueName: " + string4);
            Trace.trace(this, "selector: " + string5);
            Trace.trace(this, "correlationId: " + byArray);
        }
        MQMessage mQMessage = new MQMessage();
        try {
            String string6 = this.isDurable() ? string2 + ":" + string : "";
            if (Trace.isOn) {
                Trace.trace(this, "Writing Signature: MQJMS_PS_SUBENTRY_v2");
            }
            mQMessage.writeString("MQJMS_PS_SUBENTRY_v2");
            if (Trace.isOn) {
                Trace.trace(this, "Writing fullNameLength: " + string6.length());
            }
            mQMessage.writeInt(string6.length());
            if (Trace.isOn) {
                Trace.trace(this, "Writing fullName: " + string6);
            }
            mQMessage.writeString(string6);
            mQMessage.writeInt(string3.length());
            mQMessage.writeString(string3);
            mQMessage.writeInt(string4.length());
            mQMessage.writeString(string4);
            if (string5 == null) {
                mQMessage.writeInt(0);
            } else {
                mQMessage.writeInt(string5.length());
                mQMessage.writeString(string5);
            }
            mQMessage.writeChar(this.getNoLocal() ? 121 : 110);
            mQMessage.writeChar(this.isSharedQueue() ? 121 : 110);
            mQMessage.writeChar((int)this.subscriberState);
            if (byArray != null) {
                mQMessage.messageId = byArray;
            }
            if (this.statusMgrId != null) {
                mQMessage.correlationId = this.statusMgrId;
            }
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "Could not convert MQQueueSubscription to MQMessage: " + exception);
            }
            mQMessage = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "toMessage");
        }
        return mQMessage;
    }

    public String getFullName() {
        return this.getClientId() + ":" + this.getSubName();
    }
}

