/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public class MQQueueSession
extends MQSession
implements QueueSession {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueSession.java, jms, j600, j600-201-061220 1.91.1.4 06/09/29 13:25:54";
    static final int MQCA_QSG_NAME = 2040;

    MQQueueSession(MQQueueConnection mQQueueConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        block7: {
            int n2;
            super(mQQueueConnection, bl, n);
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            this.qm = mQQueueManager;
            try {
                n2 = 2015;
                this.resolvedQmName = mQQueueManager.getAttributeString(n2, 48).trim();
            }
            catch (Exception exception) {
                this.resolvedQmName = mQQueueManager.name;
            }
            try {
                n2 = 2040;
                this.resolvedQSGName = mQQueueManager.getAttributeString(n2, 4).trim();
            }
            catch (Exception exception) {
                this.resolvedQSGName = null;
                if (!Trace.isOn) break block7;
                Trace.trace(this, "Setting QSGName to null");
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, "QSGName set to " + this.resolvedQSGName);
        }
        this.addQueueServices();
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void commit() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "commit");
            }
            super.commitQ();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commit");
            }
        }
    }

    public void rollback() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "rollback");
            }
            super.rollbackQ();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "rollback");
            }
        }
    }

    public void recover() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recover");
            }
            super.recoverQ();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recover");
            }
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        QueueSender queueSender = super.createQSender(queue);
        this.addProducer((MessageProducer)queueSender);
        return queueSender;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        QueueReceiver queueReceiver = this.createReceiver(queue, null);
        return queueReceiver;
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        QueueReceiver queueReceiver = super.createQReceiver(queue, string);
        this.addConsumer((MessageConsumer)queueReceiver);
        return queueReceiver;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return super.createTemporaryQueue();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            QueueReceiver queueReceiver = this.createReceiver((Queue)destination);
            return queueReceiver;
        }
        if (destination instanceof MQTopic) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string = "MQJMS0003";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
        throw invalidDestinationException;
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            QueueReceiver queueReceiver = this.createReceiver((Queue)destination, string);
            return queueReceiver;
        }
        if (destination instanceof MQTopic) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string2 = "MQJMS0003";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
        throw invalidDestinationException;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null || destination instanceof Queue) {
            QueueSender queueSender = this.createSender((Queue)destination);
            return queueSender;
        }
        JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
        throw jMSException;
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (destination instanceof com.ibm.mq.jms.MQQueue) {
            String string2 = "MQJMS1112";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
            throw illegalStateException;
        }
        if (destination instanceof MQTopic) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1112");
            throw jMSException;
        }
        String string4 = "MQJMS0003";
        String string5 = ConfigEnvironment.getErrorMessage(string4);
        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
        throw invalidDestinationException;
    }

    BrokerConnectionInfo getBrk() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void sendCommand(String string, int n, String string2, byte[] byArray) throws JMSException {
        String string3 = "MQJMS1112";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        IllegalStateException illegalStateException = new IllegalStateException(string4, string3);
        throw illegalStateException;
    }

    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl) throws JMSException {
        String string3 = "MQJMS1112";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        IllegalStateException illegalStateException = new IllegalStateException(string4, string3);
        throw illegalStateException;
    }

    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        String string3 = "MQJMS1112";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        IllegalStateException illegalStateException = new IllegalStateException(string4, string3);
        throw illegalStateException;
    }

    String getConnectionID() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    int getConnectionBrokerVersion() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    int getConnectionMsgSelection() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void removePublisher(MQTopicPublisher mQTopicPublisher) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    MQQueue getResponseQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void getBrokerResponse(MQMsg2 mQMsg2, boolean bl) throws NoBrokerResponseException {
        NoBrokerResponseException noBrokerResponseException = (NoBrokerResponseException)ConfigEnvironment.newException("MQJMS1112");
        throw noBrokerResponseException;
    }

    boolean getSparseSubscriptions() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    boolean requestResponse() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    void responseRequested(long l, byte[] byArray) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    boolean checkForResponse() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void unsubscribe(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerTimeout(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public Topic createTopic(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public int getBrokerTimeout() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public byte[] getSessionName() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getReceiveIsolation() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setReceiveIsolation(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOutcomeNotification() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setOutcomeNotification(boolean bl) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getProcessDuration() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setProcessDuration(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOptimisticPublication() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setOptimisticPublication(boolean bl) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }
}

