/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQRRSQueueManager;
import com.ibm.mq.jms.ConnectionBrowser;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQRRSQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQXAQueueConnection;
import com.ibm.mq.jms.MessageReferenceHandler;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class MQQueueConnection
extends MQConnection
implements QueueConnection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueConnection.java, jms, j600, j600-201-061220 1.84.1.2 06/06/28 11:08:18";

    MQQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory) throws JMSException {
        this(mQQueueConnectionFactory, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory, String string, String string2) throws JMSException {
        super(mQQueueConnectionFactory, string, string2);
        try {
            String string3;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            if ((string3 = mQQueueConnectionFactory.getClientId()) != null) {
                this.setClientID(string3);
            }
            this.qmgrName = mQQueueConnectionFactory.getQueueManager();
            this.temporaryModelQ = mQQueueConnectionFactory.getTemporaryModel();
            this.messageRetention = mQQueueConnectionFactory.getMessageRetention();
            this.tempQPrefix = mQQueueConnectionFactory.getTempQPrefix();
            if (mQQueueConnectionFactory != null && mQQueueConnectionFactory.getFailIfQuiesce() == 1) {
                this.tmpQOpenOptions |= 0x2000;
            }
            if (this instanceof MQXAQueueConnection) {
                this.initialQm = this.createQMXA();
                try {
                    this.initialQm.disconnect();
                    this.initialQm = null;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    this.initialQm = null;
                }
            }
            if (this instanceof MQRRSQueueConnection) {
                this.initialQm = this.createQMNonXA();
                MQRRSQueueManager mQRRSQueueManager = new MQRRSQueueManager(this.initialQm);
                try {
                    mQRRSQueueManager.honourRRS();
                    return;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    try {
                        this.initialQm.disconnect();
                    }
                    catch (MQException mQException2) {
                        // empty catch block
                    }
                    this.initialQm = null;
                    throw jMSException;
                }
            }
            this.initialQm = this.createQMNonXA();
            return;
        }
        catch (JMSException jMSException) {
            if (this.poolToken != null) {
                MQEnvironment.removeConnectionPoolToken((MQPoolToken)this.poolToken);
                this.poolToken = null;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            block9: {
                if (Trace.isOn) {
                    Trace.entry(this, "finalize");
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1032", exception.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    if (!Trace.isOn) break block9;
                    Trace.trace(this, "finalize caught " + exception);
                }
            }
            super.finalize();
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "finalize");
            }
        }
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        MQQueueSession mQQueueSession = (MQQueueSession)this.createQueueSession(bl, n, 0);
        mQQueueSession.mapNameStyle = this.mapNameStyle;
        return mQQueueSession;
    }

    public void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            super.close();
            if (this.initialQm != null) {
                try {
                    this.initialQm.disconnect();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
                this.initialQm = null;
            }
            if (this.qServices != null) {
                this.qServices = null;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            this.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    synchronized QueueSession createQueueSession(boolean bl, int n, int n2) throws JMSException {
        try {
            Object object;
            MQQueueManager mQQueueManager = null;
            if (Trace.isOn) {
                Trace.entry(this, "createQueueSession");
            }
            if (!bl) {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "acknowledge mode" + n);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "invalid acknowledge mode" + n);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "acknowledge mode", String.valueOf(n));
                        throw jMSException;
                    }
                }
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: {
                    if (!Trace.isOn) break;
                    Trace.trace(this, "distributed transactional mode " + n2);
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Bad distributed transactional mode " + n2);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    throw jMSException;
                }
            }
            if (this.isClosed()) {
                String string = "MQJMS1004";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                throw new IllegalStateException(string2, string);
            }
            this.setClientIDFixed();
            if (this.initialQm != null) {
                mQQueueManager = this.initialQm;
                this.initialQm = null;
            } else {
                if (this.factory.getCCDTURL() != null) {
                    this.mqProperties.put("channel", "");
                }
                switch (n2) {
                    case 0: {
                        mQQueueManager = this.createQMNonXA();
                        break;
                    }
                    case 1: {
                        mQQueueManager = this.createQMXA();
                        break;
                    }
                    case 2: {
                        mQQueueManager = this.createQMNonXA();
                        object = new MQRRSQueueManager(mQQueueManager);
                        try {
                            object.honourRRS();
                            break;
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            try {
                                mQQueueManager.disconnect();
                            }
                            catch (MQException mQException2) {
                                // empty catch block
                            }
                            mQQueueManager = null;
                            throw jMSException;
                        }
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Distibuted transactional mode unexpectedly changed! Now " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
            }
            if (mQQueueManager != null) {
                this.setSupportsQAT2(mQQueueManager.getSupportsQAT2());
            }
            object = new MQQueueSession(this, mQQueueManager, bl, n);
            ((MQSession)object).setDistTransactionMode(n2);
            ((MQQueueSession)object).mapNameStyle = this.mapNameStyle;
            this.addSession((MQSession)object);
            if (this.isStarted()) {
                try {
                    ((MQSession)object).start();
                }
                catch (JMSException jMSException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1033", jMSException.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linkedException " + exception);
                }
            }
            this.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueSession");
            }
        }
    }

    public ConnectionBrowser createDurableConnectionBrowser(Topic topic, String string, String string2, MessageReferenceHandler messageReferenceHandler, int n, boolean bl) throws JMSException {
        String string3 = "MQJMS1112";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        IllegalStateException illegalStateException = new IllegalStateException(string4, string3);
        throw illegalStateException;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        String string3 = "MQJMS1112";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        IllegalStateException illegalStateException = new IllegalStateException(string4, string3);
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createSession");
            }
            QueueSession queueSession = this.createQueueSession(bl, n);
            return queueSession;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createSession");
            }
        }
    }

    public int getReceiveIsolation() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOutcomeNotification() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getProcessDuration() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOptimisticPublication() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }
}

