/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueueEnumeration;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class MQQueueBrowser
implements QueueBrowser {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueBrowser.java, jms, j600, j600-201-061220 1.29.1.3 05/07/07 12:43:26";
    private com.ibm.mq.jms.MQQueue queue;
    private MQMessageSelector messageSelector = null;
    private MQSession session;
    private Vector enumerations = new Vector();

    MQQueueBrowser(Queue queue, String string, MQSession mQSession) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            this.queue = (com.ibm.mq.jms.MQQueue)queue;
            if (string != null && !string.equals("")) {
                this.messageSelector = new MQMessageSelector();
                try {
                    this.messageSelector.setSelector(string);
                }
                catch (SyntaxException syntaxException) {
                    this.messageSelector = null;
                    String string4 = "MQJMS0004";
                    String string5 = ConfigEnvironment.getErrorMessage(string4);
                    InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string5, string4);
                    invalidSelectorException.setLinkedException((Exception)syntaxException);
                    throw invalidSelectorException;
                }
            }
            this.session = mQSession;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue getQueue() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueue");
            }
            com.ibm.mq.jms.MQQueue mQQueue = this.queue;
            return mQQueue;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageSelector() throws JMSException {
        try {
            String string = null;
            if (Trace.isOn) {
                Trace.entry(this, "getMessageSelector");
            }
            if (this.messageSelector != null) {
                string = this.messageSelector.getSelector();
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMessageSelector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getEnumeration() throws JMSException {
        MQQueueEnumeration mQQueueEnumeration = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getEnumeration");
            }
            MQQueue mQQueue = this.session.getServicesMgr().getQueueForBrowse(this.queue, this.session);
            mQQueueEnumeration = new MQQueueEnumeration(this.session, mQQueue, this.messageSelector, this);
            this.enumerations.addElement(mQQueueEnumeration);
            MQQueueEnumeration mQQueueEnumeration2 = mQQueueEnumeration;
            return mQQueueEnumeration2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getEnumeration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        for (int i = 0; i < this.enumerations.size(); ++i) {
            MQQueueEnumeration mQQueueEnumeration = (MQQueueEnumeration)this.enumerations.elementAt(i);
            MQQueue mQQueue = mQQueueEnumeration.getQueue();
            if (mQQueue == null) continue;
            try {
                mQQueue.close();
                continue;
            }
            catch (MQException mQException) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS2000"));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
                continue;
            }
            finally {
                mQQueue = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    protected void removeEnumeration(MQQueueEnumeration mQQueueEnumeration) {
        if (Trace.isOn) {
            Trace.trace(this, "Removing enumeration " + mQQueueEnumeration.toString());
        }
        this.enumerations.remove(mQQueueEnumeration);
    }
}

