/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQBrokerSubscription;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQQueueSubscriptionEngine;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQMigrateSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQMigrateSubscriptionEngine.java, jms, j600, j600-201-061220 1.41.1.1 05/05/25 16:04:16";
    private int useBrokerSubStore;
    private static final int BSS_AVAILABLE = 1;
    private static final int BSS_UNAVAILABLE = 0;
    private static final int BSS_UNKNOWN = -1;
    private MQQueueSubscriptionEngine queueSubStore;
    private MQBrokerSubscriptionEngine brokerSubStore;
    private int WSClone = 0;

    public MQMigrateSubscriptionEngine(MQConnection mQConnection, MQConnectionFactory mQConnectionFactory, MQQueueManager mQQueueManager, String string) throws JMSException {
        super(mQConnection);
        if (Trace.isOn) {
            Trace.entry(this, "MQMigrateSubscriptionEngine (constructor)");
        }
        try {
            this.WSClone = mQConnectionFactory.getCloneSupport();
            this.useBrokerSubStore = -1;
            if (!((MQSPIQueueManager)mQQueueManager).spiSupportsDeferred()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Queue Manager doesn't support deferred messages - using Queue substore");
                }
                this.useBrokerSubStore = 0;
            }
            if (this.useBrokerSubStore == -1 || this.useBrokerSubStore == 0) {
                this.queueSubStore = new MQQueueSubscriptionEngine(mQConnection, mQQueueManager);
            }
            if (this.useBrokerSubStore == -1 || this.useBrokerSubStore == 1) {
                this.brokerSubStore = new MQBrokerSubscriptionEngine(mQConnection, mQConnectionFactory, string);
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)((Object)mQException));
            Trace.exception(this, "MQMigrateSubscriptionEngine (constructor)", (Throwable)mQException);
            throw jMSException;
        }
        catch (JMSException jMSException) {
            Trace.exception(this, "MQMigrateSubscriptionEngine (constructor)", (Throwable)jMSException);
            if (this.queueSubStore != null) {
                this.queueSubStore.close();
            }
            if (this.brokerSubStore != null) {
                this.brokerSubStore.close();
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQMigrateSubscriptionEngine (constructor)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQSubscription openSubscription(MQSession mQSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2) throws JMSException {
        boolean bl3 = true;
        Object object = null;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription");
        }
        try {
            MQQueueSubscriptionEngine mQQueueSubscriptionEngine;
            block16: while (bl3) {
                switch (this.useBrokerSubStore) {
                    case 1: {
                        bl3 = false;
                        object = this.brokerSubStore.openSubscription(mQSession, mQTopic, string, bl, bl2, string2);
                        continue block16;
                    }
                    case -1: {
                        JMSException jMSException;
                        try {
                            if (!((MQSPIQueueManager)mQSession.getQM()).spiSupportsDeferred()) {
                                if (this.useBrokerSubStore != 0) {
                                    this.useBrokerSubStore = 0;
                                    this.brokerSubStore.close();
                                    this.brokerSubStore = null;
                                }
                                bl3 = true;
                                continue block16;
                            }
                            try {
                                object = (MQBrokerSubscription)this.brokerSubStore.openSubscription(mQSession, mQTopic, string, bl, bl2, string2);
                                this.useBrokerSubStore = 1;
                                bl3 = false;
                                continue block16;
                            }
                            catch (JMSException jMSException2) {
                                if (jMSException2 instanceof BrokerCommandFailedException && (((BrokerCommandFailedException)(jMSException = (BrokerCommandFailedException)jMSException2)).getReason() == 3083 || ((BrokerCommandFailedException)jMSException).getReason() == 2337)) {
                                    if (this.useBrokerSubStore != 0) {
                                        this.useBrokerSubStore = 0;
                                        this.brokerSubStore.close();
                                        this.brokerSubStore = null;
                                    }
                                    bl3 = true;
                                    continue block16;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "test of brokerSubStore failed. Broker type still unknown");
                                }
                                throw jMSException2;
                            }
                        }
                        catch (Exception exception) {
                            if (exception instanceof JMSException) {
                                jMSException = (JMSException)((Object)exception);
                            } else {
                                jMSException = ConfigEnvironment.newException("MQJMS1016");
                                jMSException.setLinkedException(exception);
                            }
                            throw jMSException;
                        }
                    }
                }
                if (this.WSClone == 1) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                    throw jMSException;
                }
                bl3 = false;
                object = this.queueSubStore.openSubscription(mQSession, mQTopic, string, bl, bl2, string2);
            }
            if (this.queueSubStore != null) {
                mQQueueSubscriptionEngine = this.queueSubStore;
                synchronized (mQQueueSubscriptionEngine) {
                    if (this.useBrokerSubStore == 1 && this.queueSubStore != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "BrokerSubEngine is available. Closing QueueSubscriptionEngine");
                        }
                        this.queueSubStore.close();
                        this.queueSubStore = null;
                    }
                }
            }
            mQQueueSubscriptionEngine = object;
            return mQQueueSubscriptionEngine;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "openSubscription");
            }
        }
    }

    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        if (mQSubscription instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeSubscription(mQSubscription);
        } else if (mQSubscription instanceof MQQueueSubscription) {
            this.queueSubStore.closeSubscription(mQSubscription);
        } else {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
            throw jMSException;
        }
    }

    /*
     * Exception decompiling
     */
    public MQSubscription openDurableSubscription(MQSession var1_1, MQTopic var2_2, String var3_3, boolean var4_4, boolean var5_5, String var6_6, String var7_7) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [28[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        if (mQSubscription instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeDurableSubscription(mQSubscription);
        } else if (mQSubscription instanceof MQQueueSubscription) {
            this.queueSubStore.closeDurableSubscription(mQSubscription);
        } else {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void durableUnsubscribe(MQSession mQSession, String string) throws JMSException {
        MQQueue mQQueue = null;
        try {
            mQQueue = this.getAdminQueueAccess(mQSession, mQSession.getFailIfQuiesce());
            if (this.brokerSubStore != null && this.checkQueueSubscription(mQSession, string, mQQueue, mQSession.getFailIfQuiesce()) == null) {
                this.brokerSubStore.durableUnsubscribe(mQSession, string);
            } else {
                block9: {
                    try {
                        mQQueue.close();
                        mQQueue = null;
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block9;
                        Trace.trace(this, "error closing adminQueue");
                        Trace.exception(this, "durableUnsubscribe", (Throwable)mQException);
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1032", new Integer(mQException.reasonCode));
                        throw jMSException;
                    }
                }
                this.queueSubStore.durableUnsubscribe(mQSession, string);
            }
            Object var7_6 = null;
            if (mQQueue == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (mQQueue == null) throw throwable;
            try {
                mQQueue.close();
                throw throwable;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
        }
        try {
            mQQueue.close();
            return;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS2000");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.queueSubStore != null) {
            this.queueSubStore.close();
        }
        if (this.brokerSubStore != null) {
            this.brokerSubStore.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    private MQQueueSubscription checkQueueSubscription(MQSession mQSession, String string, MQQueue mQQueue, int n) throws JMSException {
        Object object = null;
        String string2 = null;
        String string3 = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        if (Trace.isOn) {
            Trace.entry(this, "checkQueueSubscription");
        }
        try {
            MQMessage mQMessage;
            string2 = this.getMQConnection().getClientID();
            if (string2 == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                if (Trace.isOn) {
                    Trace.exception(this, "checkQueueSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            string3 = string2 + ":" + string;
            mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 16;
            if (n == 1) {
                mQGetMessageOptions.options |= 0x2000;
            }
            boolean bl = true;
            while (bl) {
                try {
                    mQMessage = new MQMessage();
                    mQQueue.get(mQMessage, mQGetMessageOptions);
                    object = new MQQueueSubscription(this, mQSession, mQMessage);
                    if (((MQQueueSubscription)object).isValid() && ((MQQueueSubscription)object).getFullName().equals(string3)) {
                        bl = false;
                        continue;
                    }
                    mQGetMessageOptions.options = 32;
                    if (n != 1) continue;
                    mQGetMessageOptions.options |= 0x2000;
                }
                catch (MQException mQException) {
                    object = null;
                    bl = false;
                }
            }
            mQMessage = object;
            return mQMessage;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "checkQueueSubscription", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "checkQueueSubscription");
            }
        }
    }

    private MQQueue getAdminQueueAccess(MQSession mQSession, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getAdminQueueAccess");
        }
        MQQueueManager mQQueueManager = mQSession.qm;
        MQQueue mQQueue = null;
        int n2 = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Try to open the adminQueue");
                }
                int n3 = 60;
                if (n == 1) {
                    n3 |= 0x2000;
                }
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", n3);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "I'm sorry Dave. I can't do that");
                }
                switch (mQException.reasonCode) {
                    case 2042: {
                        if (++n2 < 20) {
                            if (Trace.isOn) {
                                Trace.trace(this, "admin queue locked, tried " + n2 + "times");
                            }
                            Trace.trace(this, "suppressing exception and retrying after wait");
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Daisy, Daisy....");
                                }
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Tried 20 attempts. I'm bored now so I'll throw an exception");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.trace(this, "Obtaining the admin queue lock required " + n2 + " retries");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAdminQueueAccess");
        }
        return mQQueue;
    }

    byte[] getStatusMgrId() {
        return this.queueSubStore.getStatusMgrId();
    }

    byte[] createSessionName(MQSession mQSession) throws JMSException {
        if (this.brokerSubStore != null) {
            return this.brokerSubStore.createSessionName(mQSession);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MQMsg2 sendBrokerMessage(MQSession var1_1, MQMsg2 var2_2, MQPutMessageOptions var3_3, boolean var4_4, int var5_5) throws JMSException {
        var6_6 = null;
        var7_7 = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessage(mqs, brkMsg, MQMsg2, pmo, deferred)");
        }
        try {
            block21: {
                var8_8 = var1_1.getBrk();
                var9_10 = 16;
                var10_14 /* !! */  = var1_1.qm;
                if (var3_3 == null) {
                    var3_3 = new MQPutMessageOptions();
                }
                if (var5_5 == 1) {
                    var9_10 |= 8192;
                    var3_3.options |= 8192;
                }
                if (!var4_4) ** GOTO lbl26
                var11_15 = (MQSPIQueueManager)var10_14 /* !! */ ;
                if (var11_15.spiSupportsDeferred()) break block21;
                var12_16 = null;
                return var12_16;
            }
            try {
                block22: {
                    try {
                        var6_6 = var11_15.accessQueue(var8_8.controlQ, var9_10, var8_8.qmName, null, null);
                        ((MQSPIQueue)var6_6).spiDeferredPut(var2_2, var3_3);
                        break block22;
lbl26:
                        // 1 sources

                        var6_6 = var1_1.qm.accessQueue(var8_8.controlQ, var9_10, var8_8.qmName, null, null);
                        var6_6.putMsg2(var2_2, var3_3);
                    }
                    catch (MQException var9_11) {
                        var10_14 /* !! */  = ConfigEnvironment.newException("MQJMS2008", var8_8.controlQ);
                        var10_14 /* !! */ .setLinkedException((Exception)var9_11);
                        if (Trace.isOn) {
                            Trace.trace(this, "Failed to MQPUT broker command due to: " + (Object)var9_11);
                        }
                        throw var10_14 /* !! */ ;
                    }
                }
                try {
                    var6_6.close();
                }
                catch (MQException var9_12) {
                    var10_14 /* !! */  = ConfigEnvironment.newException("MQJMS2000");
                    var10_14 /* !! */ .setLinkedException((Exception)var9_12);
                    if (Trace.isOn) {
                        Trace.trace(this, "Failed to close broker queue");
                    }
                    throw var10_14 /* !! */ ;
                }
            }
            catch (JMSException var9_13) {
                if (Trace.isOn) {
                    Trace.trace(this, "Failed to put message to broker queue");
                }
                throw var9_13;
            }
        }
        catch (JMSException var8_9) {
            if (Trace.isOn) {
                Trace.exception(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)", (Throwable)var8_9);
            }
            throw var8_9;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)");
            }
        }
        return var2_2;
    }

    private MQMsg2 sendBrokerMessage(MQSession mQSession, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n) throws JMSException {
        return this.sendBrokerMessage(mQSession, mQMsg2, mQPutMessageOptions, false, n);
    }

    private MQBrokerMessage getBrokerResponse(MQSession mQSession, MQMsg2 mQMsg2) throws JMSException {
        MQBrokerMessage mQBrokerMessage = null;
        MQMsg2 mQMsg22 = null;
        MQQueue mQQueue = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerResponse");
        }
        try {
            MQBrokerMessage mQBrokerMessage2;
            if (this.getMQConnection().getBrkVersion() == 0) {
                mQBrokerMessage = new RFH1BrokerMessageImpl();
                mQBrokerMessage2 = new RFH1BrokerMessageImpl();
            } else {
                mQBrokerMessage = new RFH2BrokerMessageImpl();
                mQBrokerMessage2 = new RFH2BrokerMessageImpl();
            }
            mQMsg22 = new MQMsg2();
            mQMsg22.setCorrelationId(mQMsg2.getMessageId());
            try {
                mQQueue = mQSession.getResponseQueue();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 1;
                mQGetMessageOptions.waitInterval = mQSession.getBrokerTimeout();
                if (this.getMQConnection().getFailIfQuiesce() == 1) {
                    mQGetMessageOptions.options |= 0x2000;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "setting broker timeout to " + mQSession.getBrokerTimeout());
                }
                mQQueue.getMsg2(mQMsg22, mQGetMessageOptions);
            }
            catch (MQException mQException) {
                String string = "MQJMS5053";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.exception(this, "error getting broker response: ", (Throwable)((Object)noBrokerResponseException));
                }
                throw noBrokerResponseException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "got broker response");
            }
            mQBrokerMessage.initializeFromMessage(mQMsg22);
            mQBrokerMessage2.initializeFromMessage(mQMsg2);
            if (mQBrokerMessage2.isOptionSet("MQPSRegOpts", 65536) && Integer.parseInt(mQBrokerMessage.get("MQPSCompCode")) != 2 && mQBrokerMessage2.get("MQPSTopic") == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Full response didn't work, using workaround and setting fail");
                }
                mQBrokerMessage.set("MQPSCompCode", Integer.toString(2));
                mQBrokerMessage.set("MQPSReason", Integer.toString(2337));
                mQBrokerMessage.set("MQPSReasonText", "MQRC_RFH_PARM_ERROR");
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "exception thrown getting broker response", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getBrokerResponse");
            }
        }
        return mQBrokerMessage;
    }

    /*
     * Loose catch block
     */
    void removeQueueSubscription(MQSession mQSession, MQQueueSubscription mQQueueSubscription) throws JMSException {
        block29: {
            MQQueue mQQueue;
            block27: {
                JMSException jMSException;
                mQQueue = null;
                MQQueue mQQueue2 = null;
                MQQueueSubscription mQQueueSubscription2 = null;
                byte[] byArray = null;
                String string = null;
                MQGetMessageOptions mQGetMessageOptions = null;
                int n = 1;
                if (mQQueueSubscription.getMQTopic() != null) {
                    n = mQQueueSubscription.getMQTopic().getFailIfQuiesce();
                } else if (mQSession != null) {
                    n = mQSession.getFailIfQuiesce();
                }
                mQQueue = this.getAdminQueueAccess(mQSession, n);
                byArray = mQQueueSubscription.getCorrelationId();
                string = mQQueueSubscription.getSubName();
                mQGetMessageOptions = new MQGetMessageOptions();
                if (byArray == null) {
                    mQGetMessageOptions.options = 16;
                }
                boolean bl = true;
                if (this.getMQConnection().getFailIfQuiesce() == 1) {
                    mQGetMessageOptions.options |= 0x2000;
                }
                while (bl) {
                    try {
                        MQMessage mQMessage = new MQMessage();
                        if (byArray != null) {
                            mQMessage.messageId = byArray;
                            mQGetMessageOptions.matchOptions |= 1;
                        }
                        mQQueue.get(mQMessage, mQGetMessageOptions);
                        mQQueueSubscription2 = new MQQueueSubscription(this, mQQueueSubscription.getMQSession(), mQMessage);
                        if (byArray != null) {
                            bl = false;
                            continue;
                        }
                        if (mQQueueSubscription2.isValid() && mQQueueSubscription2.getSubName().equals(string)) {
                            mQGetMessageOptions.options = 256;
                            jMSException = new MQMessage();
                            mQQueue.get((MQMessage)jMSException, mQGetMessageOptions);
                            bl = false;
                            continue;
                        }
                        mQGetMessageOptions.options = 32;
                        if (this.getMQConnection().getFailIfQuiesce() != 1) continue;
                        mQGetMessageOptions.options |= 0x2000;
                    }
                    catch (MQException mQException) {
                        jMSException = ConfigEnvironment.newException("MQJMS3013");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (Trace.isOn) {
                            Trace.trace(this, "In removeSubscriptionEntry() - cannot remove msg!");
                        }
                        throw jMSException;
                    }
                }
                try {
                    if (mQQueueSubscription.getSubscriberQueue() != null) {
                        mQQueue2 = mQQueueSubscription.getSubscriberQueue();
                        mQQueue2.close();
                        mQQueue2 = null;
                    }
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error closing subscriber queue");
                        Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                    }
                    jMSException = ConfigEnvironment.newException("MQJMS1032", new Integer(mQException.reasonCode));
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var14_16 = null;
                try {
                    if (mQQueue != null) {
                        mQQueue.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block27;
                    Trace.trace(this, "error closing adminQueue - tracing exception only");
                    Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeQueueSubscription");
            }
            break block29;
            {
                catch (JMSException jMSException) {
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block28: {
                    Object var14_17 = null;
                    try {
                        if (mQQueue != null) {
                            mQQueue.close();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block28;
                        Trace.trace(this, "error closing adminQueue - tracing exception only");
                        Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "removeQueueSubscription");
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private MQBrokerSubscription getMigratedSubscription(MQQueueSubscription var1_1, MQSession var2_2, String var3_3) throws JMSException {
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        var12_12 = null;
        var13_13 = 0;
        var14_14 = null;
        var15_15 = null;
        var16_16 = null;
        var17_17 = false;
        var18_18 = false;
        var19_19 = null;
        var20_20 = null;
        var21_21 = null;
        var22_22 = null;
        var23_23 = null;
        var24_24 = null;
        var25_25 = null;
        var26_26 = null;
        var28_27 = 0;
        var29_28 = null;
        try {
            var26_26 = var2_2.getBrk();
            var5_5 = this.escapeString(var1_1.getQmgrName());
            var6_6 = this.escapeString(this.getMQConnection().getClientID());
            var7_7 = this.escapeString(var3_3);
            var4_4 = "JMS:" + var5_5 + ":" + var6_6 + ":" + var7_7;
            if (Trace.isOn) {
                Trace.trace(this, "Fullname = '" + var4_4 + "'");
            }
            if ((var24_24 = var1_1.getSelector()) != null && !var24_24.trim().equals("")) {
                var8_8 = this.escapeString(var24_24);
                var9_9 = "sel=\"" + var8_8 + "\"";
            } else {
                var9_9 = "";
            }
            var30_29 = 1;
            if (var1_1.getMQTopic() != null) {
                var30_29 = var1_1.getMQTopic().getFailIfQuiesce();
            } else if (var2_2 != null) {
                var30_29 = var2_2.getFailIfQuiesce();
            }
            try {
                try {
                    var13_13 = 0x180000;
                    if (var1_1.isSharedQueue()) {
                        ++var13_13;
                    }
                    var11_11 = this.getMQConnection().getBrkVersion() == 0 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                    var11_11.set("MQPSCommand", "DeregSub");
                    var11_11.set("MQPSRegOpts", var13_13);
                    var11_11.set("MQPSSubName", var4_4);
                    var11_11.set("MQPSSubIdentity", Utils.bytesToHex(var2_2.getSessionName()));
                    var11_11.set("MQPSQMgrName", var1_1.getQmgrName());
                    var11_11.set("MQPSQName", var1_1.getQueueName());
                    var11_11.set("MQPSStreamName", var26_26.streamQ);
                    var11_11.set("MQPSTopic", var1_1.getTopic());
                    var29_28 = var1_1.getFilter();
                    if (var29_28 != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting filter to " + var29_28);
                        }
                        var11_11.set("MQPSFilter", var29_28);
                    }
                }
                catch (JMSException var31_31) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error composing update MQBrokerMessage");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var31_31);
                    }
                    throw var31_31;
                }
                try {
                    var14_14 = new MQMsg2();
                    var11_11.writeToMessage(var14_14);
                    var14_14.setCorrelationId(var1_1.getCorrelationId());
                    var14_14.setReplyToQueueManagerName("");
                    var14_14.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    var14_14.setFormat(var11_11.getHeaderFormat());
                    var14_14.setMessageType(8);
                }
                catch (Exception var31_32) {
                    if (var31_32 instanceof JMSException) {
                        var32_45 = (JMSException)var31_32;
                    } else {
                        var32_45 = ConfigEnvironment.newException(var31_32.getMessage());
                        var32_45.setLinkedException(var31_32);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "error building deferred deregister MQMsg2");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var32_45);
                    }
                    throw var32_45;
                }
                try {
                    var14_14 = this.sendBrokerMessage(var2_2, var14_14, null, true, var30_29);
                    var18_18 = true;
                }
                catch (JMSException var31_33) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error sending deferred broker message");
                    }
                    throw var31_33;
                }
            }
            catch (JMSException var31_34) {
                if (Trace.isOn) {
                    Trace.trace(this, "error attempting to put deferred deregister");
                }
                throw var31_34;
            }
            var16_16 = var14_14.getMessageId();
            try {
                try {
                    var13_13 = 0x114000;
                    var13_13 = this.WSClone == 1 ? (var13_13 += 131072) : (var13_13 += 262144);
                    if (var2_2.acknowledgeMode == 3 && this.getMQConnection().getBrkOptLevel() > 0) {
                        var13_13 += 512;
                    }
                    if (var1_1.isSharedQueue()) {
                        ++var13_13;
                    }
                    var11_11 = this.getMQConnection().getBrkVersion() == 0 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                    var11_11.set("MQPSCommand", "RegSub");
                    var11_11.set("MQPSRegOpts", var13_13);
                    var11_11.set("MQPSSubName", var4_4);
                    var11_11.set("MQPSSubIdentity", Utils.bytesToHex(var2_2.getSessionName()));
                    var11_11.set("MQPSQMgrName", var1_1.getQmgrName());
                    var11_11.set("MQPSQName", var1_1.getQueueName());
                    var11_11.set("MQPSStreamName", var26_26.streamQ);
                    var11_11.set("MQPSTopic", var1_1.getTopic());
                    var11_11.set("MQPSSubUserData", var9_9);
                    var29_28 = var1_1.getFilter();
                    if (var29_28 != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting filter to " + var29_28);
                        }
                        var11_11.set("MQPSFilter", var29_28);
                    }
                }
                catch (JMSException var31_35) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error composing update MQBrokerMessage");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var31_35);
                    }
                    throw var31_35;
                }
                try {
                    var14_14 = new MQMsg2();
                    var11_11.writeToMessage(var14_14);
                    var14_14.setCorrelationId(var1_1.getCorrelationId());
                    var14_14.setReplyToQueueManagerName("");
                    var14_14.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    var14_14.setFormat(var11_11.getHeaderFormat());
                    var14_14.setMessageType(1);
                }
                catch (Exception var31_36) {
                    if (var31_36 instanceof JMSException) {
                        var32_46 = (JMSException)var31_36;
                    } else {
                        var32_46 = ConfigEnvironment.newException(var31_36.getMessage());
                        var32_46.setLinkedException(var31_36);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "error building broker update MQMsg2");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var32_46);
                    }
                    throw var32_46;
                }
                try {
                    var14_14 = this.sendBrokerMessage(var2_2, var14_14, null, var30_29);
                }
                catch (JMSException var31_37) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error sending update subscription message to broker");
                    }
                    throw var31_37;
                }
            }
            catch (JMSException var31_38) {
                if (Trace.isOn) {
                    Trace.trace(this, "error sending broker update message");
                }
                throw var31_38;
            }
            try {
                if (this.getMQConnection().getBrkVersion() == 0) {
                    var12_12 = new RFH1BrokerMessageImpl();
                    var12_12 = (RFH1BrokerMessageImpl)this.getBrokerResponse(var2_2, var14_14);
                } else {
                    var12_12 = new RFH2BrokerMessageImpl();
                    var12_12 = (RFH2BrokerMessageImpl)this.getBrokerResponse(var2_2, var14_14);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "got update response from broker");
                }
                var27_51 = Integer.parseInt(var12_12.get("MQPSCompCode"));
                var28_27 = Integer.parseInt(var12_12.get("MQPSReason"));
            }
            catch (JMSException var31_39) {
                if (Trace.isOn) {
                    Trace.trace(this, "error getting response from broker update message");
                }
                throw var31_39;
            }
            if (Trace.isOn) {
                Trace.trace(this, "requested full Response. Did we get it?");
            }
            if ((var12_12.get("MQPSTopic") == null || var12_12.get("MQPSTopic").equals("")) && var27_51 != 2) {
                if (Trace.isOn) {
                    Trace.trace(this, "No full Response. This should be a failure");
                }
                var27_51 = 2;
                var28_27 = 2337;
            }
            switch (var27_51) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    if (var28_27 != 3083 && var28_27 != 2337) ** GOTO lbl200
                    this.useBrokerSubStore = 0;
                    try {
                        this.brokerSubStore.close();
                    }
                    catch (Exception var31_40) {
                        if (!Trace.isOn) ** GOTO lbl199
                        Trace.trace(this, "error attempting to close brokerSubStore");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var31_40);
                    }
lbl199:
                    // 3 sources

                    this.brokerSubStore = null;
                }
lbl200:
                // 3 sources

                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "something went wrong updating the subscription");
                        Trace.trace(this, var12_12.get("MQPSReasonText"));
                    }
                    throw new JMSException(var12_12.get("MQPSReasonText"));
                }
            }
            try {
                var31_41 = var12_12.get("MQPSQMgrName").trim();
                var32_47 = var12_12.get("MQPSTopic").trim();
                var33_52 = var12_12.get("MQPSQName").trim();
                var34_53 = var12_12.get("MQPSCorrelId").trim();
                var10_10 = new MQBrokerSubscription(this, var2_2, true, var1_1.isSharedQueue(), (String)var31_41, this.getMQConnection().getClientID(), var3_3, var1_1.getMQTopic(), var1_1.getSelector(), var1_1.getNoLocal(), var33_52, null, Utils.hexToBytes(var34_53));
                var25_25 = this.openSubscriberQueue(var2_2, var33_52, var1_1.isSharedQueue(), true, var30_29);
                var10_10.setSubscriberQueue(var25_25);
                var10_10.setDeferredMsgId(var16_16);
            }
            catch (JMSException var31_42) {
                if (Trace.isOn) {
                    Trace.trace(this, "error creating new MQBrokerSubscription object from migrated subscription");
                    Trace.exception(this, "getMigratedSubscription", (Throwable)var31_42);
                }
                throw var31_42;
            }
            var31_41 = var10_10;
            return var31_41;
        }
        catch (JMSException var30_30) {
            block76: {
                if (Trace.isOn) {
                    Trace.trace(this, "error encountered while trying to migrate subscription - exiting via exception");
                }
                if (var18_18) {
                    if (Trace.isOn) {
                        Trace.trace(this, "cancelling deferred message");
                    }
                    try {
                        var31_43 = var2_2.qm;
                        if (!(var31_43 instanceof MQSPIQueueManager)) {
                            var32_48 = new JMSException("MQJMS3047");
                            throw var32_48;
                        }
                        var32_49 = (MQSPIQueueManager)var31_43;
                        var32_49.spiCancelDeferred(var16_16);
                    }
                    catch (Exception var31_44) {
                        if (var31_44 instanceof JMSException) {
                            var32_50 = (JMSException)var31_44;
                        } else {
                            var32_50 = new JMSException(var31_44.getMessage());
                            var32_50.setLinkedException(var31_44);
                        }
                        if (!Trace.isOn) break block76;
                        Trace.trace(this, "error cancelling deferred deregister message");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var32_50);
                    }
                }
            }
            throw var30_30;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMigratedSubscription");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String escapeString(String string) {
        String string2;
        block11: {
            String string3;
            char c;
            StringBuffer stringBuffer;
            block9: {
                String string4;
                block10: {
                    stringBuffer = new StringBuffer();
                    boolean bl = false;
                    c = '\u0000';
                    string3 = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "escapeString: " + string);
                    }
                    if (string != null) break block9;
                    string4 = "";
                    Object var9_8 = null;
                    if (!Trace.isOn) break block10;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                }
                return string4;
            }
            try {
                block6: for (int i = 0; i < string.length(); ++i) {
                    c = string.charAt(i);
                    switch (c) {
                        case '\"': 
                        case ':': 
                        case ';': 
                        case '\\': {
                            string3 = "0000" + Integer.toString(c, 16);
                            stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                            continue block6;
                        }
                        default: {
                            if (c < ' ' || c > '~') {
                                string3 = "0000" + Integer.toString(c, 16);
                                stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                                continue block6;
                            }
                            stringBuffer.append(c);
                        }
                    }
                }
                string2 = stringBuffer.toString();
                Object var9_9 = null;
                if (!Trace.isOn) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_10 = null;
                    if (!Trace.isOn) break block12;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                }
                throw throwable;
            }
            Trace.trace(this, "Returning string: " + stringBuffer.toString());
            Trace.exit(this, "escapeString");
        }
        return string2;
    }
}

