/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.FWHelper;
import com.ibm.mq.MQException;
import com.ibm.mq.PeerName;
import com.ibm.mq.SSLCRLHelper;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSLevel;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQConnectionFactory
implements ConnectionFactory,
Referenceable,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQConnectionFactory.java, jms, j600, j600-202-070608 1.157.1.17 07/05/21 16:28:14";
    static final long serialVersionUID = 1357803352856448349L;
    private static final String CLASSNAME = "MQConnectionFactory";
    public static final String KEY_VERSION = "VER";
    public static final String KEY_DESCRIPTION = "DESC";
    public static final String KEY_TRANSPORT_TYPE = "TRAN";
    public static final String KEY_CLIENT_ID = "CID";
    public static final String KEY_QUEUE_MANAGER = "QMGR";
    public static final String KEY_HOST_NAME = "HOST";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_CHANNEL = "CHAN";
    public static final String KEY_CCSID = "CCS";
    public static final String KEY_RECEIVE_EXIT = "RCX";
    public static final String KEY_RECEIVE_EXIT_INIT = "RCXI";
    public static final String KEY_SECURITY_EXIT = "SCX";
    public static final String KEY_SECURITY_EXIT_INIT = "SCXI";
    public static final String KEY_SEND_EXIT = "SDX";
    public static final String KEY_SEND_EXIT_INIT = "SDXI";
    public static final String KEY_SYNCPOINT_ALL_GETS = "SPAG";
    public static final String KEY_USE_CONN_POOLING = "UCP";
    public static final String KEY_POLLING_INTERVAL = "PINT";
    public static final String KEY_MSG_BATCH_SIZE = "MBS";
    public static final String KEY_SSL_CIPHER_SUITE = "SCPHS";
    public static final String KEY_SSL_PEER_NAME = "SPEER";
    public static final String KEY_SSL_CERT_STORES = "SCRL";
    public static final String KEY_SSL_RESET_COUNT = "SRC";
    public static final String KEY_SSL_FIPS_REQUIRED = "SFIPS";
    public static final String KEY_FAIL_IF_QUIESCE = "FIQ";
    public static final String KEY_RESCAN_INTERVAL = "RINT";
    public static final String KEY_LOCAL_ADDRESS = "LA";
    public static final String KEY_TARG_CLIENT_MATCH = "TCM";
    public static final String KEY_HEADER_COMP = "HC";
    public static final String KEY_MSG_COMP = "MC";
    public static final String KEY_CONNTAG = "CT";
    public static final String KEY_CONN_OPTS = "CTO";
    public static final String KEY_RCV_ISOL = "RCVISOL";
    public static final String KEY_OUT_NOTIFY = "NOTIFY";
    public static final String KEY_PROC_DUR = "PROCDUR";
    public static final String KEY_OPT_PUB = "OPTPUB";
    public static final String KEY_CCDTURL = "CCDTURL";
    public static final String KEY_MAPMSG_NAME_STYLE = "MNST";
    private int version = 6;
    private String description = null;
    private int transportType = 0;
    private String clientId = null;
    private String queueManager = "";
    private String hostName = "localhost";
    public static final int MQ_DEFAULT_PORT = 1414;
    public static final int DIRECT_DEFAULT_PORT = 1506;
    private int port = 1414;
    private boolean portSet = false;
    private String channel = "SYSTEM.DEF.SVRCONN";
    private int CCSID = 819;
    private String receiveExit = null;
    private String receiveExitInit = null;
    private String securityExit = null;
    private String securityExitInit = null;
    private String sendExit = null;
    private String sendExitInit = null;
    private URL ccdtUrl = null;
    private int failIfQuiesce = 1;
    private boolean syncpointAllGets = false;
    private boolean useConnectionPooling = true;
    private int pollingInterval = 5000;
    private int rescanInterval = 5000;
    protected boolean mapNameStyle = true;
    private int msgBatchSize = 10;
    private String distinguishedName = null;
    private transient PeerName sslPeerName = null;
    private String sslCipherSuite = null;
    private String sslCertStores_string = null;
    private Collection sslCertStores_coll = null;
    private Object sslSocketFactory = null;
    private int sslResetCount = 0;
    private boolean sslFipsRequired = false;
    private String localAddress = "";
    private Collection hdrCompList = null;
    private Collection msgCompList = null;
    private boolean targetClientMatching = true;
    private byte[] connTag = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int connOptions = 0;
    public static final String KEY_TEMPORARY_MODEL = "TM";
    public static final String KEY_MESSAGE_RETENTION = "MRET";
    public static final String KEY_TEMPQ_PREFIX = "TQPFX";
    private String temporaryModel = "SYSTEM.DEFAULT.MODEL.QUEUE";
    private int messageRetention = 1;
    protected String tempQPrefix = "";
    private boolean qPrefixSet = false;
    private static final int defaultCCSID = 819;
    private static final String defaultHostName = "localhost";
    private static final String defaultQueueManager = "";
    public static final String KEY_BROKER_CONTROL_QUEUE = "BCON";
    public static final String KEY_BROKER_PUB_QUEUE = "BPUB";
    public static final String KEY_BROKER_SUB_QUEUE = "BSUB";
    public static final String KEY_BROKER_CCSUB_QUEUE = "CCSUB";
    public static final String KEY_BROKER_QUEUE_MANAGER = "BQM";
    public static final String KEY_BROKER_VERSION = "BVER";
    public static final String KEY_MESSAGE_SELECTION = "MSEL";
    public static final String KEY_PUB_ACK_INTERVAL = "PAI";
    public static final String KEY_STATUS_REFRESH_INTERVAL = "SRI";
    public static final String KEY_SUBSCRIPTION_STORE = "SUBST";
    public static final String KEY_CLEANUP_LEVEL = "CL";
    public static final String KEY_CLEANUP_INTERVAL = "CLINT";
    public static final String KEY_CLONE_SUPPORT = "CLS";
    public static final String KEY_SPARSE_SUBS = "SSUBS";
    public static final String KEY_MULTICAST = "MCAST";
    public static final String KEY_PROXY_HOSTNAME = "PHOST";
    public static final String KEY_PROXY_PORT = "PPORT";
    public static final String KEY_DIRECTAUTH = "DAUTH";
    public static final String KEY_MAXBUFFERSIZE = "MBSZ";
    protected String brokerControlQueue = "SYSTEM.BROKER.CONTROL.QUEUE";
    protected String brokerPubQueue = "SYSTEM.BROKER.DEFAULT.STREAM";
    protected String brokerQueueManager = "";
    protected int brokerVersion = 0;
    protected boolean bverSet = false;
    protected int messageSelection = 0;
    protected boolean mselSet = false;
    protected String brokerSubQueue = "SYSTEM.JMS.ND.SUBSCRIBER.QUEUE";
    protected String brokerCCSubQueue = "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE";
    protected int pubAckInterval = 25;
    protected int statusRefreshInterval = 60000;
    protected int subscriptionStore = 2;
    protected int cleanupLevel = 1;
    protected long cleanupInterval = 3600000L;
    protected int cloneSupport = 0;
    protected boolean sparseSubscriptions = false;
    protected int multicast = 0;
    protected String proxyHostName = null;
    protected int proxyPort = 443;
    protected int directAuth = 0;
    protected int maxBufferSize = 1000;
    protected int receiveIsolation = 0;
    protected boolean outcomeNotification = true;
    protected int processDuration = 0;
    protected boolean optimisticPublication = false;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQConnectionFactoryFactory;

    public MQConnectionFactory() {
        if (Trace.isOn) {
            Trace.trace(this, "Manifest File Level: " + MQJMSLevel.queryValue(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getVersion");
            }
            int n = this.version;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getVersion");
            }
        }
    }

    public void setVersion(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setVersion");
            }
            JMSException jMSException = new JMSException("Version can't be changed");
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (Throwable throwable) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAddress() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getLocalAddress");
            }
            String string = this.localAddress;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getLocalAddress");
            }
        }
    }

    public void setLocalAddress(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setLocalAddress");
        }
        try {
            if (string != null && string.equals(defaultQueueManager)) {
                string = null;
            }
            FWHelper.getLocalIP((String)string);
            FWHelper.getStartPort((String)string);
            FWHelper.getEndPort((String)string);
            if (Trace.isOn) {
                Trace.trace(this, "Passed validation of firewall property.");
            }
            this.localAddress = string != null ? string.trim() : string;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "FAILED validation of firewall property.");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "localAddress", "'" + String.valueOf(string) + "'");
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setLocalAddress");
            }
        }
    }

    public void setLocalAddressNoChecking(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setLocalAddressNoChecking");
        }
        try {
            if (string != null && string.equals(defaultQueueManager)) {
                string = null;
            }
            FWHelper.getStartPort((String)string);
            FWHelper.getEndPort((String)string);
            if (Trace.isOn) {
                Trace.trace(this, "Passed validation of firewall property.");
            }
            this.localAddress = string != null ? string.trim() : string;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "FAILED validation of firewall property.");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "localAddress", "'" + String.valueOf(string) + "'");
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setLocalAddressNoChecking");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getHdrCompList() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getHdrCompList");
            }
            if (this.hdrCompList == null) {
                Collection collection = null;
                return collection;
            }
            Vector<Integer> vector = new Vector<Integer>();
            Iterator iterator = this.hdrCompList.iterator();
            Integer n = null;
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                vector.add(n);
            }
            Vector<Integer> vector2 = vector;
            return vector2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getHdrCompList");
            }
        }
    }

    public String getHdrCompListAsString() {
        String string = null;
        if (this.hdrCompList != null) {
            string = defaultQueueManager;
            Iterator iterator = this.hdrCompList.iterator();
            if (iterator != null) {
                Integer n = new Integer(0);
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    switch (n) {
                        case 0: {
                            string = string + "NONE ";
                            break;
                        }
                        case 8: {
                            string = string + "SYSTEM ";
                        }
                    }
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHdrCompList(Collection collection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setHdrCompList");
        }
        try {
            if (collection == null || collection.size() == 0) {
                this.hdrCompList = null;
                return;
            }
            Integer n = new Integer(0);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    n = (Integer)iterator.next();
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Compression technique of unacceptable type");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compression technique of unacceptable type");
                    throw jMSException;
                }
                if (n == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Compression technique null");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compression technique null");
                    throw jMSException;
                }
                int n2 = n;
                if (n2 == 0 || n2 == 8) continue;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Invalid value for compression technique", n);
                throw jMSException;
            }
            if (this.hdrCompList == null) {
                this.hdrCompList = new Vector();
            } else {
                this.hdrCompList.clear();
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.hdrCompList.add((Integer)iterator.next());
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setHdrCompList");
            }
        }
    }

    public void setHdrCompList(String string) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "setMsgCompListAsString");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Integer> vector = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("NONE")) {
                vector.add(new Integer(0));
                continue;
            }
            if (((String)object).equals("SYSTEM")) {
                vector.add(new Integer(8));
                continue;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Compression technique value is not supported");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compression technique value is not supported: " + (String)object);
            throw jMSException;
        }
        if (this.hdrCompList == null) {
            this.hdrCompList = new Vector();
        } else {
            this.hdrCompList.clear();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            this.hdrCompList.add(object.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getMsgCompList() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMsgCompList");
            }
            if (this.msgCompList == null) {
                Collection collection = null;
                return collection;
            }
            Vector<Integer> vector = new Vector<Integer>();
            Iterator iterator = this.msgCompList.iterator();
            Integer n = null;
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                vector.add(n);
            }
            Vector<Integer> vector2 = vector;
            return vector2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMsgCompList");
            }
        }
    }

    public String getMsgCompListAsString() {
        String string = null;
        if (this.msgCompList != null) {
            string = defaultQueueManager;
            Iterator iterator = this.msgCompList.iterator();
            Integer n = new Integer(0);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    switch (n) {
                        case 0: {
                            string = string + "NONE ";
                            break;
                        }
                        case 1: {
                            string = string + "RLE ";
                            break;
                        }
                        case 2: {
                            string = string + "ZLIBFAST ";
                            break;
                        }
                        case 4: {
                            string = string + "ZLIBHIGH ";
                        }
                    }
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgCompList(Collection collection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMsgCompList");
        }
        try {
            if (collection == null || collection.size() == 0) {
                this.msgCompList = null;
                return;
            }
            Integer n = new Integer(0);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    n = (Integer)iterator.next();
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Compressor of unacceptable type");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compressor of unacceptable type");
                    throw jMSException;
                }
                if (n == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Compressor null");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compressor null");
                    throw jMSException;
                }
                int n2 = n;
                if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 4) continue;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Invalid value for compressor", n);
                throw jMSException;
            }
            if (this.msgCompList == null) {
                this.msgCompList = new Vector();
            } else {
                this.msgCompList.clear();
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.msgCompList.add((Integer)iterator.next());
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMsgCompList");
            }
        }
    }

    public void setMsgCompList(String string) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "setMsgCompListAsString");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<Integer> vector = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("NONE")) {
                vector.add(new Integer(0));
                continue;
            }
            if (((String)object).equals("RLE")) {
                vector.add(new Integer(1));
                continue;
            }
            if (((String)object).equals("ZLIBFAST")) {
                vector.add(new Integer(2));
                continue;
            }
            if (((String)object).equals("ZLIBHIGH")) {
                vector.add(new Integer(4));
                continue;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Compressor value is not supported");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Compressor value is not supported: " + (String)object);
            throw jMSException;
        }
        object = vector.iterator();
        if (this.msgCompList == null) {
            this.msgCompList = new Vector();
        } else {
            this.msgCompList.clear();
        }
        while (object.hasNext()) {
            this.msgCompList.add(object.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getConnTag() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getConnTag");
            }
            byte[] byArray = this.connTag;
            return byArray;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getConnTag");
            }
        }
    }

    public void setConnTag(byte[] byArray) {
        int n;
        if (Trace.isOn) {
            Trace.entry(this, "setConnTag");
        }
        for (n = 0; n < (byArray.length < 128 ? byArray.length : 128); ++n) {
            this.connTag[n] = byArray[n];
        }
        for (n = byArray.length; n < 128; ++n) {
            this.connTag[n] = 0;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setConnTag");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMQConnectionOptions() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMQConnectionOptions");
            }
            int n = this.connOptions;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMQConnectionOptions");
            }
        }
    }

    public void setMQConnectionOptions(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMQConnectionOptions");
        }
        int n2 = 0;
        if ((n & 8) != 0) {
            ++n2;
        }
        if ((n & 0x10) != 0) {
            ++n2;
        }
        if ((n & 2) != 0) {
            ++n2;
        }
        if ((n & 4) != 0) {
            ++n2;
        }
        if (n2 > 1) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid value for ConnTagOption");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Connection options: " + n);
            throw jMSException;
        }
        n2 = 0;
        if ((n & 1) != 0) {
            ++n2;
        }
        if ((n & 0x200) != 0) {
            ++n2;
        }
        if ((n & 0x100) != 0) {
            ++n2;
        }
        if (n2 > 1) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid value for ConnTagOption");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Connection options: " + n);
            throw jMSException;
        }
        n2 = n;
        if ((n2 &= 0xFFFFFCE0) > 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid value for ConnTagOption");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Connection options: " + n);
            throw jMSException;
        }
        this.connOptions = n;
        if (this.getTransportType() == 1 && ((n & 8) != 0 || (n & 0x10) != 0)) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Invalid connection options when in client mode: " + n);
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setMQConnectionOptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailIfQuiesce() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getFailIfQuiesce");
            }
            int n = this.failIfQuiesce;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getFailIfQuiesce");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFailIfQuiesce(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFailIfQuiesce");
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.failIfQuiesce = n;
                    return;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "failIfQuiesce", String.valueOf(n));
                    throw jMSException;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFailIfQuiesce");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDescription");
            }
            String string = this.description;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getDescription");
            }
        }
    }

    public void setDescription(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setDescription");
        }
        this.description = string;
        if (Trace.isOn) {
            Trace.exit(this, "setDescription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransportType() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTransportType");
            }
            int n = this.transportType;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getTransportType");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTransportType(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTransportType");
            }
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    int n2;
                    if (n == 1 && (((n2 = this.getMQConnectionOptions()) & 2) != 0 || (n2 & 4) != 0)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Invalid connection options when in client mode: " + n2);
                        throw jMSException;
                    }
                    this.transportType = n;
                    if (!this.portSet) {
                        this.port = 1414;
                    }
                    if (this instanceof MQQueueConnectionFactory) {
                        return;
                    } else {
                        this.setBrokerVersionDefault(0);
                        return;
                    }
                }
                case 2: 
                case 4: {
                    if (!this.portSet) {
                        this.port = 1506;
                    }
                    if (this instanceof MQQueueConnectionFactory) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "transportType", String.valueOf(n));
                        throw jMSException;
                    }
                    this.setBrokerVersionDefault(1);
                    this.transportType = n;
                    return;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "transportType", String.valueOf(n));
                    throw jMSException;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setTransportType");
            }
        }
    }

    public String getClientId() {
        return this.getClientID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getClientID");
            }
            String string = this.clientId;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getClientID");
            }
        }
    }

    public void setClientId(String string) {
        this.setClientID(string);
    }

    public void setClientID(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setClientID");
        }
        this.clientId = string;
        if (Trace.isOn) {
            Trace.exit(this, "setClientID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueManager() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueueManager");
            }
            String string = this.queueManager;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueueManager");
            }
        }
    }

    public void setQueueManager(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setQueueManager");
            }
            if (string == null || string.length() > 48) {
                String string2 = string;
                if (string2 == null) {
                    string2 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "queueManager", string2);
                throw jMSException;
            }
            this.queueManager = string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setQueueManager");
            }
        }
    }

    public void setHostName(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setHostName");
        }
        this.hostName = string;
        if (Trace.isOn) {
            Trace.exit(this, "setHostName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostName() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getHostName");
            }
            String string = this.hostName;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getHostName");
            }
        }
    }

    public void setPort(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPort");
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "port", String.valueOf(n));
                throw jMSException;
            }
            this.port = n;
            this.portSet = true;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPort");
            }
        }
    }

    public int getPort() {
        if (Trace.isOn) {
            Trace.entry(this, "getPort");
            Trace.exit(this, "getPort");
        }
        return this.port;
    }

    public void setCCDTURL(URL uRL) {
        if (Trace.isOn) {
            Trace.entry(this, "setCCDTURL");
        }
        this.ccdtUrl = uRL;
        if (Trace.isOn) {
            Trace.exit(this, "setCCDTURL");
        }
    }

    public URL getCCDTURL() {
        if (Trace.isOn) {
            Trace.entry(this, "getCCDTURL");
            Trace.exit(this, "getCCDTURL");
        }
        return this.ccdtUrl;
    }

    public void setChannel(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setChannel");
            }
            if (string == null || string.length() > 20) {
                String string2 = string;
                if (string2 == null) {
                    string2 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "channel", string2);
                throw jMSException;
            }
            this.channel = string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setChannel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChannel() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getChannel");
            }
            String string = this.channel;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getChannel");
            }
        }
    }

    public void setCCSID(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setCCSID");
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "CCSID", String.valueOf(n));
                throw jMSException;
            }
            this.CCSID = n;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCCSID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCCSID() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getCCSID");
            }
            int n = this.CCSID;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getCCSID");
            }
        }
    }

    public void setReceiveExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setReceiveExit");
        }
        this.receiveExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setReceiveExit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReceiveExit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReceiveExit");
            }
            String string = this.receiveExit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReceiveExit");
            }
        }
    }

    public void setReceiveExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setReceiveExitInit");
        }
        this.receiveExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setReceiveExitInit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReceiveExitInit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReceiveExitInit");
            }
            String string = this.receiveExitInit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReceiveExitInit");
            }
        }
    }

    public void setSecurityExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSecurityExit");
        }
        this.securityExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSecurityExit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecurityExit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSecurityExit");
            }
            String string = this.securityExit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSecurityExit");
            }
        }
    }

    public void setSecurityExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSecurityExitInit");
        }
        this.securityExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSecurityExitInit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecurityExitInit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSecurityExitInit");
            }
            String string = this.securityExitInit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSecurityExitInit");
            }
        }
    }

    public void setSendExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSendExit");
        }
        this.sendExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSendExit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSendExit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSendExit");
            }
            String string = this.sendExit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSendExit");
            }
        }
    }

    public void setSendExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSendExitInit");
        }
        this.sendExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSendExitInit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSendExitInit() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSendExitInit");
            }
            String string = this.sendExitInit;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSendExitInit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncpointAllGets(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSyncpointAllGets");
                Trace.trace(this, "setting to " + bl);
            }
            this.syncpointAllGets = bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setSyncpointAllGets");
            }
        }
    }

    public boolean getSyncpointAllGets() {
        return this.syncpointAllGets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseConnectionPooling(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setUseConnectionPooling");
                Trace.trace(this, "setting to " + bl);
            }
            this.useConnectionPooling = bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setUseConnectionPooling");
            }
        }
    }

    public boolean getUseConnectionPooling() {
        return this.useConnectionPooling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgBatchSize(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setMsgBatchSize");
                Trace.trace(this, "setting to " + n);
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "MsgBatchSize", String.valueOf(n));
                throw jMSException;
            }
            this.msgBatchSize = n;
        }
        finally {
            Trace.exit(this, "setMsgBatchSize");
        }
    }

    public int getMsgBatchSize() {
        return this.msgBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingInterval(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPollingInterval");
                Trace.trace(this, "setting to " + n);
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "pollingInterval", String.valueOf(n));
                throw jMSException;
            }
            this.pollingInterval = n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPollingInterval");
            }
        }
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRescanInterval(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setRescanInterval");
                Trace.trace(this, "setting to " + n);
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "rescanInterval", String.valueOf(n));
                throw jMSException;
            }
            this.rescanInterval = n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setRescanInterval");
            }
        }
    }

    public int getRescanInterval() {
        return this.rescanInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapNameStyle(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setMapNameStyle");
                Trace.trace(this, "setting to " + bl);
            }
            this.mapNameStyle = bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMapNameStyle");
            }
        }
    }

    public boolean getMapNameStyle() {
        return this.mapNameStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLPeerName(String string) throws JMSException {
        block8: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setSSLPeerName");
                    Trace.trace(this, "setting to " + string);
                }
                if (string == null) {
                    this.sslPeerName = null;
                    this.distinguishedName = null;
                    break block8;
                }
                try {
                    this.sslPeerName = new PeerName(string, true);
                    this.distinguishedName = new String(string);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "SSL Peer DN", string);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setSSLPeerName");
                }
            }
        }
    }

    public String getSSLPeerName() {
        return this.distinguishedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLCipherSuite(String string) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSSLCipherSuite");
                Trace.trace(this, "setting to " + string);
            }
            this.sslCipherSuite = string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setSSLCipherSuite");
            }
        }
    }

    public String getSSLCipherSuite() {
        return this.sslCipherSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLCertStores(Collection collection) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSSLCertStores (Collection)");
            }
            this.sslCertStores_coll = collection;
            this.sslCertStores_string = null;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setSSLCertStores (Collection)");
            }
        }
    }

    public void setSSLCertStores(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setSSLCertStores (String)");
            Trace.trace(this, "setting to " + string);
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = defaultQueueManager;
                String string3 = stringTokenizer.nextToken();
                if (!string3.toUpperCase().startsWith("LDAP://")) {
                    throw ConfigEnvironment.newException("MQJMS1006", "CertStore URI protocol", string3);
                }
                int n = string3.indexOf(58, 7);
                if (n != -1) {
                    try {
                        int n2 = Integer.parseInt(string3.substring(n + 1));
                        string2 = string3.substring(7, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw ConfigEnvironment.newException("MQJMS1006", "CertStore URI port", string3);
                    }
                } else {
                    string2 = string3.substring(7);
                }
                if (string2.length() > 0) continue;
                throw ConfigEnvironment.newException("MQJMS1006", "CertStore URI port", string3);
            }
        }
        this.sslCertStores_string = string;
        this.sslCertStores_coll = null;
        if (Trace.isOn) {
            Trace.exit(this, "setSSLCertStores (String)");
        }
    }

    public Collection getSSLCertStores() throws JMSException {
        if (this.sslCertStores_coll != null) {
            return this.sslCertStores_coll;
        }
        if (this.sslCertStores_string == null) {
            return null;
        }
        this.sslCertStores_coll = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(this.sslCertStores_string);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                SSLCRLHelper.addCertStoreAsString((String)string, (Collection)this.sslCertStores_coll);
                bl = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.sslCertStores_coll = null;
                throw ConfigEnvironment.newException("MQJMS1056", "SSLCRL");
            }
            catch (MQException mQException) {
                if (!bl && !stringTokenizer.hasMoreTokens()) {
                    this.sslCertStores_coll = null;
                    throw ConfigEnvironment.newException("MQJMS1006", "CertStore URI", string);
                }
                if (!Trace.isOn) continue;
                Trace.trace(2, this, "CRL server " + string + " not found, trying next server");
            }
        }
        return this.sslCertStores_coll;
    }

    public String getSSLCertStoresAsString() throws JMSException {
        if (this.sslCertStores_string == null && this.sslCertStores_coll != null) {
            throw ConfigEnvironment.newException("MQJMS0000", "getSSLCertStoresAsString");
        }
        return this.sslCertStores_string;
    }

    public void setSSLSocketFactory(Object object) {
        this.sslSocketFactory = object;
    }

    public Object getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setTemporaryModel(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTemporaryModel");
            }
            if (string == null || string.length() > 48) {
                String string2 = string;
                if (string2 == null) {
                    string2 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "temporaryModel", string2);
                throw jMSException;
            }
            this.temporaryModel = string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setTemporaryModel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemporaryModel() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTemporaryModel");
            }
            String string = this.temporaryModel;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getTemporaryModel");
            }
        }
    }

    public void setMessageRetention(int n) throws JMSException {
        if (n != 1 && n != 0) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "messageRetention", new Integer(n));
            throw jMSException;
        }
        this.messageRetention = n;
    }

    public int getMessageRetention() throws JMSException {
        return this.messageRetention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTempQPrefix() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTempQPrefix");
            }
            String string = this.tempQPrefix;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getTempQPrefix");
            }
        }
    }

    public void setTempQPrefix(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTempQPrefix");
            }
            if (string == null || string.equals(defaultQueueManager)) {
                this.tempQPrefix = string;
                return;
            }
            int n = 0;
            n = string.length();
            if (n < 2 || n > 33 || !string.substring(string.length() - 1, string.length()).equals("*")) {
                String string2 = string;
                if (string2 == null) {
                    string2 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "tempQPrefix", string2);
                throw jMSException;
            }
            this.tempQPrefix = string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setTempQPrefix");
            }
        }
    }

    public void setBrokerControlQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerControlQueue", string2);
            throw jMSException;
        }
        this.brokerControlQueue = string;
    }

    public String getBrokerControlQueue() throws JMSException {
        return this.brokerControlQueue;
    }

    public void setBrokerQueueManager(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerQueueManager", string2);
            throw jMSException;
        }
        this.brokerQueueManager = string;
    }

    public String getBrokerQueueManager() throws JMSException {
        return this.brokerQueueManager;
    }

    public void setBrokerPubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerPubQueue", string2);
            throw jMSException;
        }
        this.brokerPubQueue = string;
    }

    public String getBrokerPubQueue() throws JMSException {
        return this.brokerPubQueue;
    }

    public String getBrokerSubQueue() throws JMSException {
        return this.brokerSubQueue;
    }

    public void setBrokerSubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerSubQueue", string2);
            throw jMSException;
        }
        this.brokerSubQueue = string;
    }

    public String getBrokerCCSubQueue() throws JMSException {
        return this.brokerCCSubQueue;
    }

    public void setBrokerCCSubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerCCSubQueue", string2);
            throw jMSException;
        }
        this.brokerCCSubQueue = string;
    }

    public int getBrokerVersion() throws JMSException {
        return this.brokerVersion;
    }

    public void setBrokerVersion(int n) throws JMSException {
        switch (n) {
            case 0: {
                int n2 = this.transportType;
                switch (n2) {
                    case 2: 
                    case 4: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerVersion", String.valueOf(n));
                        throw jMSException;
                    }
                }
                this.brokerVersion = n;
                this.bverSet = true;
                if (this.mselSet) break;
                this.messageSelection = 0;
                break;
            }
            case 1: {
                this.brokerVersion = n;
                this.bverSet = true;
                if (this.mselSet) break;
                this.messageSelection = 1;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerVersion", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public void setBrokerVersionDefault(int n) throws JMSException {
        if (!this.bverSet) {
            this.setBrokerVersion(n);
            this.bverSet = false;
        }
    }

    public int getMessageSelection() throws JMSException {
        return this.messageSelection;
    }

    public void setMessageSelection(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.messageSelection = n;
                this.mselSet = true;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "messageSelection", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getPubAckInterval() throws JMSException {
        return this.pubAckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPubAckInterval(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPubAckInterval");
                Trace.trace(this, "setting to " + n);
            }
            if (n != -1 && n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "PubAckInterval", String.valueOf(n));
                throw jMSException;
            }
            this.pubAckInterval = n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPubAckInterval");
            }
        }
    }

    public int getStatusRefreshInterval() throws JMSException {
        return this.statusRefreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusRefreshInterval(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setStatusRefreshInterval");
                Trace.trace(this, "setting to " + n);
            }
            if (n != -1 && n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "StatusRefreshInterval", String.valueOf(n));
                throw jMSException;
            }
            this.statusRefreshInterval = n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setStatusRefreshInterval");
            }
        }
    }

    public void setSubscriptionStore(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.subscriptionStore = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "subscriptionStore", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getSubscriptionStore() throws JMSException {
        return this.subscriptionStore;
    }

    public void setCleanupLevel(int n) throws JMSException {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.cleanupLevel = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getCleanupLevel() throws JMSException {
        return this.cleanupLevel;
    }

    public void setCleanupInterval(long l) throws JMSException {
        if (l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupInterval", String.valueOf(l));
            throw jMSException;
        }
        this.cleanupInterval = l;
    }

    public long getCleanupInterval() throws JMSException {
        return this.cleanupInterval;
    }

    public void setCloneSupport(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.cloneSupport = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cloneSupport", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getCloneSupport() throws JMSException {
        return this.cloneSupport;
    }

    public void setSparseSubscriptions(boolean bl) throws JMSException {
        this.sparseSubscriptions = bl;
    }

    public boolean getSparseSubscriptions() throws JMSException {
        return this.sparseSubscriptions;
    }

    public void setMulticast(int n) throws JMSException {
        if (n != 0 && n != 3 && n != 5 && n != 7) {
            throw ConfigEnvironment.newException("MQJMS1006", "multicast", String.valueOf(n));
        }
        this.multicast = n;
    }

    public int getMulticast() throws JMSException {
        return this.multicast;
    }

    public void setProxyHostName(String string) throws JMSException {
        this.proxyHostName = string;
    }

    public String getProxyHostName() throws JMSException {
        return this.proxyHostName;
    }

    public void setProxyPort(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setProxyPort");
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "proxyPort", String.valueOf(n));
                throw jMSException;
            }
            this.proxyPort = n;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setProxyPort");
            }
        }
    }

    public int getProxyPort() throws JMSException {
        return this.proxyPort;
    }

    public void setDirectAuth(int n) throws JMSException {
        if (n != 0 && n != 1) {
            throw ConfigEnvironment.newException("MQJMS1006", "directAuth", String.valueOf(n));
        }
        this.directAuth = n;
    }

    public int getDirectAuth() throws JMSException {
        return this.directAuth;
    }

    public boolean getTargetClientMatching() {
        return this.targetClientMatching;
    }

    public void setTargetClientMatching(boolean bl) {
        this.targetClientMatching = bl;
    }

    public void setMaxBufferSize(int n) throws JMSException {
        if (n < 0) {
            throw ConfigEnvironment.newException("MQJMS1006", "maxBufferSize", String.valueOf(n));
        }
        this.maxBufferSize = n;
    }

    public int getMaxBufferSize() throws JMSException {
        return this.maxBufferSize;
    }

    public int getReceiveIsolation() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "receiveIsolation = " + this.receiveIsolation);
        }
        return this.receiveIsolation;
    }

    public void setReceiveIsolation(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "attempting to set receiveIsolation = " + n);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.receiveIsolation = n;
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.trace(this, "invalid parameter specified. Not setting");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "receiveIsolation", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public boolean getOutcomeNotification() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "outcomeNotification = " + this.outcomeNotification);
        }
        return this.outcomeNotification;
    }

    public void setOutcomeNotification(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "setting outcomeNotification = " + bl);
        }
        this.outcomeNotification = bl;
    }

    public int getProcessDuration() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "processDuration = " + this.processDuration);
        }
        return this.processDuration;
    }

    public void setProcessDuration(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "attempting to set processDuration = " + n);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.processDuration = n;
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.trace(this, "invalid parameter specified. Not setting");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "processDuration", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public boolean getOptimisticPublication() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "optimisticPublication = " + this.optimisticPublication);
        }
        return this.optimisticPublication;
    }

    public void setOptimisticPublication(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "setting optimisticPublication = " + bl);
        }
        this.optimisticPublication = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference = new Reference((class$com$ibm$mq$jms$MQConnectionFactory == null ? (class$com$ibm$mq$jms$MQConnectionFactory = MQConnectionFactory.class$("com.ibm.mq.jms.MQConnectionFactory")) : class$com$ibm$mq$jms$MQConnectionFactory).getName(), (class$com$ibm$mq$jms$MQConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQConnectionFactoryFactory = MQConnectionFactory.class$("com.ibm.mq.jms.MQConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQConnectionFactoryFactory).getName(), null);
            this.populateReference(reference);
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    public void setSSLResetCount(int n) throws JMSException {
        if (n < 0 || n > 999999999) {
            throw ConfigEnvironment.newException("MQJMS1006", "sslResetCount", String.valueOf(n));
        }
        if (Trace.isOn) {
            Trace.trace(this, "setting sslResetCount = " + n);
        }
        this.sslResetCount = n;
    }

    public int getSSLResetCount() {
        if (Trace.isOn) {
            Trace.trace(this, "sslResetCount = " + this.sslResetCount);
        }
        return this.sslResetCount;
    }

    public boolean getSSLFipsRequired() {
        if (Trace.isOn) {
            Trace.trace(this, "sslFipsRequired = " + this.sslFipsRequired);
        }
        return this.sslFipsRequired;
    }

    public void setSSLFipsRequired(boolean bl) {
        if (Trace.isOn) {
            Trace.trace(this, "setting sslFipsRequired = " + bl);
        }
        this.sslFipsRequired = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateReference(Reference reference) throws OperationNotSupportedException {
        String string = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "populateReference");
            }
            this.updateReference(reference);
            string = this.getTemporaryModel();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_TEMPORARY_MODEL, string));
            }
            if ((string = this.getTempQPrefix()) != null) {
                reference.add(new StringRefAddr(KEY_TEMPQ_PREFIX, string));
            }
            reference.add(new StringRefAddr(KEY_MESSAGE_RETENTION, String.valueOf(this.getMessageRetention())));
            string = this.getBrokerControlQueue();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CONTROL_QUEUE, string));
            }
            if ((string = this.getBrokerPubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_PUB_QUEUE, string));
            }
            if ((string = this.getBrokerSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_SUB_QUEUE, string));
            }
            if ((string = this.getBrokerCCSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CCSUB_QUEUE, string));
            }
            if ((string = this.getBrokerQueueManager()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_QUEUE_MANAGER, string));
            }
            if ((string = this.getProxyHostName()) != null) {
                reference.add(new StringRefAddr(KEY_PROXY_HOSTNAME, string));
            }
            reference.add(new StringRefAddr(KEY_BROKER_VERSION, String.valueOf(this.getBrokerVersion())));
            reference.add(new StringRefAddr(KEY_MESSAGE_SELECTION, String.valueOf(this.getMessageSelection())));
            reference.add(new StringRefAddr(KEY_PUB_ACK_INTERVAL, String.valueOf(this.getPubAckInterval())));
            reference.add(new StringRefAddr(KEY_STATUS_REFRESH_INTERVAL, String.valueOf(this.getStatusRefreshInterval())));
            reference.add(new StringRefAddr(KEY_SUBSCRIPTION_STORE, String.valueOf(this.getSubscriptionStore())));
            reference.add(new StringRefAddr(KEY_CLEANUP_LEVEL, String.valueOf(this.getCleanupLevel())));
            reference.add(new StringRefAddr(KEY_CLEANUP_INTERVAL, String.valueOf(this.getCleanupInterval())));
            reference.add(new StringRefAddr(KEY_CLONE_SUPPORT, String.valueOf(this.getCloneSupport())));
            reference.add(new StringRefAddr(KEY_SPARSE_SUBS, String.valueOf(this.sparseSubscriptions)));
            reference.add(new StringRefAddr(KEY_MULTICAST, String.valueOf(this.getMulticast())));
            reference.add(new StringRefAddr(KEY_PROXY_PORT, String.valueOf(this.getProxyPort())));
            reference.add(new StringRefAddr(KEY_DIRECTAUTH, String.valueOf(this.getDirectAuth())));
            reference.add(new StringRefAddr(KEY_MAXBUFFERSIZE, String.valueOf(this.getMaxBufferSize())));
            reference.add(new StringRefAddr(KEY_TARG_CLIENT_MATCH, String.valueOf(this.getTargetClientMatching())));
            reference.add(new StringRefAddr(KEY_RCV_ISOL, String.valueOf(this.getReceiveIsolation())));
            reference.add(new StringRefAddr(KEY_PROC_DUR, String.valueOf(this.getProcessDuration())));
            reference.add(new StringRefAddr(KEY_OUT_NOTIFY, String.valueOf(this.getOutcomeNotification())));
            reference.add(new StringRefAddr(KEY_OPT_PUB, String.valueOf(this.getOptimisticPublication())));
            reference.add(new StringRefAddr(KEY_CCDTURL, String.valueOf(this.getCCDTURL())));
            if (Trace.isOn) {
                Trace.trace(this, "ref=" + reference);
            }
        }
        catch (JMSException jMSException) {
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "populateReference");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalsCommon(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equalsCommon");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQConnectionFactory) {
                MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)object;
                boolean bl2 = bl = this.version == mQConnectionFactory.version && MQConnectionFactory.twoStringsEqual(this.description, mQConnectionFactory.description) && this.transportType == mQConnectionFactory.transportType && MQConnectionFactory.twoStringsEqual(this.clientId, mQConnectionFactory.clientId) && MQConnectionFactory.twoStringsEqual(this.queueManager, mQConnectionFactory.queueManager) && MQConnectionFactory.twoStringsEqual(this.hostName, mQConnectionFactory.hostName) && this.port == mQConnectionFactory.port && MQConnectionFactory.twoStringsEqual(this.channel, mQConnectionFactory.channel) && this.CCSID == mQConnectionFactory.CCSID && MQConnectionFactory.twoStringsEqual(this.receiveExit, mQConnectionFactory.receiveExit) && MQConnectionFactory.twoStringsEqual(this.receiveExitInit, mQConnectionFactory.receiveExitInit) && MQConnectionFactory.twoStringsEqual(this.securityExit, mQConnectionFactory.securityExit) && MQConnectionFactory.twoStringsEqual(this.securityExitInit, mQConnectionFactory.securityExitInit) && MQConnectionFactory.twoStringsEqual(this.sendExit, mQConnectionFactory.sendExit) && MQConnectionFactory.twoStringsEqual(this.sendExitInit, mQConnectionFactory.sendExitInit) && MQConnectionFactory.twoStringsEqual(new String(this.connTag), new String(mQConnectionFactory.connTag)) && this.syncpointAllGets == mQConnectionFactory.syncpointAllGets && this.useConnectionPooling == mQConnectionFactory.useConnectionPooling && this.msgBatchSize == mQConnectionFactory.msgBatchSize && this.pollingInterval == mQConnectionFactory.pollingInterval && this.rescanInterval == mQConnectionFactory.rescanInterval && MQConnectionFactory.twoStringsEqual(this.sslCipherSuite, mQConnectionFactory.sslCipherSuite) && this.sslSocketFactory == mQConnectionFactory.sslSocketFactory && this.sslResetCount == mQConnectionFactory.sslResetCount && this.sslFipsRequired == mQConnectionFactory.sslFipsRequired;
                if (bl) {
                    if (this.sslPeerName == null && mQConnectionFactory.sslPeerName != null || this.sslPeerName != null && mQConnectionFactory.sslPeerName == null) {
                        bl = false;
                    } else if (this.sslPeerName != null && mQConnectionFactory.sslPeerName != null) {
                        boolean bl3 = bl = this.sslPeerName.isMatchingPeerName(mQConnectionFactory.sslPeerName) || mQConnectionFactory.sslPeerName.isMatchingPeerName(this.sslPeerName);
                    }
                }
                if (bl) {
                    if (this.sslCertStores_coll == null && mQConnectionFactory.sslCertStores_coll != null || this.sslCertStores_coll != null && mQConnectionFactory.sslCertStores_coll == null) {
                        bl = false;
                    } else if (this.sslCertStores_coll != null && mQConnectionFactory.sslCertStores_coll != null) {
                        bl = ((Object)this.sslCertStores_coll).equals(mQConnectionFactory.sslCertStores_coll);
                    }
                }
                if (bl) {
                    if (this.hdrCompList == null && mQConnectionFactory.hdrCompList != null || this.hdrCompList != null && mQConnectionFactory.hdrCompList == null) {
                        bl = false;
                    } else if (this.hdrCompList != null && mQConnectionFactory.hdrCompList != null) {
                        bl = ((Object)this.hdrCompList).equals(mQConnectionFactory.hdrCompList);
                    }
                }
                if (bl) {
                    if (this.msgCompList == null && mQConnectionFactory.msgCompList != null || this.msgCompList != null && mQConnectionFactory.msgCompList == null) {
                        bl = false;
                    } else if (this.msgCompList != null && mQConnectionFactory.msgCompList != null) {
                        bl = ((Object)this.msgCompList).equals(mQConnectionFactory.msgCompList);
                    }
                }
                if (bl) {
                    boolean bl4 = bl = this.connOptions == mQConnectionFactory.connOptions;
                }
                if (bl) {
                    bl = this.ccdtUrl == null || mQConnectionFactory.ccdtUrl == null ? this.ccdtUrl == mQConnectionFactory.ccdtUrl : this.ccdtUrl.equals(mQConnectionFactory.ccdtUrl);
                }
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equalsCommon - result is " + bl);
            }
            boolean bl5 = bl;
            return bl5;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equalsCommon");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQConnectionFactory && !(object instanceof MQXAConnectionFactory)) {
                MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)object;
                bl = this.equalsComparison(object);
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equals");
            }
        }
    }

    protected boolean equalsComparison(Object object) {
        MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)object;
        boolean bl = this.equalsCommon(object) && MQConnectionFactory.twoStringsEqual(this.temporaryModel, mQConnectionFactory.temporaryModel) && MQConnectionFactory.twoStringsEqual(this.tempQPrefix, mQConnectionFactory.tempQPrefix) && this.messageRetention == mQConnectionFactory.messageRetention && MQConnectionFactory.twoStringsEqual(this.brokerPubQueue, mQConnectionFactory.brokerPubQueue) && MQConnectionFactory.twoStringsEqual(this.brokerQueueManager, mQConnectionFactory.brokerQueueManager) && MQConnectionFactory.twoStringsEqual(this.brokerSubQueue, mQConnectionFactory.brokerSubQueue) && MQConnectionFactory.twoStringsEqual(this.brokerCCSubQueue, mQConnectionFactory.brokerCCSubQueue) && MQConnectionFactory.twoStringsEqual(this.proxyHostName, mQConnectionFactory.proxyHostName) && this.proxyPort == mQConnectionFactory.proxyPort && this.multicast == mQConnectionFactory.multicast && this.directAuth == mQConnectionFactory.directAuth && this.maxBufferSize == mQConnectionFactory.maxBufferSize && this.pubAckInterval == mQConnectionFactory.pubAckInterval && this.statusRefreshInterval == mQConnectionFactory.statusRefreshInterval && this.messageSelection == mQConnectionFactory.messageSelection && this.brokerVersion == mQConnectionFactory.brokerVersion && this.subscriptionStore == mQConnectionFactory.subscriptionStore && this.cleanupLevel == mQConnectionFactory.cleanupLevel && this.cleanupInterval == mQConnectionFactory.cleanupInterval && this.sparseSubscriptions == mQConnectionFactory.sparseSubscriptions && this.receiveIsolation == mQConnectionFactory.receiveIsolation && this.outcomeNotification == mQConnectionFactory.outcomeNotification && this.processDuration == mQConnectionFactory.processDuration && this.optimisticPublication == mQConnectionFactory.optimisticPublication;
        return bl;
    }

    public int hashCode() {
        int n = this.version ^ this.transportType << 4 ^ this.port << 8 ^ this.CCSID << 16;
        if (this.description != null) {
            n ^= this.description.hashCode();
        }
        if (this.clientId != null) {
            n ^= this.clientId.hashCode();
        }
        if (this.queueManager != null) {
            n ^= this.queueManager.hashCode();
        }
        if (this.hostName != null) {
            n ^= this.hostName.hashCode();
        }
        if (this.channel != null) {
            n ^= this.channel.hashCode();
        }
        if (this.receiveExit != null) {
            n ^= this.receiveExit.hashCode();
        }
        if (this.receiveExitInit != null) {
            n ^= this.receiveExitInit.hashCode();
        }
        if (this.securityExit != null) {
            n ^= this.securityExit.hashCode();
        }
        if (this.securityExitInit != null) {
            n ^= this.securityExitInit.hashCode();
        }
        if (this.sendExit != null) {
            n ^= this.sendExit.hashCode();
        }
        if (this.sendExitInit != null) {
            n ^= this.sendExitInit.hashCode();
        }
        if (this.sslCipherSuite != null) {
            n ^= this.sslCipherSuite.hashCode();
        }
        if (this.sslPeerName != null) {
            n ^= this.sslPeerName.hashCode();
        }
        if (this.sslCertStores_coll != null) {
            n ^= ((Object)this.sslCertStores_coll).hashCode();
        }
        if (this.sslSocketFactory != null) {
            n ^= this.sslSocketFactory.hashCode();
        }
        if (this.hdrCompList != null) {
            n ^= ((Object)this.hdrCompList).hashCode();
        }
        if (this.msgCompList != null) {
            n ^= ((Object)this.msgCompList).hashCode();
        }
        if (this.connTag != null) {
            n ^= new String(this.connTag).hashCode();
        }
        if (this.syncpointAllGets) {
            n ^= 0xFE00;
        }
        if (this.useConnectionPooling) {
            n ^= 0x30000;
        }
        if (this.temporaryModel != null) {
            n ^= this.temporaryModel.hashCode();
        }
        if (this.ccdtUrl != null) {
            n ^= this.ccdtUrl.hashCode();
        }
        n ^= this.messageRetention << 13;
        n ^= this.msgBatchSize << 20;
        n ^= this.pollingInterval + this.rescanInterval << 7;
        n ^= this.sslResetCount << 17;
        n ^= this.connOptions << 23;
        if (this.sslFipsRequired) {
            n ^= 0x32500;
        }
        return n;
    }

    void updateReference(Reference reference) throws OperationNotSupportedException {
        String string = null;
        reference.add(new StringRefAddr(KEY_VERSION, String.valueOf(this.getVersion())));
        string = this.getDescription();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_DESCRIPTION, string));
        }
        reference.add(new StringRefAddr(KEY_TRANSPORT_TYPE, String.valueOf(this.getTransportType())));
        string = this.getClientId();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_CLIENT_ID, string));
        }
        if ((string = this.getQueueManager()) != null) {
            reference.add(new StringRefAddr(KEY_QUEUE_MANAGER, string));
        }
        if ((string = this.getHostName()) != null) {
            reference.add(new StringRefAddr(KEY_HOST_NAME, string));
        }
        reference.add(new StringRefAddr(KEY_PORT, String.valueOf(this.getPort())));
        string = this.getChannel();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_CHANNEL, string));
        }
        reference.add(new StringRefAddr(KEY_CCSID, String.valueOf(this.getCCSID())));
        string = this.getReceiveExit();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_RECEIVE_EXIT, string));
        }
        if ((string = this.getReceiveExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_RECEIVE_EXIT_INIT, string));
        }
        if ((string = this.getSecurityExit()) != null) {
            reference.add(new StringRefAddr(KEY_SECURITY_EXIT, string));
        }
        if ((string = this.getSecurityExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_SECURITY_EXIT_INIT, string));
        }
        if ((string = this.getSendExit()) != null) {
            reference.add(new StringRefAddr(KEY_SEND_EXIT, string));
        }
        if ((string = this.getSendExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_SEND_EXIT_INIT, string));
        }
        if ((string = this.getSSLCipherSuite()) != null) {
            reference.add(new StringRefAddr(KEY_SSL_CIPHER_SUITE, string));
        }
        if ((string = this.getSSLPeerName()) != null) {
            reference.add(new StringRefAddr(KEY_SSL_PEER_NAME, string));
        }
        try {
            string = this.getSSLCertStoresAsString();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_SSL_CERT_STORES, string));
            }
        }
        catch (JMSException jMSException) {
            throw new OperationNotSupportedException(ConfigEnvironment.getMessage("MQJMS1090", "SSLCertStores"));
        }
        string = this.getHdrCompListAsString();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_HEADER_COMP, string));
        }
        if ((string = this.getMsgCompListAsString()) != null) {
            reference.add(new StringRefAddr(KEY_MSG_COMP, string));
        }
        if ((string = new String(this.getConnTag())) != null) {
            reference.add(new StringRefAddr(KEY_CONNTAG, string));
        }
        reference.add(new StringRefAddr(KEY_CONN_OPTS, String.valueOf(this.getMQConnectionOptions())));
        if (this.getSSLSocketFactory() != null) {
            throw new OperationNotSupportedException(ConfigEnvironment.getMessage("MQJMS1090", "SSLSocketFactory"));
        }
        reference.add(new StringRefAddr(KEY_SSL_RESET_COUNT, String.valueOf(this.getSSLResetCount())));
        reference.add(new StringRefAddr(KEY_SSL_FIPS_REQUIRED, String.valueOf(this.getSSLFipsRequired())));
        reference.add(new StringRefAddr(KEY_SYNCPOINT_ALL_GETS, String.valueOf(this.getSyncpointAllGets())));
        reference.add(new StringRefAddr(KEY_USE_CONN_POOLING, String.valueOf(this.getUseConnectionPooling())));
        reference.add(new StringRefAddr(KEY_POLLING_INTERVAL, String.valueOf(this.getPollingInterval())));
        reference.add(new StringRefAddr(KEY_MSG_BATCH_SIZE, String.valueOf(this.getMsgBatchSize())));
        reference.add(new StringRefAddr(KEY_FAIL_IF_QUIESCE, String.valueOf(this.getFailIfQuiesce())));
        reference.add(new StringRefAddr(KEY_LOCAL_ADDRESS, this.getLocalAddress()));
        reference.add(new StringRefAddr(KEY_RESCAN_INTERVAL, String.valueOf(this.getRescanInterval())));
        reference.add(new StringRefAddr(KEY_TARG_CLIENT_MATCH, String.valueOf(this.getTargetClientMatching())));
        if (this.getCCDTURL() != null) {
            reference.add(new StringRefAddr(KEY_CCDTURL, String.valueOf(this.getCCDTURL())));
        }
        reference.add(new StringRefAddr(KEY_MAPMSG_NAME_STYLE, String.valueOf(this.getMapNameStyle())));
    }

    /*
     * WARNING - void declaration
     */
    void setCommonFromReference(Reference reference) throws JMSException {
        try {
            int bl3;
            RefAddr refAddr;
            if (Trace.isOn) {
                Trace.entry(this, "setCommonFromReference");
            }
            if ((refAddr = reference.get(KEY_VERSION)) != null) {
                int bl = Integer.parseInt((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_DESCRIPTION)) != null) {
                this.setDescription((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_TRANSPORT_TYPE)) != null) {
                this.setTransportType(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLIENT_ID)) != null) {
                this.setClientId((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_QUEUE_MANAGER)) != null) {
                void bl2;
                String string = (String)refAddr.getContent();
                if (string == null) {
                    string = defaultQueueManager;
                }
                this.setQueueManager((String)bl2);
            }
            if ((refAddr = reference.get(KEY_HOST_NAME)) != null) {
                this.setHostName((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_PORT)) != null) {
                this.setPort(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CHANNEL)) != null) {
                this.setChannel((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_CCSID)) != null) {
                this.setCCSID(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_RECEIVE_EXIT)) != null) {
                this.setReceiveExit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_RECEIVE_EXIT_INIT)) != null) {
                this.setReceiveExitInit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SECURITY_EXIT)) != null) {
                this.setSecurityExit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SECURITY_EXIT_INIT)) != null) {
                this.setSecurityExitInit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SEND_EXIT)) != null) {
                this.setSendExit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SEND_EXIT_INIT)) != null) {
                this.setSendExitInit((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SSL_CIPHER_SUITE)) != null) {
                this.setSSLCipherSuite((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SSL_PEER_NAME)) != null) {
                this.setSSLPeerName((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SSL_CERT_STORES)) != null) {
                this.setSSLCertStores((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_SSL_RESET_COUNT)) != null) {
                this.setSSLResetCount(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_SSL_FIPS_REQUIRED)) != null) {
                this.setSSLFipsRequired(Boolean.valueOf((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_HEADER_COMP)) != null) {
                this.setHdrCompList((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_MSG_COMP)) != null) {
                this.setMsgCompList((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_CONNTAG)) != null) {
                this.setConnTag(((String)refAddr.getContent()).getBytes());
            }
            if ((refAddr = reference.get(KEY_CONN_OPTS)) != null && (bl3 = Integer.parseInt((String)refAddr.getContent())) != 0) {
                this.setMQConnectionOptions(bl3);
            }
            if ((refAddr = reference.get(KEY_TARG_CLIENT_MATCH)) != null) {
                boolean string = Boolean.valueOf((String)refAddr.getContent());
                this.setTargetClientMatching(string);
            }
            if ((refAddr = reference.get(KEY_SYNCPOINT_ALL_GETS)) != null) {
                boolean malformedURLException = Boolean.valueOf((String)refAddr.getContent());
                this.setSyncpointAllGets(malformedURLException);
            }
            if ((refAddr = reference.get(KEY_USE_CONN_POOLING)) != null) {
                boolean bl4 = Boolean.valueOf((String)refAddr.getContent());
                this.setUseConnectionPooling(bl4);
            }
            if ((refAddr = reference.get(KEY_POLLING_INTERVAL)) != null) {
                this.setPollingInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_RESCAN_INTERVAL)) != null) {
                this.setRescanInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_MSG_BATCH_SIZE)) != null) {
                this.setMsgBatchSize(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_FAIL_IF_QUIESCE)) != null) {
                this.setFailIfQuiesce(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_LOCAL_ADDRESS)) != null) {
                void var3_13;
                String jMSException = (String)refAddr.getContent();
                if (jMSException == null) {
                    String string = defaultQueueManager;
                }
                this.setLocalAddressNoChecking((String)var3_13);
            }
            if ((refAddr = reference.get(KEY_RCV_ISOL)) != null) {
                this.setReceiveIsolation(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_OUT_NOTIFY)) != null) {
                boolean bl = Boolean.valueOf((String)refAddr.getContent());
                this.setOutcomeNotification(bl);
            }
            if ((refAddr = reference.get(KEY_PROC_DUR)) != null) {
                this.setProcessDuration(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_OPT_PUB)) != null) {
                boolean bl = Boolean.valueOf((String)refAddr.getContent());
                this.setOptimisticPublication(bl);
            }
            if ((refAddr = reference.get(KEY_CCDTURL)) != null) {
                try {
                    String string = refAddr.getContent().toString();
                    if (string == null || string.equals("null")) {
                        this.setCCDTURL(null);
                    } else {
                        this.setCCDTURL(new URL(string));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "ccdturl", "'" + (String)refAddr.getContent() + "'");
                    throw jMSException;
                }
            }
            if ((refAddr = reference.get(KEY_MAPMSG_NAME_STYLE)) != null) {
                boolean bl = Boolean.valueOf((String)refAddr.getContent());
                this.setMapNameStyle(bl);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCommonFromReference");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean twoStringsEqual(String string, String string2) {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "twoStringsEqual");
            }
            if (string == null && string2 == null) {
                boolean bl = true;
                return bl;
            }
            if (string == null || string2 == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = string.equals(string2);
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "twoStringsEqual");
            }
        }
    }

    void setFromReference(Reference reference) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFromReference");
            }
            this.setCommonFromReference(reference);
            RefAddr refAddr = reference.get(KEY_TEMPORARY_MODEL);
            if (refAddr != null) {
                this.setTemporaryModel((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_TEMPQ_PREFIX)) != null) {
                this.setTempQPrefix((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_MESSAGE_RETENTION)) != null) {
                this.setMessageRetention(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_BROKER_CONTROL_QUEUE)) != null) {
                this.setBrokerControlQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_PUB_QUEUE)) != null) {
                this.setBrokerPubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_SUB_QUEUE)) != null) {
                this.setBrokerSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_CCSUB_QUEUE)) != null) {
                this.setBrokerCCSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_QUEUE_MANAGER)) != null) {
                String string = (String)refAddr.getContent();
                if (string == null) {
                    string = defaultQueueManager;
                }
                this.setBrokerQueueManager(string);
            }
            if ((refAddr = reference.get(KEY_PROXY_HOSTNAME)) != null) {
                this.setProxyHostName((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_VERSION)) != null) {
                this.setBrokerVersion(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_MESSAGE_SELECTION)) != null) {
                this.setMessageSelection(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_PUB_ACK_INTERVAL)) != null) {
                this.setPubAckInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_STATUS_REFRESH_INTERVAL)) != null) {
                this.setStatusRefreshInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_SUBSCRIPTION_STORE)) != null) {
                this.setSubscriptionStore(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLEANUP_LEVEL)) != null) {
                this.setCleanupLevel(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLEANUP_INTERVAL)) != null) {
                this.setCleanupInterval(Long.parseLong((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLONE_SUPPORT)) != null) {
                this.setCloneSupport(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_SPARSE_SUBS)) != null) {
                this.sparseSubscriptions = Boolean.valueOf((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_MULTICAST)) != null) {
                this.setMulticast(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_PROXY_PORT)) != null) {
                this.setProxyPort(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_DIRECTAUTH)) != null) {
                this.setDirectAuth(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_MAXBUFFERSIZE)) != null) {
                this.setMaxBufferSize(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_RCV_ISOL)) != null) {
                this.setReceiveIsolation(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_PROC_DUR)) != null) {
                this.setProcessDuration(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_OUT_NOTIFY)) != null) {
                this.setOutcomeNotification(Boolean.valueOf((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_OPT_PUB)) != null) {
                this.setOptimisticPublication(Boolean.valueOf((String)refAddr.getContent()));
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromReference");
            }
        }
    }

    public Connection createConnection() throws JMSException {
        Connection connection = null;
        if (Trace.isOn()) {
            Trace.entry(this, "createConnection");
        }
        try {
            String string;
            if (this.brokerVersion != 1 && this.messageSelection == 1) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3036");
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.exit(this, "createMQConnection");
                }
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 0: 
                case 3: {
                    connection = new MQConnection(this, null, null, true);
                    break;
                }
                case 1: {
                    string = System.getProperty("user.name");
                    if (Trace.isOn) {
                        Trace.trace(this, "connecting as user: " + string);
                    }
                    connection = new MQConnection(this, string, defaultQueueManager, true);
                    break;
                }
                case 2: 
                case 4: {
                    connection = this.createDirectConnection();
                    break;
                }
                default: {
                    connection = new MQConnection(this, null, null, true);
                }
            }
            string = connection;
            return string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createConnection");
            }
        }
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        Connection connection = null;
        if (Trace.isOn()) {
            Trace.entry(this, "createConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password is not-null");
                Trace.trace(this, "password length=" + string2.length());
            } else {
                Trace.trace(this, "password is null");
            }
        }
        try {
            if (this.brokerVersion != 1 && this.messageSelection == 1) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3036");
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.exit(this, "createConnection");
                }
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    connection = new MQConnection(this, string, string2, true);
                    break;
                }
                case 2: 
                case 4: {
                    connection = this.createDirectConnection(string, string2);
                    break;
                }
                default: {
                    connection = new MQConnection(this, string, string2, true);
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createConnection");
            }
        }
    }

    protected Connection createDirectConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDirectConnection");
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("user.name");
                }
                catch (AccessControlException accessControlException) {
                    return "anonymous";
                }
            }
        });
        Connection connection = this.createDirectConnection(string, null);
        if (Trace.isOn) {
            Trace.exit(this, "createDirectConnection");
        }
        return connection;
    }

    protected Connection createDirectConnection(String string, String string2) throws JMSException {
        ConnectionImpl connectionImpl;
        if (Trace.isOn) {
            Trace.entry(this, "createDirectConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password is not-null");
                Trace.trace(this, "password length=" + string2.length());
            } else {
                Trace.trace(this, "password is null");
            }
        }
        if (string == null || string.equals(defaultQueueManager)) {
            String string3 = ConfigEnvironment.getErrorMessage("MQJMS4124", "userName");
            throw new JMSParameterIsNullException(string3);
        }
        SessionConfig sessionConfig = new SessionConfig();
        String string4 = "tcp";
        if (this.directAuth == 0) {
            sessionConfig.AUTH_PROTOCOLS = "PM";
        } else if (this.directAuth == 1) {
            sessionConfig.AUTH_PROTOCOLS = "SR";
            sessionConfig.SSL_CIPHER_SUITES = "SSL_RSA_WITH_RC4_128_SHA";
            if (Trace.isOn && this.getSSLCipherSuite() != null) {
                Trace.trace(this, "WARNING: User specified ciphersuite " + this.getSSLCipherSuite() + " ignored for DIRECTAUTH");
            }
            SessionConfig.CLIENT_SECURITY_IMPL = "com.ibm.mq.jms.SxaSecurityImpl";
            sessionConfig.SSL_CLASS = "com.ibm.mq.jms.JsseImpl";
            sessionConfig.SSL_PEER_NAME = this.getSSLPeerName();
            sessionConfig.SSL_CERT_STORES = this.getSSLCertStores();
            sessionConfig.SSL_SOCKET_FACTORY = this.getSSLSocketFactory();
        }
        sessionConfig.MULTICAST_ENABLED = true;
        String string5 = this.getLocalAddress();
        if (string5 != null && !string5.equals(defaultQueueManager)) {
            if (string5.indexOf(40) != -1) {
                Trace.trace(this, "Port specified on localAddr parameter (" + string5 + ") on a DH connect - failing connect");
                throw ConfigEnvironment.newException("MQJMS1105");
            }
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = string5;
        } else {
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = "none";
        }
        if (this.proxyHostName != null && !this.proxyHostName.equals(defaultQueueManager)) {
            sessionConfig.HTTP_PROXY = this.proxyHostName;
            sessionConfig.HTTP_PROXY_PORT = this.proxyPort;
            string4 = "connect-via-proxy";
        } else if (this.getTransportType() == 4) {
            string4 = "http";
        }
        sessionConfig.MAX_MESSAGE_QUEUE_SIZE = this.maxBufferSize;
        String string6 = this.getHostName();
        int n = this.getPort();
        SessionConfig.noMoreChanges = true;
        if (Trace.isOn) {
            Trace.trace(this, "DH: directSocketType = " + string4);
            Trace.trace(this, "DH: AUTH_PROTOCOLS = " + sessionConfig.AUTH_PROTOCOLS);
            Trace.trace(this, "DH: SSL_PEER_NAME = " + sessionConfig.SSL_PEER_NAME);
            Trace.trace(this, "DH: MCAST_INTERFACE = " + sessionConfig.MULTICAST_MULTICAST_INTERFACE);
            Trace.trace(this, "DH: HTTP_PROXY = " + sessionConfig.HTTP_PROXY);
            Trace.trace(this, "DH: HTTP_PROXY_PORT = " + sessionConfig.HTTP_PROXY_PORT);
            Trace.trace(this, "DH: MAX_MESSAGE_QUEUE_SIZE = " + sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        }
        try {
            switch (this.getTransportType()) {
                case 4: {
                    connectionImpl = new ConnectionImpl(this, string4, string6, n, string, string2, sessionConfig);
                    break;
                }
                default: {
                    connectionImpl = this.proxyHostName != null ? new ConnectionImpl(this, string4, string6, n, string, string2, sessionConfig) : new ConnectionImpl(this, string4, string6, n, string, string2, sessionConfig);
                }
            }
            String string7 = this.getClientId();
            if (string7 != null && string7.length() > 0) {
                connectionImpl.setClientID(string7);
            }
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1923708604, (Object[])new Object[]{iOException}), iOException);
        }
        if (Trace.isOn) {
            Trace.exit(this, "createDirectConnection");
        }
        return connectionImpl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "readObject");
            }
            objectInputStream.defaultReadObject();
            if (this.distinguishedName != null) {
                try {
                    this.sslPeerName = new PeerName(this.distinguishedName, true);
                }
                catch (MQException mQException) {
                    this.distinguishedName = null;
                    if (!Trace.isOn) break block5;
                    Trace.trace(this, "Unable to create respective PeerName object.");
                    Trace.trace(this, "'distinguishedName' has been invalidated as a result.");
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "readObject");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.mq.jms.services.ConfigEnvironment");
                        return clazz;
                    }
                    catch (AccessControlException accessControlException) {
                        System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + accessControlException);
                        return null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + classNotFoundException);
                        return null;
                    }
                }
            });
            if (clazz != null) {
                clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + exception);
        }
    }
}

