/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.client.Listener;
import com.ibm.disthub2.client.MessageBodyHandle;
import com.ibm.disthub2.client.ThreadProvider;
import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.ConnectorImpl;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.client.SubscriptionInfo;
import com.ibm.disthub2.impl.client.TopicImpl;
import com.ibm.disthub2.impl.formats.MessageDataHandle;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.multicast.MulticastUtil;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.DoPrivileged;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.impl.util.PriorityQueueNode;
import com.ibm.disthub2.impl.util.PriorityQueuePlus;
import com.ibm.disthub2.impl.util.SocketThreadPool;
import com.ibm.disthub2.impl.util.SocketThreadPoolClient;
import com.ibm.disthub2.impl.util.SocketThreadPoolClientHndl;
import com.ibm.disthub2.impl.util.SocketThreadPoolException;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionMulticastSupport;
import com.ibm.mq.jms.ExceptionDispatchThread;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.SubscriptionInfoImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class ConnectionImpl
extends ConnectorImpl
implements Connection,
SocketThreadPoolClient,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/ConnectionImpl.java, disthub, j600, j600-202-070608 1.54.1.4 06/12/20 13:12:19";
    private static final DebugObject debug = new DebugObject("ConnectionImpl");
    private String clientID = null;
    private boolean clientIDFixed = false;
    public static ThreadProvider threadProvider = new ThreadProvider(){

        public void schedule(Runnable runnable) {
            DoPrivileged.createAndStartThread((Runnable)runnable, (boolean)true);
        }
    };
    private SocketThreadPoolClientHndl m_threadPoolHandle;
    private static SocketThreadPool s_clientSocketThreadPool;
    private ExceptionListener exceptionListener;
    protected boolean appConnectionClosed = true;
    protected Exception eConnectionClosed = null;
    private String userName;
    public boolean haltExecution = false;
    public SessionConfig sessionConfig;
    FreeSpaceHeap fsh;
    protected Vector sessions;
    protected boolean mapNameStyle = true;
    protected boolean stopped = true;
    protected ConnectionMulticastSupport multicastSupport;
    final boolean enableMulticast;
    private static boolean threadPoolChecked;
    private int multicast;
    private static long midMask;
    static /* synthetic */ Class class$com$ibm$disthub2$impl$client$SessionConfig;

    private static synchronized boolean isThreadPooled() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isThreadPooled");
        }
        boolean bl = true;
        if (threadPoolChecked) {
            bl = s_clientSocketThreadPool != null;
        } else {
            int n = SessionConfig.getSessionConfig().MAX_CLIENT_READ_THREADS;
            if (n == 0) {
                threadPoolChecked = true;
                bl = false;
            } else {
                System.err.println("Threadpooling active with " + n + " threads.");
                int n2 = SessionConfig.getSessionConfig().CLIENT_THREAD_POLLING_INTERVAL;
                try {
                    Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.disthub2.impl.util.ASocketThreadPool");
                                return clazz;
                            }
                            catch (AccessControlException accessControlException) {
                                if (Trace.isOn) {
                                    Trace.exception(3, "ConnectionImpl", "isThreadPooled", (Throwable)accessControlException);
                                }
                                return null;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "ASocketThreadPool not found");
                                }
                                return null;
                            }
                        }
                    });
                    s_clientSocketThreadPool = (SocketThreadPool)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(ExceptionBuilder.buildReasonString((int)-181372107, (Object[])new Object[]{exception}));
                }
                s_clientSocketThreadPool.setMaxThreads(n, 0);
                s_clientSocketThreadPool.setPollingInterval(n2);
                s_clientSocketThreadPool.start();
                threadPoolChecked = true;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isThreadPooled", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected Class configClass() {
        return class$com$ibm$disthub2$impl$client$SessionConfig == null ? (class$com$ibm$disthub2$impl$client$SessionConfig = ConnectionImpl.class$("com.ibm.disthub2.impl.client.SessionConfig")) : class$com$ibm$disthub2$impl$client$SessionConfig;
    }

    protected ConnectionImpl(MQConnectionFactory mQConnectionFactory, String string, String string2, int n, String string3, String string4, SessionConfig sessionConfig) throws IOException {
        super(string, string2, n, string3, string4, (Listener)null, false, (BaseConfig)sessionConfig);
        super.allocateMatchSupport();
        try {
            this.multicast = mQConnectionFactory.getMulticast();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.sessionConfig = sessionConfig != null ? sessionConfig : SessionConfig.getSessionConfig();
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ConnectionImpl", (Object)string, (Object)string2, (Object)new Integer(n), (Object)string3, (Object)"********");
        }
        boolean bl = this.enableMulticast = this.sessionConfig.MULTICAST_ENABLED && !this.pre1_2;
        if (ConnectionImpl.isThreadPooled()) {
            try {
                this.m_threadPoolHandle = s_clientSocketThreadPool.registerClient(this.socket, (SocketThreadPoolClient)this);
                this.m_threadPoolHandle.readyToRead();
            }
            catch (SocketThreadPoolException socketThreadPoolException) {
                throw new IOException(ExceptionBuilder.buildReasonString((int)66471145, (Object[])new Object[]{socketThreadPoolException}));
            }
        } else {
            threadProvider.schedule((Runnable)((Object)this));
        }
        this.userName = string3;
        this.mapNameStyle = mQConnectionFactory.getMapNameStyle();
        this.setMaxWindowSize(this.sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        this.fsh = new FreeSpaceHeap();
        this.startDelivery();
        if (this.enableMulticast) {
            this.queryMulticastFeature();
            this.multicastSupport = new ConnectionMulticastSupport(this);
        }
        this.sessions = new Vector();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ConnectionImpl");
        }
    }

    public FreeSpaceHeapNode addFreeSpaceHeapNode(int n, MessageQueue messageQueue) {
        FreeSpaceHeapNode freeSpaceHeapNode = new FreeSpaceHeapNode(n);
        this.fsh.put(freeSpaceHeapNode);
        messageQueue.setFreeSpaceHeapStuff(this.fsh, freeSpaceHeapNode, this);
        return freeSpaceHeapNode;
    }

    public void close() throws JMSException {
        this.closeT();
    }

    private void superClose() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        this.active = false;
        this.exceptionListener = null;
        super.close(!this.appConnectionClosed);
        if (this.m_threadPoolHandle != null) {
            try {
                this.m_threadPoolHandle.deregisterClient();
            }
            catch (SocketThreadPoolException socketThreadPoolException) {
                // empty catch block
            }
        }
        if (this.multicastSupport != null) {
            this.multicastSupport.close();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    public void connectionDropped() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"connectionDropped");
        }
        this.connectionDropped(this.getException(), false);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"connectionDropped");
        }
    }

    protected void handleControl(MessageHandle messageHandle) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleControl", (Object)messageHandle);
        }
        switch (messageHandle.getChoice(162)) {
            case 32: {
                this.handleMulticastControlReq(messageHandle);
                break;
            }
            case 33: {
                this.handleMulticastControlReply(messageHandle);
                break;
            }
            case 34: {
                this.handleMulticastTopicsUpdate(messageHandle);
                break;
            }
            default: {
                super.handleControl(messageHandle);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleControl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastControlReq(MessageHandle messageHandle) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastControlReq", (Object)messageHandle);
        }
        if (this.enableMulticast) {
            byte[] byArray = messageHandle.getByteArray(101);
            if (this.multicastSupport != null) {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.sendControlMessage(byArray);
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastControlReq");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastControlReply(MessageHandle messageHandle) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastControlReply", (Object)messageHandle);
        }
        if (this.enableMulticast) {
            byte[] byArray = messageHandle.getByteArray(102);
            if (this.multicastSupport != null) {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.onControlMessage(byArray);
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastControlReply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastTopicsUpdate(MessageHandle messageHandle) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastTopicsUpdate", (Object)messageHandle);
        }
        if (this.enableMulticast && this.multicastSupport != null) {
            MulticastTopic[] multicastTopicArray = MulticastUtil.getMulticastTopicsUpdate((MessageDataHandle)messageHandle);
            try {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.updateTopics(multicastTopicArray);
                }
            }
            catch (IOException iOException) {
                this.setException(iOException);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastTopicsUpdate");
        }
    }

    public void newMessageForClient(SubscriptionInfo subscriptionInfo, com.ibm.disthub2.impl.client.MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"newMessageForClient2", (Object)subscriptionInfo, (Object)messageImpl);
        }
        messageImpl.subInfo = subscriptionInfo;
        if (this.haltExecution) {
            return;
        }
        if (!((MessageConsumerImpl)subscriptionInfo.tsi).newMessage((MessageImpl)messageImpl)) {
            if (debug.debugIt(2)) {
                debug.debug(2L, (Object)"newMessageForClient", (Object)"delivery failed, will close connection");
            }
            this.haltExecution = true;
        }
        if (this.haltExecution) {
            this.setException((Exception)((Object)new JMSException(ExceptionBuilder.buildReasonString((int)1003358355, (Object[])new Object[]{new Integer(0)}))));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessageForClient");
        }
    }

    protected synchronized void completeSubscribe(int n, int n2, MessageDataHandle messageDataHandle, boolean bl) throws IOException {
        if (n < 0) {
            return;
        }
        SubscriptionInfo subscriptionInfo = (SubscriptionInfo)this.responseHolders[n2];
        subscriptionInfo.subid = n;
        if (subscriptionInfo.multicastEnabled) {
            this.completeMulticastSubscribe(subscriptionInfo, messageDataHandle);
        } else {
            super.completeSubscribe(n, n2, messageDataHandle, bl);
        }
    }

    protected void completeMulticastSubscribe(SubscriptionInfo subscriptionInfo, MessageDataHandle messageDataHandle) throws IOException {
        Object object;
        if (messageDataHandle.getChoice(168) == 1) {
            if (messageDataHandle.getBoolean(58)) {
                object = (SubscriptionInfoImpl)subscriptionInfo;
                this.match.removeSubscription(subscriptionInfo);
                ((SubscriptionInfoImpl)((Object)object)).multicastEnabled = true;
                MulticastTopic[] multicastTopicArray = MulticastUtil.getMulticastTopics((MessageDataHandle)messageDataHandle);
                if (multicastTopicArray != null) {
                    for (int i = 0; i < multicastTopicArray.length; ++i) {
                        ((SubscriptionInfoImpl)((Object)object)).addMulticastTopic(multicastTopicArray[i]);
                        if (i == 0) {
                            ((SubscriptionInfoImpl)((Object)object)).multicastReliable = multicastTopicArray[i].reliable && ((SubscriptionInfoImpl)((Object)object)).multicastReliable;
                        }
                        multicastTopicArray[i].reliable = ((SubscriptionInfoImpl)((Object)object)).multicastReliable;
                    }
                    this.multicastSupport.registerTopics((SubscriptionInfoImpl)((Object)object));
                }
            } else {
                subscriptionInfo.multicastEnabled = false;
                subscriptionInfo.multicastReliable = false;
            }
        } else {
            subscriptionInfo.multicastEnabled = false;
            subscriptionInfo.multicastReliable = false;
        }
        object = new Integer(subscriptionInfo.subid);
        this.allSubs.put(object, subscriptionInfo);
        subscriptionInfo.active = true;
    }

    public com.ibm.disthub2.impl.client.MessageImpl constructMessageImpl(MessageHandle messageHandle) {
        return MessageImpl.construct(messageHandle, this);
    }

    public com.ibm.disthub2.impl.client.MessageImpl constructDummyMessageImpl() {
        return new MessageImpl();
    }

    protected void handleMessage(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMessage", (Object)byArray);
        }
        super.handleMessage(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMessage");
        }
    }

    protected void newMulticastMessage(FastVector fastVector, MessageHandle messageHandle) throws IOException {
        Enumeration enumeration = fastVector.elements();
        while (enumeration.hasMoreElements()) {
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)enumeration.nextElement();
            if (!this.match.doesThisMatch((ConnectorImpl)this, subscriptionInfo, messageHandle)) continue;
            com.ibm.disthub2.impl.client.MessageImpl messageImpl = this.constructMessageImpl(messageHandle);
            messageImpl.subInfo = subscriptionInfo;
            this.newMessageForClient(subscriptionInfo, messageImpl);
        }
    }

    public void sendMulticastControlMsg(byte[] byArray) {
        try {
            int n = 0;
            MessageHandle messageHandle = ConnectionImpl.newControlMessage((int)32, (int)n);
            messageHandle.setByteArray(101, byArray);
            this.send(messageHandle);
        }
        catch (IOException iOException) {
            this.setException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDropped(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(32L, (Object)"connectionDropped", (Object)exception, (Object)new Boolean(bl));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            ExceptionListener exceptionListener;
            block12: {
                exceptionListener = this.exceptionListener;
                try {
                    if (this.multicastSupport != null && this.enableMulticast) {
                        Enumeration enumeration = this.allSubs.elements();
                        while (enumeration.hasMoreElements()) {
                            Object v = enumeration.nextElement();
                            if (!(v instanceof SubscriptionInfoImpl) || this.multicastSupport == null) continue;
                            this.multicastSupport.deregisterAllTopics((SubscriptionInfoImpl)((Object)v));
                        }
                    }
                    this.appConnectionClosed = bl;
                    this.eConnectionClosed = exception;
                    this.close();
                }
                catch (JMSException jMSException) {
                    if (!debug.debugIt(2)) break block12;
                    debug.debug(2L, (Object)"connectionDropped", (Object)("got mystery exception je=" + jMSException.toString()));
                }
            }
            if (exceptionListener != null) {
                ExceptionDispatchThread.xThread.enqueue(exceptionListener, exception);
            } else if (debug.debugIt(64)) {
                debug.debug(64L, (Object)"connectionDropped", (Object)"no exceptionlistener to dispacth ");
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(64L, (Object)"connectionDropped");
        }
    }

    public void unsubscribe(int n) throws IOException {
        SubscriptionInfoImpl subscriptionInfoImpl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"unsubscribe", (Object)new Integer(n));
        }
        if ((subscriptionInfoImpl = (SubscriptionInfoImpl)((Object)this.allSubs.get(new Integer(n)))) != null && subscriptionInfoImpl.multicastEnabled) {
            this.multicastSupport.deregisterAllTopics(subscriptionInfoImpl);
        }
        super.unsubscribe(n);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"unsubscribe");
        }
    }

    String getTemporaryTopicString(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTemporaryTopicString", (Object)string);
        }
        String string2 = this.createTemporaryTopicString(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTermporaryTopicString", (Object)string2);
        }
        return string2;
    }

    boolean isPre1_2() {
        return this.pre1_2;
    }

    public String getClientID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getClientID");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace((Object)this, "this.isClosed() IllegalStateException");
                Trace.exit((Object)this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getClientID", (Object)this.clientID);
        }
        if (this.clientID == null || this.clientID.equals("")) {
            return this.userName;
        }
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setClientID", (Object)string);
        }
        if (this.clientIDFixed) {
            String string2 = ConfigEnvironment.getErrorMessage("MQJMS3031");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = "MQJMS0002";
            String string4 = ConfigEnvironment.getErrorMessage(string3);
            throw new IllegalStateException(string4, string3);
        }
        if (this.clientID != null) {
            String string5 = "MQJMS3032";
            String string6 = ConfigEnvironment.getErrorMessage(string5);
            throw new IllegalStateException(string6, string5);
        }
        this.clientID = string;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setClientID", (Object)this.clientID);
        }
    }

    void setClientIDFixed() {
        this.clientIDFixed = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMetaData");
        }
        this.checkConnectionOpen();
        MQConnectionMetaData mQConnectionMetaData = new MQConnectionMetaData(2);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMetaData", (Object)mQConnectionMetaData);
        }
        return mQConnectionMetaData;
    }

    protected void setException(Exception exception) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setException", (Object)exception);
        }
        super.setException(exception);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setExceptionListener", (Object)exceptionListener);
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace((Object)this, "this.isClosed() IllegalStateException");
                Trace.exit((Object)this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.exceptionListener = exceptionListener;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getExceptionListener");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace((Object)this, "this.isClosed() IllegalStateException");
                Trace.exit((Object)this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getExceptionListener", (Object)this.exceptionListener);
        }
        return this.exceptionListener;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        return !this.active;
    }

    protected void deactivate() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"deactivate");
        }
        this.active = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"deactivate");
        }
    }

    synchronized void closed(SessionImpl sessionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"closed", (Object)sessionImpl);
        }
        Assert.condition((boolean)this.sessions.removeElement(sessionImpl));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"closed");
        }
    }

    boolean isLocalMid(long l) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isLocalMid", (Object)new Long(l));
        }
        boolean bl2 = bl = (l & midMask) == (this.messageId & midMask);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isLocalMid", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean doRead() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"doRead");
        }
        boolean bl = false;
        try {
            this.m_threadPoolHandle.beginRead();
            byte[] byArray = this.receive();
            this.m_threadPoolHandle.endRead();
            this.handleMessage(byArray);
            bl = true;
        }
        catch (IOException iOException) {
            this.setException(iOException);
            bl = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"doRead", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean doWrite() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"doWrite");
        }
        throw new RuntimeException(ExceptionBuilder.buildReasonString((int)-343781462, null));
    }

    public void culled(SocketThreadPoolClientHndl socketThreadPoolClientHndl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"culled", (Object)socketThreadPoolClientHndl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"culled");
        }
    }

    boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStopped", (Object)new Boolean(this.stopped));
        }
        return this.stopped;
    }

    boolean isStarted() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStarted");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStarted", (Object)new Boolean(!this.stopped));
        }
        return !this.stopped;
    }

    void checkConnectionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "checkConnectionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1004";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace((Object)this, "Connection is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "checkConnectionOpen");
        }
    }

    protected InetAddress getAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    protected int getPort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    protected int getMulticast() {
        return this.multicast;
    }

    public boolean ipv6Connection() {
        if (this.socket != null) {
            return this.socket.getLocalAddress() instanceof Inet6Address;
        }
        return false;
    }

    protected void queryMulticastFeature() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"queryMulticastFeature");
        }
        MessageHandle messageHandle = ConnectionImpl.newMessage((int)7, (String)"", (int)4);
        messageHandle.setBoolean(42, true);
        MessageBodyHandle[] messageBodyHandleArray = new MessageBodyHandle[]{messageHandle.newTableRow(43)};
        messageBodyHandleArray[0].setString(0, "MULTICAST");
        messageBodyHandleArray[0].setString(1, "");
        messageBodyHandleArray[0].setString(2, "");
        messageHandle.setTable(43, messageBodyHandleArray);
        this.setInFeatureExchange(true);
        this.send(messageHandle);
        this.waitForFeatureExchange("MULTICAST");
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"queryMulticastFeature");
        }
    }

    public void onException(Exception exception) {
        ExceptionDispatchThread.xThread.enqueue(this.exceptionListener, exception);
    }

    public boolean enableMulticast() {
        return this.enableMulticast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"stop");
                }
                return;
            }
            Vector vector = (Vector)this.sessions.clone();
            for (int i = 0; i < vector.size(); ++i) {
                SessionImpl sessionImpl = (SessionImpl)vector.elementAt(i);
                sessionImpl.stop();
            }
            this.stopped = true;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeT() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"closeT");
        }
        Object object = this;
        synchronized (object) {
            if (this.isClosed()) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"closeT");
                }
                return;
            }
            if (this.lastException != null) {
                this.deactivate();
            }
        }
        if (this.sessions != null) {
            object = (Vector)this.sessions.clone();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SessionImpl sessionImpl = (SessionImpl)((Vector)object).elementAt(i);
                sessionImpl.close(this.eConnectionClosed, this.appConnectionClosed);
                continue;
            }
            this.sessions.removeAllElements();
        }
        this.deactivate();
        this.superClose();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"closeT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"start");
                }
                return;
            }
            Vector vector = (Vector)this.sessions.clone();
            for (int i = 0; i < vector.size(); ++i) {
                SessionImpl sessionImpl = (SessionImpl)vector.elementAt(i);
                sessionImpl.start();
            }
            this.stopped = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createConnectionConsumer", (Object)destination, (Object)string, (Object)serverSessionPool, (Object)new Integer(n));
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createDurableConnectionConsumer", (Object)destination, (Object)string, (Object)serverSessionPool, (Object)new Integer(n));
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createDurableConnectionConsumer", (Object)topic, (Object)string, (Object)serverSessionPool, (Object)new Integer(n));
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Destination destination, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createDurableConnectionConsumer", (Object)destination, (Object)string, (Object)string2, (Object)serverSessionPool, (Object)new Integer(n));
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createDurableConnectionConsumer", (Object)topic, (Object)string, (Object)string2, (Object)serverSessionPool, (Object)new Integer(n));
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        SessionImpl sessionImpl = new SessionImpl(this, bl, n);
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.sessions.addElement(sessionImpl);
            if (!this.stopped) {
                sessionImpl.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createSession", (Object)sessionImpl);
        }
        return sessionImpl;
    }

    protected synchronized void requestProperties(String string) throws IOException {
        TopicImpl topicImpl = (TopicImpl)this.topicCache.get((Object)string);
        topicImpl.setDefaultProperties();
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        midMask = -4294967296L;
    }

    public class FreeSpaceHeapNode
    extends PriorityQueueNode {
        FreeSpaceHeapNode(int n) {
            super((long)n);
        }
    }

    public class FreeSpaceHeap
    extends PriorityQueuePlus {
    }
}

