/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.crypto.export.cl3.CL3;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.AuthPrincipal;
import com.ibm.mq.jms.DefaultExceptionConstants;
import com.ibm.mq.jms.DefaultLogConstants;
import com.ibm.mq.jms.ISSL;
import com.ibm.mq.jms.ISSLException;
import com.ibm.mq.jms.ISSLSession;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;

public class AuthBase
implements DefaultLogConstants,
DefaultExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/AuthBase.java, disthub, j600, j600-201-061220 1.7.1.1 05/05/25 16:01:01";
    protected static DebugObject debug = new DebugObject("AuthBase");
    protected static final short DUMMY = 0;
    protected short[] cfgProtos;
    protected Socket sock;
    protected DataInputStream istr;
    protected DataOutputStream ostr;
    protected AuthPrincipal credentials;
    protected Properties metaData;
    protected short whichProto = 0;
    protected byte[] sessionSecret = null;
    protected static MsgBase xDummy = new MsgBase();
    protected static final short defProto = 99;
    protected static final int N_RANDOM = 20;
    protected byte[] macServ;
    protected byte[] macClnt;
    protected static final int VERSION_MAGIC = 122605;
    protected ISSL xssl;
    protected ISSLSession sslSession;
    protected static final boolean AS_CLIENT = false;
    protected static final boolean AS_SERVER = true;
    protected boolean role;
    protected static final byte[] closeKey = new byte[]{84, 72, 73, 83, 55, 73, 83, 56, 68, 85, 77, 66, 49, 50, 51, 52};
    protected static final short AUTH_EXCEPTION = 88;
    protected static final short HELLO = 22600;
    protected static final short HELLO_old = 72;
    protected static final short REPLY_UP = 85;
    protected static final short OKAY_UP = 111;
    protected static final short OKAY_UP_pxid = 79;
    protected static final short RESPONSE_COUNTER = 19797;
    protected static final short OKAY_RESPONSE = 19791;
    protected static final short REPLY_SSL_UP = 21333;
    protected static final short OKAY_SSL_UP = 21327;
    protected static final short REPLY_SSL_PURE = 21077;
    protected static final short OKAY_SSL_PURE = 21071;
    protected static final int HEAD_WORD = 1212498244;
    protected static final short HEAD_REQUEST = 17480;
    protected static final String HTTP_HEAD_RESPONSE_STRING = "ResponseToRequest\r\n\r\n";
    protected static final int DEATH_THRESHHOLD = 60;
    protected static final String CLIENT = "Client";
    protected static final String SERVER = "Server";
    protected static final String SESSION_KEY = "SessionKey";

    protected AuthBase() {
    }

    public static boolean SSLrequired(short[] sArray) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"SSLrequired", (Object)sArray);
        }
        for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 21059: 
                case 21315: {
                    if (debug.debugIt(64)) {
                        debug.debug(-142394261359015L, (Object)"SSLrequired", (Object)new Boolean(true));
                    }
                    return true;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"SSLrequired", (Object)new Boolean(false));
        }
        return false;
    }

    void setupDataStreams() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setupDataStreams");
        }
        this.istr = new DataInputStream(this.sock.getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setupDataStreams");
        }
    }

    protected void close_ostr() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close_ostr");
        }
        if (this.ostr != null) {
            this.ostr.flush();
        }
        this.ostr = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close_ostr");
        }
    }

    void cleanup() throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"cleanup");
        }
        this.istr = null;
        if (this.ostr != null) {
            try {
                this.close_ostr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sslSession != null) {
            this.sslSession.getSocket().close();
            if (!this.role) {
                DataOutputStream dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
                dataOutputStream.write(closeKey);
                dataOutputStream.flush();
                DataInputStream dataInputStream = new DataInputStream(this.sock.getInputStream());
                byte[] byArray = new byte[1];
                int n = 0;
                while (dataInputStream.read(byArray) != -1) {
                    if (byArray[0] == closeKey[n]) {
                        if (++n != closeKey.length) continue;
                        return;
                    }
                    n = 0;
                }
                this.sock.close();
                throw new IOException(ExceptionBuilder.buildReasonString((int)-1731999971, null));
            }
            DataInputStream dataInputStream = new DataInputStream(this.sock.getInputStream());
            byte[] byArray = new byte[1];
            int n = 0;
            while (dataInputStream.read(byArray) != -1) {
                if (byArray[0] == closeKey[n]) {
                    if (++n != closeKey.length) continue;
                    break;
                }
                n = 0;
            }
            if (n != closeKey.length) {
                this.sock.close();
                throw new IOException(ExceptionBuilder.buildReasonString((int)-1731999971, null));
            }
            DataOutputStream dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
            dataOutputStream.write(closeKey);
            dataOutputStream.flush();
        }
        this.sslSession = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"cleanup");
        }
    }

    void termException(String string, int n) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termException", (Object)string, (Object)new Integer(n));
        }
        this.termException(new AuthException(n, (Exception)new RuntimeException(string), null));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termException");
        }
    }

    void termException(AuthExceptionMsg authExceptionMsg) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termException", (Object)authExceptionMsg);
        }
        if (debug.debugIt(2)) {
            debug.debug(-175584356845707L, (Object)"termException", (Object)("Terminating with exception: " + authExceptionMsg.getMessage()));
        }
        try {
            this.close_ostr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.termException(new AuthException(authExceptionMsg.getCode(), (Exception)new RuntimeException(authExceptionMsg.getMessage()), null));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termException");
        }
    }

    void termException(AuthException authException) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termException", (Object)authException);
        }
        if (this.ostr != null) {
            try {
                new AuthExceptionMsg(authException).writeMsg(this.ostr);
                this.close_ostr();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.cleanup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw authException;
    }

    void termWrongMsg(MsgBase msgBase) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termWrongMessage", (Object)msgBase);
        }
        if (msgBase instanceof AuthExceptionMsg) {
            this.termException((AuthExceptionMsg)msgBase);
        }
        this.termException(ExceptionBuilder.buildReasonString((int)1970506625, (Object[])new Object[]{new Short(msgBase.getType())}), 1);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termWrongMsg");
        }
    }

    protected static byte[] random(int n) {
        byte[] byArray = new byte[n];
        CL3.rng(null, (byte[])byArray, (int)0, (int)n);
        return byArray;
    }

    protected static byte[] hmac(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[64];
        if (byArray.length > byArray4.length) {
            CL3.sha(null, (byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray4, (int)0);
        } else {
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        }
        int n = 0;
        while (n < byArray4.length) {
            int n2 = n++;
            byArray4[n2] = (byte)(byArray4[n2] ^ 0x36);
        }
        CL3 cL3 = CL3.shaInit(null);
        CL3.sha((CL3)cL3, (byte[])byArray4, (int)0, (int)byArray4.length, null, (int)0);
        CL3 cL32 = CL3.shaInit(null);
        n = 0;
        while (n < byArray4.length) {
            int n3 = n++;
            byArray4[n3] = (byte)(byArray4[n3] ^ 0x6A);
        }
        CL3.sha((CL3)cL32, (byte[])byArray4, (int)0, (int)byArray4.length, null, (int)0);
        CL3.sha((CL3)cL3, (byte[])byArray2, (int)0, (int)byArray2.length, (byte[])byArray3, (int)0);
        CL3.sha((CL3)cL32, (byte[])byArray3, (int)0, (int)20, (byte[])byArray3, (int)0);
        return byArray3;
    }

    protected static void writeSBA(byte[] byArray, DataOutput dataOutput) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeSBA", (Object)byArray, (Object)dataOutput);
        }
        dataOutput.writeShort(byArray.length);
        dataOutput.write(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeSBA");
        }
    }

    protected static byte[] readSBA(DataInputStream dataInputStream) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readSBA", (Object)dataInputStream);
        }
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readSBA", (Object)byArray);
        }
        return byArray;
    }

    protected static String transformPropObj(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            char c;
            int n;
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c == '\\') {
                    stringBuffer2.append("\\\\");
                    continue;
                }
                if (c == '=') {
                    stringBuffer2.append("\\=");
                    continue;
                }
                stringBuffer2.append(c);
            }
            string = stringBuffer2.toString();
            stringBuffer2 = new StringBuffer();
            for (n = 0; n < string2.length(); ++n) {
                c = string2.charAt(n);
                if (c == '\\') {
                    stringBuffer2.append("\\\\");
                    continue;
                }
                if (c == ']') {
                    stringBuffer2.append("\\]");
                    continue;
                }
                stringBuffer2.append(c);
            }
            string2 = stringBuffer2.toString();
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append("]");
        }
        object = stringBuffer.toString();
        return object;
    }

    protected static Properties transformPropString(String string) throws IllegalArgumentException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"transformPropString", (Object)string);
        }
        Properties properties = new Properties();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string.charAt(i++) != '[') {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{string}));
            }
            for (n = i; n < string.length() && string.charAt(n) != '=' && (string.charAt(n) != '\\' || ++n != string.length()); ++n) {
                stringBuffer.append(string.charAt(n));
            }
            if (n >= string.length()) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{string}));
            }
            for (n = i = n + 1; n < string.length() && string.charAt(n) != ']' && (string.charAt(n) != '\\' || ++n != string.length()); ++n) {
                stringBuffer2.append(string.charAt(n));
            }
            if (n >= string.length()) {
                throw new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{string}));
            }
            properties.setProperty(stringBuffer.toString(), stringBuffer2.toString());
            i = n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"transformPropString", (Object)properties);
        }
        return properties;
    }

    public static short[] parseAuthProtocols(String string) throws AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"parseAuthProtocols", (Object)string);
        }
        if (string == null || string.length() == 0) {
            throw new AuthException(1, (Exception)new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)1100607165, null)), null);
        }
        int n = string.length();
        short[] sArray = new short[n + 1];
        int n2 = 0;
        block6: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'M': {
                    sArray[i] = 19779;
                    continue block6;
                }
                case 'S': {
                    sArray[i] = 21315;
                    continue block6;
                }
                case 'R': {
                    sArray[i] = 21059;
                    continue block6;
                }
                case 'P': {
                    sArray[i] = 99;
                    n2 = 67;
                    continue block6;
                }
                default: {
                    throw new AuthException(1, (Exception)new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)1191761697, (Object[])new Object[]{new Character(string.charAt(i))})), null);
                }
            }
        }
        sArray[n] = n2;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"parseAuthProtocols", (Object)sArray);
        }
        return sArray;
    }

    protected static final byte[] bafString(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Exception exception) {
            throw Assert.failureError();
        }
    }

    protected static final byte[] bac7(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) {
        byte[] byArray8 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length + byArray7.length];
        System.arraycopy(byArray, 0, byArray8, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray8, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray8, byArray.length + byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray8, byArray.length + byArray2.length + byArray3.length, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length, byArray5.length);
        System.arraycopy(byArray6, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length, byArray6.length);
        System.arraycopy(byArray7, 0, byArray8, byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length, byArray7.length);
        return byArray8;
    }

    protected static final byte[] bac3(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    protected void mutualPasswordMacs(String string, String string2, String string3, byte[] byArray, String string4, String string5, byte[] byArray2) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"mutualPasswordMacs", (Object)"********", (Object)string2, (Object)string3, (Object)byArray, (Object)string4, (Object)string5, (Object)byArray2);
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"mutualPasswordMacs", (Object)("MutualPasswordMacs w/ pw = " + string + ",\n\t servId = " + string2 + ", servXid = " + string3 + ", servRndm = " + byArray + ",\n\t clientId = " + string4 + ", clntXid = " + string5 + ", clntRndm = " + byArray2));
        }
        byte[] byArray3 = AuthBase.bafString(string2);
        byte[] byArray4 = AuthBase.bafString(string3);
        byte[] byArray5 = AuthBase.bafString(string4);
        byte[] byArray6 = AuthBase.bafString(string5);
        byte[] byArray7 = AuthBase.bafString(CLIENT);
        byte[] byArray8 = AuthBase.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray7);
        byte[] byArray9 = AuthBase.bafString(string);
        this.macClnt = AuthBase.hmac(byArray9, byArray8);
        byte[] byArray10 = AuthBase.bafString(SERVER);
        byte[] byArray11 = AuthBase.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray10);
        this.macServ = AuthBase.hmac(byArray9, byArray11);
        byte[] byArray12 = AuthBase.bafString(SESSION_KEY);
        byte[] byArray13 = AuthBase.bac7(byArray3, byArray4, byArray, byArray5, byArray6, byArray2, byArray12);
        this.sessionSecret = AuthBase.hmac(byArray9, byArray13);
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"mutualPasswordMacs", (Object)("Result, macClnt: " + Hex.toString((byte[])this.macClnt) + " macServ: " + Hex.toString((byte[])this.macServ) + " sessionSecret: " + Hex.toString((byte[])this.sessionSecret)));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"mutualPasswordMacs");
        }
    }

    protected void sslStart(boolean bl, short s) throws IOException, AuthException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"sslStart", (Object)new Boolean(bl), (Object)new Short(s));
        }
        Assert.condition((this.xssl != null ? 1 : 0) != 0);
        try {
            this.sslSession = this.xssl.createSession(this.sock, this.credentials.getSSLCredentials(), bl, s == 21059);
        }
        catch (ISSLException iSSLException) {
            throw new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)1536360197, (Object[])new Object[]{iSSLException})), null);
        }
        this.istr = new DataInputStream(this.sslSession.getSocket().getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.sslSession.getSocket().getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"sslStart");
        }
    }

    protected void sslDeriveSessionKey(ISSLSession iSSLSession, byte[] byArray, byte[] byArray2) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"sslDeriveSessionKey", (Object)iSSLSession, (Object)byArray, (Object)byArray2);
        }
        byte[] byArray3 = AuthBase.bafString(SESSION_KEY);
        byte[] byArray4 = AuthBase.bac3(byArray, byArray2, byArray3);
        byte[] byArray5 = iSSLSession.getMasterSecret();
        if (byArray5 == null) {
            byte[] byArray6 = new byte[]{1, 2, 3, 4, 5};
            byArray5 = byArray6;
        }
        this.sessionSecret = AuthBase.hmac(byArray5, byArray4);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"sslDeriveSessionKey");
        }
    }

    protected static class OkaySSLPure
    extends OkaySSLUP {
        public short getType() {
            return 21071;
        }

        OkaySSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkaySSLPure(byte[] byArray, String string, String string2) {
            super(byArray, string, string2);
        }
    }

    protected static class ReplySSLPure
    extends ReplySSLUP {
        public short getType() {
            return 21077;
        }

        ReplySSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplySSLPure(String string, String string2, String string3, byte[] byArray) {
            super(string, string2, string3, byArray);
        }
    }

    protected static class ChallengeSSLPure
    extends ChallengeUP {
        public short getType() {
            return 21059;
        }

        ChallengeSSLPure(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeSSLPure() {
        }
    }

    protected static class OkaySSLUP
    extends MsgBase {
        byte[] Rs;
        String serverId;
        String serverXid;

        public short getType() {
            return 21327;
        }

        OkaySSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkaySSLUP(byte[] byArray, String string, String string2) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkaySSLUP", (Object)byArray, (Object)string, (Object)string2);
            }
            this.Rs = byArray;
            this.serverId = string;
            this.serverXid = string2;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkaySSLUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            AuthBase.writeSBA(this.Rs, dataOutput);
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.Rs = AuthBase.readSBA(dataInputStream);
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class ReplySSLUP
    extends MsgBase {
        String userid;
        String password;
        String xid;
        byte[] Rc;

        public short getType() {
            return 21333;
        }

        ReplySSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplySSLUP(String string, String string2, String string3, byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ReplySSLUP", (Object)string, (Object)"********", (Object)string3, (Object)byArray);
            }
            this.userid = string;
            this.password = string2;
            this.xid = string3;
            this.Rc = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ReplySSLUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.password);
            dataOutput.writeUTF(this.xid);
            AuthBase.writeSBA(this.Rc, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.password = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            this.Rc = AuthBase.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class ChallengeSSLUP
    extends ChallengeUP {
        public short getType() {
            return 21315;
        }

        ChallengeSSLUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeSSLUP() {
        }
    }

    protected static class OkayResponse
    extends MsgBase {
        byte[] MacS;

        public short getType() {
            return 19791;
        }

        OkayResponse(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayResponse(byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkayResponse", (Object)byArray);
            }
            this.MacS = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkayResponse");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            AuthBase.writeSBA(this.MacS, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.MacS = AuthBase.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }

        public byte[] getMacBytes() {
            return this.MacS;
        }
    }

    protected static class ResponseAndCounter
    extends MsgBase {
        String userid;
        String xid;
        byte[] Rc;
        byte[] MacC;

        public short getType() {
            return 19797;
        }

        ResponseAndCounter(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ResponseAndCounter(String string, String string2, byte[] byArray, byte[] byArray2) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ResponseAndCounter", (Object)string, (Object)string2, (Object)byArray, (Object)byArray2);
            }
            this.userid = string;
            this.xid = string2;
            this.Rc = byArray;
            this.MacC = byArray2;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ResponseAndCounter");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.xid);
            AuthBase.writeSBA(this.Rc, dataOutput);
            AuthBase.writeSBA(this.MacC, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            this.Rc = AuthBase.readSBA(dataInputStream);
            this.MacC = AuthBase.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class ChallengeMPR
    extends MsgBase {
        String serverId;
        String serverXid;
        byte[] Rs;

        public short getType() {
            return 19779;
        }

        ChallengeMPR(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeMPR(String string, String string2, byte[] byArray) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ChallengeMPR", (Object)string, (Object)string2, (Object)byArray);
            }
            this.serverId = string;
            this.serverXid = string2;
            this.Rs = byArray;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ChallengeMPR");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            AuthBase.writeSBA(this.Rs, dataOutput);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            this.Rs = AuthBase.readSBA(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class OkayUP_pxid
    extends OkayUP {
        public short getType() {
            return 79;
        }

        OkayUP_pxid(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayUP_pxid() {
            super(null, null);
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
        }
    }

    protected static class OkayUP
    extends MsgBase {
        String serverId;
        String serverXid;

        public short getType() {
            return 111;
        }

        OkayUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        OkayUP(String string, String string2) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkayUP", (Object)string, (Object)string2);
            }
            this.serverId = string;
            this.serverXid = string2;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkayUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeUTF(this.serverId);
            dataOutput.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.serverId = dataInputStream.readUTF();
            this.serverXid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class ReplyUP
    extends MsgBase {
        String userid;
        String password;
        String xid;

        public short getType() {
            return 85;
        }

        ReplyUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ReplyUP(String string, String string2, String string3) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ReplyUP", (Object)string, (Object)"********", (Object)string3);
            }
            this.userid = string;
            this.password = string2;
            this.xid = string3;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ReplyUP");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeUTF(this.userid);
            dataOutput.writeUTF(this.password);
            dataOutput.writeUTF(this.xid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.userid = dataInputStream.readUTF();
            this.password = dataInputStream.readUTF();
            this.xid = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class ChallengeUP_pxid
    extends MsgBase {
        public short getType() {
            return 67;
        }

        ChallengeUP_pxid(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeUP_pxid() {
        }
    }

    protected static class ChallengeUP
    extends MsgBase {
        public short getType() {
            return 99;
        }

        ChallengeUP(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        ChallengeUP() {
        }
    }

    protected static class HeadRequest
    extends MsgBase {
        public short getType() {
            return 17480;
        }

        HeadRequest(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            throw new IOException(ExceptionBuilder.buildReasonString((int)1604135494, null));
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            int n = 0;
            do {
                by4 = dataInputStream.readByte();
                if (n++ <= 60) continue;
                throw new IOException(ExceptionBuilder.buildReasonString((int)-900202921, null));
            } while (by4 != 13 || (by3 = dataInputStream.readByte()) != 10 || (by2 = dataInputStream.readByte()) != 13 || (by = dataInputStream.readByte()) != 10);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class AuthExceptionMsg
    extends MsgBase {
        int code;
        String reason;

        public short getType() {
            return 88;
        }

        AuthExceptionMsg(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        String getMessage() {
            return this.reason;
        }

        int getCode() {
            return this.code;
        }

        AuthExceptionMsg(int n, String string) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"AuthExceptionMsg", (Object)new Integer(n), (Object)string);
            }
            this.code = n;
            this.reason = string;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"AuthExceptionMsg");
            }
        }

        AuthExceptionMsg(AuthException authException) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"AuthExceptionMsg", (Object)authException);
            }
            this.code = authException.code;
            this.reason = authException.wrapped != null ? authException.wrapped.getMessage() : "";
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"AuthExceptionMsg");
            }
        }

        public String toString() {
            return "code=" + this.code + ", reason=" + this.reason;
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeInt(this.code);
            dataOutput.writeUTF(this.reason);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            this.code = dataInputStream.readInt();
            this.reason = dataInputStream.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class Hello
    extends MsgBase {
        short[] protos;

        public short getType() {
            return 22600;
        }

        Hello(DataInputStream dataInputStream, short s) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"Hello", (Object)dataInputStream, (Object)new Short(s));
            }
            this.protos = new short[]{s};
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"Hello");
            }
        }

        Hello(DataInputStream dataInputStream) throws IOException, AuthException {
            super(dataInputStream);
        }

        Hello(short[] sArray) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"Hello", (Object)sArray);
            }
            this.protos = sArray != null ? sArray : new short[]{99};
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"Hello");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            dataOutput.writeShort(this.protos.length);
            for (int i = 0; i < this.protos.length; ++i) {
                dataOutput.writeShort(this.protos[i]);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            int n = dataInputStream.readUnsignedShort();
            this.protos = new short[n];
            for (int i = 0; i < n; ++i) {
                this.protos[i] = dataInputStream.readShort();
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }

    protected static class MsgBase {
        public short getType() {
            return 0;
        }

        MsgBase() {
        }

        protected MsgBase(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"MsgBase", (Object)dataInputStream);
            }
            this.readBody(dataInputStream);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"MsgBase");
            }
        }

        MsgBase readMsg(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readMsg", (Object)dataInputStream);
            }
            int n = dataInputStream.readInt();
            MsgBase msgBase = null;
            if (122605 != n) {
                if (n == 1212498244) {
                    msgBase = new HeadRequest(dataInputStream);
                    if (debug.debugIt(64)) {
                        debug.debug(-142394261359015L, (Object)"readMsg", (Object)msgBase);
                    }
                    return msgBase;
                }
                byte[] byArray = new byte[60];
                byArray[0] = (byte)(n >> 24);
                byArray[1] = (byte)(n >> 16);
                byArray[2] = (byte)(n >> 8);
                byArray[3] = (byte)n;
                int n2 = 4;
                try {
                    if (dataInputStream.available() > 0) {
                        n2 += dataInputStream.read(byArray, n2, byArray.length - n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)1023917489, (Object[])new Object[]{Hex.dumpString((byte[])byArray, (int)0, (int)n2)})), null);
            }
            short s = dataInputStream.readShort();
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"readMsg", (Object)("Received msg type: " + s));
            }
            switch (s) {
                case 88: {
                    msgBase = new AuthExceptionMsg(dataInputStream);
                    break;
                }
                case 72: {
                    msgBase = new Hello(dataInputStream, 67);
                    break;
                }
                case 22600: {
                    msgBase = new Hello(dataInputStream);
                    break;
                }
                case 99: {
                    msgBase = new ChallengeUP(dataInputStream);
                    break;
                }
                case 67: {
                    msgBase = new ChallengeUP_pxid(dataInputStream);
                    break;
                }
                case 85: {
                    msgBase = new ReplyUP(dataInputStream);
                    break;
                }
                case 111: {
                    msgBase = new OkayUP(dataInputStream);
                    break;
                }
                case 79: {
                    msgBase = new OkayUP_pxid(dataInputStream);
                    break;
                }
                case 19779: {
                    msgBase = new ChallengeMPR(dataInputStream);
                    break;
                }
                case 19797: {
                    msgBase = new ResponseAndCounter(dataInputStream);
                    break;
                }
                case 19791: {
                    msgBase = new OkayResponse(dataInputStream);
                    break;
                }
                case 21315: {
                    msgBase = new ChallengeSSLUP(dataInputStream);
                    break;
                }
                case 21333: {
                    msgBase = new ReplySSLUP(dataInputStream);
                    break;
                }
                case 21327: {
                    msgBase = new OkaySSLUP(dataInputStream);
                    break;
                }
                case 21059: {
                    msgBase = new ChallengeSSLPure(dataInputStream);
                    break;
                }
                case 21077: {
                    msgBase = new ReplySSLPure(dataInputStream);
                    break;
                }
                case 21071: {
                    msgBase = new OkaySSLPure(dataInputStream);
                    break;
                }
                default: {
                    throw new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)-640421958, (Object[])new Object[]{new Short(s)})), null);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readMsg", (Object)msgBase);
            }
            return msgBase;
        }

        public void writeMsg(DataOutputStream dataOutputStream) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeMsg", (Object)dataOutputStream);
            }
            dataOutputStream.writeInt(122605);
            dataOutputStream.writeShort(this.getType());
            this.writeBody(dataOutputStream);
            dataOutputStream.flush();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeMsg");
            }
        }

        public void writeBody(DataOutput dataOutput) throws IOException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)dataOutput);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
        }

        public void readBody(DataInputStream dataInputStream) throws IOException, AuthException {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)dataInputStream);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
        }
    }
}

