/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class JMSTextMessage
extends JMSMessage
implements TextMessage {
    static final long serialVersionUID = -7013263043146565366L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSTextMessage.java, jms, j600, j600-202-070608 1.33.1.4 07/03/01 06:54:50";
    String messageText = null;
    byte[] messageBytes = null;
    String characterSet;
    int dataStart;
    char[] HPCodepage = null;
    boolean readOnly = false;

    public JMSTextMessage(JMSStringResources jMSStringResources) {
        if (bTraceIsOn) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_text";
        this.jmsStrings = jMSStringResources;
        if (bTraceIsOn) {
            trace.exit(this, "constructor");
        }
    }

    public JMSTextMessage(JMSStringResources jMSStringResources, String string) throws JMSException {
        this(jMSStringResources);
        if (bTraceIsOn) {
            trace.entry(this, "MQTextMessage constructor with String");
        }
        this.messageClass = "jms_text";
        this.setText(string);
        if (bTraceIsOn) {
            trace.exit(this, "MQTextMessage constructor with StringBuffer");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_exportBody");
        }
        try {
            if (this.messageBytes == null) {
                if (this.messageText == null) {
                    if (bTraceIsOn) {
                        trace.exit(this, "_exportBody - no body");
                    }
                    return null;
                }
                this.messageBytes = this.messageText.getBytes(string);
                this.characterSet = string;
                this.dataStart = 0;
            } else {
                if (this.characterSet.equals(string)) {
                    if (this.dataStart != 0) {
                        byte[] byArray = new byte[this.messageBytes.length - this.dataStart];
                        System.arraycopy(this.messageBytes, this.dataStart, byArray, 0, this.messageBytes.length - this.dataStart);
                        this.messageBytes = byArray;
                        this.dataStart = 0;
                        if (bTraceIsOn) {
                            trace.exit(this, "_exportBody");
                        }
                        return this.messageBytes;
                    }
                    if (bTraceIsOn) {
                        trace.exit(this, "_exportBody");
                    }
                    return this.messageBytes;
                }
                this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                this.messageBytes = this.messageText.getBytes(string);
                this.characterSet = string;
                this.dataStart = 0;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = this.newJMSException(1008, string);
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (bTraceIsOn) {
                trace.exit(this, "_exportBody, via Exception");
            }
            throw jMSException;
        }
        if (bTraceIsOn) {
            trace.exit(this, "_exportBody");
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_importBody");
        }
        this.messageBytes = byArray;
        this.messageText = null;
        this.dataStart = n;
        this.characterSet = string;
        if (bTraceIsOn) {
            trace.exit(this, "_importBody");
        }
    }

    public void clearBody() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.messageText = null;
        this.messageBytes = null;
        this.isNullMessage = true;
        if (bTraceIsOn) {
            trace.entry(this, "clearBody");
        }
    }

    public String getText() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getText");
        }
        try {
            if (this.messageText == null && this.messageBytes != null) {
                if (this.characterSet.equals("1051") || this.characterSet.equalsIgnoreCase("Cp1051")) {
                    this.messageText = this.unicodeFrom1051(this.messageBytes, this.dataStart);
                    this.characterSet = new String("UTF8");
                } else {
                    this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                }
                this.messageBytes = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = this.newMessageFormatException(1008, this.characterSet);
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (bTraceIsOn) {
                trace.exit(this, "getText, via Exception");
            }
            throw jMSException;
        }
        if (this.isNullMessage && this.messageText != null && this.messageText.length() == 0) {
            this.messageText = null;
        } else if (!this.isNullMessage && this.messageText == null) {
            this.messageText = "";
        }
        if (bTraceIsOn) {
            trace.exit(this, "getText");
        }
        return this.messageText;
    }

    public void setText(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setText");
        }
        if (this.readOnly) {
            throw this.newMessageNotWriteableException();
        }
        this.isNullMessage = string == null;
        this.messageText = string;
        this.messageBytes = null;
        if (bTraceIsOn) {
            trace.exit(this, "setText");
        }
    }

    public String toString() {
        if (bTraceIsOn) {
            trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        try {
            if (this.messageText == null) {
                this.getText();
            }
        }
        catch (JMSException jMSException) {
            stringBuffer.append(this.jmsStrings.getMessage(1025, (Object)jMSException));
            stringBuffer.append(">");
        }
        if (this.messageText == null) {
            stringBuffer.append("<null>");
        } else if (this.messageText.length() > 100) {
            stringBuffer.append(this.messageText.substring(0, 100));
            stringBuffer.append("\n" + this.jmsStrings.getMessage(1026, new Integer(this.messageText.length() - 100)));
        } else {
            stringBuffer.append(this.messageText);
        }
        if (bTraceIsOn) {
            trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.messageClass.equals("jms_text")) {
            this.messageClass = "jms_text";
        }
    }

    public String unicodeFrom1051(byte[] byArray, int n) {
        if (bTraceIsOn) {
            trace.entry(this, "unicodeFrom1051");
        }
        int n2 = byArray.length - n;
        char[] cArray = new char[n2];
        if (this.HPCodepage == null) {
            this.HPCodepage = this.get1051codepage();
        }
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = (byArray[n3] + 256) % 256;
            cArray[i] = this.HPCodepage[n4];
            ++n3;
        }
        if (bTraceIsOn) {
            trace.exit(this, "unicodeFrom1051");
        }
        return new String(cArray);
    }

    private char[] get1051codepage() {
        int n;
        if (bTraceIsOn) {
            trace.entry(this, "get1051codepage");
        }
        char[] cArray = new char[256];
        char[] cArray2 = new char[]{'\u00c0', '\u00c2', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u02ca', '\u02cb', '\u02c6', '\u00a8', '\u02dc', '\u00d9', '\u00db', '\u20a4', '\u00af', '\u00dd', '\u00fd', '\u00b0', '\u00c7', '\u00e7', '\u00d1', '\u00f1', '\u00a1', '\u00bf', '\u00a4', '\u00a3', '\u00a5', '\u00a7', '\u0192', '\u00a2', '\u00e2', '\u00ea', '\u00f4', '\u00fb', '\u00e1', '\u00e9', '\u00f3', '\u00fa', '\u00e0', '\u00e8', '\u00f2', '\u00f9', '\u00e4', '\u00eb', '\u00f6', '\u00fc', '\u00c5', '\u00ee', '\u00d8', '\u00c6', '\u00e5', '\u00ed', '\u00f8', '\u00e6', '\u00c4', '\u00ec', '\u00d6', '\u00dc', '\u00c9', '\u00ef', '\u00df', '\u00d4', '\u00c1', '\u00c3', '\u00e3', '\u00d0', '\u00f0', '\u00cd', '\u00cc', '\u00d3', '\u00d2', '\u00d5', '\u00f5', '\u0160', '\u0161', '\u00da', '\u0178', '\u00ff', '\u00de', '\u00fe', '\u00b7', '\u00b5', '\u00b6', '\u00be', '\u00ad', '\u00bc', '\u00bd', '\u00aa', '\u00ba', '\u00ab', '\u25a0', '\u00bb', '\u00b1', '\u001a'};
        for (n = 0; n < 161; ++n) {
            cArray[n] = (char)n;
        }
        for (n = 161; n <= 255; ++n) {
            cArray[n] = cArray2[n - 161];
        }
        if (bTraceIsOn) {
            trace.exit(this, "get1051codepage");
        }
        return cArray;
    }
}

