/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqservices;

import com.ibm.mqservices.CallStackTrace;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public final class Trace {
    private static final String sccsid = "@(#) javabase/com/ibm/mqservices/Trace.java, java, j600, j600-202-070608 1.25.1.2 06/11/30 14:50:45";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String mqTraceExt = ".TRC";
    private static Hashtable indentsTable;
    public static boolean isOn;
    private static boolean methodTrace;
    private static boolean inCICS;
    private static boolean wasEnv;
    private static boolean wasBaseJavaTrace;
    private static Object traceLock;
    private static PrintWriter trc;
    private static int traceLevel;

    private static final String threadName() {
        if (inCICS) {
            return "unknown";
        }
        return Thread.currentThread().getName();
    }

    private static final Object currentThreadKey() {
        if (inCICS) {
            return new Integer(0);
        }
        return Thread.currentThread();
    }

    private static final void incrementIndents() {
        int n = Trace.getIndentationLevel();
        indentsTable.put(new Integer(Trace.currentThreadKey().hashCode()), new Integer(++n));
    }

    private static final void decrementIndents() {
        int n = Trace.getIndentationLevel();
        if (n > 1) {
            indentsTable.put(new Integer(Trace.currentThreadKey().hashCode()), new Integer(--n));
        } else if (n == 1) {
            indentsTable.remove(new Integer(Trace.currentThreadKey().hashCode()));
        }
    }

    private static final int getIndentationLevel() {
        int n = 0;
        if (indentsTable.containsKey(new Integer(Trace.currentThreadKey().hashCode()))) {
            Integer n2 = (Integer)indentsTable.get(new Integer(Trace.currentThreadKey().hashCode()));
            n = n2;
        }
        return n;
    }

    private static final void traceTime() {
        int n;
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = Trace.getIndentationLevel();
        for (n = 0; n < n2; ++n) {
            trc.print("  ");
        }
        n = gregorianCalendar.get(10);
        int n3 = gregorianCalendar.get(12);
        int n4 = gregorianCalendar.get(13);
        if (n < 10) {
            trc.print("0" + n + ":");
        } else {
            trc.print(n + ":");
        }
        if (n3 < 10) {
            trc.print("0" + n3 + ":");
        } else {
            trc.print(n3 + ":");
        }
        if (n4 < 10) {
            trc.print("0" + n4 + ":");
        } else {
            trc.print(n4 + " ");
        }
        trc.print("[" + date.getTime() + "] ");
    }

    public static void printHexBytes(PrintWriter printWriter, byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            int n2;
            int n3;
            int n4 = Math.min(i + 16, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n3 = i; n3 < n4; ++n3) {
                n2 = byArray[n3];
                n2 = (n2 + 256) % 256;
                n = n2 / 16;
                int n5 = n2 % 16;
                stringBuffer.append((char)(n < 10 ? 48 + n : 97 + n - 10));
                stringBuffer.append((char)(n5 < 10 ? 48 + n5 : 97 + n5 - 10));
                if (n3 % 2 == 1) {
                    stringBuffer.append(' ');
                }
                if (n2 >= 32 && n2 <= 126) {
                    stringBuffer2.append((char)n2);
                    continue;
                }
                stringBuffer2.append('.');
            }
            n3 = 16 - (n4 - i);
            n2 = (n3 * 5 + n3 % 2) / 2;
            n2 += 3;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            String string = "0000" + Integer.toHexString(i);
            string = string.substring(string.length() - 4);
            printWriter.print(string);
            printWriter.print(":  ");
            printWriter.print(stringBuffer.toString());
            printWriter.println(stringBuffer2.toString());
        }
    }

    public static final void notInCICS() {
        inCICS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dumpCallStack() {
        if (!isOn) {
            return;
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                CallStackTrace callStackTrace = new CallStackTrace();
                try {
                    throw callStackTrace;
                }
                catch (CallStackTrace callStackTrace2) {
                    Trace.traceTime();
                    trc.println("Thread: " + Trace.threadName() + " Stack Trace Follows: (stack trace requires java_g or appletviewer_g)");
                    callStackTrace.printStackTrace(trc);
                }
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void entry(Object object, String string) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.entry((Object)object, (String)string);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " ==> " + string + "() entry");
                Trace.incrementIndents();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void entry(String string, String string2) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.entry((String)string, (String)string2);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " ==> " + string + "::" + string2 + "() entry");
                Trace.incrementIndents();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exit(Object object, String string) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.exit((Object)object, (String)string);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                Trace.decrementIndents();
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " <== " + string + "() exit");
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exit(String string, String string2) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.exit((String)string, (String)string2);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                Trace.decrementIndents();
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " <== " + string + "::" + string2 + "() exit");
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(Object object, String string) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.trace((Object)object, (String)string);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                String string2 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string2 + ", Object: " + object + " " + string);
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void trace(String string, String string2) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.trace((Object)string, (String)string2);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object = traceLock;
        synchronized (object) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn) {
                String string3 = "Thread: " + Trace.threadName();
                Trace.traceTime();
                trc.println(string3 + " Class: " + string + " " + string2);
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    public static final void trace(int n, Object object, String string) {
        if (traceLevel >= n) {
            Trace.trace(object, string);
        }
    }

    public static final void trace(int n, String string, String string2) {
        if (traceLevel >= n) {
            Trace.trace(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dataTrace(int n, Object object, byte[] byArray) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.dataTrace((int)n, (Object)object, (byte[])byArray);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn && traceLevel >= n) {
                Trace.traceTime();
                trc.print("Thread: " + Trace.threadName() + ", ");
                if (object != null) {
                    trc.print("Object: " + object);
                }
                trc.println(" Data trace, " + byArray.length + " bytes of data follow: \n");
                Trace.printHexBytes(trc, byArray);
                trc.println();
            }
            if (methodTrace) {
                Trace.traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exceptionTrace(int n, Object object, Throwable throwable) {
        if (!isOn) {
            return;
        }
        if (wasEnv) {
            com.ibm.mq.jms.services.Trace.exception((int)n, (Object)object, (String)"", (Throwable)throwable);
            if (!wasBaseJavaTrace) {
                return;
            }
        }
        Object object2 = traceLock;
        synchronized (object2) {
            if (methodTrace) {
                Trace.traceMethodCalls(false);
            }
            if (isOn && traceLevel >= n) {
                Trace.traceTime();
                trc.print("Thread: " + Trace.threadName() + ", ");
                if (object != null) {
                    trc.print("Object: " + object);
                }
                trc.println(" Exception: ");
                throwable.printStackTrace(trc);
                trc.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void turnTracingOn() {
        Object object = traceLock;
        synchronized (object) {
            isOn = true;
            indentsTable = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void turnTracingOff() {
        Object object = traceLock;
        synchronized (object) {
            isOn = false;
            if (indentsTable != null) {
                indentsTable.clear();
            }
            if (trc != null) {
                try {
                    trc.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void turnMethodTracingOn() {
        Object object = traceLock;
        synchronized (object) {
            Trace.traceMethodCalls(true);
            methodTrace = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void turnMethodTracingOff() {
        Object object = traceLock;
        synchronized (object) {
            Trace.traceMethodCalls(false);
            methodTrace = false;
        }
    }

    private static final void traceMethodCalls(boolean bl) {
        if (!inCICS) {
            Runtime.getRuntime().traceMethodCalls(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setTraceStream(FileWriter fileWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (fileWriter != null) {
                traceLock = fileWriter;
                trc = new PrintWriter((Writer)fileWriter, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setTraceStream(PrintWriter printWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (printWriter != null) {
                trc = printWriter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setTraceLevel(int n) {
        Object object = traceLock;
        synchronized (object) {
            traceLevel = n;
        }
    }

    public static boolean isOn() {
        return isOn;
    }

    public static void setWasEnv(boolean bl) {
        wasEnv = bl;
    }

    public static void setWasBaseJavaTrace(boolean bl) {
        wasBaseJavaTrace = bl;
    }

    public static boolean getWasBaseJavaTrace() {
        return wasBaseJavaTrace;
    }

    static {
        isOn = false;
        methodTrace = false;
        inCICS = true;
        wasEnv = false;
        wasBaseJavaTrace = false;
        traceLock = new Object();
        trc = new PrintWriter(System.err, true);
        traceLevel = 1;
    }
}

