/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.mqjd;

import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mq.mqjd.Connection;
import com.ibm.mq.mqjd.MQJDException;
import com.ibm.mqservices.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.transaction.xa.Xid;

public class MQSESSION
extends com.ibm.mq.MQSESSION
implements MQXAVerbs {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/mqjd/MQSESSION.java, java, j600, j600-201-061220 1.10.1.1 05/05/25 15:44:26";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSION";
    private static final int MQHO_UNUSABLE_HOBJ = -1;
    private static final int MQHC_UNUSABLE_HCONN = -1;
    private int mqjdVersion = 0;
    private boolean inUseByQM = false;
    private Connection mqjdConnection = null;
    private static int lasthConn = 0;
    private static Object lasthConnLock = new Object();
    private int hConn = 0;
    private int rmid;
    private boolean inUseByXA;
    private Object mqiLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQSESSION() {
        Object object = lasthConnLock;
        synchronized (object) {
            this.hConn = ++lasthConn;
        }
        this.inUseByXA = false;
        this.mqiLock = new Object();
    }

    public void MQCONN(String string, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCONN");
            Trace.trace(2, this, sccsid);
            if (string != null) {
                Trace.trace(1, this, "Queue Manager = '" + string + "'");
            } else {
                Trace.trace(1, this, "Connecting to default queue manager");
            }
        }
        try {
            this.mqjdConnection = Connection.createConnection(string);
            if (this.mqjdConnection != null) {
                pint.x = this.hConn;
                pint2.x = 0;
                pint3.x = 0;
                this.inUseByQM = true;
                if (this.mqjdVersion == 0) {
                    this.mqjdVersion = this.mqjdConnection.getVersion();
                }
            } else {
                Trace.trace(2, this, "MQJD is not installed");
                pint.x = -1;
                pint2.x = 2;
                pint3.x = 2012;
            }
        }
        catch (MQJDException mQJDException) {
            pint.x = -1;
            pint2.x = mQJDException.getCompCode();
            pint3.x = mQJDException.getReason();
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "MQCONN returning hConn " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCONN");
        }
    }

    public void MQCONNX(String string, int n, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        Trace.entry(clsName, "MQCONNX");
        Trace.trace(2, clsName, sccsid);
        if (n == 0 || n == 1) {
            this.MQCONN(string, pint, pint2, pint3, pthrowable);
        } else {
            pint.x = -1;
            pint2.x = 2;
            pint3.x = 2046;
        }
        Trace.exit(clsName, "MQCONNX");
    }

    public void MQCONNX(String string, MQConnectionOptions mQConnectionOptions, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        this.MQCONNX(string, mQConnectionOptions.getOptions(), pint, pint2, pint3, pthrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQDISC(Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQDISC");
            Trace.trace(1, this, "Handle = " + pint.x);
        }
        if (this.mqjdConnection == null || this.hConn != pint.x) {
            pint2.x = 2;
            pint3.x = 2018;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqdisc();
                }
                pint.x = -1;
                this.inUseByQM = false;
                pint2.x = 0;
                pint3.x = 0;
                this.inUseByXA = false;
                if (false) {
                    this.mqjdConnection = null;
                }
            }
            catch (MQJDException mQJDException) {
                pint2.x = mQJDException.getCompCode();
                pint3.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQDISC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQOPEN(int n, MQOD mQOD, int n2, Pint pint, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQOPEN");
            Trace.trace(2, this, "hConn = " + n);
        }
        pint2.x = 0;
        pint3.x = 0;
        pint.x = -1;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint2.x = 2;
            pint3.x = 2018;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    pint.x = this.mqjdConnection.mqopen(mQOD, n2);
                }
            }
            catch (MQJDException mQJDException) {
                pint2.x = mQJDException.getCompCode();
                pint3.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "MQOPEN returning hObj " + pint.x);
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQOPEN");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCLOSE(int n, Pint pint, int n2, Pint pint2, Pint pint3) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCLOSE");
            Trace.trace(2, this, "Conn Handle = " + n + " Object Handle = " + pint.x);
        }
        pint2.x = 0;
        pint3.x = 0;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint2.x = 2;
            pint3.x = 2018;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqclose(pint.x, n2);
                }
                pint.x = -1;
            }
            catch (MQJDException mQJDException) {
                pint2.x = mQJDException.getCompCode();
                pint3.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQCLOSE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQPUT(int n, int n2, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        block10: {
            block9: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQPUT");
                    Trace.trace(2, this, "hConn = " + n);
                    Trace.trace(2, this, "hObj  = " + n2);
                }
                try {
                    try {
                        pint.x = 0;
                        pint2.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint.x = 2;
                            pint2.x = 2018;
                            Object var12_9 = null;
                            break block9;
                        }
                        Object object = this.mqiLock;
                        synchronized (object) {
                            this.mqjdConnection.mqput(n2, mQMD, mQPutMessageOptions, n3, byArray);
                            break block10;
                        }
                    }
                    catch (MQJDException mQJDException) {
                        pint.x = mQJDException.getCompCode();
                        pint2.x = mQJDException.getReason();
                        Object var12_11 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                        Trace.exit(this, "MQPUT");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                    Trace.exit(this, "MQPUT");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT");
            return;
        }
        Object var12_10 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        Trace.exit(this, "MQPUT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQPUT(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        block10: {
            block9: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQPUT (MQMsg2)");
                    Trace.trace(2, this, "hConn = " + n);
                    Trace.trace(2, this, "hObj  = " + n2);
                }
                try {
                    try {
                        pint.x = 0;
                        pint2.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint.x = 2;
                            pint2.x = 2018;
                            Object var13_9 = null;
                            break block9;
                        }
                        MQMD mQMD = new MQMD();
                        this.convertMQMsg2ToMQMD(mQMsg2, mQMD);
                        Object object = this.mqiLock;
                        synchronized (object) {
                            this.mqjdConnection.mqput(n2, mQMD, mQPutMessageOptions, n3, byArray);
                        }
                        this.convertMQMDToMQMsg2(mQMD, mQMsg2);
                        break block10;
                    }
                    catch (MQJDException mQJDException) {
                        pint.x = mQJDException.getCompCode();
                        pint2.x = mQJDException.getReason();
                        Object var13_11 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                        Trace.exit(this, "MQPUT (MQMsg2)");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                    Trace.exit(this, "MQPUT (MQMsg2)");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT (MQMsg2)");
            return;
        }
        Object var13_10 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        Trace.exit(this, "MQPUT (MQMsg2)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQGET(int n, int n2, MQMD mQMD, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        block12: {
            block11: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQGET");
                    Trace.trace(2, this, "hConn = " + n);
                    Trace.trace(2, this, "hObj  = " + n2);
                }
                try {
                    try {
                        pint2.x = 0;
                        pint3.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint2.x = 2;
                            pint3.x = 2018;
                            Object var13_10 = null;
                            break block11;
                        }
                        Object object = this.mqiLock;
                        synchronized (object) {
                            pint.x = this.mqjdConnection.mqget(n2, mQMD, mQGetMessageOptions, n3, byArray);
                            if (pint.x <= n3) break block12;
                        }
                        if ((mQGetMessageOptions.options & 0x40) != 0) {
                            pint2.x = 1;
                            pint3.x = 2079;
                            break block12;
                        } else {
                            pint2.x = 1;
                            pint3.x = 2080;
                        }
                        break block12;
                    }
                    catch (MQJDException mQJDException) {
                        pint2.x = mQJDException.getCompCode();
                        pint3.x = mQJDException.getReason();
                        Object var13_12 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
                        Trace.exit(this, "MQGET");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
                    Trace.exit(this, "MQGET");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET");
            return;
        }
        Object var13_11 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
        Trace.exit(this, "MQGET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQGET(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) {
        block12: {
            block11: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQGET (MQMsg2)");
                    Trace.trace(2, this, "hConn = " + n);
                    Trace.trace(2, this, "hObj  = " + n2);
                }
                try {
                    try {
                        pint2.x = 0;
                        pint3.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint2.x = 2;
                            pint3.x = 2018;
                            Object var14_10 = null;
                            break block11;
                        }
                        MQMD mQMD = new MQMD();
                        this.convertMQMsg2ToMQMD(mQMsg2, mQMD);
                        Object object = this.mqiLock;
                        synchronized (object) {
                            pint.x = this.mqjdConnection.mqget(n2, mQMD, mQGetMessageOptions, n3, byArray);
                        }
                        this.convertMQMDToMQMsg2(mQMD, mQMsg2);
                        if (pint.x <= n3) break block12;
                        if ((mQGetMessageOptions.options & 0x40) != 0) {
                            pint2.x = 1;
                            pint3.x = 2079;
                            break block12;
                        } else {
                            pint2.x = 1;
                            pint3.x = 2080;
                        }
                        break block12;
                    }
                    catch (MQJDException mQJDException) {
                        pint2.x = mQJDException.getCompCode();
                        pint3.x = mQJDException.getReason();
                        Object var14_12 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
                        Trace.exit(this, "MQGET (MQMsg2)");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
                    Trace.exit(this, "MQGET (MQMsg2)");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
            Trace.exit(this, "MQGET (MQMsg2)");
            return;
        }
        Object var14_11 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint2.x + "," + pint3.x);
        Trace.exit(this, "MQGET (MQMsg2)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQPUT1(int n, MQOD mQOD, MQMD mQMD, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        block10: {
            block9: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQPUT1");
                    Trace.trace(2, this, "hConn = " + n);
                }
                try {
                    try {
                        pint.x = 0;
                        pint2.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint.x = 2;
                            pint2.x = 2018;
                            Object var12_9 = null;
                            break block9;
                        }
                        Object object = this.mqiLock;
                        synchronized (object) {
                            this.mqjdConnection.mqput1(mQOD, mQMD, mQPutMessageOptions, n2, byArray);
                            break block10;
                        }
                    }
                    catch (MQJDException mQJDException) {
                        pint.x = mQJDException.getCompCode();
                        pint2.x = mQJDException.getReason();
                        Object var12_11 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                        Trace.exit(this, "MQPUT1");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                    Trace.exit(this, "MQPUT1");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT1");
            return;
        }
        Object var12_10 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        Trace.exit(this, "MQPUT1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void MQPUT1(int n, MQOD mQOD, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n2, byte[] byArray, Pint pint, Pint pint2) {
        block10: {
            block9: {
                if (Trace.isOn()) {
                    Trace.entry(this, "MQPUT1 - MQMsg2 version");
                    Trace.trace(2, this, "hConn = " + n);
                }
                try {
                    try {
                        pint.x = 0;
                        pint2.x = 0;
                        if (this.mqjdConnection == null || this.hConn != n) {
                            pint.x = 2;
                            pint2.x = 2018;
                            Object var13_9 = null;
                            break block9;
                        }
                        MQMD mQMD = new MQMD();
                        this.convertMQMsg2ToMQMD(mQMsg2, mQMD);
                        Object object = this.mqiLock;
                        synchronized (object) {
                            this.mqjdConnection.mqput1(mQOD, mQMD, mQPutMessageOptions, n2, byArray);
                        }
                        this.convertMQMDToMQMsg2(mQMD, mQMsg2);
                        break block10;
                    }
                    catch (MQJDException mQJDException) {
                        pint.x = mQJDException.getCompCode();
                        pint2.x = mQJDException.getReason();
                        Object var13_11 = null;
                        if (!Trace.isOn()) return;
                        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                        Trace.exit(this, "MQPUT1 - MQMsg2 version");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    if (!Trace.isOn()) throw throwable;
                    Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
                    Trace.exit(this, "MQPUT1 - MQMsg2 version");
                    throw throwable;
                }
            }
            if (!Trace.isOn()) return;
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQPUT1 - MQMsg2 version");
            return;
        }
        Object var13_10 = null;
        if (!Trace.isOn()) return;
        Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
        Trace.exit(this, "MQPUT1 - MQMsg2 version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQINQ(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQINQ");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        pint.x = 0;
        pint2.x = 0;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint.x = 2;
            pint2.x = 2018;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqinq(n2, n3, nArray, n4, nArray2, n5, byArray);
                }
            }
            catch (MQJDException mQJDException) {
                pint.x = mQJDException.getCompCode();
                pint2.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQINQ");
        }
    }

    protected String MQINQ(int n, int n2, int n3, int n4, Pint pint, Pint pint2) {
        Trace.trace(this, "STRANGE: 390/400 version of MQINQ called on client");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQSET(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQSET");
            Trace.trace(2, this, "hConn = " + n);
            Trace.trace(2, this, "hObj  = " + n2);
        }
        pint.x = 0;
        pint2.x = 0;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint.x = 2;
            pint2.x = 2018;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqset(n2, n3, nArray, n4, nArray2, n5, byArray);
                }
            }
            catch (MQJDException mQJDException) {
                pint.x = mQJDException.getCompCode();
                pint2.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQSET");
        }
    }

    protected void MQSET(int n, int n2, int n3, String string, int n4, Pint pint, Pint pint2) {
        Trace.trace(this, "STRANGE: 390/400 version of MQSET called on client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQBACK(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQBACK");
            Trace.trace(2, this, "Connection handle = " + n);
        }
        pint.x = 0;
        pint2.x = 0;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint.x = 2;
            pint2.x = 2018;
        } else if (this.inUseByXA) {
            pint.x = 2;
            pint2.x = 2012;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqback();
                }
            }
            catch (MQJDException mQJDException) {
                pint.x = mQJDException.getCompCode();
                pint2.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQBACK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MQCMIT(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "MQCMIT");
            Trace.trace(2, this, "Connection handle = " + n);
        }
        pint.x = 0;
        pint2.x = 0;
        if (this.mqjdConnection == null || this.hConn != n) {
            pint.x = 2;
            pint2.x = 2018;
        } else if (this.inUseByXA) {
            pint.x = 2;
            pint2.x = 2012;
        } else {
            try {
                Object object = this.mqiLock;
                synchronized (object) {
                    this.mqjdConnection.mqcmit();
                }
            }
            catch (MQJDException mQJDException) {
                pint.x = mQJDException.getCompCode();
                pint2.x = mQJDException.getReason();
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(this, "MQCMIT");
        }
    }

    public final void MQBEGIN(int n, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "MQBEGIN");
            Trace.trace(2, clsName, "Conn Handle = " + n);
        }
        pint.x = 2;
        pint2.x = 2012;
        Trace.exit(clsName, "MQBEGIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAOPEN(String string, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XAOPEN");
            Trace.trace(2, this, " name = " + string);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (this.mqjdConnection == null) {
            return -3;
        }
        if (this.inUseByXA && this.rmid != n) {
            return -3;
        }
        Object object = this.mqiLock;
        synchronized (object) {
            n3 = this.mqjdConnection.xaopen(string, n2);
        }
        if (n3 == 0) {
            this.rmid = n;
            this.inUseByXA = true;
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XAOPEN");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XACLOSE(String string, int n, int n2) throws Exception {
        if (Trace.isOn()) {
            Trace.entry(this, "XACLOSE");
            Trace.trace(2, this, " name = " + string);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        int n3 = 0;
        if (this.inUseByXA) {
            if (this.rmid != n) {
                n3 = -3;
            } else {
                Object object = this.mqiLock;
                synchronized (object) {
                    n3 = this.mqjdConnection.xaclose(string, n2);
                }
                if (!this.inUseByQM) {
                    this.mqjdConnection = null;
                }
                this.inUseByXA = false;
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XACLOSE");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XASTART(Xid xid, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XASTART");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xastart(xid, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XASTART");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAEND(Xid xid, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XAEND");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xaend(xid, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XAEND");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAPREPARE(Xid xid, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XAPREPARE");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xaprepare(xid, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XAPREPARE");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XACOMMIT(Xid xid, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XACOMMIT");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xacommit(xid, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XACOMMIT");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XAROLLBACK(Xid xid, int n, int n2) {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XAROLLBACK");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xarollback(xid, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XAROLLBACK");
        }
        return n3;
    }

    public int XAFORGET(Xid xid, int n, int n2) {
        if (Trace.isOn()) {
            Trace.entry(this, "XAFORGET");
            Trace.trace(2, this, " xid = " + xid);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        int n3 = !this.inUseByXA || this.rmid != n ? -3 : -4;
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XAFORGET");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int XARECOVER(Xid[] xidArray, int n, int n2) throws Exception {
        int n3;
        if (Trace.isOn()) {
            Trace.entry(this, "XARECOVER");
            Trace.trace(2, this, " xid[] length = " + xidArray.length);
            Trace.trace(2, this, " rmid = " + n);
            Trace.trace(2, this, " flags = " + n2);
        }
        if (!this.inUseByXA || this.rmid != n) {
            n3 = -3;
        } else {
            Object object = this.mqiLock;
            synchronized (object) {
                n3 = this.mqjdConnection.xarecover(xidArray, n2);
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, " returning = " + n3);
            Trace.exit(this, "XARECOVER");
        }
        return n3;
    }

    public void honourRRSInternal(int n, Pint pint, Pint pint2) {
        Trace.trace(clsName, "WARNING: honourRRSInternal called");
    }

    protected void resolveV2Support(int n, int n2, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(this, "resolveV2Support");
            Trace.exit(this, "resolveV2Support");
        }
    }

    protected final boolean supportsV2Structures(int n) {
        Trace.entry(clsName, "supportsV2Structures");
        boolean bl = true;
        Trace.exit(clsName, "supportsV2Structures");
        return bl;
    }

    protected final void setThreadAccess(String string, Boolean bl) throws MQException {
        Trace.entry(this, "setThreadAccess");
        if (string != null && !string.equals("MULTI_THREAD")) {
            if (string.equals("SINGLE_THREAD")) {
                Trace.trace(2, this, "Single thread access mode not supported.");
                Trace.exit(this, "setThreadAccess (via exception)");
                throw new MQException(2, 2012, this);
            }
            Trace.trace(2, this, "Unknown thread access mode specified");
            Trace.exit(this, "setThreadAccess (via exception)");
            throw new MQException(2, 2012, this);
        }
        Trace.trace(2, this, "Default multi-thread access will be used.");
        Trace.exit(this, "setThreadAccess");
    }

    public boolean spiSupportsDeferred() {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiSupportsDeferred");
            Trace.exit(clsName, "spiSupportsDeferred");
        }
        return false;
    }

    public void spiConnect(String string, int n, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiConnect");
        }
        this.MQCONNX(string, n, pint, pint2, pint3, pthrowable);
        if (Trace.isOn()) {
            Trace.exit(clsName, "spiConnect");
        }
    }

    public void spiConnect(String string, MQConnectionOptions mQConnectionOptions, Pint pint, Pint pint2, Pint pint3, Pthrowable pthrowable) {
        this.spiConnect(string, mQConnectionOptions.getOptions(), pint, pint2, pint3, pthrowable);
    }

    public void spiDefCancel(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefCancel");
        }
        pint.x = 2;
        pint2.x = 2195;
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "Deferred messages not supported");
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefCancel");
        }
    }

    public void spiDefActivate(int n, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefActivate");
        }
        pint.x = 2;
        pint2.x = 2195;
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "Deferred messages not supported");
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefActivate");
        }
    }

    public void spiDefPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiDefPut");
        }
        pint.x = 2;
        pint2.x = 2195;
        if (Trace.isOn()) {
            Trace.trace(2, clsName, "Deferred messages not supported");
            Trace.trace(2, clsName, "CC,RC = " + pint.x + "," + pint2.x);
            Trace.exit(clsName, "spiDefPut");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertMQMsg2ToMQMD(MQMsg2 mQMsg2, MQMD mQMD) throws MQJDException {
        FilterOutputStream filterOutputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(364);
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = MQSESSION.getDefaultCCSID();
                boolean bl = this.getCharEncoding() == 1;
                mQMsg2.writeTo((DataOutputStream)filterOutputStream, n, bl);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                filterInputStream = new DataInputStream(byteArrayInputStream);
                mQMD.readFrom((DataInputStream)filterInputStream, n, bl);
            }
            catch (IOException iOException) {
                throw new MQJDException(2, 2195);
            }
            catch (MQException mQException) {
                throw new MQJDException(mQException.completionCode, mQException.reasonCode);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (filterInputStream == null) throw throwable;
                filterInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
        if (filterInputStream == null) return;
        filterInputStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertMQMDToMQMsg2(MQMD mQMD, MQMsg2 mQMsg2) throws MQJDException {
        FilterOutputStream filterOutputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(364);
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = MQSESSION.getDefaultCCSID();
                boolean bl = this.getCharEncoding() == 1;
                mQMD.writeTo((DataOutputStream)filterOutputStream, n, bl);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                filterInputStream = new DataInputStream(byteArrayInputStream);
                mQMsg2.readFrom((DataInputStream)filterInputStream, n, bl);
            }
            catch (IOException iOException) {
                throw new MQJDException(2, 2195);
            }
            catch (MQException mQException) {
                throw new MQJDException(mQException.completionCode, mQException.reasonCode);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (filterInputStream == null) throw throwable;
                filterInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
        if (filterInputStream == null) return;
        filterInputStream.close();
        return;
    }

    protected boolean authenticate(int n, String string, String string2, Pint pint, Pint pint2) {
        pint.x = 0;
        pint2.x = 0;
        return true;
    }

    public boolean spiSupportsInherited() {
        return false;
    }

    protected void spiAsyncCmit(int n, Pint pint, Pint pint2) {
        this.MQCMIT(n, pint, pint2);
    }

    protected void spiGet(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, int n4, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n4, byArray, pint, pint2, pint3);
    }

    public void spiPut(int n, int n2, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, int n3, int n4, byte[] byArray, Pint pint, Pint pint2) {
        if (Trace.isOn()) {
            Trace.entry(clsName, "spiPut");
        }
        this.MQPUT(n, n2, mQMsg2, mQPutMessageOptions, n4, byArray, pint, pint2);
    }
}

