/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionEventListener;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.Pint;
import com.ibm.mq.PoolScavenger;
import com.ibm.mqservices.Trace;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class StoredManagedConnection
implements MQConnectionEventListener {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/StoredManagedConnection.java, java, j600, j600-201-061220 1.10.1.1 05/05/25 15:41:09";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MQManagedConnectionJ11 mqManCon;
    ManagedConnectionStore pool;
    PoolScavenger scavenger;
    MQManagedConnectionFactory mqMcf;
    MQSimpleConnectionManager owner;
    ConnectionRequestInfo cxReqInf;
    boolean inuse = false;
    boolean poolActive = false;
    boolean destroyMark = false;

    StoredManagedConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo, ManagedConnectionStore managedConnectionStore, PoolScavenger poolScavenger, MQSimpleConnectionManager mQSimpleConnectionManager) throws ResourceException {
        if (Trace.isOn) {
            Trace.entry(this, "StoredManagedConnection constructor");
        }
        this.pool = managedConnectionStore;
        this.scavenger = poolScavenger;
        this.mqMcf = mQManagedConnectionFactory;
        this.cxReqInf = connectionRequestInfo;
        this.owner = mQSimpleConnectionManager;
        this.mqManCon = mQManagedConnectionFactory.createManagedConnection(connectionRequestInfo);
        this.inuse = true;
        this.mqManCon.addMQConnectionEventListener(this);
        if (Trace.isOn) {
            Trace.exit(this, "StoredManagedConnection constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean use() {
        if (Trace.isOn) {
            Trace.entry(this, "use");
        }
        StoredManagedConnection storedManagedConnection = this;
        synchronized (storedManagedConnection) {
            if (Trace.isOn) {
                Trace.trace(2, this, "use - owns synclock");
            }
            if (!this.inuse) {
                this.inuse = true;
                this.pool.deregister(this);
                this.scavenger.deregister(this);
                if (Trace.isOn) {
                    Trace.exit(this, "use() succeeded - SMC now in-use - releasing synclock");
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "use() failed - SMC already in-use - releasing synclock");
            }
            return false;
        }
    }

    void initializePoolActive(boolean bl) {
        this.poolActive = bl;
        this.owner.addStoredManagedConnection(this);
    }

    synchronized void poolActive(boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "poolActive - owns synclock");
        }
        this.poolActive = bl;
        if (!bl && !this.inuse) {
            this.destroyMark = true;
            this.pool.deregister(this);
            this.scavenger.deregister(this);
            this.inuse = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "poolActive - releasing synclock");
        }
    }

    void destroyIfMarked() {
        if (this.destroyMark) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trigger() {
        if (Trace.isOn) {
            Trace.entry(this, "trigger");
        }
        boolean bl = false;
        StoredManagedConnection storedManagedConnection = this;
        synchronized (storedManagedConnection) {
            if (Trace.isOn) {
                Trace.trace(2, this, "trigger owns synclock");
            }
            if (!this.inuse) {
                bl = true;
                this.pool.deregister(this);
                this.scavenger.deregister(this);
                this.inuse = true;
            }
            if (Trace.isOn) {
                Trace.trace(2, this, "trigger releasing synclock");
            }
        }
        if (bl) {
            this.destroy();
        }
        if (Trace.isOn) {
            Trace.exit(this, "trigger");
        }
    }

    void quiesce() throws MQException {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "quiesce");
            }
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this.mqManCon;
            this.owner.removeStoredManagedConnection(this);
            mQManagedConnectionJ11.removeMQConnectionEventListener(this);
            try {
                mQManagedConnectionJ11.destroy();
            }
            catch (ResourceException resourceException) {
                Exception exception = resourceException.getLinkedException();
                if (!(exception instanceof MQException)) break block4;
                mQManagedConnectionJ11.addMQConnectionEventListener(this);
                this.owner.addStoredManagedConnection(this);
                throw (MQException)exception;
            }
        }
        this.mqManCon = null;
        if (Trace.isOn) {
            Trace.exit(this, "quiesce");
        }
    }

    void destroy() {
        MQManagedConnectionJ11 mQManagedConnectionJ11;
        if (Trace.isOn) {
            Trace.entry(this, "destroy");
        }
        if ((mQManagedConnectionJ11 = this.mqManCon) != null) {
            this.owner.removeStoredManagedConnection(this);
            mQManagedConnectionJ11.removeMQConnectionEventListener(this);
            try {
                mQManagedConnectionJ11.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
            this.mqManCon = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(MQManagedConnectionJ11 mQManagedConnectionJ11, MQQueueManager mQQueueManager) {
        if (Trace.isOn) {
            Trace.entry(this, "connectionClosed");
        }
        mQQueueManager.setExceptionForDisconnect(null);
        boolean bl = false;
        try {
            MQSESSION mQSESSION = mQManagedConnectionJ11.getMQSESSION();
            Pint pint = mQManagedConnectionJ11.getHConn();
            Pint pint2 = new Pint();
            Pint pint3 = new Pint();
            mQSESSION.MQCMIT(pint.x, pint2, pint3);
            if (pint2.x == 2 && pint3.x == 2012) {
                pint2.x = 0;
                pint3.x = 0;
            }
            if (pint2.x == 2) {
                throw new MQException(pint2.x, pint3.x, this);
            }
            mQManagedConnectionJ11.cleanup();
            StoredManagedConnection storedManagedConnection = this;
            synchronized (storedManagedConnection) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "connectionClosed owns synclock");
                }
                if (this.poolActive) {
                    this.inuse = false;
                    this.pool.register(this);
                    this.scavenger.register(this);
                } else {
                    this.quiesce();
                    bl = true;
                }
                if (Trace.isOn) {
                    Trace.trace(2, this, "connectionClosed releasing synclock");
                }
            }
            if (pint2.x == 1) {
                throw new MQException(pint2.x, pint3.x, this);
            }
        }
        catch (ResourceException resourceException) {
            try {
                this.quiesce();
            }
            catch (MQException mQException) {
                mQQueueManager.setExceptionForDisconnect(mQException);
            }
        }
        catch (MQException mQException) {
            mQQueueManager.setExceptionForDisconnect(mQException);
            try {
                if (!bl) {
                    this.quiesce();
                }
            }
            catch (MQException mQException2) {
                // empty catch block
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "connectionClosed");
        }
    }

    public synchronized void connectionErrorOccurred(MQManagedConnectionJ11 mQManagedConnectionJ11, MQQueueManager mQQueueManager, Exception exception) {
    }
}

