/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.io.IOException;

class MQS390FloatSupport {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQS390FloatSupport.java, java, j600, j600-201-061220 1.9.1.1 05/05/25 15:38:09";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQS90FloatSupport";
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;

    MQS390FloatSupport() {
    }

    protected static final long doubleToS390LongBits(double d) throws IOException {
        long l;
        boolean bl;
        Trace.entry(clsName, "doubleToS90LongBits");
        Trace.trace(2, clsName, sccsid);
        long l2 = Double.doubleToLongBits(d);
        Trace.trace(2, clsName, "IEEE double bit pattern= " + Long.toString(l2, 16));
        boolean bl2 = bl = (l2 & Long.MIN_VALUE) == 0L;
        if ((l2 & Long.MAX_VALUE) == 0L) {
            Trace.exit(clsName, "doubleToS390LongBits (zero number)");
            return l2;
        }
        long l3 = l2 & 0x7FF0000000000000L;
        l3 >>>= 52;
        long l4 = l2 & 0xFFFFFFFFFFFFFL;
        long l5 = Math.abs(l3 -= 1022L) % 4L;
        long l6 = l = Math.abs(l3) / 4L;
        if (l3 > 0L && l5 != 0L) {
            ++l6;
        }
        if (l3 < 0L) {
            l6 = -l6;
        }
        l6 += 64L;
        long l7 = l4;
        l7 = l3 > -1022L ? (l7 |= 0x10000000000000L) : (l7 <<= 1);
        l7 <<= 3;
        if (l5 > 0L) {
            if (l3 > 0L) {
                int n = (int)(4L - l5);
                l7 >>>= n;
            } else {
                if (l3 == -1022L && (l7 & 0xF0000000000000L) == 0L) {
                    l7 <<= 4;
                    --l6;
                }
                l7 >>>= (int)l5;
            }
        }
        if (l3 == -1022L) {
            while (l7 != 0L && (l7 & 0xF0000000000000L) == 0L) {
                l7 <<= 4;
                --l6;
            }
        }
        if (l6 > 127L) {
            Trace.trace(1, clsName, "Exponent = " + l6);
            Trace.exit(clsName, "doubleToS390LongBits (exponent outside of range)");
            throw new IOException("Number outside of range for double precision S/390 Float");
        }
        if (l6 < 0L) {
            Trace.trace(1, clsName, "Number too small to represent, rounding to zero");
            Trace.exit(clsName, "doubleToS390LongBits (exponent outside of range)");
            return 0L;
        }
        long l8 = 0L;
        long l9 = l6 & 0x7FL;
        l8 = l9 << 56;
        if (!bl) {
            l8 |= Long.MIN_VALUE;
        }
        Trace.trace(2, clsName, "S390 bit pattern = " + Long.toString(l8 |= l7, 16));
        Trace.exit(clsName, "doubleToS390LongBits");
        return l8;
    }

    protected static final double longS390BitsToDouble(long l) throws IOException {
        boolean bl;
        Trace.entry(clsName, "longS390BitsToDouble");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(2, clsName, "S390 bit pattern = " + Long.toString(l, 16));
        boolean bl2 = bl = (l & Long.MIN_VALUE) == 0L;
        if ((l & Long.MAX_VALUE) == 0L) {
            Trace.exit(clsName, "longS390BitsToDouble (zero number)");
            if (bl) {
                return 0.0;
            }
            return -0.0;
        }
        long l2 = l & 0xFFFFFFFFFFFFFFL;
        long l3 = l & 0x7F00000000000000L;
        l3 >>= 56;
        long l4 = (l3 -= 64L) * 4L;
        long l5 = l2;
        l5 >>= 3;
        if (l4 <= -1022L) {
            l5 >>= 1;
            while (l4 < -1022L) {
                ++l4;
                l5 >>= 1;
            }
        }
        while (l5 != 0L && (l5 & 0x10000000000000L) == 0L && l4 > -1022L) {
            l5 <<= 1;
            --l4;
        }
        if (l4 < -1045L) {
            return 0.0;
        }
        if (l4 > 1024L) {
            if (bl) {
                Trace.trace(1, clsName, "overflow - returning +INFINITY");
                Trace.exit(clsName, "longS90BitsToDouble");
                return Double.POSITIVE_INFINITY;
            }
            Trace.trace(1, clsName, "overflow - returning -INFINITY");
            Trace.exit(clsName, "longS390BitsToDouble");
            return Double.NEGATIVE_INFINITY;
        }
        long l6 = 0L;
        if (!bl) {
            l6 |= Long.MIN_VALUE;
        }
        l4 += 1022L;
        l6 |= (l4 <<= 52);
        Trace.trace(2, clsName, "IEEE bit pattern = " + Long.toString(l6 |= (l5 &= 0xFFFFFFFFFFFFFL), 16));
        Trace.exit(clsName, "longS390BitsToDouble");
        return Double.longBitsToDouble(l6);
    }

    protected static final int floatToS390IntBits(float f) throws IOException {
        int n;
        int n2;
        boolean bl;
        Trace.entry(clsName, "floatToS390IntBits");
        Trace.trace(2, clsName, sccsid);
        int n3 = Float.floatToIntBits(f);
        Trace.trace(2, clsName, "IEEE bit pattern = " + Integer.toString(n3, 16));
        boolean bl2 = bl = (n3 & Integer.MIN_VALUE) == 0;
        if ((n3 & Integer.MAX_VALUE) == 0) {
            Trace.exit(clsName, "floatToS390IntBits (zero number)");
            return n3;
        }
        int n4 = n3 & 0x7F800000;
        n4 >>>= 23;
        int n5 = n3 & 0x7FFFFF;
        if ((n4 -= 126) > -126) {
            n5 |= 0x800000;
        }
        int n6 = Math.abs(n4) % 4;
        int n7 = n2 = Math.abs(n4) / 4;
        if (n4 > 0 && n6 != 0) {
            ++n7;
        }
        if (n4 < 0) {
            n7 = -n7;
        }
        n7 += 64;
        int n8 = n5;
        if (n6 > 0) {
            if (n4 > 0) {
                n = 4 - n6;
                n8 >>>= n;
            } else {
                if (n4 == -126 && (n8 & 0xF00000) == 0) {
                    n8 <<= 4;
                    --n7;
                }
                n = n6;
                n8 >>>= n;
            }
        }
        if (n4 == -126) {
            n8 <<= 1;
            while (n8 != 0 && (n8 & 0xF00000) == 0) {
                n8 <<= 4;
                --n7;
            }
        }
        n = 0;
        int n9 = n7 & 0x7F;
        n = n9 << 24;
        if (!bl) {
            n |= Integer.MIN_VALUE;
        }
        Trace.trace(2, clsName, "S390 Bit pattern = " + Integer.toString(n |= n8, 16));
        Trace.exit(clsName, "floatToS390IntBits");
        return n;
    }

    protected static final float intS390BitsToFloat(int n) throws IOException {
        boolean bl;
        Trace.entry(clsName, "intS390BitsToFloat");
        Trace.trace(2, clsName, sccsid);
        Trace.trace(2, clsName, "S390 Bit pattern = " + Integer.toString(n, 16));
        boolean bl2 = bl = (n & Integer.MIN_VALUE) == 0;
        if ((n & Integer.MAX_VALUE) == 0) {
            Trace.exit(clsName, "intS390BitsToFloat (zero number)");
            if (bl) {
                return 0.0f;
            }
            return -0.0f;
        }
        int n2 = n & 0xFFFFFF;
        int n3 = n & 0x7F000000;
        n3 >>= 24;
        int n4 = (n3 -= 64) * 4;
        int n5 = n2;
        if (n4 <= -126) {
            n5 >>= 1;
            while (n4 < -126) {
                ++n4;
                n5 >>= 1;
            }
        }
        while (n5 != 0 && (n5 & 0x800000) == 0 && n4 > -126) {
            n5 <<= 1;
            --n4;
        }
        if (n4 < -149) {
            Trace.exit(clsName, "intS390BitsToFloat (underflow, returning zero)");
            return 0.0f;
        }
        if (n4 > 128) {
            if (bl) {
                Trace.exit(clsName, "intS390BitsToFloat (overflow, returning +INFINITY)");
                return Float.POSITIVE_INFINITY;
            }
            Trace.exit(clsName, "intS390BitsToFloat (overflow, returning -INFINITY)");
            return Float.NEGATIVE_INFINITY;
        }
        int n6 = 0;
        if (!bl) {
            n6 |= Integer.MIN_VALUE;
        }
        n4 += 126;
        n6 |= (n4 <<= 23);
        Trace.trace(2, clsName, "IEEE Bit pattern = " + Integer.toString(n6 |= (n5 &= 0x7FFFFF), 16));
        Trace.exit(clsName, "intS390BitsToFloat");
        return Float.intBitsToFloat(n6);
    }
}

