/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQQueue
extends MQManagedObject {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQQueue.java, java, j600, j600-201-061220 1.72.1.4 06/09/19 11:48:21";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    protected MQQueueManager mgr = null;
    protected MQSESSION osession = null;
    private GregorianCalendar putCalendar = null;
    protected byte[] baseJavaGetBuffer = null;
    private int DefaultMsgLength = 4096;
    private static final int MQCA_CREATION_DATE = 2004;
    private static final int MQ_CREATION_DATE_LENGTH = 12;
    private static final int MQCA_CREATION_TIME = 2005;
    private static final int MQ_CREATION_TIME_LENGTH = 8;
    private static final int MQIA_CURRENT_Q_DEPTH = 3;
    private static final int MQIA_DEFINITION_TYPE = 7;
    private static final int MQIA_Q_TYPE = 20;
    private static final int MQIA_MAX_Q_DEPTH = 15;
    private static final int MQIA_MAX_MSG_LENGTH = 13;
    private static final int MQIA_OPEN_INPUT_COUNT = 17;
    private static final int MQIA_OPEN_OUTPUT_COUNT = 18;
    private static final int MQIA_SHAREABILITY = 23;
    private static final int MQIA_INHIBIT_PUT = 10;
    private static final int MQIA_INHIBIT_GET = 9;
    private static final int MQIA_TRIGGER_CONTROL = 24;
    private static final int MQCA_TRIGGER_DATA = 2023;
    private static final int MQ_TRIGGER_DATA_LENGTH = 64;
    private static final int MQIA_TRIGGER_DEPTH = 29;
    private static final int MQIA_TRIGGER_MSG_PRIORITY = 26;
    private static final int MQIA_TRIGGER_TYPE = 28;
    private static final int MQIA_NPM_CLASS = 78;
    private static final int MQCA_REMOTE_Q_MGR_NAME = 2017;
    private static final int MQCA_REMOTE_Q_NAME = 2018;
    private static final int MQCA_BASE_Q_NAME = 2002;
    private static final int MQNPM_CLASS_HIGH = 10;
    private static final int MQNPM_CLASS_NORMAL = 0;
    private static final int MQ_Q_NAME_LENGTH = 48;
    private static final byte[] MQMI_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected MQQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueue default constructor");
            Trace.trace(2, this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "MQQueue default constructor");
        }
    }

    public MQQueue(MQQueueManager mQQueueManager, String string, int n, String string2, String string3, String string4) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueue public constructor");
            Trace.trace(2, this, sccsid);
        }
        if (mQQueueManager == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueue constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 1);
        }
        if (!mQQueueManager.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "MQQueue public constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        MQOD mQOD = new MQOD();
        if (string != null && string.length() > 0) {
            mQOD.ObjectName = string;
        }
        if (string2 != null && string2.length() > 0) {
            mQOD.ObjectQMgrName = string2;
        }
        if (string3 != null && string3.length() > 0) {
            mQOD.DynamicQName = string3;
        }
        if (string4 != null && string4.length() > 0) {
            mQOD.AlternateUserId = string4;
        }
        this.Hconn = mQQueueManager.Hconn;
        this.connected = mQQueueManager.connected;
        if (Trace.isOn) {
            Trace.trace(2, this, "queue = " + mQOD.ObjectName + "\nqueue manager = " + mQOD.ObjectQMgrName + "\ndynamic queue name = " + mQOD.DynamicQName + "\nalternate user id = " + mQOD.AlternateUserId + "\noptions = " + n);
        }
        this.osession = mQQueueManager.getSession();
        this.osession.MQOPEN(this.Hconn.x, mQOD, n, this.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            this.resourceOpen = false;
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            mQQueueManager.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "MQQueue public constructor (via exception)");
            }
            throw mQException;
        }
        this.resourceOpen = true;
        this.mgr = mQQueueManager;
        this.name = mQOD.ObjectName;
        this.openOptions = n;
        this.isOpen = true;
        this.openStatus = true;
        this.parentQmgr = mQQueueManager;
        this.connectionReference = mQQueueManager;
        if (string4 != null) {
            this.alternateUserId = string4;
        }
        this.mqca_description = 2013;
        mQQueueManager.registerQueue(this);
        if (Trace.isOn) {
            Trace.exit(this, "MQQueue public constructor");
        }
    }

    public synchronized void get(MQMessage mQMessage, MQGetMessageOptions mQGetMessageOptions, int n) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "get (with max size)");
            Trace.trace(2, this, "Max msg size = " + n);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        if (mQMessage == null) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2026, (Object)this, 27);
        }
        if (n < 0) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2005, this);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "get (via exception)");
            throw new MQException(2, 2186, (Object)this, 28);
        }
        int n3 = mQMessage.encoding;
        int n4 = mQMessage.characterSet;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        if (mQMessage.messageId != null) {
            byArray3 = new byte[mQMessage.messageId.length];
            System.arraycopy(mQMessage.messageId, 0, byArray3, 0, mQMessage.messageId.length);
        } else {
            mQMessage.messageId = MQC.MQMI_NONE;
            if (Trace.isOn) {
                Trace.trace(this, "Saved NullPointerException on message.messageId");
            }
        }
        if (mQMessage.correlationId != null) {
            byArray4 = new byte[mQMessage.correlationId.length];
            System.arraycopy(mQMessage.correlationId, 0, byArray4, 0, mQMessage.correlationId.length);
        } else if (Trace.isOn) {
            Trace.trace(this, "Saved NullPointerException on message.correlationId");
        }
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if ((n2 = mQGetMessageOptions.matchOptions) == 0 || n2 == 1) {
            byArray2 = mQMessage.correlationId;
            mQMessage.correlationId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMessage.messageId;
            mQMessage.messageId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 1;
        }
        MQMessage mQMessage2 = mQMessage;
        Pint pint = new Pint();
        byte[] byArray5 = new byte[n];
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "get (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "get (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 29);
        }
        if (Trace.isOn) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        if (this.completionCode.x != 0 && this.reason.x == 2010) {
            Trace.trace(1, this, "Retrying MQGET with buffer size reduced to " + pint.x);
            byArray5 = new byte[pint.x];
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, byArray5.length, byArray5, pint, this.completionCode, this.reason);
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
            if (pint.x <= 0) {
                Trace.exit(this, "get (empty message)");
            }
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMessage.messageId = byArray;
            }
            if (byArray2 != null) {
                mQMessage.correlationId = byArray2;
            }
        }
        mQMessage.setMessageData(byArray5, Math.min(byArray5.length, pint.x), pint.x);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "get (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "get");
        }
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2 (with max size)");
            Trace.trace(2, this, "Max msg size = " + n);
        }
        this.getMsg2Int(mQMsg2, mQGetMessageOptions, n, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2 (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getMsg2");
        }
    }

    public synchronized int getMsg2NoExc(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n) {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2NoExc (with max size)");
            Trace.trace(2, this, "Max msg size = " + n);
        }
        this.getMsg2Int(mQMsg2, mQGetMessageOptions, n, this.completionCode, this.reason);
        if (Trace.isOn) {
            Trace.trace(2, this, "getMsg2NoExc returning RC=" + this.reason.x);
            Trace.exit(this, "getMsg2NoExc");
        }
        return this.reason.x;
    }

    private void getMsg2Int(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n, Pint pint, Pint pint2) {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2Int (with max size)");
            Trace.trace(2, this, "Max msg size = " + n);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint + ", rc=" + pint2.x + ")");
            }
            return;
        }
        if (n < 0) {
            pint.x = 2;
            pint2.x = 2005;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint + ", rc=" + pint2.x + ")");
            }
            return;
        }
        if (mQGetMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2186;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint + ", rc=" + pint2.x + ")");
            }
            return;
        }
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if ((n2 = mQGetMessageOptions.matchOptions) == 0 || n2 == 1) {
            byArray2 = mQMsg2.getCorrelationId();
            mQMsg2.setCorrelationId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMsg2.getMessageId();
            mQMsg2.setMessageId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 1;
        }
        Pint pint3 = new Pint();
        byte[] byArray3 = new byte[n];
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            pint.x = 2;
            pint2.x = 2018;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint + ", rc=" + pint2.x + ")");
            }
            return;
        }
        if (!this.resourceOpen) {
            pint.x = 2;
            pint2.x = 2019;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint + ", rc=" + pint2.x + ")");
            }
            return;
        }
        if (Trace.isOn) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray3.length, byArray3, pint3, pint, pint2);
        if (pint.x != 0 && this.reason.x == 2010) {
            Trace.trace(1, this, "Retrying MQGET with buffer size reduced to " + pint3.x);
            byArray3 = new byte[pint3.x];
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray3.length, byArray3, pint3, pint, pint2);
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Message is " + pint3.x + " bytes long.");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (pint.x == 2) {
            if (byArray != null) {
                mQMsg2.setMessageId(byArray);
            }
            if (byArray2 != null) {
                mQMsg2.setCorrelationId(byArray2);
            }
        }
        mQMsg2.setMessageData(byArray3, Math.min(byArray3.length, pint3.x));
        if (Trace.isOn) {
            Trace.trace(2, this, "getMsg2Int completed with cc=" + pint.x + ", rc=" + pint2.x + ")");
            Trace.exit(this, "getMsg2Int");
        }
    }

    public synchronized void get(MQMessage mQMessage, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        int n = 4096;
        if (Trace.isOn) {
            Trace.entry(this, "get (no size specified)");
        }
        if (mQMessage == null) {
            Trace.exit(this, "get");
            throw new MQException(2, 2026, (Object)this, 27);
        }
        if (mQGetMessageOptions == null) {
            Trace.exit(this, "get");
            throw new MQException(2, 2186, (Object)this, 28);
        }
        MQMessage mQMessage2 = mQMessage;
        Pint pint = new Pint();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        n2 = mQGetMessageOptions.matchOptions;
        if (n2 == 0 || n2 == 1) {
            byArray2 = mQMessage.correlationId;
            mQMessage.correlationId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMessage.messageId;
            mQMessage.messageId = MQMI_NONE;
            mQGetMessageOptions.matchOptions |= 1;
        }
        int n3 = mQMessage.encoding;
        int n4 = mQMessage.characterSet;
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        if (mQMessage.messageId != null) {
            byArray3 = new byte[mQMessage.messageId.length];
            System.arraycopy(mQMessage.messageId, 0, byArray3, 0, mQMessage.messageId.length);
        } else {
            mQMessage.messageId = MQC.MQMI_NONE;
            if (Trace.isOn) {
                Trace.trace(this, "Saved NullPointerException on message.messageId");
            }
        }
        if (mQMessage.correlationId != null) {
            byArray4 = new byte[mQMessage.correlationId.length];
            System.arraycopy(mQMessage.correlationId, 0, byArray4, 0, mQMessage.correlationId.length);
        } else if (Trace.isOn) {
            Trace.trace(this, "Saved NullPointerException on message.correlationId");
        }
        if (mQMessage.getBufferSizeHint() != -1) {
            n = mQMessage.getBufferSizeHint();
            this.baseJavaGetBuffer = new byte[n];
        } else if (this.baseJavaGetBuffer == null) {
            this.baseJavaGetBuffer = new byte[4096];
        }
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "get");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "get");
            }
            throw new MQException(2, 2019, (Object)this, 29);
        }
        if (Trace.isOn) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, this.baseJavaGetBuffer.length, this.baseJavaGetBuffer, pint, this.completionCode, this.reason);
        if (this.completionCode.x != 0 && this.reason.x == 2010) {
            Trace.trace(1, this, "Retrying MQGET with buffer size reduced to " + pint.x);
            n = pint.x;
            this.baseJavaGetBuffer = new byte[n];
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, this.baseJavaGetBuffer.length, this.baseJavaGetBuffer, pint, this.completionCode, this.reason);
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Message is " + pint.x + " bytes long.");
        }
        while (this.completionCode.x != 0 && this.reason.x == 2080) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Retrying MQGET with increased buffer size.");
            }
            n = pint.x;
            this.baseJavaGetBuffer = new byte[n];
            mQMessage2.encoding = n3;
            mQMessage2.characterSet = n4;
            mQMessage2.messageId = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, mQMessage2.messageId, 0, byArray3.length);
            mQMessage2.correlationId = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, mQMessage2.correlationId, 0, byArray4.length);
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMessage2, mQGetMessageOptions, this.baseJavaGetBuffer.length, this.baseJavaGetBuffer, pint, this.completionCode, this.reason);
        }
        if (pint.x <= 0 && Trace.isOn) {
            Trace.exit(this, "get (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (this.completionCode.x == 2) {
            if (byArray != null) {
                mQMessage.messageId = byArray;
            }
            if (byArray2 != null) {
                mQMessage.correlationId = byArray2;
            }
        }
        mQMessage.setMessageData(this.baseJavaGetBuffer, Math.min(this.baseJavaGetBuffer.length, pint.x), pint.x);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "get (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "get");
        }
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2 (no size specified)");
        }
        this.getMsg2Int(mQMsg2, mQGetMessageOptions, this.completionCode, this.reason, 0);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2 (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getMsg2");
        }
    }

    public synchronized int getMsg2NoExc(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2NoExc (no size specified)");
        }
        this.getMsg2Int(mQMsg2, mQGetMessageOptions, this.completionCode, this.reason, 0);
        if (Trace.isOn) {
            Trace.trace(2, this, "getMsg2NoExc returning RC=" + this.reason.x);
            Trace.exit(this, "getMsg2NoExc");
        }
        return this.reason.x;
    }

    private synchronized void getMsg2Int(MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, Pint pint, Pint pint2, int n) {
        if (Trace.isOn) {
            Trace.entry(this, "getMsg2Int (no size specified)");
        }
        if (n > 0) {
            this.DefaultMsgLength = n;
        }
        if (mQMsg2 == null) {
            pint.x = 2;
            pint2.x = 2026;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint.x + ", rc=" + pint2.x);
            }
            return;
        }
        if (mQGetMessageOptions == null) {
            pint.x = 2;
            pint2.x = 2186;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint.x + ", rc=" + pint2.x);
            }
            return;
        }
        Pint pint3 = new Pint();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n2 = 0;
        n2 = mQGetMessageOptions.matchOptions;
        if (n2 == 0 || n2 == 1) {
            byArray2 = mQMsg2.getCorrelationId();
            mQMsg2.setCorrelationId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 2;
        }
        if (n2 == 0 || n2 == 2) {
            byArray = mQMsg2.getMessageId();
            mQMsg2.setMessageId(MQMI_NONE);
            mQGetMessageOptions.matchOptions |= 1;
        }
        int n3 = mQMsg2.getEncoding();
        int n4 = mQMsg2.getCharacterSet();
        byte[] byArray3 = mQMsg2.getMessageId();
        byte[] byArray4 = mQMsg2.getCorrelationId();
        byte[] byArray5 = new byte[this.DefaultMsgLength];
        if ((mQGetMessageOptions.options & 0x1006) == 0) {
            mQGetMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            pint.x = 2;
            pint2.x = 2018;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint.x + ", rc=" + pint2.x);
            }
            return;
        }
        if (!this.resourceOpen) {
            pint.x = 2;
            pint2.x = 2019;
            if (Trace.isOn) {
                Trace.exit(this, "getMsg2Int (cc=" + pint.x + ", rc=" + pint2.x);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.trace(3, this, "get options = " + mQGetMessageOptions.options + "\nwait interval = " + mQGetMessageOptions.waitInterval + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray5.length, byArray5, pint3, pint, pint2);
        if (pint.x != 0 && this.reason.x == 2010) {
            Trace.trace(1, this, "Retrying MQGET with buffer size reduced to " + pint3.x);
            this.DefaultMsgLength = pint3.x;
            byArray5 = new byte[this.DefaultMsgLength];
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray5.length, byArray5, pint3, pint, pint2);
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Message is " + pint3.x + " bytes long.");
        }
        while (pint.x != 0 && pint2.x == 2080) {
            Trace.trace(1, this, "Retrying MQGET with increased buffer size.");
            this.DefaultMsgLength = pint3.x;
            byArray5 = new byte[this.DefaultMsgLength];
            mQMsg2.setEncoding(n3);
            mQMsg2.setCharacterSet(n4);
            mQMsg2.setMessageId(byArray3);
            mQMsg2.setCorrelationId(byArray4);
            this.osession.MQGET(this.Hconn.x, this.Hobj.x, mQMsg2, mQGetMessageOptions, byArray5.length, byArray5, pint3, pint, pint2);
        }
        if (pint3.x <= 0 && Trace.isOn) {
            Trace.trace(2, this, "getMsg2Int (empty message)");
        }
        if (byArray != null || byArray2 != null) {
            mQGetMessageOptions.matchOptions = n2;
        }
        if (pint.x == 2) {
            if (byArray != null) {
                mQMsg2.setMessageId(byArray);
            }
            if (byArray2 != null) {
                mQMsg2.setCorrelationId(byArray2);
            }
        }
        mQMsg2.setMessageData(byArray5, Math.min(byArray5.length, pint3.x));
        if (Trace.isOn) {
            Trace.trace(2, this, "getMsg2Int completed with cc=" + pint.x + ", rc=" + pint2.x + ")");
            Trace.exit(this, "getMsg2Int");
        }
    }

    public synchronized void get(MQMessage mQMessage) throws MQException {
        this.get(mQMessage, new MQGetMessageOptions(true));
    }

    public synchronized void getMsg2(MQMsg2 mQMsg2) throws MQException {
        this.getMsg2(mQMsg2, new MQGetMessageOptions(true));
    }

    public synchronized void put(MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "put");
        }
        MQMessage mQMessage2 = mQMessage;
        if (mQMessage == null) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2026, (Object)this, 30);
        }
        if (mQPutMessageOptions == null) {
            Trace.exit(this, "put (via exception)");
            throw new MQException(2, 2173, (Object)this, 31);
        }
        mQPutMessageOptions.invalidDestCount = 1;
        mQPutMessageOptions.knownDestCount = 0;
        mQPutMessageOptions.unknownDestCount = 0;
        if ((mQPutMessageOptions.options & 6) == 0) {
            mQPutMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 29);
        }
        if ((mQPutMessageOptions.options & 0x300) != 0) {
            if (mQPutMessageOptions.contextReference != null) {
                mQPutMessageOptions.contextReferenceHandle = mQPutMessageOptions.contextReference.getHandle();
                if (mQPutMessageOptions.contextReferenceHandle == -1) {
                    if (Trace.isOn) {
                        Trace.exit(this, "put (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (this.mgr != mQPutMessageOptions.contextReference.mgr) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Connection references do not match");
                        Trace.exit(this, "put (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (Trace.isOn) {
                    Trace.trace(2, this, "Obtained context reference handle:" + mQPutMessageOptions.contextReferenceHandle);
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Context reference queue is null");
                    Trace.exit(this, "put (via exception)");
                }
                throw new MQException(2, 2097, this);
            }
        }
        if ((mQPutMessageOptions.options & 0x800) != 0) {
            if (mQMessage2.putDateTime == null) {
                mQMessage2.putDate = MQMD.getDate(null);
                mQMessage2.putTime = MQMD.getTime(null);
            } else {
                if (this.putCalendar == null) {
                    object = TimeZone.getTimeZone("GMT");
                    this.putCalendar = new GregorianCalendar((TimeZone)object);
                }
                this.putCalendar.setTime(mQMessage2.putDateTime.getTime());
                mQMessage2.putDate = MQMD.getDate(this.putCalendar);
                mQMessage2.putTime = MQMD.getTime(this.putCalendar);
            }
        }
        object = mQMessage.toByteArray();
        if (Trace.isOn) {
            Trace.trace(2, this, "Message length = " + ((byte[])object).length + " bytes.");
            Trace.trace(3, this, "put options = " + mQPutMessageOptions.options + "\nmessage type = " + mQMessage.messageType + "\nencoding = " + mQMessage.encoding + "\ncharacter set = " + mQMessage.characterSet + "\nformat = " + mQMessage.format + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
        }
        this.osession.MQPUT(this.Hconn.x, this.Hobj.x, mQMessage2, mQPutMessageOptions, ((byte[])object).length, (byte[])object, this.completionCode, this.reason);
        if (Trace.isOn) {
            Trace.trace(3, this, "Returned message id follows:");
            Trace.dataTrace(3, this, mQMessage.messageId);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "put");
        }
    }

    public synchronized void put(MQMessage mQMessage) throws MQException {
        this.put(mQMessage, new MQPutMessageOptions());
    }

    public synchronized void putMsg2(MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "putMsg2");
        }
        if (mQMsg2 == null) {
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2 (via exception)");
            }
            throw new MQException(2, 2026, (Object)this, 30);
        }
        if (mQPutMessageOptions == null) {
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2 (via exception)");
            }
            throw new MQException(2, 2173, (Object)this, 31);
        }
        mQPutMessageOptions.invalidDestCount = 1;
        mQPutMessageOptions.knownDestCount = 0;
        mQPutMessageOptions.unknownDestCount = 0;
        if ((mQPutMessageOptions.options & 6) == 0) {
            mQPutMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2 (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2 (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 29);
        }
        if ((mQPutMessageOptions.options & 0x300) != 0) {
            if (mQPutMessageOptions.contextReference != null) {
                mQPutMessageOptions.contextReferenceHandle = mQPutMessageOptions.contextReference.getHandle();
                if (mQPutMessageOptions.contextReferenceHandle == -1) {
                    if (Trace.isOn) {
                        Trace.exit(this, "putMsg2 (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (this.mgr != mQPutMessageOptions.contextReference.mgr) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Connection references do not match");
                        Trace.exit(this, "putMsg2 (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (Trace.isOn) {
                    Trace.trace(2, this, "Obtained context reference handle:" + mQPutMessageOptions.contextReferenceHandle);
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Context reference queue is null");
                    Trace.exit(this, "putMsg2 (via exception)");
                }
                throw new MQException(2, 2097, this);
            }
        }
        byte[] byArray = mQMsg2.getInternalBuffer();
        int n = mQMsg2.getMessageDataLength();
        if (Trace.isOn) {
            Trace.trace(2, this, "Message length = " + n + " bytes.");
            Trace.trace(3, this, "put options = " + mQPutMessageOptions.options + "\nmessage type = " + mQMsg2.getMessageType() + "\nencoding = " + mQMsg2.getEncoding() + "\ncharacter set = " + mQMsg2.getCharacterSet() + "\nformat = " + mQMsg2.getFormat() + "\nmessage id, correlation id follow:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
            Trace.dataTrace(3, this, mQMsg2.getCorrelationId());
        }
        this.osession.MQPUT(this.Hconn.x, this.Hobj.x, mQMsg2, mQPutMessageOptions, n, byArray, this.completionCode, this.reason);
        if (Trace.isOn) {
            Trace.trace(3, this, "Returned message id follows:");
            Trace.dataTrace(3, this, mQMsg2.getMessageId());
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "putMsg2 (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "putMsg2");
        }
    }

    public synchronized void putMsg2(MQMsg2 mQMsg2) throws MQException {
        this.putMsg2(mQMsg2, new MQPutMessageOptions());
    }

    public synchronized void close() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterQueue(this);
        }
        this.mgr = null;
        this.connectionReference = null;
        this.baseJavaGetBuffer = null;
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    public GregorianCalendar getCreationDateTime() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "getCreationDateTime");
        }
        String string = this.getString(2004, 12);
        String string2 = this.getString(2005, 8);
        if (Trace.isOn) {
            Trace.trace(2, this, "date = " + string + " time = " + string2);
        }
        GregorianCalendar gregorianCalendar = MQSESSION.getInquireCalendar();
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(5, 7));
            int n3 = Integer.parseInt(string.substring(8, 10));
            int n4 = Integer.parseInt(string2.substring(0, 2));
            int n5 = Integer.parseInt(string2.substring(3, 5));
            int n6 = Integer.parseInt(string2.substring(6, 8));
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "String index error" + stringIndexOutOfBoundsException);
            }
            gregorianCalendar = new GregorianCalendar();
        }
        catch (NumberFormatException numberFormatException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Number format error" + numberFormatException);
            }
            gregorianCalendar = new GregorianCalendar();
        }
        if (Trace.isOn) {
            Trace.exit(this, "getCreationDateTime");
        }
        return gregorianCalendar;
    }

    public int getQueueType() throws MQException {
        return this.getInt(20);
    }

    public int getCurrentDepth() throws MQException {
        return this.getInt(3);
    }

    public int getDefinitionType() throws MQException {
        return this.getInt(7);
    }

    public int getMaximumDepth() throws MQException {
        return this.getInt(15);
    }

    public int getMaximumMessageLength() throws MQException {
        return this.getInt(13);
    }

    public int getOpenInputCount() throws MQException {
        return this.getInt(17);
    }

    public int getOpenOutputCount() throws MQException {
        return this.getInt(18);
    }

    public int getShareability() throws MQException {
        return this.getInt(23);
    }

    public int getInhibitPut() throws MQException {
        return this.getInt(10);
    }

    public void setInhibitPut(int n) throws MQException {
        this.setInt(10, n);
    }

    public int getInhibitGet() throws MQException {
        return this.getInt(9);
    }

    public void setInhibitGet(int n) throws MQException {
        this.setInt(9, n);
    }

    public int getTriggerControl() throws MQException {
        return this.getInt(24);
    }

    public void setTriggerControl(int n) throws MQException {
        this.setInt(24, n);
    }

    public String getTriggerData() throws MQException {
        return this.getString(2023, 64);
    }

    public void setTriggerData(String string) throws MQException {
        this.setString(2023, string, 64);
    }

    public int getTriggerDepth() throws MQException {
        return this.getInt(29);
    }

    public void setTriggerDepth(int n) throws MQException {
        this.setInt(29, n);
    }

    public int getTriggerMessagePriority() throws MQException {
        return this.getInt(26);
    }

    public void setTriggerMessagePriority(int n) throws MQException {
        this.setInt(26, n);
    }

    public int getTriggerType() throws MQException {
        return this.getInt(28);
    }

    public void setTriggerType(int n) throws MQException {
        this.setInt(28, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNPMClassHigh() {
        block46: {
            var1_1 = null;
            var2_2 = false;
            try {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "isNPMClassHigh");
                    }
                    try {
                        if (this.isOpen() && (this.openOptions & 32) == 32) {
                            if (Trace.isOn) {
                                Trace.trace(2, this, "Not reopening queue as already opened for inquire");
                            }
                            var2_2 = false;
                            var1_1 = this;
                        } else {
                            var1_1 = this.mgr.accessQueue(this.name, 32);
                            var2_2 = true;
                        }
                    }
                    catch (Exception var3_3) {
                        var1_1 = null;
                    }
                    v0 = var3_4 = var1_1 != null && var1_1.getInt(78) == 10;
                    if (Trace.isOn) {
                        Trace.trace(2, this, "isNPMClassHigh=" + var3_4);
                    }
                    var4_6 = var3_4;
                    var14_9 = null;
                }
                catch (MQException var3_5) {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    try {
                                        var4_7 = var1_1.getInt(20);
                                        if (var4_7 == 1 || var4_7 == 2) {
                                            if (Trace.isOn) {
                                                Trace.trace(2, this, "NPMCLASS(HIGH) unsupported, qType=" + var4_7);
                                            }
                                            var5_23 = false;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (MQException var4_8) {
                                        if (Trace.isOn) {
                                            Trace.trace(1, this, "inquire failed with: " + var4_8);
                                        }
                                        var5_27 = false;
                                        var14_14 = null;
                                        try {
                                            if (var1_1 != null && var2_2) {
                                                var1_1.close();
                                            }
                                        }
                                        catch (MQException var15_21) {
                                            // empty catch block
                                        }
                                        if (Trace.isOn == false) return var5_27;
                                        Trace.exit(this, "isNPMClassHigh");
                                        return var5_27;
                                    }
                                    var14_10 = null;
                                    ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl54:
                                    // 1 sources

                                    if (var1_1 != null && var2_2) {
                                        var1_1.close();
                                    }
                                    break block41;
lbl57:
                                    // 1 sources

                                    catch (MQException var15_17) {
                                        // empty catch block
                                    }
                                }
                                if (Trace.isOn == false) return var5_23;
                                Trace.exit(this, "isNPMClassHigh");
                                return var5_23;
lbl-1000:
                                // 1 sources

                                {
                                    if (var4_7 != 3) ** GOTO lbl-1000
                                    var5_24 = new int[1];
                                    var6_28 = new byte[48];
                                    var5_24[0] = 2002;
                                    var1_1.inquire(var5_24, null, var6_28);
                                    var7_30 = new String(var6_28);
                                    if (Trace.isOn) {
                                        Trace.trace(2, this, "alias, resolves to =" + var7_30);
                                    }
                                    var8_32 = this.mgr.accessQueue(var7_30, 32);
                                    var9_34 = var8_32.isNPMClassHigh();
                                    var8_32.close();
                                    var10_36 = var9_34;
                                }
                                var14_11 = null;
                                ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl78:
                                // 1 sources

                                if (var1_1 != null && var2_2) {
                                    var1_1.close();
                                }
                                break block42;
lbl81:
                                // 1 sources

                                catch (MQException var15_18) {
                                    // empty catch block
                                }
                            }
                            if (Trace.isOn == false) return var10_36;
                            Trace.exit(this, "isNPMClassHigh");
                            return var10_36;
lbl-1000:
                            // 1 sources

                            {
                                if (var4_7 != 6) ** GOTO lbl-1000
                                var5_25 = new int[2];
                                var6_29 = new byte[96];
                                var5_25[0] = 2017;
                                var5_25[1] = 2018;
                                var1_1.inquire(var5_25, null, var6_29);
                                var7_31 = new String(var6_29);
                                var8_33 = var7_31.substring(0, 47);
                                var9_35 = var7_31.substring(48);
                                if (Trace.isOn) {
                                    Trace.trace(2, this, "remote queue, resolves to=" + var8_33 + "/" + var9_35);
                                }
                                var10_37 = this.mgr.accessQueue(var7_31, 32);
                                var11_38 = var10_37.isNPMClassHigh();
                                var10_37.close();
                                var12_39 = var11_38;
                            }
                            var14_12 = null;
                            ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl105:
                            // 1 sources

                            if (var1_1 != null && var2_2) {
                                var1_1.close();
                            }
                            break block43;
lbl108:
                            // 1 sources

                            catch (MQException var15_19) {
                                // empty catch block
                            }
                        }
                        if (Trace.isOn == false) return var12_39;
                        Trace.exit(this, "isNPMClassHigh");
                        return var12_39;
lbl-1000:
                        // 1 sources

                        {
                            if (Trace.isOn) {
                                Trace.trace(1, this, "unexpected qType=" + var4_7);
                            }
                            var5_26 = false;
                        }
                        var14_13 = null;
                        ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl120:
                        // 1 sources

                        if (var1_1 != null && var2_2) {
                            var1_1.close();
                        }
                        break block44;
lbl123:
                        // 1 sources

                        catch (MQException var15_20) {
                            // empty catch block
                        }
                    }
                    if (Trace.isOn == false) return var5_26;
                    Trace.exit(this, "isNPMClassHigh");
                    return var5_26;
                }
            }
            catch (Throwable var13_40) {
                block45: {
                    var14_15 = null;
                    ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl133:
                    // 1 sources

                    if (var1_1 != null && var2_2) {
                        var1_1.close();
                    }
                    break block45;
lbl136:
                    // 1 sources

                    catch (MQException var15_22) {
                        // empty catch block
                    }
                }
                if (Trace.isOn == false) throw var13_40;
                Trace.exit(this, "isNPMClassHigh");
                throw var13_40;
            }
            ** try [egrp 7[TRYBLOCK] [13 : 547->562)] { 
lbl144:
            // 1 sources

            if (var1_1 != null && var2_2) {
                var1_1.close();
            }
            break block46;
lbl147:
            // 1 sources

            catch (MQException var15_16) {
                // empty catch block
            }
        }
        if (Trace.isOn == false) return var4_6;
        Trace.exit(this, "isNPMClassHigh");
        return var4_6;
    }

    final int getHandle() {
        if (!this.resourceOpen) {
            return -1;
        }
        return this.Hobj.x;
    }

    public final int _getConnectionCCSID() {
        if (this.osession == null) {
            this.osession = this.mgr.getSession();
        }
        return this.osession.getConnectionCCSID();
    }
}

