/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MQGetMessageOptions {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQGetMessageOptions.java, java, j600, j600-201-061220 1.31.1.1 05/05/25 15:36:58";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] gmo_bytes = new byte[100];
    private boolean noReadBack = false;
    public int options = 0;
    public int waitInterval = 0;
    public String resolvedQueueName = "";
    public byte[] msgToken = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public int returnedLength = -1;
    public int matchOptions = 3;
    public char groupStatus = (char)32;
    public char segmentStatus = (char)32;
    public char segmentation = (char)32;
    protected static final int sizeofMQGetMessageOptionsv1 = 72;
    protected static final int sizeofMQGetMessageOptionsv2 = 80;
    protected static final int sizeofMQGetMessageOptionsv3 = 100;
    private int version = 3;

    public MQGetMessageOptions() {
        Trace.entry(this, "MQGetMessageOptions constructor");
        Trace.trace(2, this, sccsid);
        this.gmo_bytes[0] = 71;
        this.gmo_bytes[1] = 77;
        this.gmo_bytes[2] = 79;
        this.gmo_bytes[3] = 32;
        this.gmo_bytes[7] = 3;
        Trace.exit(this, "MQGetMessageOptions constructor");
    }

    public MQGetMessageOptions(boolean bl) {
        this();
        if (bl) {
            Trace.trace(2, this, "Setting MQGMO noReadBack option");
            this.noReadBack = true;
        }
    }

    protected final int sizeOfMQGetMessageOptions() {
        if (this.version == 1) {
            return 72;
        }
        if (this.version == 2) {
            return 80;
        }
        return 100;
    }

    protected final int getVersion() {
        return this.version;
    }

    protected final void setVersion(int n) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "setVersion");
            Trace.trace(2, this, "version = " + n);
        }
        if (n > 3 || n < 1) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion (via exception)");
            }
            throw new MQInternalException(2, 2186, 82, "" + n);
        }
        if (n < 3 && this.msgToken != null && !new String(this.msgToken).trim().equals("")) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion (via exception)");
            }
            throw new MQInternalException(2, 2186, 97);
        }
        if (n == 1 && (this.matchOptions != 3 || this.groupStatus != ' ' || this.segmentStatus != ' ' || this.segmentation != ' ')) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion (via exception)");
            }
            throw new MQInternalException(2, 2186, 97);
        }
        this.version = n;
        this.gmo_bytes[7] = (byte)n;
        if (Trace.isOn) {
            Trace.exit(this, "setVersion");
        }
    }

    protected final byte[] getV2V3Bytes() {
        this.gmo_bytes[8] = (byte)(this.options >>> 24 & 0xFF);
        this.gmo_bytes[9] = (byte)(this.options >>> 16 & 0xFF);
        this.gmo_bytes[10] = (byte)(this.options >>> 8 & 0xFF);
        this.gmo_bytes[11] = (byte)(this.options >>> 0 & 0xFF);
        this.gmo_bytes[12] = (byte)(this.waitInterval >>> 24 & 0xFF);
        this.gmo_bytes[13] = (byte)(this.waitInterval >>> 16 & 0xFF);
        this.gmo_bytes[14] = (byte)(this.waitInterval >>> 8 & 0xFF);
        this.gmo_bytes[15] = (byte)(this.waitInterval >>> 0 & 0xFF);
        if (this.version > 1) {
            this.gmo_bytes[72] = (byte)(this.matchOptions >>> 24 & 0xFF);
            this.gmo_bytes[73] = (byte)(this.matchOptions >>> 16 & 0xFF);
            this.gmo_bytes[74] = (byte)(this.matchOptions >>> 8 & 0xFF);
            this.gmo_bytes[75] = (byte)(this.matchOptions >>> 0 & 0xFF);
            this.gmo_bytes[76] = (byte)(this.groupStatus >>> 0 & 0xFF);
            this.gmo_bytes[77] = (byte)(this.segmentStatus >>> 0 & 0xFF);
            this.gmo_bytes[78] = (byte)(this.segmentation >>> 0 & 0xFF);
        }
        if (this.version > 2) {
            if (this.msgToken == null) {
                this.msgToken = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            }
            if (this.msgToken.length != 16) {
                byte[] byArray = new byte[16];
                for (int i = 0; i < (this.msgToken.length < 16 ? this.msgToken.length : 16); ++i) {
                    byArray[i] = this.msgToken[i];
                }
                this.msgToken = byArray;
            }
            for (int i = 0; i < this.msgToken.length; ++i) {
                this.gmo_bytes[80 + i] = this.msgToken[i];
            }
        }
        return this.gmo_bytes;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeTo");
        }
        if (this.version > 1) {
            if (this.version > 2) {
                dataOutputStream.write(this.getV2V3Bytes(), 0, 100);
            } else {
                if (this.msgToken != null && !new String(this.msgToken).trim().equals("")) {
                    if (Trace.isOn) {
                        Trace.exit(this, "writeTo (via exception)");
                    }
                    throw new MQInternalException(2, 2186, 97);
                }
                dataOutputStream.write(this.getV2V3Bytes(), 0, 80);
            }
        } else {
            if (this.matchOptions != 3 || this.groupStatus != ' ' || this.segmentStatus != ' ' || this.segmentation != ' ' || this.msgToken != null && !new String(this.msgToken).trim().equals("")) {
                if (Trace.isOn) {
                    Trace.exit(this, "writeTo (via exception)");
                }
                throw new MQInternalException(2, 2186, 97);
            }
            dataOutputStream.write(this.getV2V3Bytes(), 0, 72);
        }
        if (Trace.isOn) {
            Trace.exit(this, "writeTo");
        }
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "readFrom");
        }
        if (dataInputStream.available() < 72) {
            if (Trace.isOn) {
                Trace.exit(this, "readFrom (via exception)");
            }
            throw new MQInternalException(2, 2195, 14);
        }
        if (this.noReadBack) {
            if (this.version == 1) {
                dataInputStream.skipBytes(72);
            } else if (this.version == 2) {
                dataInputStream.skipBytes(80);
            } else {
                dataInputStream.skipBytes(100);
            }
            if (Trace.isOn) {
                Trace.exit(this, "readFrom - optimised return");
            }
            return dataInputStream;
        }
        dataInputStream.skipBytes(8);
        this.options = dataInputStream.readInt();
        this.waitInterval = dataInputStream.readInt();
        dataInputStream.skipBytes(8);
        byte[] byArray = new byte[48];
        dataInputStream.read(byArray, 0, 48);
        this.resolvedQueueName = MQEnvironment.stringFromBytes(byArray);
        if (this.version > 1) {
            this.matchOptions = dataInputStream.readInt();
            this.groupStatus = (char)dataInputStream.readByte();
            this.segmentStatus = (char)dataInputStream.readByte();
            this.segmentation = (char)dataInputStream.readByte();
            dataInputStream.skipBytes(1);
        } else {
            this.matchOptions = 3;
            this.groupStatus = (char)32;
            this.segmentStatus = (char)32;
            this.segmentation = (char)32;
        }
        if (this.version > 2) {
            dataInputStream.read(this.msgToken, 0, 16);
            this.returnedLength = dataInputStream.readInt();
        } else {
            this.msgToken = MQC.MQMTOK_NONE;
            this.returnedLength = -1;
            this.matchOptions &= 0xFFFFFFDF;
        }
        if (Trace.isOn) {
            Trace.exit(this, "readFrom");
        }
        return dataInputStream;
    }
}

