/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQResponseRecord;
import com.ibm.mqservices.Trace;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class MQCompressor {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQCompressor.java, jms, j600, j600-201-061220 1.17.1.1 05/05/25 15:58:31";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static int COMPLEVEL = 0;
    public static byte ESCAPECHAR = (byte)-85;
    private byte[] previousMdGmo = new byte[100];
    private byte[] previousMdPmo = new byte[152];
    private byte[] previousPutMQMD = new byte[364];
    private byte[] previousGetMQMD = new byte[364];
    private int compLevel = 0;
    private Deflater compressor = null;
    private Inflater decompressor = null;

    public MQCompressor(int n) {
        this.compLevel = n;
        if (this.compLevel != 0) {
            this.compressor = new Deflater(this.compLevel);
            this.decompressor = new Inflater();
        }
    }

    public byte[] compressMsgSegment(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (Trace.isOn) {
            Trace.entry(this, "compressMsgSegment");
            Trace.trace(4, this, "Segment to compress: ");
            Trace.dataTrace(4, this, byArray);
            Trace.trace(2, this, "Current Header Compression: " + n);
            Trace.trace(2, this, "Current Message Compression: " + n2);
        }
        byte[] byArray2 = new byte[(int)(1.001 * (double)byArray.length) + 1 + 12];
        int n5 = 28;
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        int n6 = n5;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = byArray[9];
        if (n10 < 0) {
            n10 += 256;
        }
        if ((n4 = byArray[10]) < 0) {
            n4 += 256;
        }
        if ((n4 & 0x10) != 0) {
            int n11;
            if (Trace.isOn) {
                Trace.trace(1, this, "In the first message segment");
            }
            n6 = n5 += 16;
            System.arraycopy(byArray, 28, byArray2, 28, 16);
            if (n != 0 || n2 != 0) {
                byArray2[n5] = 0;
                byArray2[n5 + 1] = 0;
                byArray2[n5 + 2] = 0;
                byArray2[n5 + 3] = (byte)n2;
                n6 += 4;
            }
            n3 = n5;
            switch (n10) {
                case 129: 
                case 131: {
                    n5 = byArray.length;
                    break;
                }
                case 135: {
                    int n12;
                    int n13 = this.getIntFromArray(byArray, n3 += 4);
                    if (n13 == 1) {
                        n9 = 168;
                        n3 += 164;
                    } else {
                        n9 = 200;
                        n12 = this.getIntFromArray(byArray, n3 + 168 - 4);
                        n11 = this.getIntFromArray(byArray, n3 + 168 + 16);
                        n5 += n11 - 200 + n12 * MQResponseRecord.sizeOfMQResponseRecord;
                        n3 += n11 - 200 + n12 * MQResponseRecord.sizeOfMQResponseRecord - 4;
                    }
                    n5 += n9;
                }
                case 134: {
                    int n12;
                    int n13;
                    if (byArray.length - (n3 += 4) >= 4) {
                        int n14;
                        n13 = this.getIntFromArray(byArray, n3);
                        n3 += 4;
                        if (n13 == 1) {
                            n7 = 324;
                            n5 += n7;
                            if (byArray.length - (n3 += n7 - 4) >= 4) {
                                n12 = this.getIntFromArray(byArray, n3);
                                if (n12 == 1) {
                                    n8 = 128;
                                    n3 += 124;
                                } else {
                                    n8 = 152;
                                    if (byArray.length - (n3 += 124) >= 4) {
                                        n11 = this.getIntFromArray(byArray, n3);
                                        if (byArray.length - (n3 += 12) >= 4) {
                                            n14 = this.getIntFromArray(byArray, n3);
                                            n5 += n14 - 152 + n11 * MQResponseRecord.sizeOfMQResponseRecord;
                                        } else {
                                            n5 = byArray.length + 1;
                                        }
                                    }
                                }
                                n5 += n8;
                                break;
                            }
                            n5 = byArray.length + 1;
                            break;
                        }
                        if (n13 != 2) break;
                        n7 = 364;
                        n5 += n7;
                        if (byArray.length - (n3 += n7 - 4) < 4) break;
                        n12 = this.getIntFromArray(byArray, n3);
                        if (n12 == 1) {
                            n8 = 128;
                        } else {
                            n8 = 152;
                            if (byArray.length - (n3 += 124) >= 4) {
                                n11 = this.getIntFromArray(byArray, n3);
                                if (byArray.length - (n3 += 12) >= 4) {
                                    n14 = this.getIntFromArray(byArray, n3);
                                    n5 += n14 - 152 + n11 * MQResponseRecord.sizeOfMQResponseRecord;
                                } else {
                                    n5 = byArray.length + 1;
                                }
                            }
                        }
                        n5 += n8;
                        break;
                    }
                    n5 = byArray.length + 1;
                    break;
                }
                case 133: {
                    int n12;
                    int n13 = this.getIntFromArray(byArray, n3 += 4);
                    n3 += 4;
                    if (n13 == 1) {
                        n7 = 324;
                        n5 += n7;
                        n12 = this.getIntFromArray(byArray, n3 += n7 - 4);
                        n3 += 4;
                        n8 = n12 == 1 ? 72 : (n12 == 2 ? 80 : 100);
                        n5 += n8;
                        break;
                    }
                    if (n13 != 2) break;
                    n7 = 364;
                    n5 += n7;
                    n12 = this.getIntFromArray(byArray, n3 += n7 - 4);
                    n3 += 4;
                    n8 = n12 == 1 ? 72 : (n12 == 2 ? 80 : 100);
                    n5 += n8;
                }
            }
            if ((n10 == 133 || n10 == 134 || n10 == 135) && byArray.length - n5 >= 4) {
                n5 += 4;
            }
            if (Trace.isOn) {
                Trace.trace(2, this, "Header length is: " + n5);
            }
            byte[] byArray3 = new byte[n7];
            byte[] byArray4 = new byte[n8];
            if (n == 8) {
                if (n10 == 133 || n10 == 134 || n10 == 135) {
                    System.arraycopy(byArray, 44 + n9, byArray3, 0, n7);
                    System.arraycopy(byArray, 44 + n9 + n7, byArray4, 0, n8);
                    if (byArray.length >= n5) {
                        if (n10 == 133) {
                            this.xorMsgSegment(this.previousGetMQMD, byArray, 44 + n9 + 8, n7 - 8);
                            this.xorMsgSegment(this.previousMdGmo, byArray, 44 + n9 + n7 + 8, n8 - 8);
                        } else {
                            this.xorMsgSegment(this.previousPutMQMD, byArray, 44 + n9 + 8, n7 - 8);
                            this.xorMsgSegment(this.previousMdPmo, byArray, 44 + n9 + n7 + 8, n8 - 8);
                        }
                    }
                }
                if (n5 > byArray.length) {
                    n5 = byArray.length;
                }
                if ((n6 += this.compressRLE(byArray, n6 - 4, n5 - n6 + 4, byArray2, n6)) >= n5) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Compression increases header length - undoing");
                    }
                    System.arraycopy(byArray3, 0, byArray, 44 + n9, n7);
                    System.arraycopy(byArray4, 0, byArray, 44 + n9 + n7, n8);
                    System.arraycopy(byArray2, 48 + n9, byArray, 44 + n9, n5 - (44 + n9));
                } else {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Header compression completed");
                    }
                    byArray2[11] = (byte)(byArray2[11] | 1);
                    if (n10 == 133) {
                        System.arraycopy(byArray3, 0, this.previousGetMQMD, 0, n7);
                        if (n7 < this.previousGetMQMD.length) {
                            for (n11 = n7; n11 < this.previousGetMQMD.length; ++n11) {
                                this.previousGetMQMD[n11] = 0;
                            }
                        }
                        System.arraycopy(byArray4, 0, this.previousMdGmo, 0, n8);
                        if (n8 < this.previousMdGmo.length) {
                            for (n11 = n8; n11 < this.previousMdGmo.length; ++n11) {
                                this.previousMdGmo[n11] = 0;
                            }
                        }
                    } else if (n10 == 134 || n10 == 135) {
                        System.arraycopy(byArray3, 0, this.previousPutMQMD, 0, n7);
                        if (n7 < this.previousPutMQMD.length) {
                            for (n11 = n7; n11 < this.previousPutMQMD.length; ++n11) {
                                this.previousPutMQMD[n11] = 0;
                            }
                        }
                        System.arraycopy(byArray4, 0, this.previousMdPmo, 0, n8);
                        if (n8 < this.previousMdPmo.length) {
                            for (n11 = n8; n11 < this.previousMdPmo.length; ++n11) {
                                this.previousMdPmo[n11] = 0;
                            }
                        }
                    }
                }
            } else {
                System.arraycopy(byArray, n6 - 4, byArray2, n6, n5 - n6 + 4);
                n6 = n5 + 4;
            }
        } else {
            n6 = n5;
        }
        n3 = n6;
        byArray2[44] = (byte)(n3 >>> 8);
        byArray2[45] = (byte)n3;
        if (n10 == 134 || n10 == 135 || n10 == 133 || n10 == 131) {
            if (n2 != 0) {
                if (byArray.length - n5 > 0) {
                    int n15 = 0;
                    switch (n2) {
                        case 1: {
                            n15 = this.compressRLE(byArray, n5, byArray.length - n5, byArray2, n6);
                            break;
                        }
                        case 2: 
                        case 4: {
                            n15 = this.compressZLIB(byArray, n5, byArray.length - n5, byArray2, n6);
                        }
                    }
                    int n16 = 0;
                    n16 = n == 0 ? n15 + 4 : n15;
                    if (n16 < byArray.length - n5) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Message compression completed");
                        }
                        byArray2[11] = (byte)(byArray2[11] | 2);
                        n6 += n15;
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(3, this, "Message compression increases length - undoing");
                        }
                        System.arraycopy(byArray, n5, byArray2, n6, byArray.length - n5);
                        n6 += byArray.length - n5;
                    }
                }
            } else if (byArray.length > n5) {
                System.arraycopy(byArray, n5, byArray2, n6, byArray.length - n5);
                n6 += byArray.length - n5;
            }
        }
        if ((n4 & 0x10) != 0 && (n != 0 || n2 != 0) && (byArray2[11] & 1) == 0 && (byArray2[11] & 2) == 0) {
            for (int i = 44; i < byArray2.length - 4; ++i) {
                byArray2[i] = byArray2[i + 4];
            }
            n6 -= 4;
        }
        n3 = n6;
        if (Trace.isOn) {
            Trace.trace(2, this, "Segment length after compression: " + n6);
        }
        byArray2[4] = (byte)(n3 >>> 24);
        byArray2[5] = (byte)(n3 >>> 16);
        byArray2[6] = (byte)(n3 >>> 8);
        byArray2[7] = (byte)n3;
        if (Trace.isOn) {
            Trace.trace(2, this, "Header length after compression: " + n6);
        }
        byte[] byArray5 = new byte[n6];
        System.arraycopy(byArray2, 0, byArray5, 0, n6);
        if (Trace.isOn) {
            Trace.trace(4, this, "Compressed segment: ");
            Trace.dataTrace(4, this, byArray5);
            Trace.exit(this, "compressMsgSegment");
        }
        return byArray5;
    }

    public byte[] decompressMsgSegment(byte[] byArray, int n, int n2) throws MQException {
        int n3;
        int n4;
        if (Trace.isOn) {
            Trace.entry(this, "decompressMsgSegment");
        }
        if (Trace.isOn) {
            Trace.entry(this, "decompressMsgSegment");
            Trace.trace(4, this, "Segment to decompress: ");
            Trace.dataTrace(4, this, byArray);
            Trace.trace(2, this, "Current Message Compression: " + n);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray[9];
        if (n7 < 0) {
            n7 += 256;
        }
        if ((n4 = byArray[10]) < 0) {
            n4 += 256;
        }
        if ((n3 = byArray[11]) < 0) {
            n3 += 256;
        }
        if ((n4 & 0x10) != 0) {
            n6 |= (byArray[44] & 0xFF) << 8;
            n6 |= byArray[45] & 0xFF;
            n = byArray[47];
        } else {
            n6 = 28;
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Compressed header length: " + n6);
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        n11 = (n4 & 0x10) != 0 && (n4 & 0x20) != 0 ? this.getIntFromArray(byArray, 28) + 28 + 16 + 4 : n2;
        byte[] byArray2 = new byte[n11];
        int n12 = 28;
        System.arraycopy(byArray, 0, byArray2, 0, n12);
        if ((n4 & 0x10) != 0) {
            int n13;
            n12 += 16;
            System.arraycopy(byArray, 28, byArray2, 28, 16);
            if ((n3 & 1) != 0) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Header compression flag set");
                }
                n13 = 48;
                n12 += this.decompressRLE(byArray, n13, n6 - n13, byArray2, n12);
                switch (n7) {
                    case 151: {
                        int n14 = this.getIntFromArray(byArray2, n13 += 4);
                        if (n14 == 1) {
                            n10 = 168;
                            n13 += n10 - 4;
                        } else {
                            n10 = 200;
                            n13 += n10 - 4;
                        }
                    }
                    case 150: {
                        int n15;
                        int n14 = this.getIntFromArray(byArray2, n13);
                        n13 += 4;
                        if (n14 == 1) {
                            n8 = 324;
                            n15 = this.getIntFromArray(byArray2, n13 += n8 - 4);
                            n13 += 4;
                            if (n15 == 1) {
                                n9 = 128;
                                break;
                            }
                            n9 = 152;
                            break;
                        }
                        if (n14 != 2) break;
                        n8 = 364;
                        n15 = this.getIntFromArray(byArray2, n13 += n8 - 4);
                        n13 += 4;
                        if (n15 == 1) {
                            n9 = 128;
                            break;
                        }
                        n9 = 152;
                        break;
                    }
                    case 149: {
                        int n15;
                        int n14 = this.getIntFromArray(byArray2, n13);
                        n13 += 4;
                        if (n14 == 1) {
                            n8 = 324;
                            n15 = this.getIntFromArray(byArray2, n13 += n8 - 4);
                            n13 += 4;
                            if (n15 == 1) {
                                n9 = 72;
                                break;
                            }
                            if (n15 == 2) {
                                n9 = 80;
                                break;
                            }
                            n9 = 100;
                            break;
                        }
                        if (n14 != 2) break;
                        n8 = 364;
                        n15 = this.getIntFromArray(byArray2, n13 += n8 - 4);
                        n13 += 4;
                        n9 = n15 == 1 ? 72 : (n15 == 2 ? 80 : 100);
                    }
                }
                if ((n7 == 149 || n7 == 150 || n7 == 151) && n12 != n2) {
                    if (n7 == 149) {
                        this.xorMsgSegment(this.previousGetMQMD, byArray2, 44 + n10 + 8, n8 - 8);
                        this.xorMsgSegment(this.previousMdGmo, byArray2, 44 + n10 + n8 + 8, n9 - 8);
                    } else {
                        this.xorMsgSegment(this.previousPutMQMD, byArray2, 44 + n10 + 8, n8 - 8);
                        this.xorMsgSegment(this.previousMdPmo, byArray2, 44 + n10 + n8 + 8, n9 - 8);
                    }
                }
                byArray2[11] = (byte)(byArray2[11] & 0xFFFFFFFE);
            } else {
                System.arraycopy(byArray, n12 + 4, byArray2, n12, n6 - n12);
                n12 = n6 - 4;
            }
            if (n7 == 149) {
                System.arraycopy(byArray2, 44 + n10, this.previousGetMQMD, 0, n8);
                if (n8 < this.previousGetMQMD.length) {
                    for (n13 = n8; n13 < this.previousGetMQMD.length; ++n13) {
                        this.previousGetMQMD[n13] = 0;
                    }
                }
                System.arraycopy(byArray2, 44 + n10 + n8, this.previousMdGmo, 0, n9);
                if (n9 < this.previousMdGmo.length) {
                    for (n13 = n9; n13 < this.previousMdGmo.length; ++n13) {
                        this.previousMdGmo[n13] = 0;
                    }
                }
            } else if (n7 == 150 || n7 == 151) {
                System.arraycopy(byArray2, 44 + n10, this.previousPutMQMD, 0, n8);
                if (n8 < this.previousPutMQMD.length) {
                    for (n13 = n8; n13 < this.previousPutMQMD.length; ++n13) {
                        this.previousPutMQMD[n13] = 0;
                    }
                }
                System.arraycopy(byArray2, 44 + n10 + n8, this.previousMdPmo, 0, n9);
                if (n9 < this.previousMdPmo.length) {
                    for (n13 = n9; n13 < this.previousMdPmo.length; ++n13) {
                        this.previousMdPmo[n13] = 0;
                    }
                }
            }
        }
        if ((n4 & 0x10) == 0 || n7 == 149) {
            if ((n3 & 2) != 0) {
                switch (n) {
                    case 1: {
                        n12 += this.decompressRLE(byArray, n6, byArray.length - n6, byArray2, n12);
                        break;
                    }
                    case 2: 
                    case 4: {
                        n12 += this.decompressZLIB(byArray, n6, byArray.length - n6, byArray2, n12);
                        break;
                    }
                    default: {
                        System.arraycopy(byArray, n6, byArray2, n12, n5);
                        break;
                    }
                }
                byArray2[11] = (byte)(byArray2[11] & 0xFFFFFFFD);
            } else {
                System.arraycopy(byArray, n6, byArray2, n12, byArray.length - n6);
                n12 += byArray.length - n6;
            }
        }
        if (Trace.isOn) {
            Trace.trace(4, this, "Decompressed segment: ");
            Trace.dataTrace(4, this, byArray2);
            Trace.exit(this, "deCompressMsgSegment");
        }
        return byArray2;
    }

    public void xorMsgSegment(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (Trace.isOn) {
            Trace.entry(this, "xorMsgSegment");
            Trace.trace(4, this, "Segment before xor: ");
            Trace.dataTrace(4, this, byArray);
        }
        if (byArray == null) {
            byArray = new byte[n2];
        }
        for (int i = n; i < n2 + n; ++i) {
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[i - n + 8]);
        }
        if (Trace.isOn) {
            Trace.trace(4, this, "Segment after xor: ");
            Trace.dataTrace(4, this, byArray);
            Trace.exit(this, "xorMsgSegment");
        }
    }

    public int compressRLE(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (Trace.isOn) {
            Trace.entry(this, "compressRLE");
            Trace.trace(4, this, "Segment before compression: ");
            Trace.dataTrace(4, this, byArray);
        }
        int n4 = n;
        int n5 = n3;
        int n6 = 1;
        byte by = byArray[n];
        byte by2 = 0;
        for (n4 = n + 1; n4 < n + n2; ++n4) {
            by2 = byArray[n4];
            if (by == ESCAPECHAR) {
                byArray2[n5++] = ESCAPECHAR;
                if (byArray2.length - n5 >= 1) {
                    byArray2[n5++] = ESCAPECHAR;
                }
            } else if (by == by2 && n6 < 255 && n2 + n - n4 > 1) {
                ++n6;
            } else {
                if (n6 >= 4) {
                    if (byArray2.length - n5 >= 3) {
                        if (n2 + n - n4 == 1 && by == by2) {
                            ++n6;
                            ++n4;
                        }
                        byArray2[n5++] = ESCAPECHAR;
                        byArray2[n5++] = by;
                        byArray2[n5++] = (byte)n6;
                    }
                } else if (byArray2.length - n5 >= n6) {
                    for (int i = 0; i < n6; ++i) {
                        byArray2[n5++] = by;
                    }
                }
                n6 = 1;
            }
            by = by2;
            if (n2 + n - n4 != 1 || byArray2.length - n5 < 1) continue;
            byArray2[n5++] = by2;
            if (by2 != ESCAPECHAR || byArray2.length - n5 < 1) continue;
            byArray2[n5++] = by2;
        }
        if (Trace.isOn) {
            Trace.trace(4, this, "Segment after compression: ");
            Trace.dataTrace(4, this, byArray2);
            Trace.exit(this, "compressRLE");
        }
        return n5 - n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int decompressRLE(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "decompressRLE");
            Trace.trace(4, this, "Segment before decompression: ");
            Trace.dataTrace(4, this, byArray);
            Trace.trace(3, this, "Size of output buffer: " + byArray2.length);
        }
        int n4 = 0;
        int n5 = n;
        int n6 = n3;
        int n7 = byArray[n];
        boolean bl = false;
        boolean bl2 = false;
        for (n5 = n + 1; n5 < n + n2; ++n5) {
            block20: {
                block22: {
                    block21: {
                        n4 = byArray[n5];
                        if (!bl) break block21;
                        int n8 = n4;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        int n9 = n7;
                        if (byArray2.length - n6 < n8) {
                            Trace.trace(2, this, "Provided buffer too small");
                            Trace.exit(this, "decompressRLE (via exception)");
                            throw new MQException(2, 2005, this);
                        }
                        for (int i = 0; i < n8; ++i) {
                            byArray2[n6++] = n9;
                        }
                        if (byArray.length - ++n5 >= 1) {
                            n4 = byArray[n5];
                        }
                        bl = false;
                        break block20;
                    }
                    if (n7 != ESCAPECHAR) break block22;
                    if (!bl2) {
                        if (n4 == ESCAPECHAR) {
                            if (byArray2.length - n6 >= 1) {
                                byArray2[n6++] = ESCAPECHAR;
                                bl2 = true;
                                break block20;
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(2, this, "Provided buffer too small");
                                    Trace.exit(this, "decompressRLE (via exception)");
                                }
                                throw new MQException(2, 2005, this);
                            }
                        }
                        bl = true;
                        break block20;
                    } else {
                        bl2 = false;
                    }
                    break block20;
                }
                if (byArray2.length - n6 >= 1) {
                    byArray2[n6++] = n7;
                    if (n2 + n - n5 == 1 && !bl2) {
                        if (byArray2.length - n6 >= 1) {
                            byArray2[n6++] = n4;
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(2, this, "Provided buffer too small");
                                Trace.exit(this, "decompressRLE (via exception)");
                            }
                            throw new MQException(2, 2005, this);
                        }
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Provided buffer too small");
                        Trace.exit(this, "decompressRLE (via exception)");
                    }
                    throw new MQException(2, 2005, this);
                }
            }
            n7 = n4;
        }
        if (Trace.isOn) {
            Trace.trace(4, this, "Segment after decompression: ");
            Trace.dataTrace(4, this, byArray2);
            Trace.exit(this, "decompressRLE");
        }
        return n6 - n3;
    }

    public int compressZLIB(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (Trace.isOn) {
            Trace.entry(this, "compressZLIB");
            Trace.trace(4, this, "Segment before compression: ");
            Trace.dataTrace(4, this, byArray);
        }
        this.compressor.setInput(byArray, n, n2);
        this.compressor.finish();
        int n4 = this.compressor.deflate(byArray2, n3, byArray2.length - n3);
        this.compressor.reset();
        if (Trace.isOn) {
            Trace.trace(4, this, "Segment after compression: ");
            Trace.dataTrace(4, this, byArray2);
            Trace.trace(2, this, "Compressed data length: " + n4);
            Trace.exit(this, "compressZLIB");
        }
        return n4;
    }

    public int decompressZLIB(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "decompressZLIB");
            Trace.trace(4, this, "Segment before decompression: ");
            Trace.dataTrace(4, this, byArray);
        }
        this.decompressor.setInput(byArray, n, n2);
        int n4 = 0;
        try {
            n4 = this.decompressor.inflate(byArray2, n3, byArray2.length - n3);
            if (!this.decompressor.finished()) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Provided buffer too small");
                    Trace.exit(this, "decompressZLIB (via exception)");
                }
                throw new MQException(2, 2005, this);
            }
            this.decompressor.reset();
        }
        catch (DataFormatException dataFormatException) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Data format not supported by ZLIB decompressor");
                Trace.exit(this, "decompressZLIB (via exception)");
            }
            throw new MQException(2, 2110, this);
        }
        if (Trace.isOn) {
            Trace.trace(4, this, "Segment after decompression: ");
            Trace.dataTrace(4, this, byArray2);
            Trace.trace(2, this, "Decompressed buffer length" + n4);
            Trace.exit(this, "decompressZLIB");
        }
        return n4;
    }

    private int getIntFromArray(byte[] byArray, int n) {
        int n2 = 0;
        n2 = byArray[n] << 24;
        n2 |= (byArray[n + 1] & 0xFF) << 16;
        n2 |= (byArray[n + 2] & 0xFF) << 8;
        return n2 |= byArray[n + 3] & 0xFF;
    }

    public void finalize() {
        this.compressor.end();
        this.decompressor.end();
    }
}

