/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mqservices.Trace;
import java.util.Hashtable;
import javax.resource.spi.ConnectionRequestInfo;

class ClientConnectionRequestInfo
extends MQConnectionRequestInfo
implements Cloneable,
ConnectionRequestInfo {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/ClientConnectionRequestInfo.java, java, j600, j600-201-061220 1.38.1.3 06/08/16 10:10:48";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public int connectOptions;
    public MQSecurityExit securityExit;
    public MQSendExit sendExit;
    public MQReceiveExit receiveExit;
    public String userName;
    public String password;
    public boolean xaRequired;
    public boolean useQmCcsid;
    public Boolean useBatching = null;
    public Integer batchFloor = null;
    public Integer batchCeiling = null;
    public Integer batchThreshold = null;
    public Integer batchInterval = null;
    public String spi;
    public Object inheritTx;
    public Object asyncCmt;
    public String sslCipherSuite = null;
    public String sslPeername = null;
    public Object sslCertStores = null;
    public Object sslSocketFactory = null;
    public Object hdrCompList = null;
    public Object msgCompList = null;
    public Integer sslResetCount = null;
    public Boolean sslFipsRequired = null;
    public Object localAddress = "";
    public byte[] connTag = null;

    ClientConnectionRequestInfo(Hashtable hashtable, boolean bl) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "ClientConnectionRequestInfo constructor");
        }
        if (bl) {
            this.simplePopulate(hashtable);
        } else {
            this.complexPopulate(hashtable);
        }
        if (Trace.isOn) {
            Trace.exit(this, "ClientConnectionRequestInfo constructor");
        }
    }

    ClientConnectionRequestInfo(Hashtable hashtable) throws MQException {
        if (Trace.isOn) {
            Trace.entry("Uninitialized object", "ClientConnectionRequestInfo constructor");
        }
        this.complexPopulate(hashtable);
        if (Trace.isOn) {
            Trace.exit(this, "ClientConnectionRequestInfo constructor");
        }
    }

    private void simplePopulate(Hashtable hashtable) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "simplePopulate");
        }
        this.hasVariablePortion = true;
        this.connectOptions = this.getInt(hashtable, "connectOptions");
        this.securityExit = (MQSecurityExit)hashtable.get("securityExit");
        this.receiveExit = (MQReceiveExit)hashtable.get("receiveExit");
        this.sendExit = (MQSendExit)hashtable.get("sendExit");
        this.userName = MQEnvironment.getStringProperty("userID", hashtable);
        this.password = MQEnvironment.getStringProperty("password", hashtable);
        this.spi = (String)hashtable.get("SPI");
        this.inheritTx = hashtable.get("SPI_INHERIT_TX");
        this.asyncCmt = hashtable.get("SPI_ASYNC_CMIT");
        if (Trace.isOn) {
            Trace.trace(this, "inheritTx = " + this.inheritTx);
            Trace.trace(this, "asyncCmt = " + this.asyncCmt);
        }
        this.sslCipherSuite = (String)hashtable.get("SSL Cipher Suite");
        this.sslPeername = (String)hashtable.get("SSL Peer Name");
        this.sslCertStores = hashtable.get("SSL CertStores");
        this.sslSocketFactory = hashtable.get("SSL Socket Factory");
        this.hdrCompList = hashtable.get("Header Compression Property");
        this.msgCompList = hashtable.get("Message Compression Property");
        this.sslResetCount = (Integer)hashtable.get("KeyResetCount");
        this.connTag = (byte[])hashtable.get("ConnTag Property");
        String string = (String)hashtable.get("Local Address Property");
        if (string != null && !string.equals("")) {
            this.localAddress = FWHelper.encodeToObject(string);
        }
        this.setClassFields(hashtable);
        if (Trace.isOn) {
            Trace.exit(this, "simplePopulate");
        }
    }

    private void complexPopulate(Hashtable hashtable) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "complexPopulate");
        }
        this.hasVariablePortion = true;
        this.connectOptions = MQEnvironment.getIntegerProperty("connectOptions", hashtable);
        this.securityExit = (MQSecurityExit)MQEnvironment.getObjectProperty("securityExit", hashtable);
        this.receiveExit = (MQReceiveExit)MQEnvironment.getObjectProperty("receiveExit", hashtable);
        this.sendExit = (MQSendExit)MQEnvironment.getObjectProperty("sendExit", hashtable);
        this.userName = MQEnvironment.getStringProperty("userID", hashtable);
        this.password = MQEnvironment.getStringProperty("password", hashtable);
        this.spi = MQEnvironment.getStringProperty("SPI", hashtable);
        this.inheritTx = MQEnvironment.getObjectProperty("SPI_INHERIT_TX", hashtable);
        this.asyncCmt = MQEnvironment.getObjectProperty("SPI_ASYNC_CMIT", hashtable);
        if (Trace.isOn) {
            Trace.trace(this, "inheritTx = " + this.inheritTx);
            Trace.trace(this, "asyncCmt = " + this.asyncCmt);
        }
        this.sslCipherSuite = MQEnvironment.getStringProperty("SSL Cipher Suite", hashtable);
        this.sslPeername = MQEnvironment.getStringProperty("SSL Peer Name", hashtable);
        this.sslCertStores = MQEnvironment.getObjectProperty("SSL CertStores", hashtable);
        this.sslSocketFactory = MQEnvironment.getObjectProperty("SSL Socket Factory", hashtable);
        this.hdrCompList = MQEnvironment.getObjectProperty("Header Compression Property", hashtable);
        this.msgCompList = MQEnvironment.getObjectProperty("Message Compression Property", hashtable);
        this.sslResetCount = (Integer)MQEnvironment.getObjectProperty("KeyResetCount", hashtable);
        this.sslFipsRequired = (Boolean)MQEnvironment.getObjectProperty("SSL Fips Required", hashtable);
        this.connTag = (byte[])MQEnvironment.getObjectProperty("ConnTag Property", hashtable);
        String string = MQEnvironment.getStringProperty("Local Address Property", hashtable);
        if (string != null) {
            this.localAddress = FWHelper.encodeToObject(string);
        }
        this.setClassFields(hashtable);
        if (Trace.isOn) {
            Trace.exit(this, "complexPopulate");
        }
    }

    private void setClassFields(Hashtable hashtable) {
        if (hashtable != null) {
            this.xaRequired = false;
            Object v = hashtable.get("XAReq");
            if (v != null && v instanceof Boolean) {
                this.xaRequired = (Boolean)v;
            }
            this.useQmCcsid = false;
            Object v2 = hashtable.get("Use QM CCSID");
            if (v2 != null && v2 instanceof Boolean) {
                this.useQmCcsid = (Boolean)v2;
            }
            if ((v2 = hashtable.get("Batching enabled")) != null && v2 instanceof Boolean) {
                this.useBatching = (Boolean)v2;
            }
            if ((v2 = hashtable.get("Batch size floor")) != null && v2 instanceof Integer) {
                this.batchFloor = (Integer)v2;
            }
            if ((v2 = hashtable.get("Batch size ceiling")) != null && v2 instanceof Integer) {
                this.batchCeiling = (Integer)v2;
            }
            if ((v2 = hashtable.get("Batching threshold")) != null && v2 instanceof Integer) {
                this.batchThreshold = (Integer)v2;
            }
            if ((v2 = hashtable.get("Batch interval")) != null && v2 instanceof Integer) {
                this.batchInterval = (Integer)v2;
            }
        }
    }

    public int variableHashCode() {
        int n = 0;
        if (this.localAddress != null) {
            n += 101 * this.localAddress.hashCode();
        }
        return n;
    }

    public int fixedHashCode() {
        int n = 31 * this.connectOptions;
        if (this.userName != null) {
            n += 37 * this.userName.hashCode();
        }
        if (this.xaRequired) {
            n += 43;
        }
        if (this.useQmCcsid) {
            n += 47;
        }
        if (this.spi != null) {
            n += 53 * this.spi.hashCode();
        }
        if (this.useBatching != null) {
            n += 59 * this.useBatching.hashCode();
        }
        if (this.batchFloor != null) {
            n += 61 * this.batchFloor.hashCode();
        }
        if (this.batchCeiling != null) {
            n += 67 * this.batchCeiling.hashCode();
        }
        if (this.batchThreshold != null) {
            n += 71 * this.batchThreshold.hashCode();
        }
        if (this.batchInterval != null) {
            n += 73 * this.batchInterval.hashCode();
        }
        if (this.sslCipherSuite != null) {
            n += 79 * this.sslCipherSuite.hashCode();
        }
        if (this.sslPeername != null) {
            n += 83 * this.sslPeername.hashCode();
        }
        if (this.sslCertStores != null) {
            n += 89 * this.sslCertStores.hashCode();
        }
        if (this.sslSocketFactory != null) {
            n += 97 * this.sslSocketFactory.hashCode();
        }
        if (this.hdrCompList != null) {
            n += 103 * this.hdrCompList.hashCode();
        }
        if (this.msgCompList != null) {
            n += 107 * this.msgCompList.hashCode();
        }
        if (this.connTag != null) {
            n += 109 * new String(this.connTag).hashCode();
        }
        if (this.sslResetCount != null) {
            n += 113 * this.sslResetCount.hashCode();
        }
        if (this.sslFipsRequired != null) {
            n += 127 * this.sslFipsRequired.hashCode();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean variableIsSuitable(MQManagedConnectionJ11 mQManagedConnectionJ11) {
        if (mQManagedConnectionJ11 == null) {
            return false;
        }
        MQManagedConnectionJ11 mQManagedConnectionJ112 = mQManagedConnectionJ11;
        synchronized (mQManagedConnectionJ112) {
            if (!FWHelper.fuzzyCompare(mQManagedConnectionJ11, this.localAddress)) {
                return false;
            }
        }
        return true;
    }

    public boolean fixedEquals(Object object) {
        block6: {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            ClientConnectionRequestInfo clientConnectionRequestInfo = (ClientConnectionRequestInfo)object;
            try {
                if (this.connectOptions == clientConnectionRequestInfo.connectOptions && this.objEquals(this.userName, clientConnectionRequestInfo.userName) && this.objEquals(this.password, clientConnectionRequestInfo.password) && this.objEquals(this.securityExit, clientConnectionRequestInfo.securityExit) && this.objEquals(this.sendExit, clientConnectionRequestInfo.sendExit) && this.objEquals(this.receiveExit, clientConnectionRequestInfo.receiveExit) && this.xaRequired == clientConnectionRequestInfo.xaRequired && this.useQmCcsid == clientConnectionRequestInfo.useQmCcsid && this.objEquals(this.spi, clientConnectionRequestInfo.spi) && this.objEquals(this.inheritTx, clientConnectionRequestInfo.inheritTx) && this.objEquals(this.asyncCmt, clientConnectionRequestInfo.asyncCmt) && this.objEquals(this.useBatching, clientConnectionRequestInfo.useBatching) && this.objEquals(this.batchFloor, clientConnectionRequestInfo.batchFloor) && this.objEquals(this.batchCeiling, clientConnectionRequestInfo.batchCeiling) && this.objEquals(this.batchThreshold, clientConnectionRequestInfo.batchThreshold) && this.objEquals(this.batchInterval, clientConnectionRequestInfo.batchInterval) && this.objEquals(this.sslCipherSuite, clientConnectionRequestInfo.sslCipherSuite) && this.objEquals(this.sslPeername, clientConnectionRequestInfo.sslPeername) && this.objEquals(this.sslCertStores, clientConnectionRequestInfo.sslCertStores) && this.objEquals(this.sslSocketFactory, clientConnectionRequestInfo.sslSocketFactory) && this.objEquals(this.hdrCompList, clientConnectionRequestInfo.hdrCompList) && this.objEquals(this.msgCompList, clientConnectionRequestInfo.msgCompList) && ClientConnectionRequestInfo.byteArrayEquals(this.connTag, clientConnectionRequestInfo.connTag) && this.objEquals(this.sslResetCount, clientConnectionRequestInfo.sslResetCount) && this.objEquals(this.sslFipsRequired, clientConnectionRequestInfo.sslFipsRequired)) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block6;
                Trace.trace(this, "fixedEquals caught exception:");
                Trace.trace(this, exception.toString());
            }
        }
        return false;
    }

    public boolean variableEquals(Object object) {
        ClientConnectionRequestInfo clientConnectionRequestInfo = (ClientConnectionRequestInfo)object;
        return this.objEquals(this.localAddress, clientConnectionRequestInfo.localAddress);
    }

    private int getInt(Hashtable hashtable, String string) {
        Integer n = (Integer)hashtable.get(string);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static boolean byteArrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

