/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.vaadin.ui.sqlexplorer.IDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSuggester {
    private static final Logger logger = LoggerFactory.getLogger(SqlSuggester.class);
    public static final String[] TABLE_TYPES = new String[]{"TABLE", "SYSTEM TABLE", "SYSTEM VIEW"};
    public static final String[] QUERY_INITIALIZERS = new String[]{"alter ", "create ", "delete ", "drop ", "insert ", "select ", "truncate ", "update "};
    private Map<String, List<String>> tableNameCache;
    private Map<String, List<String>> columnNameCache;
    private Map<String, List<String>> schemaNameCache;
    private List<String> catalogNameCache;
    private IDdlReader reader;
    private AceEditor editor;
    private String text;
    private int cursor;
    private String currentWord;
    private boolean addPeriod;
    private boolean setCursorPosition;
    private boolean enabled;
    private List<String> referencedTableNames;
    private Map<String, String> aliases;

    public SqlSuggester(IDb db, AceEditor editor) {
        this.reader = db.getPlatform().getDdlReader();
        this.editor = editor;
        this.enabled = true;
        this.tableNameCache = new HashMap<String, List<String>>();
        this.columnNameCache = new HashMap<String, List<String>>();
        this.schemaNameCache = new HashMap<String, List<String>>();
        this.catalogNameCache = new ArrayList<String>();
        this.editor.setAutoComplete(true);
        this.editor.addSyncCompletedListener((ComponentEventListener & Serializable)event -> {
            if (this.addPeriod) {
                this.editor.addTextAtCurrentPosition(".");
                this.addPeriod = false;
                this.editor.sync();
                this.setCursorPosition = true;
            }
        });
        this.editor.addValueChangeListener((ComponentEventListener & Serializable)event -> this.updateSuggestions(event.getValue(), this.getCursorPosition()));
        this.editor.addSelectionChangeListener((ComponentEventListener & Serializable)event -> {
            if (this.setCursorPosition && event.getSelection().getEndIndex() != this.cursor) {
                this.editor.setCursorPosition(this.cursor);
            }
            this.setCursorPosition = false;
        });
        Shortcuts.addShortcutListener((Component)this.editor, (Command & Serializable)() -> {
            this.addPeriod = true;
            this.editor.sync();
        }, (Key)Key.PERIOD, (KeyModifier[])new KeyModifier[0]).listenOn(new Component[]{editor});
    }

    public void updateSuggestions(String text, int cursor) {
        this.editor.addStaticWordCompleter(new ArrayList());
        if (this.enabled) {
            try {
                this.text = text;
                this.cursor = cursor;
                this.currentWord = this.getCurrentWord();
                this.referencedTableNames = this.getReferencedTableNames();
                this.aliases = this.getAliases();
                ArrayList<String> suggestions = new ArrayList<String>();
                int lastDeliminatorIndex = this.getLastDeliminatorIndex();
                if (lastDeliminatorIndex > 0 && text.charAt(lastDeliminatorIndex) == '.' && this.isSqlIdentifier(text.charAt(lastDeliminatorIndex - 1))) {
                    suggestions.addAll(this.getHierarchySuggestions());
                } else if (lastDeliminatorIndex > 0 && text.charAt(lastDeliminatorIndex - 1) != '.' || lastDeliminatorIndex <= 0) {
                    suggestions.addAll(this.getAliasSuggestions());
                    for (String fullTableName : this.referencedTableNames) {
                        String[] fullNameParts = this.parseFullName(fullTableName);
                        suggestions.addAll(this.getColumnNameSuggestions(fullNameParts[2], fullNameParts[1], fullNameParts[0]));
                    }
                    suggestions.addAll(this.getCatalogNameSuggestions());
                    suggestions.addAll(this.getSchemaNameSuggestions(null));
                    suggestions.addAll(this.getTableNameSuggestions(null, null));
                }
                this.removeRepeats(suggestions);
                this.editor.addStaticWordCompleter(suggestions);
            }
            catch (Exception ex) {
                logger.debug("Failed to generate suggestions. cursor=" + cursor + " text=" + text, (Throwable)ex);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private int getCursorPosition() {
        String value = this.editor.getValue();
        int cursorRow = this.editor.getCursorPosition().getRow();
        int cursorColumn = this.editor.getCursorPosition().getColumn();
        int row = 0;
        int column = 0;
        int index = 0;
        for (char c : value.toCharArray()) {
            if (row == cursorRow && column == cursorColumn) {
                return index;
            }
            if (c == '\n') {
                ++row;
                column = 0;
            } else {
                ++column;
            }
            ++index;
        }
        if (row == cursorRow && column == cursorColumn) {
            return index;
        }
        return -1;
    }

    private boolean isSqlIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == '@' || c == '_' || c == '#' || c == '$' || c == '*';
    }

    private int getLastDeliminatorIndex() {
        int lookBack;
        for (lookBack = 0; this.cursor > lookBack && this.isSqlIdentifier(this.text.charAt(this.cursor - 1 - lookBack)); ++lookBack) {
        }
        return this.cursor - lookBack - 1;
    }

    private String getCurrentWord() {
        return this.text.substring(this.getLastDeliminatorIndex() + 1, this.cursor);
    }

    private String getPrevWord(int index) {
        int lookBack;
        for (lookBack = 0; index - 1 >= lookBack && this.isSqlIdentifier(this.text.charAt(index - 1 - lookBack)); ++lookBack) {
        }
        while (index - 1 >= lookBack && !this.isSqlIdentifier(this.text.charAt(index - 1 - lookBack))) {
            if (this.text.charAt(index - 1 - lookBack) == ';') {
                return "";
            }
            ++lookBack;
        }
        int endIndex = index - lookBack;
        while (index - 1 >= lookBack && this.isSqlIdentifier(this.text.charAt(index - 1 - lookBack))) {
            ++lookBack;
        }
        return this.text.substring(index - lookBack, endIndex);
    }

    private List<String> getAliasSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String alias : this.aliases.keySet()) {
            if (!alias.toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            suggestions.add(alias);
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private Map<String, String> getAliases() {
        int asIndex;
        HashMap<String, String> aliases = new HashMap<String, String>();
        int lastAliasIndex = 0;
        String as = " as ";
        while (lastAliasIndex + as.length() < this.text.length() && (asIndex = this.text.toLowerCase().indexOf(as, lastAliasIndex)) != -1) {
            int i;
            for (i = asIndex + as.length(); i < this.text.length() && this.isSqlIdentifier(this.text.charAt(i)); ++i) {
            }
            String alias = this.text.substring(asIndex + as.length(), i);
            i = asIndex;
            while (i > 0 && (this.text.charAt(--i) == '.' || this.isSqlIdentifier(this.text.charAt(i)))) {
            }
            aliases.put(alias, this.text.substring(i + 1, asIndex));
            lastAliasIndex = asIndex + as.length();
        }
        for (String tableName : this.referencedTableNames) {
            int i;
            int end;
            int start;
            int tableNameIndex;
            if (aliases.containsValue(tableName) || (tableNameIndex = this.text.toLowerCase().indexOf(tableName.toLowerCase())) == -1 || (start = tableNameIndex + tableName.length() + 1) >= this.text.length()) continue;
            while (start < this.text.length() && Character.isWhitespace(this.text.charAt(start))) {
                ++start;
            }
            for (end = start; end < this.text.length() && this.isSqlIdentifier(this.text.charAt(end)); ++end) {
            }
            String alias = this.text.substring(start, end);
            for (i = tableNameIndex; i < this.text.length() && (this.text.charAt(i) == '.' || this.isSqlIdentifier(this.text.charAt(i))); ++i) {
            }
            aliases.put(alias, this.text.substring(tableNameIndex, i));
        }
        return aliases;
    }

    private String getCurrentQuery() {
        int blockIndex;
        ArrayList<int[]> queryBlocks = new ArrayList<int[]>();
        int min = this.text.lastIndexOf(59, this.cursor + 1);
        int max = this.text.indexOf(59, this.cursor) < 0 ? this.text.length() : this.text.indexOf(59, this.cursor);
        queryBlocks.add(new int[]{min, max});
        for (int i = min + 1; i < max; ++i) {
            int j;
            if (this.text.charAt(i) == '(' || i + 5 < max && this.text.regionMatches(true, i, "begin", 0, 5)) {
                queryBlocks.add(new int[]{i, -1});
                continue;
            }
            if (this.text.charAt(i) != ')' && (i <= 3 || !this.text.regionMatches(true, i - 3, "end", 0, 3))) continue;
            for (j = queryBlocks.size() - 1; j > 0 && ((int[])queryBlocks.get(j))[1] != -1; --j) {
            }
            if (j <= 0) continue;
            ((int[])queryBlocks.get((int)j))[1] = i;
        }
        int[] currentBlock = (int[])queryBlocks.get(0);
        for (blockIndex = queryBlocks.size() - 1; blockIndex > 0 && ((int[])queryBlocks.get(blockIndex))[1] == -1 && ((int[])queryBlocks.get(blockIndex))[0] > this.cursor; --blockIndex) {
        }
        if (((int[])queryBlocks.get(blockIndex))[1] == -1) {
            currentBlock[0] = ((int[])queryBlocks.get(blockIndex))[0];
            currentBlock[1] = max;
        } else {
            for (int[] block : queryBlocks) {
                if (block[0] <= currentBlock[0] || block[0] >= this.cursor || block[1] >= currentBlock[1] || block[1] <= this.cursor) continue;
                currentBlock = block;
            }
        }
        if (currentBlock[1] == -1 || this.text.length() - 1 < currentBlock[1] && min >= 0) {
            return this.text.substring(min, max);
        }
        try {
            Object tempText = "";
            if (currentBlock.length > 1) {
                tempText = this.text.substring(currentBlock[0] + 1, currentBlock[1]);
                int shiftLeft = currentBlock[0] + 1;
                int lastRemoval = currentBlock[0] + 1;
                block7: for (int[] block : queryBlocks) {
                    if (block[1] <= 0 || block[0] < currentBlock[0] || block[1] > currentBlock[1] || block == currentBlock || block[0] <= lastRemoval) continue;
                    for (String word : QUERY_INITIALIZERS) {
                        if (!this.text.substring(block[0] + 1, block[1]).trim().startsWith(word)) continue;
                        tempText = ((String)tempText).substring(min + 1, block[0] - shiftLeft) + (((String)tempText).length() > block[1] - shiftLeft + 1 ? ((String)tempText).substring(block[1] - shiftLeft + 1) : "");
                        shiftLeft += block[1] - block[0];
                        lastRemoval = block[1];
                        continue block7;
                    }
                }
            }
            return tempText;
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            return "";
        }
    }

    private List<String> getReferencedTableNames() {
        String[] keywords;
        if (this.text.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        String currentQuery = this.getCurrentQuery();
        String tempText = currentQuery.toLowerCase();
        for (String keyword : keywords = new String[]{"from ", "update ", "join ", "into "}) {
            int lastIndexOfKeyword = 0;
            while (lastIndexOfKeyword < tempText.length() && lastIndexOfKeyword >= 0) {
                int indexOfKeyword = tempText.indexOf(keyword, lastIndexOfKeyword + 1);
                if (indexOfKeyword == 0 || indexOfKeyword > 0 && !this.isSqlIdentifier(tempText.charAt(indexOfKeyword - 1))) {
                    int start = indexOfKeyword + keyword.length();
                    boolean newWord = true;
                    boolean seenComma = true;
                    boolean ignore = false;
                    for (int i = start; i < tempText.length() && (this.isSqlIdentifier(tempText.charAt(i)) || tempText.charAt(i) == ',' || Character.isWhitespace(tempText.charAt(i)) || tempText.charAt(i) == '.'); ++i) {
                        char character = tempText.charAt(i);
                        if (newWord && ignore && this.isSqlIdentifier(character)) continue;
                        if (newWord && ignore) {
                            ignore = false;
                            continue;
                        }
                        if (newWord && (character == '.' || character == '$' || Character.isDigit(character))) break;
                        if (newWord && seenComma && this.isSqlIdentifier(character)) {
                            start = i;
                            newWord = false;
                            continue;
                        }
                        if (newWord && character == ',') {
                            seenComma = true;
                            continue;
                        }
                        if (newWord && !seenComma && !Character.isWhitespace(character)) {
                            ignore = true;
                            continue;
                        }
                        if (!newWord && !this.isSqlIdentifier(character) && character != '.') {
                            tableNames.add(currentQuery.substring(start, i));
                            newWord = true;
                            seenComma = character == ',';
                            continue;
                        }
                        if (newWord || i + 1 < tempText.length()) continue;
                        tableNames.add(currentQuery.substring(start));
                        break;
                    }
                }
                lastIndexOfKeyword = indexOfKeyword;
            }
        }
        return tableNames;
    }

    private List<String> getHierarchySuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        String prevWord = this.getPrevWord(this.cursor);
        String prevWord2 = null;
        String prevWord3 = null;
        int lookBack = prevWord.length();
        if (this.cursor - 2 > lookBack && this.text.charAt(this.cursor - 2 - lookBack) == '.' && this.isSqlIdentifier(this.text.charAt(this.cursor - 3 - lookBack))) {
            prevWord2 = this.getPrevWord(this.cursor - lookBack);
        }
        if (this.cursor - 2 > (lookBack += prevWord2 == null ? 0 : prevWord2.length()) && this.text.charAt(this.cursor - 2 - lookBack) == '.' && this.isSqlIdentifier(this.text.charAt(this.cursor - 3 - lookBack))) {
            prevWord3 = this.getPrevWord(this.cursor - lookBack);
        }
        if (prevWord2 == null && prevWord3 == null) {
            suggestions.addAll(this.getSchemaNameSuggestions(prevWord.isEmpty() ? null : prevWord));
        }
        if (prevWord3 == null) {
            suggestions.addAll(this.getTableNameSuggestions(prevWord2, prevWord));
        }
        suggestions.addAll(this.getColumnNameSuggestions(prevWord3, prevWord2, prevWord));
        return suggestions;
    }

    private List<String> getCatalogNameSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        List<String> catalogs = this.getCatalogNamesFromCache();
        for (String catalog : catalogs) {
            if (!catalog.toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            suggestions.add(catalog);
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private List<String> getCatalogNamesFromCache() {
        List catalogs = this.catalogNameCache;
        if (catalogs.isEmpty()) {
            catalogs = this.reader.getCatalogNames();
        }
        return catalogs;
    }

    public void clearCatalogNameCache() {
        this.catalogNameCache = new ArrayList<String>();
    }

    private List<String> getSchemaNameSuggestions(String catalog) {
        ArrayList<String> suggestions = new ArrayList<String>();
        List<String> schemaNames = this.getSchemaNamesFromCache(catalog);
        for (String schemaName : schemaNames) {
            if (!schemaName.toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            suggestions.add(schemaName);
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private List<String> getSchemaNamesFromCache(String catalog) {
        List schemaNames = this.schemaNameCache.get(catalog);
        if (schemaNames == null) {
            schemaNames = this.reader.getSchemaNames(catalog);
            this.schemaNameCache.put(catalog, schemaNames);
        }
        return schemaNames;
    }

    public void clearSchemaNamesCache() {
        this.schemaNameCache = new HashMap<String, List<String>>();
    }

    private List<String> getTableNameSuggestions(String catalog, String schema) {
        ArrayList<String> suggestions = new ArrayList<String>();
        List<String> tableNames = this.getTableNamesFromCache(catalog, schema);
        for (String tableName : tableNames) {
            if (!tableName.toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            suggestions.add(tableName);
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private List<String> getTableNamesFromCache(String catalog, String schema) {
        String key = this.getFullName(catalog, schema, null);
        List tableNames = this.tableNameCache.get(key);
        if (tableNames == null) {
            tableNames = this.reader.getTableNames(catalog, schema, TABLE_TYPES);
            this.tableNameCache.put(key, tableNames);
        }
        return tableNames;
    }

    public void clearTableNamesCache() {
        this.tableNameCache = new HashMap<String, List<String>>();
    }

    private List<String> getColumnNameSuggestions(String catalog, String schema, String tableName) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (this.aliases.get(tableName) != null) {
            String[] parsedName = this.parseFullName(this.aliases.get(tableName));
            tableName = parsedName[0];
            schema = parsedName[1];
            catalog = parsedName[2];
        }
        List<String> columnNames = this.getColumnNamesFromCache(catalog, schema, tableName);
        for (String columnName : columnNames) {
            if (!columnName.toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            suggestions.add(columnName);
        }
        Collections.sort(suggestions);
        return suggestions;
    }

    private List<String> getColumnNamesFromCache(String catalog, String schema, String tableName) {
        String key = this.getFullName(catalog, schema, tableName);
        List columnNames = this.columnNameCache.get(key);
        if (columnNames == null) {
            columnNames = this.reader.getColumnNames(catalog, schema, tableName);
            this.columnNameCache.put(key, columnNames);
        }
        return columnNames;
    }

    public void clearColumnNamesCache() {
        this.columnNameCache = new HashMap<String, List<String>>();
    }

    public void clearCaches() {
        this.clearSchemaNamesCache();
        this.clearTableNamesCache();
        this.clearColumnNamesCache();
        this.clearCatalogNameCache();
    }

    private String[] parseFullName(String fullName) {
        ArrayList<String> parsedName = new ArrayList<String>();
        while (fullName.lastIndexOf(46) >= 0) {
            parsedName.add(fullName.substring(fullName.lastIndexOf(46) + 1));
            fullName = fullName.substring(0, fullName.lastIndexOf(46));
        }
        parsedName.add(fullName);
        return parsedName.toArray(new String[3]);
    }

    private String getFullName(String catalogName, String schemaName, String tableName) {
        return (String)(catalogName == null ? "" : catalogName + ".") + (String)(schemaName == null ? "" : schemaName + ".") + (tableName == null ? "" : tableName);
    }

    private List<String> removeRepeats(List<String> longList) {
        ArrayList<String> shortList = new ArrayList<String>();
        for (String suggestion : longList) {
            if (shortList.contains(suggestion)) continue;
            shortList.add(suggestion);
        }
        return shortList;
    }
}

