/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.sqlexplorer;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.sqlexplorer.ISettingsProvider;
import org.jumpmind.vaadin.ui.sqlexplorer.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSettingsProvider
implements ISettingsProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    File dir;
    Settings settings;

    public DefaultSettingsProvider(String dir) {
        this(dir, null);
    }

    public DefaultSettingsProvider(String dir, String user) {
        if (StringUtils.isNotBlank((CharSequence)user)) {
            this.dir = new File(dir, user);
            this.dir.mkdirs();
        } else {
            this.dir = new File(dir);
            this.dir.mkdirs();
        }
    }

    protected File getSettingsFile() {
        return new File(this.dir, "sqlexplorer-settings.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Settings settings) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            File file = this.getSettingsFile();
            ClassLoader classloader = this.setContextClassloader();
            try (FileOutputStream os = new FileOutputStream(file, false);){
                XMLEncoder encoder = new XMLEncoder(os);
                encoder.writeObject(settings);
                encoder.close();
                this.settings = settings;
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.restoreContextClassloader(classloader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public Settings load() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            File file = this.getSettingsFile();
            if (file.exists() && file.length() > 0L) {
                ClassLoader classloader = this.setContextClassloader();
                FileInputStream is = new FileInputStream(file);
                XMLDecoder decoder = new XMLDecoder(is);
                Settings settings = (Settings)decoder.readObject();
                decoder.close();
                Settings settings2 = settings;
                is.close();
                this.restoreContextClassloader(classloader);
                return settings2;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception ex) {
                                this.log.error("Failed to load settings", (Throwable)ex);
                                FileUtils.deleteQuietly((File)file);
                                this.restoreContextClassloader(classloader);
                            }
                        }
                        catch (Throwable throwable3) {
                            this.restoreContextClassloader(classloader);
                            throw throwable3;
                        }
                    }
                }
            }
            return new Settings();
        }
    }

    protected ClassLoader setContextClassloader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Settings.class.getClassLoader());
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return classLoader;
    }

    protected void restoreContextClassloader(ClassLoader classloader) {
        try {
            Thread.currentThread().setContextClassLoader(classloader);
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
    }

    @Override
    public Settings get() {
        if (this.settings == null) {
            this.settings = this.load();
        }
        return this.settings;
    }
}

