/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.vaadin.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.Scroller;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.ResizableDialog;

public class NotifyDialog
extends ResizableDialog {
    private static final long serialVersionUID = 1L;
    boolean detailsMode = false;

    public NotifyDialog(String text, Throwable ex) {
        this("Error", text, ex, NotificationVariant.LUMO_ERROR);
    }

    public NotifyDialog(String caption, String text, Throwable ex, NotificationVariant type) {
        super(caption);
        this.setWidth("400px");
        this.setHeight("320px");
        Scroller messageArea = new Scroller();
        messageArea.setSizeFull();
        String string = StringUtils.isNotBlank((CharSequence)text) ? text : (text = ex != null ? ex.getMessage() : "");
        if (type == NotificationVariant.LUMO_ERROR) {
            this.setHeaderTitle(null);
            Span captionSpan = new Span(caption);
            captionSpan.addComponentAsFirst((Component)new Icon(VaadinIcon.BAN));
            this.getHeader().add(new Component[]{captionSpan});
        }
        String message = text;
        Label textLabel = new Label(message);
        messageArea.setContent((Component)textLabel);
        this.innerContent.add(new Component[]{messageArea});
        this.innerContent.expand(new Component[]{messageArea});
        Button detailsButton = new Button("Details");
        detailsButton.setVisible(ex != null);
        detailsButton.addClickListener((ComponentEventListener & Serializable)event -> {
            boolean bl = this.detailsMode = !this.detailsMode;
            if (this.detailsMode) {
                Object msg = "<pre>" + ExceptionUtils.getStackTrace((Throwable)ex).trim() + "</pre>";
                msg = ((String)msg).replace("\t", "    ");
                textLabel.setText((String)msg);
                detailsButton.setText("Message");
                messageArea.getStyle().set("margin", "0 0 0 16px");
                this.setHeight("600px");
                this.setWidth("1000px");
            } else {
                textLabel.setText(message);
                detailsButton.setText("Details");
                this.setWidth("400px");
                this.setHeight("320px");
            }
        });
        this.buildButtonFooter(new Component[]{detailsButton, this.buildCloseButton()});
    }

    public static void show(String caption, String text, Throwable throwable, NotificationVariant type) {
        new NotifyDialog(caption, text, throwable, type).open();
    }
}

