/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.PresenceManager;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.avatar.AvatarGroup;
import com.vaadin.flow.component.avatar.AvatarGroupVariant;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollaborationAvatarGroup
extends Composite<AvatarGroup>
implements HasSize,
HasStyle,
HasTheme,
HasOverlayClassName {
    private final SerializableSupplier<CollaborationEngine> ceSupplier;
    private final UserInfo localUser;
    private final List<UserInfo> userInfoCache = new ArrayList<UserInfo>();
    private PresenceManager presenceManager;
    private String topicId;
    private ImageProvider imageProvider;
    private ImageHandler imageHandler;
    private boolean ownAvatarVisible;

    public CollaborationAvatarGroup(UserInfo localUser, String topicId) {
        this(localUser, topicId, (SerializableSupplier<CollaborationEngine>)((SerializableSupplier & Serializable)CollaborationEngine::getInstance));
    }

    CollaborationAvatarGroup(UserInfo localUser, String topicId, SerializableSupplier<CollaborationEngine> ceSupplier) {
        this.localUser = Objects.requireNonNull(localUser, "User cannot be null");
        this.ceSupplier = ceSupplier;
        this.ownAvatarVisible = true;
        this.setTopic(topicId);
        this.refreshItems();
    }

    public void setTopic(String topicId) {
        if (Objects.equals(this.topicId, topicId)) {
            return;
        }
        if (this.presenceManager != null) {
            this.presenceManager.close();
            this.presenceManager = null;
        }
        this.topicId = topicId;
        if (topicId != null) {
            this.presenceManager = new PresenceManager((ConnectionContext)new ComponentConnectionContext((Component)this), this.localUser, topicId, this.ceSupplier);
            this.presenceManager.markAsPresent(true);
            this.presenceManager.setPresenceHandler(context -> {
                UserInfo userInfo = context.getUser();
                this.userInfoCache.add(userInfo);
                this.refreshItems();
                return (Registration & Serializable)() -> {
                    this.userInfoCache.remove(userInfo);
                    this.refreshItems();
                };
            });
        }
    }

    public Integer getMaxItemsVisible() {
        return ((AvatarGroup)this.getContent()).getMaxItemsVisible();
    }

    public void setMaxItemsVisible(Integer max) {
        ((AvatarGroup)this.getContent()).setMaxItemsVisible(max);
    }

    public void addThemeVariants(AvatarGroupVariant ... variants) {
        ((AvatarGroup)this.getContent()).addThemeVariants((ThemeVariant[])variants);
    }

    public void removeThemeVariants(AvatarGroupVariant ... variants) {
        ((AvatarGroup)this.getContent()).removeThemeVariants((ThemeVariant[])variants);
    }

    public AvatarGroup.AvatarGroupI18n getI18n() {
        return ((AvatarGroup)this.getContent()).getI18n();
    }

    public void setI18n(AvatarGroup.AvatarGroupI18n i18n) {
        ((AvatarGroup)this.getContent()).setI18n(i18n);
    }

    private void refreshItems() {
        List items = Stream.concat(Stream.of(this.localUser), this.userInfoCache.stream()).distinct().filter(user -> this.ownAvatarVisible || this.isNotLocalUser((UserInfo)user)).map(this::userToAvatarGroupItem).collect(Collectors.toList());
        ((AvatarGroup)this.getContent()).setItems(items);
    }

    private AvatarGroup.AvatarGroupItem userToAvatarGroupItem(UserInfo user) {
        AvatarGroup.AvatarGroupItem item = new AvatarGroup.AvatarGroupItem();
        item.setName(user.getName());
        item.setAbbreviation(user.getAbbreviation());
        if (this.imageHandler != null) {
            item.setImageHandler(this.imageHandler.getDownloadHandler(user));
        } else if (this.imageProvider != null) {
            item.setImageResource(this.imageProvider.getImageResource(user));
        } else {
            item.setImage(user.getImage());
        }
        item.setColorIndex(Integer.valueOf(this.getCollaborationEngine().getUserColorIndex(user)));
        return item;
    }

    private CollaborationEngine getCollaborationEngine() {
        return (CollaborationEngine)this.ceSupplier.get();
    }

    private boolean isNotLocalUser(UserInfo user) {
        return !this.localUser.equals(user);
    }

    @Deprecated(since="6.5", forRemoval=true)
    public void setImageProvider(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
        this.refreshItems();
    }

    @Deprecated(since="6.5", forRemoval=true)
    public ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageHandler(ImageHandler imageHandler) {
        this.imageHandler = imageHandler;
        this.refreshItems();
    }

    public ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public boolean isOwnAvatarVisible() {
        return this.ownAvatarVisible;
    }

    public void setOwnAvatarVisible(boolean ownAvatarVisible) {
        this.ownAvatarVisible = ownAvatarVisible;
        this.refreshItems();
    }

    public Avatar createOwnAvatar() {
        return new Avatar(this.localUser.getName(), this.localUser.getImage());
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/CollaborationAvatarGroup", (String)"6.5");
    }

    @FunctionalInterface
    public static interface ImageHandler {
        public DownloadHandler getDownloadHandler(UserInfo var1);
    }

    @FunctionalInterface
    @Deprecated(since="6.5", forRemoval=true)
    public static interface ImageProvider {
        public AbstractStreamResource getImageResource(UserInfo var1);
    }
}

