/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.http;

import com.onelogin.saml2.http.HttpResponse;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HttpResponseUtils {
    private HttpResponseUtils() {
    }

    public static String sendRedirect(HttpResponse response, String location, Map<String, String> parameters, Boolean stay) throws IOException {
        String target = location;
        if (!parameters.isEmpty()) {
            boolean first = !location.contains("?");
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    target = target + "?";
                    first = false;
                } else {
                    target = target + "&";
                }
                target = target + parameter.getKey();
                if (parameter.getValue().isEmpty()) continue;
                target = target + "=" + Util.urlEncoder(parameter.getValue());
            }
        }
        if (!stay.booleanValue()) {
            response.sendRedirect(target);
        }
        return target;
    }

    public static void sendRedirect(HttpResponse response, String location, Map<String, String> parameters) throws IOException {
        HttpResponseUtils.sendRedirect(response, location, parameters, false);
    }

    public static void sendRedirect(HttpResponse response, String location) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HttpResponseUtils.sendRedirect(response, location, parameters);
    }
}

