/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.http;

import com.onelogin.saml2.util.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface HttpRequest {
    public int getServerPort();

    public String getScheme();

    public String getServerName();

    public String getRequestURL();

    public String getRequestURI();

    public String getQueryString();

    public void invalidateSession();

    public Map<String, String[]> getParameterMap();

    default public List<String> getParameters(String name) {
        Map<String, String[]> paramsAsArray = this.getParameterMap();
        HashMap<String, List<Object>> paramsAsList = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String[]> param : paramsAsArray.entrySet()) {
            paramsAsList.put(param.getKey(), Arrays.asList((Object[])param.getValue()));
        }
        return (List)paramsAsList.get(name);
    }

    default public String getParameter(String name) {
        List<String> values = this.getParameters(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    default public String getEncodedParameter(String name, String defaultValue) {
        String value = this.getEncodedParameter(name);
        return value != null ? value : Util.urlEncoder(defaultValue);
    }

    default public String getEncodedParameter(String name) {
        String queryString = this.getQueryString();
        Matcher matcher = Pattern.compile(Pattern.quote(name) + "=([^&#]+)").matcher(queryString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return Util.urlEncoder(this.getParameter(name));
    }
}

