/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.util.LogSummaryAppender;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class StatisticFlushJob
extends AbstractJob {
    public StatisticFlushJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Stat Flush", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("0 0/5 * * * *").description("Write statistics out to the database");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        this.engine.getStatisticManager().flush();
        this.engine.getPurgeService().purgeStats(force);
        this.purgeLogSummaryAppender();
    }

    protected void purgeLogSummaryAppender() {
        LogSummaryAppender appender = LogSummaryAppenderUtils.getLogSummaryAppender();
        if (appender != null) {
            appender.purgeOlderThan(System.currentTimeMillis() - this.engine.getParameterService().getLong("purge.log.summary.retention.minutes", 60L) * 60000L);
        }
    }
}

