/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

public class JobDefaults {
    public static final String EVERY_5_MINUTES = "0 0/5 * * * *";
    public static final String EVERY_10_SECONDS = "10000";
    public static final String EVERY_30_SECONDS = "30000";
    public static final String EVERY_MINUTE = "60000";
    public static final String EVERY_FIFTEEN_MINUTES = "900000";
    public static final String EVERY_HOUR = "3600000";
    public static final String EVERY_NIGHT_AT_MIDNIGHT = "0 0 0 * * *";
    public static final String EVERY_TEN_MINUTES_AT_THE_ONE_OCLOCK_HOUR = "0 0/10 1 * * *";
    private String schedule;
    private boolean requiresRegisteration = true;
    private String description;
    private boolean enabled = true;

    public JobDefaults schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    public JobDefaults enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public JobDefaults requiresRegisteration(boolean requiresRegisteration) {
        this.requiresRegisteration = requiresRegisteration;
        return this;
    }

    public JobDefaults description(String description) {
        this.description = description;
        return this;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public boolean isRequiresRegisteration() {
        return this.requiresRegisteration;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static String getJobNameParameter(String name) {
        if (name != null) {
            return name.toLowerCase().replace(' ', '.');
        }
        return null;
    }

    public static String getStartParameter(String name) {
        return String.format("start.%s.job", JobDefaults.getJobNameParameter(name));
    }

    public static String getPeriodicParameter(String name) {
        return String.format("job.%s.period.time.ms", JobDefaults.getJobNameParameter(name));
    }

    public static String getCronParameter(String name) {
        return String.format("job.%s.cron", JobDefaults.getJobNameParameter(name));
    }
}

