/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.job.OracleNoOrderHeartbeat;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class HeartbeatJob
extends AbstractJob {
    public HeartbeatJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Heartbeat", engine, taskScheduler);
        if (engine.getParameterService().is("oracle.sequence.noorder")) {
            engine.getExtensionService().addExtensionPoint((IExtensionPoint)new OracleNoOrderHeartbeat(engine));
        }
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().description("Record a heartbeat").requiresRegisteration(false).schedule("900000");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        if (this.engine.getClusterService().lock(this.getName())) {
            try {
                this.engine.getDataService().heartbeat(false);
            }
            finally {
                this.engine.getClusterService().unlock(this.getName());
            }
        }
    }
}

