/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ext;

import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.kafka.KafkaPlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.JdbcBatchBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;

public class BulkDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory,
ISymmetricEngineAware,
IBuiltInExtensionPoint {
    protected ISymmetricEngine engine;

    public String getTypeName() {
        return "bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        IDatabasePlatform platform = this.engine.getTargetDialect().getPlatform();
        if (this.engine.getParameterService().is("db.jdbc.bulk.execute.batch.override", false)) {
            return new JdbcBatchBulkDatabaseWriter(symmetricDialect.getPlatform(), platform, symmetricDialect.getTablePrefix(), this.buildParameterDatabaseWriterSettings(conflictSettings));
        }
        return new JdbcBatchBulkDatabaseWriter(symmetricDialect.getPlatform(), platform, symmetricDialect.getTablePrefix(), this.buildParameterDatabaseWriterSettings(conflictSettings));
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return !(platform instanceof KafkaPlatform);
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
    }
}

