/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.informix;

import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.informix.InformixTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class InformixSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "drop function $(defaultSchema).$(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from sysprocedures where procname = '$(functionName)' and owner = (select trim(user) from sysmaster:sysdual)";
    static final String SQL_PAGE_SIZE = "select pagesize from systables where tabname = 'systables'";
    private int pageSize = 2048;

    public InformixSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new InformixTriggerTemplate(this);
        try {
            this.pageSize = platform.getSqlTemplate().queryForInt(SQL_PAGE_SIZE, new Object[0]);
            this.log.info("Page size is {}", (Object)this.pageSize);
        }
        catch (Exception e) {
            this.log.debug("Unable to query page size", (Throwable)e);
        }
    }

    public Database readSymmetricSchemaFromXml() {
        Database database = super.readSymmetricSchemaFromXml();
        String prefix = this.parameterService.getTablePrefix() + "_";
        if (this.pageSize == 2048) {
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "file_name", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "file_name", "55");
            Table table = database.findTable(prefix + "registration_request");
            if (table != null) {
                table.removeIndex(0);
            }
        }
        return database;
    }

    protected void reconfigureTableColumn(Database database, String prefix, String tableName, String columnName, String size) {
        Column column;
        Table table = database.findTable(prefix + tableName);
        if (table != null && (column = table.findColumn(columnName)) != null) {
            column.setSize(size);
        }
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalog, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from systriggers where lower(trigname) = ?", new Object[]{triggerName.toLowerCase()}) > 0;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_triggers_set_disabled('t'), " + this.parameterService.getTablePrefix() + "_node_set_disabled(?) from sysmaster:sysdual", new Object[]{nodeId});
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("select " + this.parameterService.getTablePrefix() + "_triggers_set_disabled('f'), " + this.parameterService.getTablePrefix() + "_node_set_disabled(null) from sysmaster:sysdual", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "not $(defaultSchema)" + this.parameterService.getTablePrefix() + "_triggers_disabled()";
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        String nodeSetDisabled;
        String nodeDisabled;
        String triggersSetDisabled;
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (!this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            String sql = "create function $(defaultSchema).$(functionName)() returning boolean;                                                                                                                                                                      define global symmetric_triggers_disabled boolean default 'f';                                                                                                                                         return symmetric_triggers_disabled;                                                                                                                                                                 end function;                                                                                                                                                          ";
            this.install(sql, triggersDisabled, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, triggersSetDisabled = this.parameterService.getTablePrefix() + "_triggers_set_disabled")) {
            String sql = "create function $(defaultSchema).$(functionName)(is_disabled boolean) returning boolean;                                                                                                                                                   define global symmetric_triggers_disabled boolean default 'f';                                                                                                                                         let symmetric_triggers_disabled = is_disabled;                                                                                                                                                         return symmetric_triggers_disabled;                                                                                                                                                                 end function;                                                                                                                                                          ";
            this.install(sql, triggersSetDisabled, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            String sql = "create function $(defaultSchema).$(functionName)() returning varchar(50);                                                                                                                                                                  define global symmetric_node_disabled varchar(50) default null;                                                                                                                                        return symmetric_node_disabled;                                                                                                                                                                     end function;                                                                                                                                                          ";
            this.install(sql, nodeDisabled, ddl);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, nodeSetDisabled = this.parameterService.getTablePrefix() + "_node_set_disabled")) {
            String sql = "create function $(defaultSchema).$(functionName)(node_id varchar(50)) returning integer;                                                                                                                                                   define global symmetric_node_disabled varchar(50) default null;                                                                                                                                        let symmetric_node_disabled = node_id;                                                                                                                                                                 return 1;                                                                                                                                                                                           end function;                                                                                                                                                          ";
            this.install(sql, nodeSetDisabled, ddl);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String nodeSetDisabled;
        String nodeDisabled;
        String triggersSetDisabled;
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            this.uninstall(SQL_DROP_FUNCTION, triggersDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, triggersSetDisabled = this.parameterService.getTablePrefix() + "_triggers_set_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, triggersSetDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, nodeDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, nodeSetDisabled = this.parameterService.getTablePrefix() + "_node_set_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, nodeSetDisabled);
        }
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public boolean isBlobSyncSupported() {
        return false;
    }

    public boolean isClobSyncSupported() {
        return false;
    }

    public void cleanDatabase() {
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }
}

