/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.dbcp2.BasicDataSource;
import org.h2.tools.Shell;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.Version;

public class DbSqlCommand
extends AbstractCommandLauncher {
    private static final String OPTION_SQL = "sql";
    private static final String OPTION_SQLFILE = "sqlfile";
    private static final String OPTION_USE_SYM_DB = "use-sym-db";
    private Options localOptions;

    public DbSqlCommand() {
        super("dbsql", "", "DbSql.Option.");
    }

    public static void main(String[] args) {
        new DbSqlCommand().execute(args);
    }

    @Override
    protected void printHelp(CommandLine cmd, Options options) {
        System.out.println(this.app + " version " + Version.version());
        System.out.println("Provides a sql shell for database interaction from the command line.\n");
        super.printHelp(cmd, options);
    }

    @Override
    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.addOption(options, null, OPTION_SQL, true);
        this.addOption(options, null, OPTION_SQLFILE, true);
        this.addOption(options, null, OPTION_USE_SYM_DB, false);
        this.localOptions = options;
    }

    @Override
    protected boolean printHelpIfNoOptionsAreProvided() {
        return false;
    }

    @Override
    protected boolean requiresPropertiesFile(CommandLine line) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeWithOptions(CommandLine line) throws Exception {
        BasicDataSource basicDataSource = (BasicDataSource)this.getDatabasePlatform(false, line.hasOption(OPTION_USE_SYM_DB)).getDataSource();
        String url = basicDataSource.getUrl();
        String user = basicDataSource.getUserName();
        String password = basicDataSource.getPassword();
        String driver = basicDataSource.getDriverClassName();
        Shell shell = new Shell();
        if (line.hasOption(OPTION_SQL)) {
            String sql = line.getOptionValue(OPTION_SQL);
            shell.runTool(new String[]{"-url", url, "-user", user, "-password", password, "-driver", driver, "-sql", sql});
        } else if (line.hasOption(OPTION_SQLFILE)) {
            File file = new File(line.getOptionValue(OPTION_SQLFILE));
            if (file.exists()) {
                try (BufferedReader br = null;){
                    br = new BufferedReader(new FileReader(file));
                    String sql = null;
                    while ((sql = br.readLine()) != null) {
                        if ((sql = sql.trim()).endsWith(";")) {
                            sql = sql.substring(0, sql.length() - 1);
                        }
                        if (sql.length() <= 0) continue;
                        System.out.println(sql);
                        shell.runTool(new String[]{"-url", url, "-user", user, "-password", password, "-driver", driver, "-sql", sql});
                    }
                }
            } else {
                System.err.println("-------------------------------------------------------------------------------");
                System.err.println("File does not exist: " + file.getPath());
                System.err.println("-------------------------------------------------------------------------------");
                this.printHelp(line, this.localOptions);
            }
        } else {
            shell.runTool(new String[]{"-url", url, "-user", user, "-password", password, "-driver", driver});
        }
        return true;
    }
}

