/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.platform.generic.GenericJdbcDatabasePlatform;
import org.jumpmind.db.sql.LogSqlBuilder;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BasicDataSourceFactory;
import org.jumpmind.db.util.BasicDataSourcePropertyConstants;
import org.jumpmind.extension.IProgressListener;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.JdbcSymmetricDialectFactory;
import org.jumpmind.symmetric.ext.ICached;
import org.jumpmind.symmetric.io.stage.BatchStagingManager;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.job.JobManager;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ClientExtensionService;
import org.jumpmind.symmetric.service.impl.NodeService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.statistic.StatisticManager;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.util.SnapshotUtil;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.xml.sax.InputSource;

public class ClientSymmetricEngine
extends AbstractSymmetricEngine {
    private static final Logger log = LoggerFactory.getLogger(ClientSymmetricEngine.class);
    public static final String DEPLOYMENT_TYPE_CLIENT = "client";
    protected File propertiesFile;
    protected Properties properties;
    protected DataSource dataSource;
    protected ApplicationContext springContext;

    public ClientSymmetricEngine(DataSource dataSource, ApplicationContext springContext, Properties properties, boolean registerEngine) {
        super(registerEngine);
        this.deploymentType = DEPLOYMENT_TYPE_CLIENT;
        this.dataSource = dataSource;
        this.springContext = springContext;
        this.properties = properties;
        this.init();
        this.setDeploymentSubTypeByProperties(properties);
    }

    public ClientSymmetricEngine(DataSource dataSource, Properties properties, boolean registerEngine) {
        super(registerEngine);
        this.deploymentType = DEPLOYMENT_TYPE_CLIENT;
        this.dataSource = dataSource;
        this.properties = properties;
        this.init();
        this.setDeploymentSubTypeByProperties(properties);
    }

    public ClientSymmetricEngine(File propertiesFile, boolean registerEngine) {
        super(registerEngine);
        this.deploymentType = DEPLOYMENT_TYPE_CLIENT;
        this.propertiesFile = propertiesFile;
        this.init();
        this.setDeploymentSubTypeByProperties(this.properties);
    }

    public ClientSymmetricEngine(File propertiesFile) {
        this(propertiesFile, true);
    }

    public ClientSymmetricEngine(File propertiesFile, ApplicationContext springContext) {
        super(true);
        this.deploymentType = DEPLOYMENT_TYPE_CLIENT;
        this.propertiesFile = propertiesFile;
        this.springContext = springContext;
        this.init();
        this.setDeploymentSubTypeByProperties(this.properties);
    }

    public ClientSymmetricEngine(Properties properties, boolean registerEngine) {
        super(registerEngine);
        this.deploymentType = DEPLOYMENT_TYPE_CLIENT;
        this.properties = properties;
        this.init();
        this.setDeploymentSubTypeByProperties(properties);
    }

    protected final void setDeploymentSubTypeByProperties(Properties properties) {
        String deploymentSubType = SymmetricUtils.getDeploymentSubType((Properties)properties);
        if (deploymentSubType != null) {
            this.setDeploymentSubType(deploymentSubType);
        }
    }

    public ClientSymmetricEngine(Properties properties) {
        this(properties, true);
    }

    public ClientSymmetricEngine() {
        this((Properties)null, true);
    }

    public ClientSymmetricEngine(boolean registerEngine) {
        this((Properties)null, registerEngine);
    }

    protected SecurityServiceFactory.SecurityServiceType getSecurityServiceType() {
        return SecurityServiceFactory.SecurityServiceType.CLIENT;
    }

    protected void init() {
        Thread shutdownHook = new Thread(() -> this.destroy());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            LogSummaryAppenderUtils.initialize();
            if (this.getSecurityServiceType() == SecurityServiceFactory.SecurityServiceType.CLIENT) {
                SymmetricUtils.logNotices();
            }
            super.init();
            this.dataSource = (DataSource)this.platform.getDataSource();
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setProperties((Properties)this.parameterService.getAllParameters());
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(this.springContext);
            ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            ArrayList<Object> extensionLocations = new ArrayList<Object>();
            extensionLocations.add("classpath:/symmetric-ext-points.xml");
            if (this.registerEngine) {
                extensionLocations.add("classpath:/symmetric-jmx.xml");
            }
            String xml = this.parameterService.getString("extensions.xml");
            File file = new File(this.parameterService.getTempDirectory(), "extension.xml");
            FileUtils.deleteQuietly((File)file);
            if (StringUtils.isNotBlank((CharSequence)xml)) {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    factory.setNamespaceAware(true);
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.parse(new InputSource(new StringReader(xml)));
                    FileUtils.write((File)file, (CharSequence)xml, (Charset)Charset.defaultCharset(), (boolean)false);
                    extensionLocations.add("file:" + file.getAbsolutePath());
                }
                catch (Exception e) {
                    log.error("Invalid extensions.xml parameter.");
                }
            }
            try {
                ctx.setConfigLocations(extensionLocations.toArray(new String[extensionLocations.size()]));
                ctx.refresh();
                this.springContext = ctx;
                ((ClientExtensionService)this.extensionService).setSpringContext(this.springContext);
                this.extensionService.refresh();
            }
            catch (Exception ex) {
                log.error("Failed to initialize the extension points.  Please fix the problem and restart the server.", (Throwable)ex);
                throw ex;
            }
            if (this.nodeService instanceof NodeService) {
                ((NodeService)this.nodeService).setNodePasswordFilter((INodePasswordFilter)this.extensionService.getExtensionPoint(INodePasswordFilter.class));
            }
        }
        catch (RuntimeException ex) {
            this.destroy();
            throw ex;
        }
    }

    public synchronized boolean start() {
        if (this.springContext instanceof AbstractApplicationContext) {
            AbstractApplicationContext ctx = (AbstractApplicationContext)this.springContext;
            try {
                if (!ctx.isActive()) {
                    ctx.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.start();
    }

    public synchronized void stop() {
        if (this.springContext != null && this.springContext instanceof AbstractApplicationContext) {
            AbstractApplicationContext ctx = (AbstractApplicationContext)this.springContext;
            try {
                if (ctx.isActive()) {
                    ctx.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
    }

    public static BasicDataSource createBasicDataSource(File propsFile) {
        TypedProperties properties = PropertiesUtil.createTypedPropertiesFactory((File)propsFile, null).reload();
        return BasicDataSourceFactory.create((TypedProperties)properties, (ISecurityService)SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties));
    }

    protected ISymmetricDialect createSymmetricDialect() {
        return JdbcSymmetricDialectFactory.getInstance().create((IParameterService)this.parameterService, this.platform);
    }

    protected ISymmetricDialect createTargetDialect() {
        if (this.parameterService.is("load.only", false)) {
            TypedProperties properties = new TypedProperties();
            String prefix = "target.";
            this.copyProperties(properties, prefix, BasicDataSourcePropertyConstants.ALL_PROPS);
            this.copyProperties(properties, prefix, ParameterConstants.ALL_JDBC_PARAMS);
            this.copyProperties(properties, "", ParameterConstants.ALL_KAFKA_PARAMS);
            this.copyProperties(properties, "", ParameterConstants.ALL_GOOGLE_BIG_QUERY_PARAMS);
            this.copyProperties(properties, "", ParameterConstants.ALL_MONGODB_PARAMS);
            this.copyProperties(properties, "", ParameterConstants.ALL_COSMOS_PARAMS);
            IDatabasePlatform targetPlatform = ClientSymmetricEngine.createDatabasePlatform(null, properties, null, true, true, this.parameterService.is("start.log.miner.job", false));
            if (targetPlatform instanceof GenericJdbcDatabasePlatform) {
                targetPlatform.getDatabaseInfo().setNotNullColumnsSupported(this.parameterService.is(prefix + "create.table.not.null.columns.supported", true));
            }
            return JdbcSymmetricDialectFactory.getInstance().create((IParameterService)this.parameterService, targetPlatform);
        }
        return this.getSymmetricDialect();
    }

    private void copyProperties(TypedProperties properties, String prefix, String[] parameterNames) {
        for (String name : parameterNames) {
            properties.put((Object)name, (Object)this.parameterService.getString(prefix + name));
        }
    }

    protected IDatabasePlatform createDatabasePlatform(TypedProperties properties) {
        IDatabasePlatform platform = ClientSymmetricEngine.createDatabasePlatform(this.springContext, properties, this.dataSource, Boolean.parseBoolean(System.getProperty("symmetric.wait.for.database.enabled", "true")));
        return platform;
    }

    public static IDatabasePlatform createDatabasePlatform(ApplicationContext springContext, TypedProperties properties, DataSource dataSource, boolean waitOnAvailableDatabase) {
        return ClientSymmetricEngine.createDatabasePlatform(springContext, properties, dataSource, waitOnAvailableDatabase, properties.is("load.only"), properties.is("start.log.miner.job"));
    }

    public static IDatabasePlatform createDatabasePlatform(ApplicationContext springContext, TypedProperties properties, DataSource dataSource, boolean waitOnAvailableDatabase, boolean isLoadOnly, boolean isLogBased) {
        log.info("Initializing connection to database");
        if (dataSource == null) {
            String springBeanName;
            String jndiName = properties.getProperty("db.jndi.name");
            if (StringUtils.isNotBlank((CharSequence)jndiName)) {
                try {
                    log.info("Looking up datasource in jndi.  The jndi name is {}", (Object)jndiName);
                    JndiObjectFactoryBean jndiFactory = new JndiObjectFactoryBean();
                    jndiFactory.setJndiName(jndiName);
                    jndiFactory.afterPropertiesSet();
                    dataSource = (DataSource)jndiFactory.getObject();
                    if (dataSource == null) {
                        throw new SymmetricException("Could not locate the configured datasource in jndi.  The jndi name is %s", new Object[]{jndiName});
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new SymmetricException("Could not locate the configured datasource in jndi.  The jndi name is %s", (Throwable)e, new Object[]{jndiName});
                }
                catch (NamingException e) {
                    throw new SymmetricException("Could not locate the configured datasource in jndi.  The jndi name is %s", (Throwable)e, new Object[]{jndiName});
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(springBeanName = properties.getProperty("db.spring.bean.name"))) && springContext != null) {
                log.info("Using datasource from spring.  The spring bean name is {}", (Object)springBeanName);
                dataSource = (DataSource)springContext.getBean(springBeanName);
            }
            String dbUrl = properties.get("db.url");
            if (dataSource == null && JdbcDatabasePlatformFactory.isJdbcUrl((String)dbUrl)) {
                dataSource = BasicDataSourceFactory.create((TypedProperties)properties, (ISecurityService)SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties));
            }
        }
        if (waitOnAvailableDatabase && dataSource != null) {
            ClientSymmetricEngine.waitForAvailableDatabase(dataSource);
        }
        boolean delimitedIdentifierMode = properties.is("db.delimited.identifier.mode", true);
        boolean caseSensitive = !properties.is("db.metadata.ignore.case", true);
        return JdbcDatabasePlatformFactory.getInstance().create(dataSource, ClientSymmetricEngine.createSqlTemplateSettings(properties), delimitedIdentifierMode, caseSensitive, isLoadOnly, isLogBased);
    }

    protected static SqlTemplateSettings createSqlTemplateSettings(TypedProperties properties) {
        SqlTemplateSettings settings = new SqlTemplateSettings();
        settings.setFetchSize(properties.getInt("db.jdbc.streaming.results.fetch.size", 1000));
        settings.setQueryTimeout(properties.getInt("db.sql.query.timeout.seconds", 300));
        settings.setBatchSize(properties.getInt("db.jdbc.execute.batch.size", 100));
        settings.setBatchBulkLoaderSize(properties.getInt("db.jdbc.bulk.execute.batch.size", 25));
        settings.setOverrideIsolationLevel(properties.getInt("db.jdbc.isolation.level", -1));
        settings.setReadStringsAsBytes(properties.is("db.read.strings.as.bytes", false));
        settings.setTreatBinaryAsLob(properties.is("treat.binary.as.lob.enabled", true));
        settings.setRightTrimCharValues(properties.is("right.trim.char.values", false));
        settings.setAllowUpdatesWithResults(properties.is("allow.updates.with.results", false));
        settings.setAllowTriggerCreateOrReplace(properties.is("trigger.allow.create.or.replace", true));
        settings.setIncludeRowIdentifierAsColumn(properties.is("include.rowidentifier.as.column", false));
        LogSqlBuilder logSqlBuilder = new LogSqlBuilder();
        logSqlBuilder.setLogSlowSqlThresholdMillis(properties.getInt("log.slow.sql.threshold.millis", 20000));
        logSqlBuilder.setConsoleLogSlowSqlThresholdMillis(properties.getInt("console.log.slow.sql.threshold.millis", 5000));
        logSqlBuilder.setLogSqlParametersInline(properties.is("log.sql.parameters.inline", true));
        settings.setLogSqlBuilder(logSqlBuilder);
        if (settings.getOverrideIsolationLevel() >= 0) {
            log.info("Overriding isolation level to " + settings.getOverrideIsolationLevel());
        }
        settings.setJdbcLobHandling(SqlTemplateSettings.JdbcLobHandling.valueOf((String)FormatUtils.upper((String)properties.get("oracle.jdbc.lob.handling", SqlTemplateSettings.JdbcLobHandling.PLAIN.name()))));
        settings.setProperties(properties);
        return settings;
    }

    protected IExtensionService createExtensionService() {
        return new ClientExtensionService((ISymmetricEngine)this, this.springContext);
    }

    protected IJobManager createJobManager() {
        return new JobManager((ISymmetricEngine)this);
    }

    protected IStagingManager createStagingManager() {
        Object directory = this.parameterService.getString("staging.dir");
        if (StringUtils.isBlank((CharSequence)directory)) {
            directory = this.parameterService.getTempDirectory();
        } else {
            String engineName = this.parameterService.getEngineName();
            if (StringUtils.isNotBlank((CharSequence)engineName)) {
                directory = (String)directory + File.separator + engineName;
            }
        }
        String stagingManagerClassName = this.parameterService.getString("staging.manager.class");
        if (stagingManagerClassName != null) {
            try {
                Constructor<?> cons = Class.forName(stagingManagerClassName).getConstructor(ISymmetricEngine.class, String.class);
                return (IStagingManager)cons.newInstance(new Object[]{this, directory});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new BatchStagingManager((ISymmetricEngine)this, (String)directory);
    }

    protected IStatisticManager createStatisticManager() {
        String statisticManagerClassName = this.parameterService.getString("statistic.manager.class");
        if (statisticManagerClassName != null) {
            try {
                Constructor<?> cons = Class.forName(statisticManagerClassName).getConstructor(ISymmetricEngine.class);
                return (IStatisticManager)cons.newInstance(new Object[]{this});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new StatisticManager((IParameterService)this.parameterService, this.nodeService, this.configurationService, this.statisticService, this.clusterService);
    }

    /*
     * Exception decompiling
     */
    protected static void waitForAvailableDatabase(DataSource dataSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[MONITOR]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ITypedPropertiesFactory createTypedPropertiesFactory() {
        return PropertiesUtil.createTypedPropertiesFactory((File)this.propertiesFile, (Properties)this.properties);
    }

    public synchronized void destroy() {
        super.destroy();
        if (this.springContext != null && this.springContext instanceof AbstractApplicationContext) {
            try {
                ((AbstractApplicationContext)this.springContext).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.springContext = null;
        if (this.platform != null) {
            this.platform.shutdown();
        }
        if (this.dataSource != null && this.dataSource instanceof BasicDataSource) {
            try {
                ((BasicDataSource)this.dataSource).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public List<File> listSnapshots() {
        File snapshotsDir = SnapshotUtil.getSnapshotDirectory((ISymmetricEngine)this);
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles((File)snapshotsDir, (String[])new String[]{"zip"}, (boolean)false));
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return -o1.compareTo(o2);
            }
        });
        return files;
    }

    public ApplicationContext getSpringContext() {
        return this.springContext;
    }

    public File snapshot(IProgressListener listener) {
        return SnapshotUtil.createSnapshot((ISymmetricEngine)this, listener);
    }

    public void clearCaches() {
        super.clearCaches();
        for (ICached cachedExtension : this.extensionService.getExtensionPointList(ICached.class)) {
            cachedExtension.flushCache();
        }
    }
}

