/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import org.jdom2.Element;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.integrate.AbstractXmlPublisherExtensionPoint;
import org.jumpmind.symmetric.integrate.IPublisherFilter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.util.Context;

public class XmlPublisherDatabaseWriterFilter
extends AbstractXmlPublisherExtensionPoint
implements IPublisherFilter,
INodeGroupExtensionPoint {
    public static final String PUBLISH_ON_COMPLETE = "COMPLETE";
    public static final String PUBLISH_ON_COMMIT = "COMMIT";
    protected boolean loadDataInTargetDatabase = true;
    protected String publishOn = "COMPLETE";

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        if (this.tableNamesToPublishAsGroup == null || this.tableNamesToPublishAsGroup.contains(table.getName())) {
            Element xml;
            String[] rowData = data.getParsedData("rowData");
            if (data.getDataEventType() == DataEventType.DELETE) {
                rowData = data.getParsedData("oldData");
            }
            if ((xml = this.getXmlFromCache((Context)context, context.getBatch().getBinaryEncoding(), table.getColumnNames(), rowData, table.getPrimaryKeyColumnNames(), data.getParsedData("pkData"))) != null) {
                this.toXmlElement(data.getDataEventType(), xml, table.getCatalog(), table.getSchema(), table.getName(), table.getColumnNames(), rowData, table.getPrimaryKeyColumnNames(), data.getParsedData("pkData"));
            }
        }
        return this.loadDataInTargetDatabase;
    }

    public void setLoadDataInTargetDatabase(boolean loadDataInTargetDatabase) {
        this.loadDataInTargetDatabase = loadDataInTargetDatabase;
    }

    public void setPublishOn(String publishOn) {
        this.publishOn = publishOn;
    }

    public void afterWrite(DataContext context, Table table, CsvData data) {
    }

    public boolean handlesMissingTable(DataContext context, Table table) {
        return false;
    }

    public void earlyCommit(DataContext context) {
    }

    public void batchComplete(DataContext context) {
        if (PUBLISH_ON_COMPLETE.equals(this.publishOn)) {
            this.publish(context);
        }
    }

    public void batchCommitted(DataContext context) {
        if (PUBLISH_ON_COMMIT.equals(this.publishOn)) {
            this.publish(context);
        }
    }

    private void publish(DataContext context) {
        if (this.doesXmlExistToPublish((Context)context)) {
            this.finalizeXmlAndPublish((Context)context);
        }
    }

    public void batchRolledback(DataContext context) {
    }
}

