/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.writer;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.ITableMap;
import com.anfcorp.stores.integration.IWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMapRouterWriter
implements IWriter<List<ITableMap>> {
    static final Log logger = LogFactory.getLog(TableMapRouterWriter.class);
    Map<String, IWriter<Object>> writersByTable;

    @Override
    public void write(List<ITableMap> data) {
        for (ITableMap tableMap : data) {
            IWriter<Object> writer = this.writersByTable.get(tableMap.getTableName());
            if (writer != null) {
                writer.write(tableMap);
                continue;
            }
            logger.warn((Object)("Could not find a writer for table map data with a table of " + tableMap.getTableName()));
        }
    }

    @Override
    public void close() {
        for (IWriter<Object> w : this.writersByTable.values()) {
            try {
                w.close();
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public void open(Context context) {
        for (IWriter<Object> w : this.writersByTable.values()) {
            w.open(context);
        }
    }

    public void setWritersByTable(Map<String, IWriter<Object>> writersByTable) {
        this.writersByTable = writersByTable;
    }
}

