/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.writer;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IWriter;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcWriter
implements IWriter<Map<String, Object>>,
BeanNameAware {
    static final Log logger = LogFactory.getLog(SimpleJdbcWriter.class);
    protected DataSource dataSource;
    protected SimpleJdbcTemplate jdbcTemplate;
    protected String updateSql;
    protected String insertSql;
    protected String deleteSql;
    protected String deleteIndicator;
    protected int insertCount = 0;
    protected int updateStatsCount = 0;
    protected int deleteCount = 0;
    protected int writeCount = 0;
    protected int numberOfWritesBeforeStatusLogged = 1000;
    protected String beanName;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void write(Map<String, Object> data) {
        int updateCount = 0;
        if (data != null && StringUtils.isBlank((String)((String)data.get("IGNORE")))) {
            ++this.writeCount;
            if (this.deleteIndicator != null && data.get(this.deleteIndicator) != null) {
                if (0 == (this.deleteCount += this.jdbcTemplate.update(this.deleteSql, data))) {
                    logger.warn((Object)("Expected to delete a row, but none where found for " + data));
                }
            } else if ((this.updateSql == null || (updateCount = this.jdbcTemplate.update(this.updateSql, data)) == 0) && this.insertSql != null) {
                this.insertCount += this.jdbcTemplate.update(this.insertSql, data);
            } else if (updateCount > 0) {
                this.updateStatsCount += updateCount;
            } else {
                logger.warn((Object)("Could not find a valid operation that effects row data for " + data + updateCount + this.insertSql));
            }
            if (this.writeCount % this.numberOfWritesBeforeStatusLogged == 0) {
                this.logStatus();
            }
        } else {
            logger.warn((Object)"Received null data.  Talking no action.");
        }
    }

    private void logStatus() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Inserts=" + this.insertCount + ", Updates=" + this.updateStatsCount + ", Deletes=" + this.deleteCount));
        }
    }

    @Override
    public void close() {
        this.logStatus();
        logger.debug((Object)"Closing jdbc writer");
    }

    @Override
    public void open(Context context) {
        this.writeCount = 0;
        this.insertCount = 0;
        this.deleteCount = 0;
        this.updateStatsCount = 0;
        logger.debug((Object)"Opening jdbc writer");
        this.jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }

    public void setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
    }

    public void setDeleteIndicator(String deleteIndicator) {
        this.deleteIndicator = deleteIndicator;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNumberOfWritesBeforeStatusLogged(int numberOfWritesBeforeStatusLogged) {
        this.numberOfWritesBeforeStatusLogged = numberOfWritesBeforeStatusLogged;
    }
}

