/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.util;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SequenceGenerator {
    static final Log logger = LogFactory.getLog(SequenceGenerator.class);
    private DataSource dataSource;
    private boolean cycle = true;
    private int incrementBy = 1;
    private int startWith = -1;
    private int numberToCache = -1;
    private int maxValue = -1;
    private int minValue = -1;
    private boolean order = true;
    private String sequencePrefix = "ANF_";
    private String sequenceSuffix = "_SEQ";

    public int nextVal(String sequenceIdentifier) {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        try {
            return template.queryForInt("SELECT " + this.buildSequenceNameBaseOn(sequenceIdentifier) + ".NEXTVAL from DUAL", new Object[0]);
        }
        catch (DataAccessException ex) {
            if (this.isDatabaseObjectMissing(ex)) {
                this.create(sequenceIdentifier);
                return this.nextVal(sequenceIdentifier);
            }
            throw ex;
        }
    }

    public int currentVal(String sequenceIdentifier) {
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        try {
            return template.queryForInt("SELECT " + this.buildSequenceNameBaseOn(sequenceIdentifier) + ".CURRVAL from DUAL", new Object[0]);
        }
        catch (DataAccessException ex) {
            if (this.isDatabaseObjectMissing(ex)) {
                this.create(sequenceIdentifier);
                return this.currentVal(sequenceIdentifier);
            }
            throw ex;
        }
    }

    public void create(String sequenceIdentifier) {
        StringBuilder ddl = new StringBuilder("CREATE SEQUENCE ");
        ddl.append(this.buildSequenceNameBaseOn(sequenceIdentifier));
        if (this.startWith >= 0) {
            ddl.append(" START WITH " + this.startWith);
        }
        if (this.incrementBy > 0) {
            ddl.append(" INCREMENT BY " + this.incrementBy);
        }
        if (this.minValue > 0) {
            ddl.append(" MINVALUE " + this.minValue);
        }
        if (this.maxValue > 0) {
            ddl.append(" MAXVALUE " + this.maxValue);
        }
        if (this.cycle) {
            ddl.append(" CYCLE ");
        }
        if (this.numberToCache > 0) {
            ddl.append(" CACHE " + this.numberToCache);
        }
        if (this.order) {
            ddl.append(" ORDER");
        }
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        int count = template.update(ddl.toString(), new Object[0]);
        logger.info((Object)("Update count was: " + count + " for ddl: " + ddl));
    }

    public void remove(String sequenceIdentifier) {
        String seq = this.buildSequenceNameBaseOn(sequenceIdentifier);
        String ddl = "DROP SEQUENCE " + seq;
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        try {
            int count = template.update(ddl, new Object[0]);
            logger.info((Object)("Update count was: " + count + " for ddl: " + ddl));
        }
        catch (DataAccessException ex) {
            if (this.isDatabaseObjectMissing(ex)) {
                logger.info((Object)("The sequence does not exist: " + seq));
            }
            throw ex;
        }
    }

    private boolean isDatabaseObjectMissing(Throwable ex) {
        SQLException sql;
        Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
        return root instanceof SQLException && (sql = (SQLException)root).getErrorCode() == 2289;
    }

    private final String buildSequenceNameBaseOn(String sequenceIdentifier) {
        return this.sequencePrefix + sequenceIdentifier + this.sequenceSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setIncrementBy(int incrementBy) {
        this.incrementBy = incrementBy;
    }

    public void setNumberToCache(int numberToCache) {
        this.numberToCache = numberToCache;
    }

    public void setStartWith(int startWith) {
        this.startWith = startWith;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setOrder(boolean order) {
        this.order = order;
    }

    public void setSequencePrefix(String sequencePrefix) {
        this.sequencePrefix = sequencePrefix;
    }

    public void setSequenceSuffix(String sequenceSuffix) {
        this.sequenceSuffix = sequenceSuffix;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }
}

