/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.transform;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IFormatter;
import com.anfcorp.stores.integration.ITransform;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTemplateTransform
implements ITransform<Map<String, Object>, String> {
    protected String template;
    protected Map<String, IFormatter> formatters;
    protected String execKey;
    protected String firstTimeString = "";
    protected boolean firstTimeOutput = true;
    boolean escapeForXmlCharacterData = true;
    boolean escapeCommaForXmlCharacterData = true;
    boolean escapeQuotesForXmlCharacterData = true;
    private final IFormatter DEFAULT_FORMATTER = new IFormatter(){

        public String format(Object o) {
            if (o != null) {
                return o.toString().trim();
            }
            return null;
        }
    };

    @Override
    public boolean isTransformable(Object data) {
        return data instanceof Map && (this.execKey == null || ((Map)data).containsKey(this.execKey));
    }

    @Override
    public String transform(Context context, Map<String, Object> data) {
        String xml = this.template;
        for (String key : data.keySet()) {
            xml = xml.replace("%" + key + "%", this.format(key, data.get(key)));
        }
        if (this.firstTimeOutput) {
            xml = this.firstTimeString + xml;
            this.firstTimeOutput = false;
        }
        return xml;
    }

    @Override
    public void reset() {
        this.firstTimeOutput = true;
    }

    protected String format(String key, Object data) {
        String content;
        IFormatter f = null;
        if (this.formatters != null) {
            f = this.formatters.get(key);
        }
        if (f == null) {
            f = this.DEFAULT_FORMATTER;
        }
        if ((content = f.format(data)) != null && this.escapeCommaForXmlCharacterData) {
            content = content.replaceAll(",", " ");
        }
        if (content != null && this.escapeQuotesForXmlCharacterData) {
            content = content.replaceAll("'", "");
            content = content.replaceAll("\"", "");
        }
        return this.formatForXml(content);
    }

    protected String formatForXml(String content) {
        if (content != null && this.escapeForXmlCharacterData) {
            return content.replaceAll("&", "&amp;");
        }
        if (content == null) {
            return "";
        }
        return content;
    }

    public void setTemplate(String xmlTemplate) {
        this.template = xmlTemplate;
    }

    public void setFormatters(Map<String, IFormatter> formatters) {
        this.formatters = formatters;
    }

    public void setExecKey(String execKey) {
        this.execKey = execKey;
    }

    public String getFirstTimeString() {
        return this.firstTimeString;
    }

    public void setFirstTimeString(String firstTimeString) {
        this.firstTimeString = firstTimeString;
    }

    public void setEscapeForXmlCharacterData(boolean escapeForXmlCharacterData) {
        this.escapeForXmlCharacterData = escapeForXmlCharacterData;
    }

    public void setEscapeCommaForXmlCharacterData(boolean escapeCommaForXmlCharacterData) {
        this.escapeCommaForXmlCharacterData = escapeCommaForXmlCharacterData;
    }

    public void setEscapeQuotesForXmlCharacterData(boolean escapeQuotesForXmlCharacterData) {
        this.escapeQuotesForXmlCharacterData = escapeQuotesForXmlCharacterData;
    }
}

