/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.integration.reader;

import com.anfcorp.stores.integration.Context;
import com.anfcorp.stores.integration.IReader;
import com.anfcorp.stores.integration.ReaderException;
import com.anfcorp.stores.integration.XmlMessageRouter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementFromParameterReader
implements IReader<Element> {
    static final Log logger = LogFactory.getLog(XmlMessageRouter.class);
    protected Integer parameterIndex;
    protected String xmlElementName;
    protected String removeElementName;
    transient Iterator<Element> elements;
    boolean atLeastOneElement = false;

    @Override
    public boolean hasNext() {
        boolean hasNext;
        boolean bl = hasNext = this.elements != null && this.elements.hasNext();
        if (!hasNext && !this.atLeastOneElement) {
            logger.warn((Object)("Could not find expected XML element: " + this.xmlElementName));
        } else {
            this.atLeastOneElement = true;
        }
        return hasNext;
    }

    @Override
    public Element next() {
        return this.elements.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
    }

    @Override
    public void open(Context context) {
        this.atLeastOneElement = false;
        String xml = (String)((Object[])context.get("couplingArgs"))[this.parameterIndex];
        StringReader stringReader = new StringReader(xml);
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            Document doc = saxBuilder.build((Reader)stringReader);
            this.documentBeforeRemove(context, doc);
            if (this.removeElementName != null) {
                Iterator selectToRemove = doc.getDescendants((Filter)new ElementFilter(this.removeElementName));
                ArrayList<Element> toRemove = new ArrayList<Element>();
                while (selectToRemove.hasNext()) {
                    Element removeMe = (Element)selectToRemove.next();
                    toRemove.add(removeMe);
                }
                for (Element removeMe : toRemove) {
                    removeMe.getParent().removeContent((Content)removeMe);
                }
            }
            this.documentAfterRemove(context, doc);
            this.elements = doc.getRootElement().getDescendants((Filter)new ElementFilter(this.xmlElementName));
        }
        catch (JDOMException e) {
            throw new ReaderException("Trouble parsing xml document", e);
        }
        catch (IOException e) {
            throw new ReaderException("Trouble parsing xml document", e);
        }
    }

    protected void documentBeforeRemove(Context context, Document xmlDocument) {
    }

    protected void documentAfterRemove(Context context, Document xmlDocument) {
    }

    public void setParameterIndex(Integer parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    public void setXmlElementName(String xmlElementName) {
        this.xmlElementName = xmlElementName;
    }

    public void setRemoveElementName(String removeElementName) {
        this.removeElementName = removeElementName;
    }
}

