/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;

final class JavaSerializer<T extends Serializable>
implements Serializer<T> {
    private static final JavaSerializer<Serializable> INSTANCE = new JavaSerializer();

    JavaSerializer() {
    }

    static <T extends Serializable> JavaSerializer<T> instance() {
        return INSTANCE;
    }

    @Override
    public Reader<T> createReader(InputStream in) {
        ObjectInputStream ois;
        try {
            ois = new ObjectInputStream(in);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Reader<T>(){

            @Override
            public T read() throws IOException {
                try {
                    return (Serializable)ois.readObject();
                }
                catch (EOFException e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() throws IOException {
                ois.close();
            }
        };
    }

    @Override
    public Writer<T> createWriter(OutputStream out) {
        ObjectOutputStream oos;
        try {
            oos = new ObjectOutputStream(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Writer<T>(){

            @Override
            public void write(T value) throws IOException {
                oos.writeObject(value);
            }

            @Override
            public void close() throws IOException {
                oos.close();
            }

            @Override
            public void flush() throws IOException {
                oos.flush();
            }
        };
    }
}

