/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.signature;

import com.anfcorp.stores.signature.JavaPosSignature;
import com.anfcorp.stores.signature.PosSignature;
import com.anfcorp.stores.signature.SignatureFactory;
import com.anfcorp.stores.signature.SignatureInterface;
import com.anfcorp.stores.signature.element.Line;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeByteAsciiSignature
extends PosSignature
implements SignatureInterface {
    private static final int SEGMENT_START = 96;
    private static final byte PEN_UP = 112;
    private static final int CLEAR_LOWER_HALF = 240;
    private static final int GET_LOWER_HALF = 15;
    private static final int X_BIT_10 = 8;
    private static final int X_BIT_9 = 4;
    private static final int Y_BIT_10 = 2;
    private static final int Y_BIT_9 = 1;
    private static final int X_BIT_8 = 32;
    private static final int X_BIT_7 = 16;
    private static final int X_BIT_6 = 8;
    private static final int X_BIT_5 = 4;
    private static final int X_BIT_4 = 2;
    private static final int X_BIT_3 = 1;
    private static final int Y_BIT_8 = 32;
    private static final int Y_BIT_7 = 16;
    private static final int Y_BIT_6 = 8;
    private static final int Y_BIT_5 = 4;
    private static final int Y_BIT_4 = 2;
    private static final int Y_BIT_3 = 1;
    private static final int X_BIT_2 = 32;
    private static final int X_BIT_1 = 16;
    private static final int X_BIT_0 = 8;
    private static final int Y_BIT_2 = 4;
    private static final int Y_BIT_1 = 2;
    private static final int Y_BIT_0 = 1;
    private byte[] bArray = null;

    protected ThreeByteAsciiSignature() {
    }

    @Override
    public Vector<Line> buildSignatureVector(String s) {
        Vector<Line> ret = new Vector<Line>();
        if (s != null) {
            if (this.bArray == null) {
                try {
                    this.bArray = Base64.decodeBase64((byte[])s.getBytes());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            if (this.bArray != null) {
                Point previousPoint = null;
                Point currentPoint = null;
                for (int i = 0; i < this.bArray.length; ++i) {
                    if (this.bArray[i] == 112) {
                        previousPoint = null;
                        currentPoint = null;
                        continue;
                    }
                    if ((this.bArray[i] & 0xF0) == 96) {
                        previousPoint = null;
                        currentPoint = null;
                        if (this.bArray.length <= i + 3) continue;
                        int firstTwoDigits = this.bArray[i] & 0xF;
                        int xPrefix = this.bArray[++i];
                        int yPrefix = this.bArray[++i];
                        int suffix = this.bArray[++i];
                        xPrefix -= 32;
                        yPrefix -= 32;
                        suffix -= 32;
                        BigInteger xBigInt = BigInteger.valueOf(0L);
                        xBigInt = (firstTwoDigits & 8) != 0 ? xBigInt.setBit(10) : xBigInt;
                        xBigInt = (firstTwoDigits & 4) != 0 ? xBigInt.setBit(9) : xBigInt;
                        xBigInt = (xPrefix & 0x20) != 0 ? xBigInt.setBit(8) : xBigInt;
                        xBigInt = (xPrefix & 0x10) != 0 ? xBigInt.setBit(7) : xBigInt;
                        xBigInt = (xPrefix & 8) != 0 ? xBigInt.setBit(6) : xBigInt;
                        xBigInt = (xPrefix & 4) != 0 ? xBigInt.setBit(5) : xBigInt;
                        xBigInt = (xPrefix & 2) != 0 ? xBigInt.setBit(4) : xBigInt;
                        xBigInt = (xPrefix & 1) != 0 ? xBigInt.setBit(3) : xBigInt;
                        xBigInt = (suffix & 0x20) != 0 ? xBigInt.setBit(2) : xBigInt;
                        xBigInt = (suffix & 0x10) != 0 ? xBigInt.setBit(1) : xBigInt;
                        xBigInt = (suffix & 8) != 0 ? xBigInt.setBit(0) : xBigInt;
                        BigInteger yBigInt = BigInteger.valueOf(0L);
                        yBigInt = (firstTwoDigits & 2) != 0 ? yBigInt.setBit(10) : yBigInt;
                        yBigInt = (firstTwoDigits & 1) != 0 ? yBigInt.setBit(9) : yBigInt;
                        yBigInt = (yPrefix & 0x20) != 0 ? yBigInt.setBit(8) : yBigInt;
                        yBigInt = (yPrefix & 0x10) != 0 ? yBigInt.setBit(7) : yBigInt;
                        yBigInt = (yPrefix & 8) != 0 ? yBigInt.setBit(6) : yBigInt;
                        yBigInt = (yPrefix & 4) != 0 ? yBigInt.setBit(5) : yBigInt;
                        yBigInt = (yPrefix & 2) != 0 ? yBigInt.setBit(4) : yBigInt;
                        yBigInt = (yPrefix & 1) != 0 ? yBigInt.setBit(3) : yBigInt;
                        yBigInt = (suffix & 4) != 0 ? yBigInt.setBit(2) : yBigInt;
                        yBigInt = (suffix & 2) != 0 ? yBigInt.setBit(1) : yBigInt;
                        yBigInt = (suffix & 1) != 0 ? yBigInt.setBit(0) : yBigInt;
                        int x = xBigInt.intValue();
                        int y = yBigInt.intValue();
                        currentPoint = new Point(x, y);
                        continue;
                    }
                    if (this.bArray.length <= i + 2) continue;
                    int xPrefix = this.bArray[i];
                    int yPrefix = this.bArray[++i];
                    int suffix = this.bArray[++i];
                    yPrefix -= 32;
                    suffix -= 32;
                    BigInteger xBigInt = BigInteger.valueOf(0L);
                    if (((xPrefix -= 32) & 0x20) != 0) {
                        for (int j = 32; j >= 8; --j) {
                            xBigInt = xBigInt.setBit(j);
                        }
                    }
                    xBigInt = (xPrefix & 0x10) != 0 ? xBigInt.setBit(7) : xBigInt;
                    xBigInt = (xPrefix & 8) != 0 ? xBigInt.setBit(6) : xBigInt;
                    xBigInt = (xPrefix & 4) != 0 ? xBigInt.setBit(5) : xBigInt;
                    xBigInt = (xPrefix & 2) != 0 ? xBigInt.setBit(4) : xBigInt;
                    xBigInt = (xPrefix & 1) != 0 ? xBigInt.setBit(3) : xBigInt;
                    xBigInt = (suffix & 0x20) != 0 ? xBigInt.setBit(2) : xBigInt;
                    xBigInt = (suffix & 0x10) != 0 ? xBigInt.setBit(1) : xBigInt;
                    xBigInt = (suffix & 8) != 0 ? xBigInt.setBit(0) : xBigInt;
                    BigInteger yBigInt = BigInteger.valueOf(0L);
                    if ((yPrefix & 0x20) != 0) {
                        for (int j = 32; j >= 8; --j) {
                            yBigInt = yBigInt.setBit(j);
                        }
                    }
                    yBigInt = (yPrefix & 0x10) != 0 ? yBigInt.setBit(7) : yBigInt;
                    yBigInt = (yPrefix & 8) != 0 ? yBigInt.setBit(6) : yBigInt;
                    yBigInt = (yPrefix & 4) != 0 ? yBigInt.setBit(5) : yBigInt;
                    yBigInt = (yPrefix & 2) != 0 ? yBigInt.setBit(4) : yBigInt;
                    yBigInt = (yPrefix & 1) != 0 ? yBigInt.setBit(3) : yBigInt;
                    yBigInt = (suffix & 4) != 0 ? yBigInt.setBit(2) : yBigInt;
                    yBigInt = (suffix & 2) != 0 ? yBigInt.setBit(1) : yBigInt;
                    yBigInt = (suffix & 1) != 0 ? yBigInt.setBit(0) : yBigInt;
                    int x = xBigInt.intValue();
                    int y = yBigInt.intValue();
                    if (currentPoint == null) continue;
                    previousPoint = currentPoint;
                    currentPoint = new Point(currentPoint);
                    currentPoint.translate(x, y);
                    if (previousPoint == null || currentPoint == null) continue;
                    ret.add(new Line(previousPoint, currentPoint));
                }
            }
        }
        return ret;
    }

    @Override
    protected BufferedImage buildSignatureImage(Vector<Line> vectorOfLines) {
        BufferedImage bi = super.buildSignatureImage(vectorOfLines);
        AffineTransform t = AffineTransform.getScaleInstance(1.0, -1.0);
        t.translate(0.0, -bi.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(t, 1);
        bi = op.filter(bi, new BufferedImage(this.getWidth(), this.getHeight(), 1));
        return bi;
    }

    @Override
    public boolean isValid(String s) {
        boolean ret = false;
        if (s != null) {
            try {
                this.bArray = Base64.decodeBase64((byte[])s.getBytes());
                if (this.bArray != null && this.bArray.length > 0 && (this.bArray[0] & 0xF0) == 96) {
                    ret = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    protected float getStrokeAdjustmentFactor() {
        return 1.1f;
    }

    @Override
    public String convert(Vector<Line> v) {
        ArrayList<Byte> l = new ArrayList<Byte>();
        ConvertState state = new ConvertState();
        for (Line line : v) {
            if (state.getPreviousPoint() == null) {
                state.setPreviousPoint(line.getBeginPoint());
                state.setCurrentPoint(line.getEndPoint());
                this.createSegmentStart(state, l);
                continue;
            }
            if (state.getPreviousPoint().equals(line.getBeginPoint())) {
                state.setCurrentPoint(line.getEndPoint());
                this.createNextPoint(state, l);
                continue;
            }
            state.setPreviousPoint(null);
            state.setCurrentPoint(null);
        }
        l.add((byte)112);
        byte[] bArray = new byte[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            bArray[i] = (Byte)l.get(i);
        }
        return new String(Base64.encodeBase64((byte[])bArray));
    }

    private void createSegmentStart(ConvertState state, List<Byte> l) {
        byte segStart = 96;
        byte xPrefix = 0;
        byte yPrefix = 0;
        byte suffix = 0;
        BigInteger bi = BigInteger.valueOf(state.getPreviousPoint().x);
        segStart = (byte)(segStart | (bi.testBit(10) ? 8 : 0));
        segStart = (byte)(segStart | (bi.testBit(9) ? 4 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(8) ? 32 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(7) ? 16 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(6) ? 8 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(5) ? 4 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(4) ? 2 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(3) ? 1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 32 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 16 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? 8 : 0));
        bi = BigInteger.valueOf(state.getPreviousPoint().y);
        segStart = (byte)(segStart | (bi.testBit(10) ? 2 : 0));
        segStart = (byte)(segStart | (bi.testBit(9) ? 1 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(8) ? 32 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(7) ? 16 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(6) ? 8 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(5) ? 4 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(4) ? 2 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(3) ? 1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 4 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 2 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? 1 : 0));
        xPrefix = (byte)(xPrefix + 32);
        yPrefix = (byte)(yPrefix + 32);
        suffix = (byte)(suffix + 32);
        l.add(segStart);
        l.add(xPrefix);
        l.add(yPrefix);
        l.add(suffix);
        bi = BigInteger.valueOf(state.getCurrentPoint().x - state.getPreviousPoint().x);
        xPrefix = 0;
        yPrefix = 0;
        suffix = 0;
        xPrefix = (byte)(xPrefix | (bi.byteValue() < 0 ? 32 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(7) ? 16 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(6) ? 8 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(5) ? 4 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(4) ? 2 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(3) ? (byte)1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 32 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 16 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? 8 : 0));
        bi = BigInteger.valueOf(state.getCurrentPoint().y - state.getPreviousPoint().y);
        yPrefix = (byte)(yPrefix | (bi.byteValue() < 0 ? 32 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(7) ? 16 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(6) ? 8 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(5) ? 4 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(4) ? 2 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(3) ? (byte)1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 4 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 2 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? (byte)1 : 0));
        xPrefix = (byte)(xPrefix + 32);
        yPrefix = (byte)(yPrefix + 32);
        suffix = (byte)(suffix + 32);
        l.add(xPrefix);
        l.add(yPrefix);
        l.add(suffix);
        state.setPreviousPoint(new Point(state.getCurrentPoint()));
    }

    private void createNextPoint(ConvertState state, List<Byte> l) {
        byte yPrefix = 0;
        byte xPrefix = 0;
        byte suffix = 0;
        BigInteger bi = BigInteger.valueOf(state.getCurrentPoint().x - state.getPreviousPoint().x);
        xPrefix = (byte)(xPrefix | (bi.byteValue() < 0 ? 32 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(7) ? 16 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(6) ? 8 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(5) ? 4 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(4) ? 2 : 0));
        xPrefix = (byte)(xPrefix | (bi.testBit(3) ? 1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 32 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 16 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? 8 : 0));
        bi = BigInteger.valueOf(state.getCurrentPoint().y - state.getPreviousPoint().y);
        yPrefix = (byte)(yPrefix | (bi.byteValue() < 0 ? 32 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(7) ? 16 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(6) ? 8 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(5) ? 4 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(4) ? 2 : 0));
        yPrefix = (byte)(yPrefix | (bi.testBit(3) ? 1 : 0));
        suffix = (byte)(suffix | (bi.testBit(2) ? 4 : 0));
        suffix = (byte)(suffix | (bi.testBit(1) ? 2 : 0));
        suffix = (byte)(suffix | (bi.testBit(0) ? 1 : 0));
        xPrefix = (byte)(xPrefix + 32);
        yPrefix = (byte)(yPrefix + 32);
        suffix = (byte)(suffix + 32);
        l.add(xPrefix);
        l.add(yPrefix);
        l.add(suffix);
        state.setPreviousPoint(new Point(state.getCurrentPoint()));
    }

    public static void main(String[] args) {
        ThreeByteAsciiSignature tbas = new ThreeByteAsciiSignature();
        JavaPosSignature jps = new JavaPosSignature();
        String originalString = "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";
        if (tbas.isValid(originalString)) {
            Vector<Line> v = tbas.buildSignatureVector(originalString);
            String convertedString = tbas.convert(v);
            System.out.println(originalString);
            System.out.println(convertedString);
            System.out.println(originalString.equals(convertedString));
        } else if (jps.isValid(new String(Base64.decodeBase64((byte[])originalString.getBytes())))) {
            String convertedString = null;
            try {
                convertedString = SignatureFactory.convert(new String(Base64.decodeBase64((byte[])originalString.getBytes())), ThreeByteAsciiSignature.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            System.out.println(convertedString);
        } else {
            System.out.println("Not a valid string!");
        }
    }

    private class ConvertState {
        Point previousPoint = null;
        Point currentPoint = null;

        private ConvertState() {
        }

        void setCurrentPoint(Point currentPoint) {
            this.currentPoint = currentPoint;
        }

        Point getCurrentPoint() {
            return this.currentPoint;
        }

        void setPreviousPoint(Point previousPoint) {
            this.previousPoint = previousPoint;
        }

        Point getPreviousPoint() {
            return this.previousPoint;
        }
    }
}

