/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.signature;

import com.anfcorp.stores.signature.PosSignature;
import com.anfcorp.stores.signature.element.Line;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigSignature
extends PosSignature {
    private static final int ONEBYTE_MASK = 255;
    private static final int ID0_OFFSET = 0;
    private static final int ID1_OFFSET = 1;
    private static final int ID_LENGTH = 2;
    private static final int SIGOFFSET0_OFFSET = 3;
    private static final int SIGOFFSET1_OFFSET = 2;
    private static final int SIGSIZE0_OFFSET = 5;
    private static final int SIGSIZE1_OFFSET = 4;
    private static final int SIGVERSION_OFFSET = 6;
    private static final int SIGSTATUS_OFFSET = 7;
    private static final int SIGWIDTH0_OFFSET = 9;
    private static final int SIGWIDTH1_OFFSET = 8;
    private static final int SIGHEIGHT0_OFFSET = 11;
    private static final int SIGHEIGHT1_OFFSET = 10;
    private static final int SIGHDPI0_OFFSET = 13;
    private static final int SIGHDPI1_OFFSET = 12;
    private static final int SIGVDPI0_OFFSET = 15;
    private static final int SIGVDPI1_OFFSET = 14;
    private static final char ID0 = 'M';
    private static final char ID1 = 'P';
    private static final int PEN_UP = 16384;
    private byte[] bArray = null;

    protected SigSignature() {
    }

    @Override
    public Vector<Line> buildSignatureVector(String s) {
        Vector<Line> ret = new Vector<Line>();
        if (s != null && this.bArray == null) {
            try {
                this.bArray = Base64.decodeBase64((byte[])s.getBytes());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (this.bArray != null && this.bArray.length > 0) {
            Point previousPoint = null;
            Point2D currentPoint = null;
            String identifier = null;
            int sigOffset = 0;
            int sigSizeBytes = 0;
            byte sigVersion = 0;
            byte sigStatus = 0;
            int sigWidth = 0;
            int sigHeight = 0;
            int sigHdpi = 0;
            int sigVdpi = 0;
            if (this.bArray[0] == 77 && this.bArray[1] == 80) {
                identifier = new String(this.bArray, 0, 2);
            }
            sigOffset = this.bArray[3] << 8 | this.bArray[2] & 0xFF;
            sigSizeBytes = this.bArray[5];
            sigSizeBytes = sigSizeBytes << 8 | this.bArray[4] & 0xFF;
            sigVersion = this.bArray[6];
            sigStatus = this.bArray[7];
            sigWidth = this.bArray[9] << 8 | this.bArray[8] & 0xFF;
            sigHeight = this.bArray[11] << 8 | this.bArray[10] & 0xFF;
            sigHdpi = this.bArray[13] << 8 | this.bArray[12] & 0xFF;
            sigVdpi = this.bArray[15] << 8 | this.bArray[14] & 0xFF;
            if (this.bArray.length != sigSizeBytes + sigOffset) {
                throw new RuntimeException("identifier=" + identifier + " sigOffset=" + sigOffset + " sigSizeBytes=" + sigSizeBytes + " sigVersion=" + sigVersion + " sigStatus=" + sigStatus + " sigWidth=" + sigWidth + " sigHeight=" + sigHeight + " sigHdpi=" + sigHdpi + " sigVdpi=" + sigVdpi);
            }
            for (int i = sigOffset - 1; i < this.bArray.length; ++i) {
                if (this.bArray.length > i + 3 && (this.bArray[i] << 8 | this.bArray[i + 1] & 0xFF) == 16384 && (this.bArray[i + 2] << 8 | this.bArray[i + 3] & 0xFF) == 16384) {
                    ++i;
                    previousPoint = null;
                    currentPoint = null;
                    continue;
                }
                int x = 0;
                int y = 0;
                if (this.bArray.length > i + 3) {
                    x = this.bArray[i] << 8 | this.bArray[i + 1] & 0xFF;
                    ++i;
                    y = this.bArray[++i] << 8 | this.bArray[i + 1] & 0xFF;
                    ++i;
                    previousPoint = currentPoint == null ? null : (Point)currentPoint.clone();
                    currentPoint = new Point(x, y);
                }
                if (previousPoint == null || currentPoint == null) continue;
                ret.add(new Line(previousPoint, (Point)currentPoint));
            }
        }
        return ret;
    }

    @Override
    protected float getStrokeAdjustmentFactor() {
        return 1.0f;
    }

    @Override
    public boolean isValid(String s) {
        boolean ret = false;
        if (s != null) {
            try {
                this.bArray = Base64.decodeBase64((byte[])s.getBytes());
                if (this.bArray != null && this.bArray.length > 0 && this.bArray[0] == 77 && this.bArray[1] == 80) {
                    ret = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public String convert(Vector<Line> v) {
        throw new RuntimeException("convert is not implemented!");
    }
}

