/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.signature;

import com.anfcorp.stores.signature.PosSignature;
import com.anfcorp.stores.signature.SignatureInterface;
import com.anfcorp.stores.signature.element.Line;
import java.awt.Point;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPosSignature
extends PosSignature
implements SignatureInterface {
    private static final String validIndicator = "x" + String.valueOf(65535);
    private static final int penOffX = 65535;
    private static final int penOffY = 65535;
    private static final String xToken = "x";
    private static final String yToken = "y";

    protected JavaPosSignature() {
    }

    @Override
    protected float getStrokeAdjustmentFactor() {
        return 2.0f;
    }

    @Override
    public Vector<Line> buildSignatureVector(String s) {
        String[] splitString;
        Vector<Line> vectorOfLines = new Vector<Line>();
        if (s != null && (splitString = s.split("[xy]")).length > 0) {
            try {
                Integer lastX = null;
                Integer lastY = null;
                Integer x = null;
                Integer y = null;
                for (int i = 1; i < splitString.length; ++i) {
                    x = Integer.valueOf(splitString[i]);
                    y = Integer.valueOf(splitString[++i]);
                    if (65535 == x && 65535 == y) {
                        x = null;
                        y = null;
                    }
                    if (lastX != null && lastY != null && x != null && y != null) {
                        vectorOfLines.add(new Line(new Point(lastX, lastY), new Point(x, y)));
                    }
                    lastX = x;
                    lastY = y;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return vectorOfLines;
    }

    @Override
    public boolean isValid(String s) {
        boolean ret = false;
        if (s != null && s.length() >= 6 && s.substring(0, 6).equalsIgnoreCase(validIndicator)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public String convert(Vector<Line> v) {
        throw new RuntimeException("convert is not implemented!");
    }
}

