/*
 * Decompiled with CFR 0.152.
 */
package de.f0rce.ace.util;

import elemental.json.JsonObject;

public class AceSelection {
    private int startRow;
    private int startColumn;
    private int endRow;
    private int endColumn;
    private int startIndex;
    private int endIndex;
    private String selectedText;

    public AceSelection() {
        this.startRow = 0;
        this.startColumn = 0;
        this.endRow = 0;
        this.endColumn = 0;
        this.startIndex = 0;
        this.endIndex = 0;
        this.selectedText = "";
    }

    public AceSelection(JsonObject selectionObject) {
        JsonObject startObject = selectionObject.getObject("start");
        this.startRow = (int)startObject.getNumber("row");
        this.startColumn = (int)startObject.getNumber("column");
        JsonObject endObject = selectionObject.getObject("end");
        this.endRow = (int)endObject.getNumber("row");
        this.endColumn = (int)endObject.getNumber("column");
        JsonObject indexObject = selectionObject.getObject("index");
        this.startIndex = (int)indexObject.getNumber("start");
        this.endIndex = (int)indexObject.getNumber("end");
        this.selectedText = selectionObject.getString("selectedText");
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public boolean compareTo(AceSelection a) {
        return a.getStartRow() == this.startRow && a.getStartColumn() == this.startColumn && a.getStartIndex() == this.startIndex && a.getEndRow() == this.endRow && a.getEndColumn() == this.endColumn && a.getEndIndex() == this.endIndex && a.getSelectedText().equals(this.selectedText);
    }
}

