/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.encryption.client.service;

import com.anfcorp.stores.encryption.client.service.EncryptionConstants;
import com.anfcorp.stores.encryption.client.service.ErrorCode;
import com.anfcorp.stores.encryption.client.service.StoresSecurityException;
import com.anfcorp.stores.encryption.client.service.StoresSecurityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoresSecurityServiceImpl
implements StoresSecurityService {
    private static final Logger logger = LogManager.getLogger(StoresSecurityServiceImpl.class);

    @Override
    public String hash(String strToHash) throws StoresSecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] messageDigest = md.digest(strToHash.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            String hashtext = no.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (Exception ex) {
            logger.error("Error while hashing: " + ex.getMessage());
            throw new StoresSecurityException(ex.getMessage(), ErrorCode.ERROR_CODE_HASH);
        }
    }

    @Override
    public SecretKeySpec getKeySpec(File file) throws StoresSecurityException {
        logger.info("GetKeySpec from file:" + file.getAbsolutePath());
        SecretKeySpec secretKeySpec = null;
        try {
            FileInputStream fileIn = new FileInputStream(file.getAbsolutePath());
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            secretKeySpec = (SecretKeySpec)objectIn.readObject();
            objectIn.close();
        }
        catch (Exception e) {
            logger.error("Error while getKeySpec from file: " + e.getMessage());
            throw new StoresSecurityException(e.getMessage(), ErrorCode.ERROR_CODE_KEYSPEC);
        }
        logger.info("Completed getKeySpec from file:" + file.getAbsolutePath());
        return secretKeySpec;
    }

    @Override
    public String encrypt(List<SecretKeySpec> secretKeySpecList, String strToEncrypt) throws StoresSecurityException {
        logger.info("Start util.encrypt:" + strToEncrypt);
        if (strToEncrypt == null || strToEncrypt.equals("")) {
            logger.info("Not encrypting empty/null input:" + strToEncrypt);
            return strToEncrypt;
        }
        String encryptedString = "";
        for (SecretKeySpec secretKeySpec : secretKeySpecList) {
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKeySpec);
                byte[] b1 = Base64.encodeBase64((byte[])cipher.doFinal(strToEncrypt.getBytes(Charset.defaultCharset())), (boolean)false);
                encryptedString = new String(b1, StandardCharsets.UTF_8);
                try {
                    encryptedString = this.addSalt(strToEncrypt, encryptedString);
                }
                catch (Exception e) {
                    logger.error("Failed to addSalt while encrypting:" + strToEncrypt);
                    logger.error(e.getMessage());
                }
                logger.info("End util.encrypt:" + strToEncrypt);
                return encryptedString;
            }
            catch (Exception e) {
                logger.error("Failed to encrypt with a key. Trying to Encrypt:" + strToEncrypt);
                logger.error(e.getMessage());
            }
        }
        if (encryptedString.equals("")) {
            logger.error("Error while encrypting from Util using keyspecList: " + strToEncrypt);
            throw new StoresSecurityException("Error while encrypting: " + strToEncrypt, ErrorCode.ERROR_CODE_ENCRYPTION);
        }
        return encryptedString;
    }

    @Override
    public String decrypt(List<SecretKeySpec> secretKeySpecList, String inStrToDecrypt) throws StoresSecurityException {
        logger.info("Start util.decrypt:" + inStrToDecrypt);
        if (inStrToDecrypt == null || inStrToDecrypt.equals("")) {
            logger.error("Not decrypting empty/null input:" + inStrToDecrypt);
            return inStrToDecrypt;
        }
        String decryptedString = "";
        String saltString = null;
        String strToDecrypt = inStrToDecrypt;
        if (inStrToDecrypt.startsWith("crypto") && inStrToDecrypt.contains("|")) {
            String[] strOutput = inStrToDecrypt.split("\\|");
            saltString = strOutput[0];
            strToDecrypt = inStrToDecrypt.substring(saltString.length());
        }
        for (SecretKeySpec secretKeySpec : secretKeySpecList) {
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, secretKeySpec);
                decryptedString = new String(cipher.doFinal(Base64.decodeBase64((byte[])strToDecrypt.getBytes())));
                if (saltString != null && !this.verifySalt(decryptedString, saltString)) {
                    throw new StoresSecurityException("Error while decrypting - verifySalt process: String :" + inStrToDecrypt, ErrorCode.ERROR_CODE_DECRYPTION);
                }
                logger.info("End decrypt:" + inStrToDecrypt);
                return decryptedString;
            }
            catch (Exception e) {
                logger.error("Failed to decrypt with a key. Trying to Decrypt:" + inStrToDecrypt);
                logger.error(e.getMessage());
            }
        }
        if (decryptedString.equals("")) {
            logger.error("Error while decrypting from Util : " + inStrToDecrypt);
            throw new StoresSecurityException("Error while decrypting: String :" + inStrToDecrypt, ErrorCode.ERROR_CODE_DECRYPTION);
        }
        return decryptedString;
    }

    @Override
    public ArrayList<SecretKeySpec> getKeySpecList(File file) throws StoresSecurityException {
        ArrayList secretKeySpecList = null;
        try {
            logger.info("Begin getKeySpecList:" + file.getAbsolutePath());
            FileInputStream fileIn = new FileInputStream(file.getAbsolutePath());
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            secretKeySpecList = (ArrayList)objectIn.readObject();
            objectIn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while getKeySpecList:" + e.getMessage());
            throw new StoresSecurityException(e.getMessage(), ErrorCode.ERROR_CODE_KEYSPEC);
        }
        logger.info("End getKeySpecList. Size of list:" + secretKeySpecList.size());
        return secretKeySpecList;
    }

    private String addSalt(String strToEncrypt, String encryptedString) {
        int strLen = strToEncrypt.length();
        String lastChar = strToEncrypt.substring(strLen - 1);
        if (lastChar.equals("\\")) {
            lastChar = "\\\\";
        }
        String saltString = "crypto" + (strLen + EncryptionConstants.SALT_LENGTH) + lastChar + "|";
        return saltString + encryptedString;
    }

    private static String removeLastCharRegex(String s) {
        return s == null ? null : s.replaceAll(".$", "");
    }

    private boolean verifySalt(String decryptedString, String saltString) {
        if (!saltString.startsWith("crypto")) {
            return false;
        }
        saltString = saltString.replaceFirst("crypto", "");
        saltString = StoresSecurityServiceImpl.removeLastCharRegex(saltString);
        int strLen = Integer.parseInt(saltString) - EncryptionConstants.SALT_LENGTH;
        return decryptedString.length() == strLen;
    }
}

