/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hbase;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class HbaseDdlBuilder
extends AbstractDdlBuilder {
    public HbaseDdlBuilder() {
        super("hbase");
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setMaxSize("TIMESTAMP", 9);
    }

    @Override
    protected void writePrimaryKeyStmt(Table table, Column[] primaryKeyColumns, StringBuilder ddl) {
        ddl.append("CONSTRAINT NAME PRIMARY KEY (");
        for (int idx = 0; idx < primaryKeyColumns.length; ++idx) {
            this.printIdentifier(this.getColumnName(primaryKeyColumns[idx]), ddl);
            if (idx >= primaryKeyColumns.length - 1) continue;
            ddl.append(", ");
        }
        ddl.append(")");
    }

    @Override
    public void writeCopyDataStatement(Table sourceTable, Table targetTable, LinkedHashMap<Column, Column> columnMap, StringBuilder ddl) {
        ddl.append("UPSERT INTO ");
        ddl.append(this.getFullyQualifiedTableNameShorten(targetTable));
        ddl.append(" (");
        Iterator<Column> columnIt = columnMap.values().iterator();
        while (columnIt.hasNext()) {
            this.printIdentifier(this.getColumnName(columnIt.next()), ddl);
            if (!columnIt.hasNext()) continue;
            ddl.append(",");
        }
        ddl.append(") SELECT ");
        Iterator<Map.Entry<Column, Column>> columnsIt = columnMap.entrySet().iterator();
        while (columnsIt.hasNext()) {
            Map.Entry<Column, Column> entry = columnsIt.next();
            this.writeCastExpression(entry.getKey(), entry.getValue(), ddl);
            if (!columnsIt.hasNext()) continue;
            ddl.append(",");
        }
        ddl.append(" FROM ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printEndOfStatement(ddl);
    }
}

