/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.cassandra.CassandraDMLStatement;
import org.jumpmind.db.platform.cassandra.CassandraDdlBuilder;
import org.jumpmind.db.platform.cassandra.CassandraDdlReader;
import org.jumpmind.db.platform.cassandra.CassandraSqlTemplate;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class CassandraPlatform
extends AbstractDatabasePlatform {
    Map<String, Map<String, Table>> metaData = new HashMap<String, Map<String, Table>>();
    protected Session session;
    protected Cluster cluster;

    public CassandraPlatform(SqlTemplateSettings settings, String contactPoint) {
        super(settings);
        this.cluster = Cluster.builder().addContactPoint(contactPoint).build();
        this.session = this.cluster.connect();
        this.buildMetaData();
    }

    @Override
    public String getName() {
        return "cassandra";
    }

    @Override
    public String getDefaultSchema() {
        return null;
    }

    @Override
    public String getDefaultCatalog() {
        return null;
    }

    @Override
    public <T> T getDataSource() {
        return null;
    }

    @Override
    public boolean isLob(Column column) {
        return false;
    }

    @Override
    public IDdlBuilder getDdlBuilder() {
        return new CassandraDdlBuilder();
    }

    @Override
    public IDdlReader getDdlReader() {
        return new CassandraDdlReader(this);
    }

    @Override
    public ISqlTemplate getSqlTemplate() {
        return new CassandraSqlTemplate();
    }

    @Override
    public ISqlTemplate getSqlTemplateDirty() {
        return new CassandraSqlTemplate();
    }

    @Override
    public DmlStatement createDmlStatement(DmlStatementOptions options) {
        return new CassandraDMLStatement(options.databaseInfo(this.getDatabaseInfo()));
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Map<String, Map<String, Table>> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Map<String, Table>> metaData) {
        this.metaData = metaData;
    }

    protected final void buildMetaData() {
        for (KeyspaceMetadata keystoreMeta : this.cluster.getMetadata().getKeyspaces()) {
            this.metaData.put(keystoreMeta.getName(), new HashMap());
            for (TableMetadata tableMeta : keystoreMeta.getTables()) {
                Table table = new Table();
                table.setName(tableMeta.getName());
                table.setSchema(keystoreMeta.getName());
                List pkColumns = tableMeta.getPrimaryKey();
                for (ColumnMetadata columnMeta : tableMeta.getColumns()) {
                    Column column = new Column();
                    column.setName(columnMeta.getName());
                    column.setMappedTypeCode(this.getMappedTypeCode(columnMeta.getType().getName().name()));
                    if (columnMeta.getType().getTypeArguments() != null) {
                        StringBuilder types = new StringBuilder();
                        for (DataType dt : columnMeta.getType().getTypeArguments()) {
                            if (types.length() > 0) {
                                types.append(",");
                            }
                            types.append(dt.getName().name());
                            column.setDescription(types.toString());
                        }
                    }
                    for (ColumnMetadata pkMeta : pkColumns) {
                        if (!pkMeta.equals((Object)columnMeta)) continue;
                        column.setPrimaryKey(true);
                    }
                    table.addColumn(column);
                }
                this.metaData.get(keystoreMeta.getName()).put(table.getName(), table);
            }
        }
    }

    protected int getMappedTypeCode(String dataType) {
        if (dataType.equals(DataType.Name.INT.name())) {
            return 4;
        }
        if (dataType.equals(DataType.Name.BIGINT.name())) {
            return -5;
        }
        if (dataType.equals(DataType.Name.SMALLINT.name())) {
            return 5;
        }
        if (dataType.equals(DataType.Name.TINYINT.name())) {
            return -6;
        }
        if (dataType.equals(DataType.Name.BOOLEAN.name())) {
            return 16;
        }
        if (dataType.equals(DataType.Name.DECIMAL.name())) {
            return 3;
        }
        if (dataType.equals(DataType.Name.DOUBLE.name())) {
            return 8;
        }
        if (dataType.equals(DataType.Name.FLOAT.name())) {
            return 6;
        }
        if (dataType.equals(DataType.Name.TIMESTAMP.name())) {
            return 93;
        }
        if (dataType.equals(DataType.Name.DATE.name())) {
            return 91;
        }
        if (dataType.equals(DataType.Name.TIME.name())) {
            return 92;
        }
        if (dataType.equals(DataType.Name.VARCHAR.name()) || dataType.equals(DataType.Name.TEXT.name())) {
            return 12;
        }
        if (dataType.equals(DataType.Name.UUID.name())) {
            return 2000;
        }
        if (dataType.equals(DataType.Name.LIST.name())) {
            return 2002;
        }
        if (dataType.equals(DataType.Name.SET.name())) {
            return 2006;
        }
        if (dataType.equals(DataType.Name.MAP.name())) {
            return 1111;
        }
        return 12;
    }
}

