/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.alter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddForeignKeyChange;
import org.jumpmind.db.alter.AddFunctionChange;
import org.jumpmind.db.alter.AddIndexChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.AddTableChange;
import org.jumpmind.db.alter.AddTableLoggingChange;
import org.jumpmind.db.alter.AddTriggerChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnAutoUpdateChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnGeneratedChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.GeneratedColumnDefinitionChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemoveForeignKeyChange;
import org.jumpmind.db.alter.RemoveFunctionChange;
import org.jumpmind.db.alter.RemoveIndexChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.RemoveTableChange;
import org.jumpmind.db.alter.RemoveTableLoggingChange;
import org.jumpmind.db.alter.RemoveTriggerChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Function;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformFunction;
import org.jumpmind.db.model.PlatformTrigger;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.ase.AseDdlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelComparator {
    private final Logger log = LoggerFactory.getLogger(ModelComparator.class);
    protected DatabaseInfo platformInfo;
    protected boolean caseSensitive;
    protected IDdlBuilder ddlBuilder;

    public ModelComparator(IDdlBuilder ddlBuilder, DatabaseInfo platformInfo, boolean caseSensitive) {
        this.ddlBuilder = ddlBuilder;
        this.platformInfo = platformInfo;
        this.caseSensitive = caseSensitive;
    }

    private boolean supportsDefaultValues() {
        return !(this.ddlBuilder instanceof AseDdlBuilder) || !((AseDdlBuilder)this.ddlBuilder).isUsingJtds();
    }

    public List<IModelChange> compare(Database sourceModel, Database targetModel) {
        int fkIdx;
        int tableIdx;
        ArrayList<IModelChange> changes = new ArrayList<IModelChange>();
        for (tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.caseSensitive);
            if (sourceTable == null) {
                this.log.info("Table {} needs to be added", (Object)targetTable.getName());
                changes.add(new AddTableChange(targetTable));
                if (!this.platformInfo.isForeignKeysSupported()) continue;
                for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                    changes.add(new AddForeignKeyChange(targetTable, targetTable.getForeignKey(fkIdx)));
                }
                continue;
            }
            changes.addAll(this.compareTables(sourceModel, sourceTable, targetModel, targetTable));
        }
        for (tableIdx = 0; tableIdx < sourceModel.getTableCount(); ++tableIdx) {
            Table sourceTable = sourceModel.getTable(tableIdx);
            Table targetTable = targetModel.findTable(sourceTable.getName(), this.caseSensitive);
            if (targetTable != null || sourceTable.getName() == null || sourceTable.getName().length() <= 0) continue;
            this.log.info("Table {} needs to be removed", (Object)sourceTable.getName());
            changes.add(new RemoveTableChange(sourceTable));
            if (!this.platformInfo.isForeignKeysSupported()) continue;
            for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
                changes.add(new RemoveForeignKeyChange(sourceTable, sourceTable.getForeignKey(fkIdx)));
            }
        }
        return changes;
    }

    public List<IModelChange> compareTables(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable) {
        ArrayList<IModelChange> changes = new ArrayList<IModelChange>();
        this.detectLoggingChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        this.detectForeignKeyChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        this.detectIndexChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        this.detectColumnChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        this.detectPrimaryKeyChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        this.detectTriggerChanges(sourceModel, sourceTable, targetModel, targetTable, changes);
        return changes;
    }

    public void detectLoggingChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        if (!this.platformInfo.isTableLevelLoggingSupported()) {
            return;
        }
        if (sourceTable.getLogging() == targetTable.getLogging()) {
            this.log.debug("Logging mode remains unchanged for table {}", (Object)sourceTable.getName());
            return;
        }
        if (!sourceTable.getLogging() && targetTable.getLogging()) {
            this.log.debug("Logging needs to be added to table {}", (Object)sourceTable.getName());
            changes.add(new AddTableLoggingChange(sourceTable));
            return;
        }
        this.log.debug("Logging needs to be removed from table {}", (Object)sourceTable.getName());
        changes.add(new RemoveTableLoggingChange(sourceTable));
    }

    public void detectForeignKeyChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        int fkIdx;
        if (!this.platformInfo.isForeignKeysSupported()) {
            return;
        }
        for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey sourceFk = sourceTable.getForeignKey(fkIdx);
            ForeignKey targetFk = this.findCorrespondingForeignKey(targetTable, sourceFk);
            if (targetFk != null) continue;
            this.log.info("{} needs to be removed from table {}", (Object)sourceFk, (Object)sourceTable.getName());
            changes.add(new RemoveForeignKeyChange(sourceTable, sourceFk));
        }
        for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
            ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
            if (sourceFk != null) continue;
            this.log.info("{} needs to be created for table {}", (Object)targetFk, (Object)sourceTable.getName());
            changes.add(new AddForeignKeyChange(targetTable, targetFk));
        }
    }

    public void detectIndexChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        int indexIdx;
        if (!this.platformInfo.isIndicesSupported()) {
            return;
        }
        for (indexIdx = 0; indexIdx < sourceTable.getIndexCount(); ++indexIdx) {
            IIndex sourceIndex = sourceTable.getIndex(indexIdx);
            IIndex targetIndex = this.findCorrespondingIndex(targetTable, sourceIndex);
            if (targetIndex != null) continue;
            this.log.info("Index {} needs to be removed from table {}", (Object)sourceIndex.getName(), (Object)sourceTable.getName());
            changes.add(new RemoveIndexChange(sourceTable, sourceIndex));
        }
        for (indexIdx = 0; indexIdx < targetTable.getIndexCount(); ++indexIdx) {
            IIndex targetIndex = targetTable.getIndex(indexIdx);
            IIndex sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndex);
            if (sourceIndex == null) {
                this.log.info("Index {} needs to be created for table {}", (Object)targetIndex.getName(), (Object)sourceTable.getName());
                changes.add(new AddIndexChange(targetTable, targetIndex));
                continue;
            }
            if (new EqualsBuilder().append(new HashSet<IIndex>(Arrays.asList(targetIndex)), new HashSet<IIndex>(Arrays.asList(sourceIndex))).isEquals()) continue;
            this.log.info("Index {} needs to be modified (removed/created) for table {}", (Object)targetIndex.getName(), (Object)sourceTable.getName());
            changes.add(new RemoveIndexChange(sourceTable, sourceIndex));
            changes.add(new AddIndexChange(targetTable, targetIndex));
        }
    }

    public void detectColumnChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        AddColumnChange change;
        Column targetColumn;
        int columnIdx;
        HashMap<Column, AddColumnChange> addColumnChanges = new HashMap<Column, AddColumnChange>();
        for (columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this.caseSensitive);
            if (sourceColumn == null) {
                this.log.info("Column {} needs to be created for table {}", (Object)targetColumn.getName(), (Object)sourceTable.getName());
                AddColumnChange change2 = new AddColumnChange(sourceTable, targetColumn, columnIdx > 0 ? targetTable.getColumn(columnIdx - 1) : null, columnIdx < targetTable.getColumnCount() - 1 ? targetTable.getColumn(columnIdx + 1) : null);
                changes.add(change2);
                addColumnChanges.put(targetColumn, change2);
                continue;
            }
            changes.addAll(this.compareColumns(sourceTable, sourceColumn, targetTable, targetColumn));
        }
        for (columnIdx = targetTable.getColumnCount() - 1; columnIdx >= 0 && (change = (AddColumnChange)addColumnChanges.get(targetColumn = targetTable.getColumn(columnIdx))) != null; --columnIdx) {
            change.setAtEnd(true);
        }
    }

    public void detectPrimaryKeyChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        Column[] sourcePK = sourceTable.getPrimaryKeyColumnsInIndexOrder();
        Column[] targetPK = targetTable.getPrimaryKeyColumnsInIndexOrder();
        if (sourcePK.length == 0 && targetPK.length > 0) {
            this.log.info("A primary key needs to be added to the table {}", (Object)sourceTable.getName());
            changes.add(new AddPrimaryKeyChange(targetTable, targetPK));
        } else if (targetPK.length == 0 && sourcePK.length > 0) {
            this.log.info("The primary key needs to be removed from the table {}", (Object)sourceTable.getName());
            changes.add(new RemovePrimaryKeyChange(sourceTable, sourcePK));
        } else if (sourcePK.length > 0 && targetPK.length > 0) {
            boolean changePK = false;
            if (sourcePK.length != targetPK.length) {
                changePK = true;
            } else {
                for (int pkColumnIdx = 0; pkColumnIdx < sourcePK.length && !changePK; ++pkColumnIdx) {
                    if ((!this.caseSensitive || sourcePK[pkColumnIdx].getName().equals(targetPK[pkColumnIdx].getName())) && (this.caseSensitive || sourcePK[pkColumnIdx].getName().equalsIgnoreCase(targetPK[pkColumnIdx].getName()))) continue;
                    changePK = true;
                }
            }
            if (changePK) {
                this.log.info("The primary key of table {} needs to be changed", (Object)sourceTable.getName());
                changes.add(new PrimaryKeyChange(sourceTable, sourcePK, targetPK));
            }
        }
        for (int columnIdx = 0; columnIdx < sourceTable.getColumnCount(); ++columnIdx) {
            Column sourceColumn = sourceTable.getColumn(columnIdx);
            Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.caseSensitive);
            if (targetColumn != null) continue;
            this.log.info("Column {} needs to be removed from table {}", (Object)sourceColumn.getName(), (Object)sourceTable.getName());
            changes.add(new RemoveColumnChange(sourceTable, sourceColumn));
        }
    }

    public void detectTriggerChanges(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable, ArrayList<IModelChange> changes) {
        HashMap<String, Object> sourceTriggersMap = new HashMap<String, Object>();
        HashMap<String, Object> targetTriggersMap = new HashMap<String, Object>();
        String platformName = targetModel.getName();
        if (sourceTable.getTriggers() != null) {
            for (Trigger trigger : sourceTable.getTriggers()) {
                sourceTriggersMap.put(trigger.getName(), trigger);
            }
        }
        if (targetTable.getTriggers() != null) {
            for (Trigger trigger : targetTable.getTriggers()) {
                targetTriggersMap.put(trigger.getName(), trigger);
            }
        }
        for (Map.Entry entry : sourceTriggersMap.entrySet()) {
            PlatformTrigger platformTrigger;
            Function sourceFunction;
            Trigger sourceTrigger = (Trigger)entry.getValue();
            if (targetTriggersMap.containsKey(entry.getKey())) {
                boolean functionTextChanged;
                Trigger trigger = (Trigger)targetTriggersMap.get(entry.getKey());
                if (!sourceTrigger.getPlatformTriggers().containsKey(platformName)) continue;
                PlatformTrigger targetPlatformTrigger = trigger.findPlatformTrigger(platformName);
                PlatformTrigger sourcePlatformTrigger2 = sourceTrigger.findPlatformTrigger(platformName);
                boolean triggerTextChanged = !Strings.CS.equals(targetPlatformTrigger.getTriggerText(), sourcePlatformTrigger2.getTriggerText());
                String targetFunctionText = this.getFunctionText(targetPlatformTrigger, platformName);
                String sourceFunctionText = this.getFunctionText(sourcePlatformTrigger2, platformName);
                boolean bl = functionTextChanged = !Strings.CS.equals(targetFunctionText, sourceFunctionText);
                if (!triggerTextChanged && !functionTextChanged) continue;
                changes.add(new RemoveTriggerChange(sourceTable, sourceTrigger));
                changes.add(new RemoveFunctionChange(sourceTable, sourceTrigger, sourcePlatformTrigger2.getFunction()));
                changes.add(new AddFunctionChange(targetTable, trigger, targetPlatformTrigger.getFunction()));
                changes.add(new AddTriggerChange(targetTable, trigger));
                continue;
            }
            changes.add(new RemoveTriggerChange(sourceTable, sourceTrigger));
            if (!sourceTrigger.getPlatformTriggers().containsKey(platformName) || (sourceFunction = (platformTrigger = sourceTrigger.findPlatformTrigger(platformName)).getFunction()) == null) continue;
            changes.add(new RemoveFunctionChange(sourceTable, sourceTrigger, sourceFunction));
        }
        for (Map.Entry entry : targetTriggersMap.entrySet()) {
            PlatformTrigger platformTrigger;
            Function targetFunction;
            if (sourceTriggersMap.containsKey(entry.getKey())) continue;
            Trigger targetTrigger = (Trigger)entry.getValue();
            if (targetTrigger.getPlatformTriggers().containsKey(platformName) && (targetFunction = (platformTrigger = targetTrigger.getPlatformTriggers().get(platformName)).getFunction()) != null) {
                changes.add(new AddFunctionChange(targetTable, targetTrigger, targetFunction));
            }
            changes.add(new AddTriggerChange(targetTable, (Trigger)entry.getValue()));
        }
    }

    private String getFunctionText(PlatformTrigger platformTrigger, String databaseName) {
        PlatformFunction platformFunction;
        Function function;
        String functionText = null;
        if (platformTrigger != null && platformTrigger.getFunction() != null && (function = platformTrigger.getFunction()).getPlatformFunctions().containsKey(databaseName) && (platformFunction = function.getPlatformFunctions().get(databaseName)) != null) {
            functionText = platformFunction.getFunctionText();
        }
        return functionText;
    }

    public List<TableChange> compareColumns(Table sourceTable, Column sourceColumn, Table targetTable, Column targetColumn) {
        boolean compatible;
        ArrayList<TableChange> changes = new ArrayList<TableChange>();
        int actualTypeCode = sourceColumn.getMappedTypeCode();
        int desiredTypeCode = targetColumn.getMappedTypeCode();
        boolean sizeMatters = this.platformInfo.hasSize(targetColumn.getMappedTypeCode());
        boolean scaleMatters = this.platformInfo.hasPrecisionAndScale(targetColumn.getMappedTypeCode());
        boolean bl = compatible = !(actualTypeCode != 2 && actualTypeCode != 3 || desiredTypeCode != 4 && desiredTypeCode != -5);
        if (sourceColumn.isAutoIncrement() && targetColumn.isAutoIncrement() && (desiredTypeCode == 2 || desiredTypeCode == 3) && (actualTypeCode == 4 || actualTypeCode == -5)) {
            compatible = true;
            sizeMatters = false;
            scaleMatters = false;
        }
        if (sourceColumn.getMappedTypeCode() == 2004 && targetColumn.getMappedTypeCode() == -1) {
            compatible = true;
        }
        if (!compatible && !this.ddlBuilder.areMappedTypesTheSame(sourceColumn, targetColumn) && this.platformInfo.getTargetJdbcType(targetColumn.getMappedTypeCode()) != this.platformInfo.getTargetJdbcType(sourceColumn.getMappedTypeCode())) {
            this.log.info("The {} column on the {} table changed type codes from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getMappedTypeCode(), targetColumn.getMappedTypeCode()});
            changes.add(new ColumnDataTypeChange(sourceTable, sourceColumn, targetColumn.getMappedTypeCode()));
        }
        if (!this.ddlBuilder.areColumnSizesTheSame(sourceColumn, targetColumn)) {
            if (sizeMatters) {
                int targetSize = targetColumn.getSizeAsInt();
                if (targetColumn.getSize() == null) {
                    Integer defaultSize = this.platformInfo.getDefaultSize(this.platformInfo.getTargetJdbcType(targetColumn.getMappedTypeCode()));
                    targetSize = defaultSize != null ? defaultSize : 0;
                }
                this.log.info("The {} column on the {} table changed size from ({}) to ({})", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getSizeAsInt(), targetSize});
                changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetSize, targetColumn.getScale()));
            } else if (scaleMatters) {
                this.log.info("The {} column on the {} table changed scale from ({},{}) to ({},{})", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getSizeAsInt(), sourceColumn.getScale(), targetColumn.getSizeAsInt(), targetColumn.getScale()});
                changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
            }
        }
        if (this.supportsDefaultValues() && !this.defaultValuesAreEqual(sourceColumn, targetColumn)) {
            this.log.info("The {} column on the {} table changed default value from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getDefaultValue(), targetColumn.getDefaultValue()});
            changes.add(new ColumnDefaultValueChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        if (!targetColumn.isGenerated() && sourceColumn.isRequired() != targetColumn.isRequired()) {
            this.log.info("The {} column on the {} table changed required status from {} to {}", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isRequired(), targetColumn.isRequired()});
            changes.add(new ColumnRequiredChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isAutoIncrement() != targetColumn.isAutoIncrement()) {
            this.log.info("The {} column on the {} table changed auto increment status from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isAutoIncrement(), targetColumn.isAutoIncrement()});
            changes.add(new ColumnAutoIncrementChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isAutoUpdate() != targetColumn.isAutoUpdate()) {
            this.log.info("The {} column on the {} table changed auto update status from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isAutoUpdate(), targetColumn.isAutoUpdate()});
            changes.add(new ColumnAutoUpdateChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isGenerated() != targetColumn.isGenerated()) {
            this.log.info("The {} column on the {} table changed generated status from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.isGenerated(), targetColumn.isGenerated()});
            changes.add(new ColumnGeneratedChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        } else if (Boolean.valueOf(System.getProperty("compare.generated.column.definitions", "true")).booleanValue() && sourceColumn.isGenerated() && sourceColumn.getDefaultValue() != null && !sourceColumn.getDefaultValue().equals(targetColumn.getDefaultValue())) {
            this.log.info("The {} generated column on the {} table changed definition from {} to {} ", new Object[]{sourceColumn.getName(), sourceTable.getName(), sourceColumn.getDefaultValue(), targetColumn.getDefaultValue()});
            changes.add(new GeneratedColumnDefinitionChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        return changes;
    }

    private ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            ForeignKey curFk = table.getForeignKey(fkIdx);
            if ((!this.caseSensitive || !fk.equals(curFk)) && (this.caseSensitive || !fk.equalsIgnoreCase(curFk))) continue;
            return curFk;
        }
        return null;
    }

    private IIndex findCorrespondingIndex(Table table, IIndex index) {
        for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
            IIndex curIndex = table.getIndex(indexIdx);
            if ((!this.caseSensitive || !index.equals(curIndex)) && (this.caseSensitive || !index.equalsIgnoreCase(curIndex))) continue;
            return curIndex;
        }
        return null;
    }

    private boolean defaultValuesAreEqual(Column sourceColumn, Column targetColumn) {
        Object sourceDefaultValue = sourceColumn.getParsedDefaultValue();
        Object targetDefaultValue = targetColumn.getParsedDefaultValue();
        if (!(targetColumn.isGenerated() || sourceDefaultValue == null && targetDefaultValue == null)) {
            String targetDefaultValueString;
            String sourceDefaultValueString;
            boolean isBigDecimal;
            if (sourceDefaultValue == null && targetDefaultValue != null || sourceDefaultValue != null && targetDefaultValue == null) {
                return false;
            }
            boolean bl = isBigDecimal = sourceDefaultValue instanceof BigDecimal && targetDefaultValue instanceof BigDecimal;
            if (isBigDecimal && ((BigDecimal)sourceDefaultValue).compareTo((BigDecimal)targetDefaultValue) != 0) {
                return false;
            }
            if (!isBigDecimal && !(sourceDefaultValueString = sourceDefaultValue.toString()).equals(targetDefaultValueString = this.ddlBuilder.mapDefaultValue(targetDefaultValue, targetColumn).toString())) {
                int typeCode = targetColumn.getMappedTypeCode();
                if (typeCode == 93 || typeCode == -101 || typeCode == -102) {
                    if (targetColumn.anyPlatformColumnNameContains("mysql") || targetColumn.anyPlatformColumnNameContains("maria")) {
                        while (targetDefaultValueString.startsWith("(") && targetDefaultValueString.endsWith(")")) {
                            targetDefaultValueString = targetDefaultValueString.substring(1, targetDefaultValueString.length() - 1);
                        }
                    }
                    if (targetColumn.anyPlatformColumnNameContains("postgres")) {
                        sourceDefaultValueString = sourceDefaultValueString.replace("::text", "");
                    }
                    return sourceDefaultValueString.equalsIgnoreCase(targetDefaultValueString);
                }
                if (sourceColumn.isOfNumericType() && targetColumn.isOfNumericType()) {
                    if (sourceColumn.anyPlatformColumnNameContains("postgres")) {
                        sourceDefaultValueString = sourceDefaultValueString.replace("'", "").replace("::integer", "");
                    }
                    return sourceDefaultValueString.equalsIgnoreCase(targetDefaultValueString);
                }
                return false;
            }
        }
        return true;
    }
}

