/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.net.ns.NetException;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.SocketChannelWrapper;

public class SSLSocketChannel
extends SocketChannelWrapper {
    private static final String CLASS_NAME = SSLSocketChannel.class.getName();
    private final SSLEngine sslEngine;
    private ByteBuffer localUnwrapBuffer;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private boolean isClosed = false;
    private boolean isHandshakeDone = false;
    private final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final boolean isRenegotiating;
    private final DNVerifier dnVerifier;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;

    public SSLSocketChannel(SocketChannel channel, SSLEngine engine, Diagnosable diagnosable, DNVerifier dnVerifier, boolean isRenegotiating) throws IOException {
        super(channel, diagnosable);
        this.socketChannel = channel;
        this.sslEngine = engine;
        this.dnVerifier = dnVerifier;
        this.isRenegotiating = isRenegotiating;
        this.initializeBuffers();
    }

    public SSLSocketChannel(SocketChannel channel, SSLEngine engine, Diagnosable diagnosable) throws IOException {
        this(channel, engine, diagnosable, null, false);
    }

    public SecurityInformation.DNMatchStatus getDnMatchStatus() {
        return this.dnMatchStatus;
    }

    @Override
    public int read(ByteBuffer dstBuffer) throws IOException {
        int readBytesCount;
        if (this.isClosed()) {
            return -1;
        }
        if (dstBuffer == null || !dstBuffer.hasRemaining()) {
            return 0;
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if (this.localUnwrapBuffer.hasRemaining()) {
            readBytesCount = this.readFromLocalUnwrapBuffer(dstBuffer);
        } else {
            int dstBufferInitialPosition = dstBuffer.position();
            this.fillAndUnwrap(dstBuffer);
            readBytesCount = dstBuffer.position() - dstBufferInitialPosition;
        }
        return readBytesCount;
    }

    @Override
    public int write(ByteBuffer srcBuffer) throws NetException, IOException {
        if (this.isClosed()) {
            throw new NetException(17909);
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if (!this.writeToSocket()) {
            return 0;
        }
        int initialPosition = srcBuffer.position();
        this.wrapAndWriteToSocket(srcBuffer);
        if (this.writeBuffer.hasRemaining() && !srcBuffer.hasRemaining()) {
            boolean flushSuccessful = false;
            for (int attemptCount = 0; !flushSuccessful && attemptCount < 10; ++attemptCount) {
                flushSuccessful = this.writeToSocket();
            }
            if (!flushSuccessful) {
                throw new IOException("Unable to write to the socket");
            }
        }
        return srcBuffer.position() - initialPosition;
    }

    private void wrapAndWriteToSocket(ByteBuffer srcBuffer) throws IOException {
        boolean wrapSuccessful = false;
        this.writeBuffer.clear();
        while (srcBuffer.hasRemaining()) {
            SSLEngineResult result = this.wrap(srcBuffer);
            if (result.getStatus() != SSLEngineResult.Status.OK) {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (wrapSuccessful) {
                        if (!this.flushWriteBuffer()) break;
                        this.writeBuffer.clear();
                        continue;
                    }
                    throw new IOException("Write error '" + result.getStatus() + "'");
                }
                this.shutdown();
                throw new IOException("Write error '" + result.getStatus() + "'");
            }
            wrapSuccessful = true;
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.runTasks();
        }
        this.flushWriteBuffer();
    }

    private boolean flushWriteBuffer() throws IOException {
        this.writeBuffer.flip();
        return this.writeToSocket();
    }

    public boolean hasRemaining() {
        return this.readBuffer.hasRemaining() || this.localUnwrapBuffer.hasRemaining();
    }

    private boolean fillAndUnwrap(ByteBuffer dstBuffer) throws IOException {
        boolean unwrapSuccessful;
        boolean readFromSocket;
        SSLEngineResult wrapResult = null;
        boolean useLocalUnwrapBuffer = false;
        boolean bl = readFromSocket = !this.readBuffer.hasRemaining();
        while (wrapResult == null || wrapResult.getStatus() != SSLEngineResult.Status.OK) {
            if (readFromSocket) {
                if (this.fillReadBuffer()) {
                    readFromSocket = false;
                } else {
                    return false;
                }
            }
            if ((wrapResult = useLocalUnwrapBuffer ? this.unwrapToLocalBuffer() : this.unwrapData(dstBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (useLocalUnwrapBuffer) {
                    throw new IOException("Read error '" + wrapResult.getStatus() + "'");
                }
                useLocalUnwrapBuffer = true;
                readFromSocket = false;
                continue;
            }
            if (wrapResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            readFromSocket = true;
        }
        boolean bl2 = unwrapSuccessful = wrapResult != null && wrapResult.getStatus() == SSLEngineResult.Status.OK;
        if (unwrapSuccessful && useLocalUnwrapBuffer) {
            this.readFromLocalUnwrapBuffer(dstBuffer);
        }
        return unwrapSuccessful;
    }

    private SSLEngineResult unwrapToLocalBuffer() throws IOException {
        assert (!this.localUnwrapBuffer.hasRemaining());
        this.localUnwrapBuffer.clear();
        SSLEngineResult result = this.unwrapData(this.localUnwrapBuffer);
        this.localUnwrapBuffer.flip();
        return result;
    }

    private boolean fillReadBuffer() throws IOException {
        if (this.readBuffer.hasRemaining()) {
            this.readBuffer.compact();
        } else {
            this.readBuffer.clear();
        }
        int readBytes = this.readFromSocket();
        this.readBuffer.flip();
        return readBytes > 0;
    }

    private SSLEngineResult unwrapData(ByteBuffer dstBuffer) throws IOException {
        SSLEngineResult result = this.unwrap(this.readBuffer, dstBuffer);
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.shutdown();
            throw new IOException("Read error '" + result.getStatus() + "'");
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.runTasks();
        }
        return result;
    }

    private void shutdown() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (!this.sslEngine.isOutboundDone()) {
                this.sslEngine.closeOutbound();
                this.writeBuffer.clear();
                this.wrap(this.EMPTY_BUFFER);
                this.writeBuffer.flip();
                this.writeToSocket();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeUnderlyingChannel();
    }

    private void closeUnderlyingChannel() {
        try {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).disconnect();
            } else {
                this.socketChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readFromLocalUnwrapBuffer(ByteBuffer dstBuffer) {
        if (!this.localUnwrapBuffer.hasRemaining()) {
            return 0;
        }
        int bytesToCopy = Math.min(this.localUnwrapBuffer.remaining(), dstBuffer.remaining());
        for (int i = 0; i < bytesToCopy; ++i) {
            dstBuffer.put(this.localUnwrapBuffer.get());
        }
        return bytesToCopy;
    }

    private void initializeBuffers() throws SSLException {
        SSLSession sslSession = this.sslEngine.getSession();
        this.localUnwrapBuffer = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.readBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.writeBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.localUnwrapBuffer.limit(0);
        this.readBuffer.limit(0);
        this.writeBuffer.limit(0);
    }

    private void doSSLHandshake() throws IOException {
        Metrics.ConnectionEvent event;
        if (this.isHandshakeDone) {
            return;
        }
        boolean isEnqueueAllWrites = this.getEnqueueAllWrites();
        Metrics.ConnectionEvent connectionEvent = event = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_BEGIN_HANDSHAKE_RENEGOTIATION : Metrics.ConnectionEvent.SSL_BEGIN_HANDSHAKE;
        if (isEnqueueAllWrites) {
            this.enqueueAllWrites(false);
        }
        this.begin(event);
        this.sslEngine.beginHandshake();
        SSLEngineResult.HandshakeStatus handShakeStatus = this.sslEngine.getHandshakeStatus();
        this.end(event);
        Metrics.ConnectionEvent event1 = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGOTIATION : Metrics.ConnectionEvent.SSL_HANDSHAKE;
        this.begin(event1);
        block6: while (!this.isHandshakeDone && !this.isClosed) {
            switch (handShakeStatus) {
                case NEED_TASK: {
                    handShakeStatus = this.runTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    handShakeStatus = this.unwrapHandshakeMessage();
                    continue block6;
                }
                case NEED_WRAP: {
                    handShakeStatus = this.wrapHandshakeMessage();
                    continue block6;
                }
                case FINISHED: {
                    this.isHandshakeDone = true;
                    this.end(event1);
                    if (this.dnVerifier == null || this.dnVerifier.isWeakDNMatchAllowed()) continue block6;
                    this.verifyDN();
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected handshake status '" + handShakeStatus + "'");
        }
        if (isEnqueueAllWrites) {
            this.enqueueAllWrites(true);
        }
    }

    CompletionStage<Void> doSSLHandshakeAsync(Executor asyncExecutor) {
        if (this.isHandshakeDone) {
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        try {
            this.sslEngine.beginHandshake();
        }
        catch (SSLException beginHandshakeFailure) {
            return CompletionStageUtil.failedStage(beginHandshakeFailure);
        }
        return this.chainAsyncHandshakeIO(asyncExecutor);
    }

    private CompletionStage<Void> chainAsyncHandshakeIO(Executor asyncExecutor) {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        block10: while (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.readBuffer.hasRemaining()) {
            if (this.isClosed) {
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }
            try {
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        handshakeStatus = this.runTasks();
                        continue block10;
                    }
                    case NEED_WRAP: {
                        handshakeStatus = this.wrapHandshakeMessage();
                        continue block10;
                    }
                    case NEED_UNWRAP: {
                        handshakeStatus = this.unwrapHandshakeMessage();
                        continue block10;
                    }
                    case FINISHED: {
                        this.isHandshakeDone = true;
                        if (this.dnVerifier != null && !this.dnVerifier.isWeakDNMatchAllowed()) {
                            this.verifyDN();
                        }
                        return CompletionStageUtil.VOID_COMPLETED_FUTURE;
                    }
                }
                return CompletionStageUtil.failedStage(new IllegalStateException("Unexpected handshake status '" + handshakeStatus + "'"));
            }
            catch (IOException handshakeFailure) {
                return CompletionStageUtil.failedStage(handshakeFailure);
            }
        }
        CompletableFuture ioFuture = new CompletableFuture();
        try {
            this.registerForNonBlockingRead(error -> asyncExecutor.execute(() -> {
                if (error == null) {
                    ioFuture.complete(null);
                } else {
                    ioFuture.completeExceptionally((Throwable)error);
                }
            }));
        }
        catch (IOException registerFailure) {
            return CompletionStageUtil.failedStage(registerFailure);
        }
        return ioFuture.thenCompose(CompletionStageUtil.normalCompletionHandler(nil -> {
            SSLEngineResult.HandshakeStatus status = this.unwrapHandshakeMessage();
            return status == SSLEngineResult.HandshakeStatus.FINISHED ? CompletionStageUtil.VOID_COMPLETED_FUTURE : this.chainAsyncHandshakeIO(asyncExecutor);
        }));
    }

    private SSLEngineResult.HandshakeStatus wrapHandshakeMessage() throws IOException {
        this.writeBuffer.clear();
        Metrics.ConnectionEvent event = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGO_ROUND_TRIP_WRAP : Metrics.ConnectionEvent.SSL_HS_ROUND_TRIP_WRAP;
        this.begin(event);
        SSLEngineResult result = this.wrap(this.EMPTY_BUFFER);
        this.end(event);
        SSLEngineResult.HandshakeStatus handShakeStatus = result.getHandshakeStatus();
        if (result.getStatus() != SSLEngineResult.Status.OK) {
            throw new IOException("Handshake failed : " + result.getStatus());
        }
        this.writeBuffer.flip();
        Metrics.ConnectionEvent event1 = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGO_ROUND_TRIP_SEND : Metrics.ConnectionEvent.SSL_HS_ROUND_TRIP_SEND;
        this.begin(event1);
        this.writeToSocket();
        this.end(event1);
        return handShakeStatus;
    }

    private SSLEngineResult.HandshakeStatus unwrapHandshakeMessage() throws IOException {
        SSLEngineResult.HandshakeStatus handShakeStatus;
        SSLEngineResult result;
        Metrics.ConnectionEvent event = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGO_ROUND_TRIP_RECEIVE : Metrics.ConnectionEvent.SSL_HS_ROUND_TRIP_RECEIVE;
        this.begin(event);
        if (!this.readBuffer.hasRemaining()) {
            this.readBuffer.clear();
            while (this.readFromSocket() == 0) {
            }
            this.readBuffer.flip();
        }
        this.end(event);
        do {
            this.localUnwrapBuffer.clear();
            Metrics.ConnectionEvent event1 = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGO_ROUND_TRIP_UNWRAP : Metrics.ConnectionEvent.SSL_HS_ROUND_TRIP_UNWRAP;
            this.begin(event1);
            result = this.unwrap(this.readBuffer, this.localUnwrapBuffer);
            this.end(event1);
            handShakeStatus = result.getHandshakeStatus();
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                this.readBuffer.compact();
                this.readBuffer.flip();
                this.localUnwrapBuffer.flip();
                continue;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.readBuffer.compact();
                if (this.readBuffer.position() == this.readBuffer.capacity()) {
                    throw new IOException("Handshake failed : SSL packet is too big to hold in the read buffer");
                }
                while (this.readFromSocket() == 0) {
                }
                this.readBuffer.flip();
                continue;
            }
            throw new IOException("Handshake failed : " + result.getStatus());
        } while (result.getStatus() != SSLEngineResult.Status.OK);
        return handShakeStatus;
    }

    private SSLEngineResult unwrap(ByteBuffer srcBuffer, ByteBuffer dstBuffer) throws NetException, IOException {
        try {
            SSLEngineResult result = this.isEmptyTLSPacket(srcBuffer) ? new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 5, 0) : this.sslEngine.unwrap(srcBuffer, dstBuffer);
            this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unwrap", "SSLEngineResult=[{0}]", "SSLEngineResult=[{0}]\n{1}", null, () -> {
                if (this.isSensitiveEnabled()) {
                    return new Object[]{result, Parameter.arg(Format.Style.PACKET_DUMP, SSLSocketChannel.copy(dstBuffer, result.bytesProduced()), 0L, result.bytesProduced())};
                }
                return new Object[]{result};
            });
            return result;
        }
        catch (SSLHandshakeException e) {
            throw new NetException(17967, e.getMessage());
        }
        catch (Exception e) {
            throw (IOException)new IOException("IO Error " + e.getMessage()).initCause(e);
        }
    }

    private boolean isEmptyTLSPacket(ByteBuffer srcBuffer) {
        if (srcBuffer.remaining() >= 5) {
            int initialPosition = srcBuffer.position();
            byte recordType = srcBuffer.get();
            short tlsVersion = srcBuffer.getShort();
            short length = srcBuffer.getShort();
            if (recordType == 23 && length == 0) {
                return true;
            }
            srcBuffer.position(initialPosition);
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBuffer srcBuffer) throws IOException {
        try {
            SSLEngineResult result = this.sslEngine.wrap(srcBuffer, this.writeBuffer);
            this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "wrap", "SSLEngineResult=[{0}]", "SSLEngineResult=[{0}]\n{1}", null, () -> {
                if (this.isSensitiveEnabled()) {
                    return new Object[]{result, Parameter.arg(Format.Style.PACKET_DUMP, SSLSocketChannel.copy(srcBuffer, result.bytesConsumed()), 0L, result.bytesConsumed())};
                }
                return new Object[]{result};
            });
            return result;
        }
        catch (Exception e) {
            throw (IOException)new IOException("IO Error " + e.getMessage()).initCause(e);
        }
    }

    private int readFromSocket() throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            throw new IOException("IO Error : No room left in the read buffer");
        }
        try {
            int bytesRead = this.socketChannel.read(this.readBuffer);
            if (bytesRead < 0) {
                throw new IOException("Connection closed");
            }
            return bytesRead;
        }
        catch (IOException x) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.shutdown();
            throw x;
        }
    }

    private boolean writeToSocket() throws IOException {
        try {
            this.socketChannel.write(this.writeBuffer);
            return !this.writeBuffer.hasRemaining();
        }
        catch (IOException x) {
            this.shutdown();
            throw x;
        }
    }

    private boolean isClosed() throws IOException {
        return this.isClosed || !this.socketChannel.isOpen() || this.socketChannel.socket().isInputShutdown() || this.socketChannel.socket().isOutputShutdown();
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        try {
            Runnable runnable;
            Metrics.ConnectionEvent event;
            Metrics.ConnectionEvent connectionEvent = event = this.isRenegotiating ? Metrics.ConnectionEvent.SSL_RENEGO_ROUND_TRIP_RUNTASKS : Metrics.ConnectionEvent.SSL_HS_ROUND_TRIP_RUNTASKS;
            if (!this.isHandshakeDone) {
                this.begin(event);
            }
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            if (!this.isHandshakeDone) {
                this.end(event);
            }
            return this.sslEngine.getHandshakeStatus();
        }
        catch (Exception e) {
            throw (IOException)new IOException("IO Error " + e.getMessage()).initCause(e);
        }
    }

    void verifyDN() throws IOException {
        if (this.dnVerifier != null) {
            this.dnMatchStatus = this.dnVerifier.verify((X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0]);
        } else {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "verifyDN", "Server DN verification is disabled and connection is not secure.Enable DN verification through Connection Property 'oracle.net.ssl_server_dn_match' or through URL parameter 'SSL_SERVER_DN_MATCH'", null, null, new Object[0]);
        }
    }

    @Override
    void disconnect() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.shutdown();
    }

    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }
}

