/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.driver.OracleConfigurationJsonProvider;

public class OracleConfigurationJsonHttpsProvider
extends OracleConfigurationJsonProvider {
    @Override
    public InputStream getJson(String location) throws SQLException {
        try {
            HttpURLConnection connection = this.getHttpURLConnection(location);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            if (this.options.containsKey("authentication") && ((String)this.options.get("authentication")).equals("basic")) {
                String headerValue = Base64.getEncoder().encodeToString(((String)this.options.get("user") + ":" + (String)this.options.get("password")).getBytes());
                connection.setRequestProperty("Authorization", "Basic " + headerValue);
            }
            connection.setDoOutput(true);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            throw new SQLException("Error retrieving Json configuration", ex);
        }
    }

    @Override
    public String getType() {
        return "https";
    }

    HttpURLConnection getHttpURLConnection(String location) throws IOException {
        if (!((String)location).startsWith("https://")) {
            location = "https://" + (String)location;
        }
        URL url = new URL((String)location);
        return (HttpsURLConnection)url.openConnection();
    }
}

